/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions.md;

import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.microkernel.MDIncomingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDOutgoingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDOperationRef;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceActivityBase;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;
import oracle.bpm.util.ArrayUtils;

public class MDServiceTask
extends MDServiceActivityBase
implements MDServiceActivity,
MDIncomingMessage,
MDOutgoingMessage {
    private final QName eventName;
    private final QName eventPayloadName;
    private final FlowNode flowElement;
    private final String[] initiateInCorrelationSets;
    private final String[] initiateOutCorrelationSets;
    private final DataDeclarationContainer inputArgumentsContainer;
    private final DataAssociationSet inputDataAssociationSet;
    private final String[] inputHeaderVariableNames;
    private final String inputVariableName;
    private final boolean markCompleteWhenDone;
    private final DataDeclarationContainer outputArgumentsContainer;
    private final DataAssociationSet outputDataAssociationSet;
    private final String[] outputHeaderVariableNames;
    private final String outputVariableName;
    private final String referenceName;

    public MDServiceTask(String inputVariableName, String outputVariableName, DataAssociationSet outputDataAssociationSet, DataAssociationSet inputDataAssociationSet, DataDeclarationContainer outputArgumentsContainer, DataDeclarationContainer inputArgumentsContainer, MDOperationRef mdOperationRef, String referenceName, QName eventName, QName eventPayloadName, FlowNode flowElement, ServicePropertySet inputServiceProperties, ServicePropertySet outputServiceProperties, CorrelationItemsContainer inputCorrelationItemsContainer, CorrelationItemsContainer outputCorrelationItemsContainer, String[] inputHeaderVariableNames, String[] outputHeaderVariableNames, boolean markCompleteWhenDone) {
        super(mdOperationRef, inputServiceProperties, outputServiceProperties);
        this.inputVariableName = inputVariableName;
        this.outputVariableName = outputVariableName;
        this.outputDataAssociationSet = outputDataAssociationSet;
        this.inputDataAssociationSet = inputDataAssociationSet;
        this.outputArgumentsContainer = outputArgumentsContainer;
        this.inputArgumentsContainer = inputArgumentsContainer;
        this.referenceName = referenceName;
        this.eventPayloadName = eventPayloadName;
        this.flowElement = flowElement;
        this.eventName = eventName;
        this.inputHeaderVariableNames = inputHeaderVariableNames != null ? inputHeaderVariableNames : ArrayUtils.EMPTY_STRING_ARRAY;
        this.outputHeaderVariableNames = outputHeaderVariableNames != null ? outputHeaderVariableNames : ArrayUtils.EMPTY_STRING_ARRAY;
        this.initiateInCorrelationSets = new MDServiceActivityBase.CorrelationSetInfo(inputCorrelationItemsContainer).getInitiateCorrelationSetNames();
        this.initiateOutCorrelationSets = new MDServiceActivityBase.CorrelationSetInfo(outputCorrelationItemsContainer).getInitiateCorrelationSetNames();
        this.markCompleteWhenDone = markCompleteWhenDone;
    }

    @Override
    public String getInputVariableName() {
        return this.inputVariableName;
    }

    @Override
    public String getOutputVariableName() {
        return this.outputVariableName;
    }

    @Override
    public DataAssociationSet getOutputDataAssociationSet() {
        return this.outputDataAssociationSet;
    }

    public boolean isMarkCompleteWhenDone() {
        return this.markCompleteWhenDone;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    @Override
    public DataDeclarationContainer getOutputArgumentsContainer() {
        return this.outputArgumentsContainer;
    }

    @Override
    public DataAssociationSet getInputDataAssociationSet() {
        return this.inputDataAssociationSet;
    }

    @Override
    public DataDeclarationContainer getInputArgumentsContainer() {
        return this.inputArgumentsContainer;
    }

    @Override
    public String getServiceName() {
        return this.referenceName;
    }

    @Override
    public FlowNode getFlowElement() {
        return this.flowElement;
    }

    @Override
    public QName getEventName() {
        return this.eventName;
    }

    @Override
    public QName getEventPayloadName() {
        return this.eventPayloadName;
    }

    @Override
    public boolean markCompleteWhenDone() {
        return this.markCompleteWhenDone;
    }

    public String[] getInitiateOutCorrelationSets() {
        return this.initiateOutCorrelationSets;
    }

    public String[] getInitiateInCorrelationSets() {
        return this.initiateInCorrelationSets;
    }

    public String[] getInputHeaderVariableNames() {
        return this.inputHeaderVariableNames;
    }

    public String[] getOutputHeaderVariableNames() {
        return this.outputHeaderVariableNames;
    }

    public boolean useCorrelationSet() {
        return this.initiateInCorrelationSets.length > 0 || this.initiateOutCorrelationSets.length > 0;
    }

    @Override
    public String getMetadataDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getMetadataDescription());
        builder.append(";InputVariableName:").append(this.getInputVariableName());
        builder.append(";OutputVariableName:").append(this.getOutputVariableName());
        builder.append(";Correlations:");
        for (String correlation : this.getInitiateInCorrelationSets()) {
            builder.append(correlation).append(";");
        }
        for (String correlation : this.getInitiateOutCorrelationSets()) {
            builder.append(correlation).append(";");
        }
        builder.append(";ArgumentsContainer:");
        for (DataDeclaration dd : this.getInputArgumentsContainer().getDeclarations()) {
            builder.append(dd.getName()).append("-").append(dd.getDeclarationType().getString()).append(";");
        }
        if (this.getOutputArgumentsContainer() != null) {
            for (DataDeclaration dd : this.getOutputArgumentsContainer().getDeclarations()) {
                builder.append(dd.getName()).append("-").append(dd.getDeclarationType().getString()).append(";");
            }
        }
        builder.append(";DataAssociations:");
        for (DataAssociation dae : this.getInputDataAssociationSet().getDataAssociations()) {
            builder.append(dae.toString()).append(";");
        }
        if (this.getOutputDataAssociationSet() != null) {
            for (DataAssociation dae : this.getOutputDataAssociationSet().getDataAssociations()) {
                builder.append(dae.toString()).append(";");
            }
        }
        builder.append(";Headers:");
        for (String header : this.getInputHeaderVariableNames()) {
            builder.append(header).append(";");
        }
        for (String header : this.getOutputHeaderVariableNames()) {
            builder.append(header).append(";");
        }
        return builder.toString();
    }
}

