/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions.md;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDOperationRef;
import oracle.bpm.project.model.processes.correlations.CorrelationItem;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.serviceproperties.ServiceProperty;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;

public abstract class MDServiceActivityBase
implements MDServiceActivity {
    private final Map<String, ServiceProperty> inputServiceProperties = new HashMap<String, ServiceProperty>();
    private final boolean isMessage;
    private final MDOperationRef mdOperationRef;
    private final Map<String, ServiceProperty> outputServiceProperties = new HashMap<String, ServiceProperty>();

    protected MDServiceActivityBase(MDOperationRef mdOperationRef, ServicePropertySet inputServicePropertiesEnabled, ServicePropertySet outputServicePropertiesEnabled) {
        if (mdOperationRef != null) {
            this.isMessage = true;
            this.mdOperationRef = mdOperationRef;
        } else {
            this.isMessage = false;
            this.mdOperationRef = null;
        }
        this.resolveInputProperties(inputServicePropertiesEnabled);
        this.resolveOutputProperties(outputServicePropertiesEnabled);
    }

    @Override
    public boolean isAllowsWrappedArguments() {
        return this.mdOperationRef.allowsWrappedArguments();
    }

    @Override
    public boolean isMessage() {
        return this.isMessage;
    }

    @Override
    public boolean isTwoWay() {
        return this.mdOperationRef.isTwoWay();
    }

    @Override
    public QName getInputType() {
        QName result = null;
        if (this.mdOperationRef != null) {
            result = this.mdOperationRef.getInputType();
        }
        return result;
    }

    @Override
    public QName getOutputType() {
        return this.mdOperationRef.getOutputType();
    }

    @Override
    public QName getFaultMessageType() {
        return this.mdOperationRef.getFaultMessageType();
    }

    @Override
    public QName getFaultCodeError() {
        return this.mdOperationRef.getFaultCodeError();
    }

    public String getOperationRefName() {
        return this.mdOperationRef.getName();
    }

    public QName getPortType() {
        return this.mdOperationRef.getPortType();
    }

    public Map<String, String> getInputPartNamesMap() {
        return this.mdOperationRef.getInputPartNamesMap();
    }

    public Map<String, String> getOutputPartNamesMap() {
        return this.mdOperationRef.getOutputPartNamesMap();
    }

    public Map<String, ServiceProperty> getIncomingProperties() {
        return this.outputServiceProperties;
    }

    public Map<String, ServiceProperty> getOutgoingProperties() {
        return this.inputServiceProperties;
    }

    public String getMetadataDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("Service:").append(this.getServiceName());
        if (this.getEventName() == null) {
            builder.append(";Operation:").append(this.getOperationRefName());
            builder.append(";PortType:").append(this.getPortType());
            builder.append(";InputType:").append(this.getInputType());
            builder.append(";OutputType:").append(this.getOutputType());
            builder.append(";FaultMessageType:").append(this.getFaultMessageType());
            builder.append(";FaultCodeError:").append(this.getFaultCodeError());
            builder.append(";InputPartNamesMap:");
            for (Map.Entry<String, Object> entry : this.getInputPartNamesMap().entrySet()) {
                builder.append(entry.getKey()).append("-").append((String)entry.getValue()).append(";");
            }
            builder.append(";OutputPartNamesMap:");
            for (Map.Entry<String, Object> entry : this.getOutputPartNamesMap().entrySet()) {
                builder.append(entry.getKey()).append("-").append((String)entry.getValue()).append(";");
            }
        } else {
            builder.append(";EventName:").append(this.getEventName());
            builder.append(";EventPayloadName:").append(this.getEventPayloadName());
        }
        builder.append(";IncomingProperties:");
        for (Map.Entry<String, ServiceProperty> entry : this.getIncomingProperties().entrySet()) {
            builder.append(entry.getKey()).append("-").append(entry.getValue().getName()).append("-").append(entry.getValue().getExpression()).append(";");
        }
        builder.append(";OutgoingProperties:");
        for (Map.Entry<String, ServiceProperty> entry : this.getOutgoingProperties().entrySet()) {
            builder.append(entry.getKey()).append("-").append(entry.getValue().getName()).append("-").append(entry.getValue().getExpression()).append(";");
        }
        return builder.toString();
    }

    private static void resolveProperties(ServicePropertySet propertySet, Map<String, ServiceProperty> propertiesMap) {
        for (ServiceProperty property : propertySet.getServiceProperties()) {
            propertiesMap.put(property.getName(), property);
        }
    }

    private void resolveInputProperties(ServicePropertySet propertySet) {
        if (!this.isEmpty(propertySet)) {
            MDServiceActivityBase.resolveProperties(propertySet, this.inputServiceProperties);
        }
    }

    private boolean isEmpty(ServicePropertySet propertySet) {
        return propertySet == null || propertySet.getServiceProperties().isEmpty();
    }

    private void resolveOutputProperties(ServicePropertySet propertySet) {
        if (!this.isEmpty(propertySet)) {
            MDServiceActivityBase.resolveProperties(propertySet, this.outputServiceProperties);
        }
    }

    protected static class CorrelationSetInfo {
        private String[] initiateCorrelationSetNames;
        private String[] subscribeCorrelationSetNames;

        public CorrelationSetInfo(CorrelationItemsContainer correlationItemsContainer) {
            if (correlationItemsContainer != null) {
                ArrayList<String> initiateList = new ArrayList<String>();
                ArrayList<String> subscribeList = new ArrayList<String>();
                for (CorrelationItem item : correlationItemsContainer.getCorrelationItems()) {
                    String correlationName = item.getCorrelationKey().getName();
                    if (item.initiates()) {
                        initiateList.add(correlationName);
                        continue;
                    }
                    subscribeList.add(correlationName);
                }
                this.initiateCorrelationSetNames = new String[initiateList.size()];
                initiateList.toArray(this.initiateCorrelationSetNames);
                this.subscribeCorrelationSetNames = new String[subscribeList.size()];
                subscribeList.toArray(this.subscribeCorrelationSetNames);
            } else {
                this.initiateCorrelationSetNames = new String[0];
                this.subscribeCorrelationSetNames = new String[0];
            }
        }

        public String[] getInitiateCorrelationSetNames() {
            return this.initiateCorrelationSetNames;
        }

        public String[] getSubscribeCorrelationSetNames() {
            return this.subscribeCorrelationSetNames;
        }
    }
}

