/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions.md;

import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.microkernel.MDOutgoingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDOperationRef;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceActivityBase;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;

public class MDReply
extends MDServiceActivityBase
implements MDServiceActivity,
MDOutgoingMessage {
    private final FlowNode flowElement;
    private final String[] initiateCorrelationSetNames;
    private final DataDeclarationContainer inputArgumentsContainer;
    private final DataAssociationSet inputDataAssociationSet;
    private final String[] inputHeaderVariableNames;
    private final String outputVariableName;
    private final String serviceName;

    public MDReply(String outputVariableName, MDOperationRef mdOperationRef, DataAssociationSet inputDataAssociationSet, DataDeclarationContainer inputArgumentsContainer, String serviceName, FlowNode flowElement, ServicePropertySet inputServiceProperties, CorrelationItemsContainer correlationItemsContainer, String[] inputHeaderVariableNames) {
        super(mdOperationRef, inputServiceProperties, null);
        this.outputVariableName = outputVariableName;
        this.inputDataAssociationSet = inputDataAssociationSet;
        this.inputArgumentsContainer = inputArgumentsContainer;
        this.serviceName = serviceName;
        this.flowElement = flowElement;
        this.inputHeaderVariableNames = inputHeaderVariableNames;
        MDServiceActivityBase.CorrelationSetInfo correlationSetInfo = new MDServiceActivityBase.CorrelationSetInfo(correlationItemsContainer);
        this.initiateCorrelationSetNames = correlationSetInfo.getInitiateCorrelationSetNames();
    }

    @Override
    public String getOutputVariableName() {
        return this.outputVariableName;
    }

    @Override
    public DataAssociationSet getInputDataAssociationSet() {
        return this.inputDataAssociationSet;
    }

    @Override
    public DataDeclarationContainer getInputArgumentsContainer() {
        return this.inputArgumentsContainer;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public FlowNode getFlowElement() {
        return this.flowElement;
    }

    @Override
    public QName getEventName() {
        return null;
    }

    @Override
    public QName getEventPayloadName() {
        return null;
    }

    @Override
    public boolean markCompleteWhenDone() {
        return true;
    }

    public String[] getInitiateCorrelationSetNames() {
        return this.initiateCorrelationSetNames;
    }

    public String[] getInputHeaderVariableNames() {
        return this.inputHeaderVariableNames;
    }

    @Override
    public String getMetadataDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getMetadataDescription());
        builder.append(";OutputVariableName:").append(this.getOutputVariableName());
        builder.append(";Correlations:");
        for (String correlation : this.getInitiateCorrelationSetNames()) {
            builder.append(correlation).append(";");
        }
        builder.append(";ArgumentsContainer:");
        for (DataDeclaration dd : this.getInputArgumentsContainer().getDeclarations()) {
            builder.append(dd.getName()).append("-").append(dd.getDeclarationType().getString()).append(";");
        }
        builder.append(";DataAssociations:");
        for (DataAssociation dae : this.getInputDataAssociationSet().getDataAssociations()) {
            builder.append(dae.toString()).append(";");
        }
        builder.append(";Headers:");
        for (String header : this.getInputHeaderVariableNames()) {
            builder.append(header).append(";");
        }
        return builder.toString();
    }
}

