/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions.md;

import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.microkernel.MDIncomingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDOperationRef;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceActivityBase;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;
import oracle.bpm.util.ArrayUtils;

public class MDReceive
extends MDServiceActivityBase
implements MDServiceActivity,
MDIncomingMessage {
    private final QName eventName;
    private final QName eventPayloadName;
    private final FlowNode flowElement;
    private final boolean inEventHandler;
    private final String[] initiateCorrelationSetNames;
    private final String[] inputHeaderVariableNames;
    private final String inputVariableName;
    private final boolean isEventInterrupting;
    private final DataDeclarationContainer outputArgumentsContainer;
    private final DataAssociationSet outputDataAssociationSet;
    private final String serviceName;
    private final String[] subscribeCorrelationSetNames;

    public MDReceive(String inputVariableName, MDOperationRef mdOperationRef, DataAssociationSet outputDataAssociationSet, DataDeclarationContainer outputArgumentsContainer, String serviceName, QName eventName, QName eventPayloadName, FlowNode flowElement, ServicePropertySet outputServiceProperties, CorrelationItemsContainer correlationItemsContainer, boolean inEventHandler, boolean isEventInterrupting, String[] inputHeaderVariableNames) {
        super(mdOperationRef, null, outputServiceProperties);
        this.inputVariableName = inputVariableName;
        this.outputDataAssociationSet = outputDataAssociationSet;
        this.outputArgumentsContainer = outputArgumentsContainer;
        this.serviceName = serviceName;
        this.eventName = eventName;
        this.eventPayloadName = eventPayloadName;
        this.flowElement = flowElement;
        this.inEventHandler = inEventHandler;
        this.isEventInterrupting = isEventInterrupting;
        this.inputHeaderVariableNames = inputHeaderVariableNames == null ? ArrayUtils.EMPTY_STRING_ARRAY : inputHeaderVariableNames;
        MDServiceActivityBase.CorrelationSetInfo correlationSetInfo = new MDServiceActivityBase.CorrelationSetInfo(correlationItemsContainer);
        this.initiateCorrelationSetNames = correlationSetInfo.getInitiateCorrelationSetNames();
        this.subscribeCorrelationSetNames = correlationSetInfo.getSubscribeCorrelationSetNames();
    }

    @Override
    public String getInputVariableName() {
        return this.inputVariableName;
    }

    @Override
    public DataAssociationSet getOutputDataAssociationSet() {
        return this.outputDataAssociationSet;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public FlowNode getFlowElement() {
        return this.flowElement;
    }

    @Override
    public QName getEventName() {
        return this.eventName;
    }

    @Override
    public QName getEventPayloadName() {
        return this.eventPayloadName;
    }

    public String[] getInputHeaderVariableNames() {
        return this.inputHeaderVariableNames;
    }

    @Override
    public DataDeclarationContainer getOutputArgumentsContainer() {
        return this.outputArgumentsContainer;
    }

    @Override
    public boolean markCompleteWhenDone() {
        return true;
    }

    public boolean useCorrelationSet() {
        return this.initiateCorrelationSetNames.length > 0 || this.subscribeCorrelationSetNames.length > 0;
    }

    public String[] getInitiateCorrelationSetNames() {
        return this.initiateCorrelationSetNames;
    }

    public String[] getSubscribeCorrelationSetNames() {
        return this.subscribeCorrelationSetNames;
    }

    @Override
    public String getMetadataDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getMetadataDescription());
        builder.append(";IsEventHandler").append(this.isInEventHandler());
        builder.append(";isEventInterrupting").append(this.isEventInterrupting());
        builder.append(";InputVariableName:").append(this.getInputVariableName());
        builder.append(";Correlations:");
        for (String correlation : this.getInitiateCorrelationSetNames()) {
            builder.append(correlation).append(";");
        }
        for (String correlation : this.getSubscribeCorrelationSetNames()) {
            builder.append(correlation).append(";");
        }
        builder.append(";ArgumentsContainer:");
        for (DataDeclaration dd : this.getOutputArgumentsContainer().getDeclarations()) {
            builder.append(dd.getName()).append("-").append(dd.getDeclarationType().getString()).append(";");
        }
        builder.append(";DataAssociations:");
        for (DataAssociation dae : this.getOutputDataAssociationSet().getDataAssociations()) {
            builder.append(dae.toString()).append(";");
        }
        builder.append(";Headers:");
        for (String header : this.getInputHeaderVariableNames()) {
            builder.append(header).append(";");
        }
        return builder.toString();
    }

    public boolean isInEventHandler() {
        return this.inEventHandler;
    }

    public boolean isEventInterrupting() {
        return this.isEventInterrupting;
    }
}

