/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions.md;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.OperationReference;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.jetbrains.annotations.NotNull;

public class MDOperationRef {
    private boolean allowsWrappedArguments;
    private QName faultCodeError = null;
    private QName faultMessageType = null;
    private Map<String, String> inputPartNamesMap;
    private QName inputType = null;
    private boolean isTwoWay = false;
    private String name = null;
    private Map<String, String> outputPartNamesMap;
    private QName outputType = null;
    private String partName = null;
    private QName portType = null;

    public MDOperationRef(@NotNull String name, @NotNull QName portType, boolean isTwoWay, QName inputType, QName outputType, QName faultCodeError, QName faultMessageType) {
        this.name = name;
        this.inputType = inputType;
        this.isTwoWay = isTwoWay;
        this.portType = portType;
        this.outputType = outputType;
        this.faultCodeError = faultCodeError;
        this.faultMessageType = faultMessageType;
    }

    public MDOperationRef(OperationReference operationRef, boolean isTwoWay, QName inputType, QName outputType, QName faultCodeError, QName faultMessageType, DataAssociationSet inputDataAssociationSet, DataAssociationSet outputDataAssociationSet) {
        this(operationRef.getName(), operationRef.getPortType(), isTwoWay, inputType, outputType, faultCodeError, faultMessageType);
        this.allowsWrappedArguments = operationRef.allowsWrappedArguments();
        this.inputPartNamesMap = new HashMap<String, String>();
        this.outputPartNamesMap = new HashMap<String, String>();
        MDOperationRef.fillPartNamesMap(operationRef, inputDataAssociationSet, this.inputPartNamesMap);
        MDOperationRef.fillPartNamesMap(operationRef, outputDataAssociationSet, this.outputPartNamesMap);
    }

    public MDOperationRef(String partName, String name, QName portType, boolean isTwoWay, QName inputType, QName outputType, QName faultCodeError, QName faultMessageType) {
        this(name, portType, isTwoWay, inputType, outputType, faultCodeError, faultMessageType);
        this.partName = partName;
        this.inputPartNamesMap = new HashMap<String, String>();
        this.outputPartNamesMap = new HashMap<String, String>();
        this.inputPartNamesMap.put(partName, partName);
    }

    public String findArgumentPartName(String argumentName) {
        return this.partName;
    }

    public String getName() {
        return this.name;
    }

    public QName getInputType() {
        return this.inputType;
    }

    public boolean isTwoWay() {
        return this.isTwoWay;
    }

    public QName getPortType() {
        return this.portType;
    }

    public QName getOutputType() {
        return this.outputType;
    }

    public QName getFaultCodeError() {
        return this.faultCodeError;
    }

    public QName getFaultMessageType() {
        return this.faultMessageType;
    }

    public boolean allowsWrappedArguments() {
        return this.allowsWrappedArguments;
    }

    public Map<String, String> getInputPartNamesMap() {
        return Collections.unmodifiableMap(this.inputPartNamesMap);
    }

    public Map<String, String> getOutputPartNamesMap() {
        return Collections.unmodifiableMap(this.outputPartNamesMap);
    }

    private static void fillPartNamesMap(OperationReference operationRef, DataAssociationSet dataAssociationSet, Map<String, String> partNamesMap) {
        if (dataAssociationSet != null) {
            Sequence dataDeclarationSequence = dataAssociationSet.getArgumentsContainer().getDeclarations();
            for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
                String partName = operationRef.findArgumentPartName(dataDeclaration.getName());
                if (partNamesMap.containsKey(dataDeclaration.getName())) {
                    throw new RuntimeException("MDServiceActivityBase.fillPartNamesMap duplicated arguments");
                }
                partNamesMap.put(dataDeclaration.getName(), partName);
            }
        }
    }
}

