/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions.md;

import com.collaxa.cube.engine.core.map.ICubeBlock;
import oracle.bpm.bpmn.engine.microkernel.MIMetadata;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;

public class MDGenerateNextToken
implements MIMetadata {
    private final boolean createNewThread;
    private final String nextTokenId;
    private final int parentBlockDepth;
    private final BPMNCubeElement sourceNode;

    public MDGenerateNextToken(boolean createNewThread, BPMNCubeElement sourceNode, String nextTokenId) {
        this.createNewThread = createNewThread;
        this.sourceNode = sourceNode;
        this.nextTokenId = nextTokenId;
        this.parentBlockDepth = this.calculateParentBlocksDepth();
    }

    public int getParentBlockDepth() {
        return this.parentBlockDepth;
    }

    public boolean isCreateNewThread() {
        return this.createNewThread;
    }

    public BPMNCubeElement getSourceNode() {
        return this.sourceNode;
    }

    public String getNextTokenId() {
        return this.nextTokenId;
    }

    private int calculateParentBlocksDepth() {
        int result = 0;
        boolean blockFound = false;
        for (ICubeBlock block = this.sourceNode.getParentBlock(); !blockFound && block != null; block = block.getParentBlock()) {
            for (ICubeBlock iCubeBlock : block.getChildBlocks()) {
                if (!iCubeBlock.getId().equals(this.nextTokenId)) continue;
                blockFound = true;
                break;
            }
            if (!blockFound) {
                for (ICubeBlock iCubeBlock : block.getChildNodes()) {
                    if (!iCubeBlock.getId().equals(this.nextTokenId)) continue;
                    blockFound = true;
                    break;
                }
            }
            ++result;
        }
        return result;
    }
}

