/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.persistence.dto.WorkItemKey;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceLocal;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskResponse;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;

public class MIUserTaskWithdraw
extends MIBase<Object> {
    public static void withdrawUserTaskIfExist(ICubeContext context, IScope sc, WorkItemKey workItemKey) throws Exception {
        String taskIdKey = MIUserTaskWithdraw.getTaskIdKey(workItemKey);
        if (sc.contains(taskIdKey)) {
            String taskId = MIUserTaskWithdraw.getTaskId(sc, workItemKey);
            if (taskId != null) {
                ArrayList<String> taskIds = new ArrayList<String>();
                taskIds.add(taskId);
                MIUserTaskWithdraw.withdrawUserTask(workItemKey, sc, taskIds, context);
            } else {
                BPELExecutionLogger.LOG.debug((Object)("No UserTask Id found to withdraw. WorkItemKey: " + workItemKey.toString()));
            }
        }
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        WorkItemKey workItemKey = wi.getKey();
        MIUserTaskWithdraw.withdrawUserTaskIfExist(context.getCubeContext(), sc, workItemKey);
        return null;
    }

    private static String getTaskIdKey(WorkItemKey wiKey) {
        return wiKey + ".taskid";
    }

    private static String getTaskId(IScope sc, WorkItemKey wiKey) throws CubeException {
        Object object;
        String taskIdKey = MIUserTaskWithdraw.getTaskIdKey(wiKey);
        if (sc.contains(taskIdKey) && (object = sc.getObject(taskIdKey)) != null) {
            return object.toString();
        }
        return null;
    }

    private static void withdrawUserTask(WorkItemKey wiKey, IScope sc, List<String> taskIds, ICubeContext cubeContext) throws Exception {
        IInternalInstanceManagementServiceLocal local = BPMNUtility.getInternalManagementservice(cubeContext);
        local.withdrawWorkflowTasks(taskIds, true);
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)cubeContext);
        MIUserTaskResponse.unregisterTaskInScope(wiKey, sc, ci);
    }
}

