/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.delivery.IDeliveryService;
import com.collaxa.cube.engine.delivery.SubscriptionInfo;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.engine.types.bpel.CXPartnerLink;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.collaxa.cube.persistence.dto.WorkItemKey;
import com.oracle.bpel.client.BPELFault;
import com.oracle.bpel.client.CorrelationId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskCallback;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.model.runtime.util.ScopeUtils;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.audit.impl.AuditService;
import oracle.bpm.project.model.processes.UserTask;
import oracle.soa.common.util.XMLUtil;
import oracle.soa.management.ComponentDN;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MIUserTaskResponse
extends MIBase<Object> {
    private MDServiceTask mdServiceTask;
    private UserTask userTask = null;
    public static final String TASK_SERVICE_NAMESPACE = "http://xmlns.oracle.com/bpel/workflow/taskService";
    private static final String TASK_SERVICE_CALLBACK_OPERATION = "onTaskCompleted";
    private static final String TASK_SERVICE_CALLBACK_PORTTYPE = "TaskServiceCallback";
    private static final String TASK_NAMESPACE = "http://xmlns.oracle.com/bpel/workflow/task";
    private static final String TASK_PRIORITY_XPATH = "/task:task/task:priority";
    private static final String TASK_PAYLOAD_XPATH = "/task:task/task:payload";
    private static final String TASK_TITLE_XPATH = "/task:task/task:title";
    private static final String TASK_OWNER_USER_XPATH = "/task:task/task:ownerUser";
    private static final String TASK_CREATOR_XPATH = "/task:task/task:creator";
    private static final String TASK_INSTANCEID_XPATH = "/task:task/task:processInfo/task:instanceId";
    private static final String TASK_PROCESSID_XPATH = "/task:task/task:processInfo/task:processId";
    private static final String TASK_ACTIVITYID_XPATH = "/task:task/task:systemAttributes/task:activityId";
    private static final String TASK_THREAD_XPATH = "/task:task/task:systemAttributes/task:thread";
    private static final String TASK_PARENTTHREAD_XPATH = "/task:task/task:systemAttributes/task:parentThread";
    private static final String PAYLOAD_ELEMENT_NAME = "payload";
    private static final String TASK_ELEMENT_NAME = "task";
    private static final String TITLE_ELEMENT_NAME = "title";
    private static final String TASK_NUMBER_ELEMENT_NAME = "taskNumber";
    public static final String INITIATETASK_OP = "initiateTask";
    public static final String RE_INITIATETASK_OP = "reinitiateTask";
    public static final String TASKSERVICE_PORTTYPE = "TaskService";
    public static final String TASKSERVICE_INIIATETASKMESSAGE = "initiateTaskMessage";
    public static final String TASKSERVICE_INIIATETASKRESPONSEMESSAGE = "initiateTaskResponseMessage";
    public static final String TASKSERVICE_INITIATE_TASK_RESPONSE = "initiateTaskResponse";
    public static final String TASKSERVICE_INIIATEFAULTMESSAGE = "workflowErrorMessage";
    private static final String[] sTaskElementsXPath = new String[]{"/task:task/task:priority", "/task:task/task:payload", "/task:task/task:title", "/task:task/task:ownerUser", "/task:task/task:creator", "/task:task/task:processInfo/task:instanceId", "/task:task/task:processInfo/task:processId", "/task:task/task:systemAttributes/task:activityId", "/task:task/task:systemAttributes/task:thread", "/task:task/task:systemAttributes/task:parentThread"};
    public static final String TASKID_SUFFIX = ".taskid";

    public MIUserTaskResponse(MDServiceTask mdServiceTask) {
        this.mdServiceTask = mdServiceTask;
        this.userTask = (UserTask)mdServiceTask.getFlowElement();
    }

    public static void unregisterTaskInScope(WorkItemKey wiKey, IScope sc, ICubeInstanceImpl ci) throws CubeException {
        String key = wiKey + TASKID_SUFFIX;
        String taskId = null;
        if (sc.contains(key)) {
            taskId = (String)sc.getObject(key);
            sc.set(key, null);
        }
        if (wiKey != null) {
            MIUserTaskResponse.unregisterTaskInRootScopeMap(wiKey.getNodeId(), ci, taskId);
        }
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        this.handleTaskServiceResponse(context);
        return null;
    }

    private static void registerTaskInScope(IWorkItem wi, IScope sc, CXMessageVariable result, ICubeInstanceImpl ci) throws CubeException {
        String taskId = MIUserTaskResponse.getTaskId((Map)result, (ICubeInstance)ci);
        WorkItemKey wiKey = wi.getKey();
        sc.declareAndSet(wiKey + TASKID_SUFFIX, (Object)taskId);
        String nodeId = wiKey.getNodeId();
        MIUserTaskResponse.registerTaskInRootScopeMap(ci, taskId, nodeId);
    }

    private static void registerTaskInRootScopeMap(ICubeInstanceImpl ci, String taskId, String nodeId) throws CubeException {
        Set<String> taskIds;
        IScopeImpl scope = ci.getScopeContext().getRootScope();
        Map<String, Set<String>> tasksInRootScope = null;
        if (scope.contains("__taskmap_rootscope__")) {
            tasksInRootScope = (Map)scope.getObject("__taskmap_rootscope__");
        } else {
            tasksInRootScope = new HashMap();
            scope.declareAndSet("__taskmap_rootscope__", tasksInRootScope);
        }
        if (tasksInRootScope.containsKey(nodeId)) {
            taskIds = ScopeUtils.getTaskIdsSet(nodeId, tasksInRootScope);
        } else {
            taskIds = new HashSet<String>();
            tasksInRootScope.put(nodeId, taskIds);
        }
        taskIds.add(taskId);
    }

    private static void unregisterTaskInRootScopeMap(String nodeId, ICubeInstanceImpl ci, String taskId) throws CubeException {
        Map taskMap;
        IScopeImpl scope = ci.getScopeContext().getRootScope();
        if (scope.contains("__taskmap_rootscope__") && (taskMap = (Map)scope.getObject("__taskmap_rootscope__")) != null && nodeId != null) {
            if (taskId != null) {
                Set<String> taskIds = ScopeUtils.getTaskIdsSet(nodeId, taskMap);
                if (taskIds != null) {
                    taskIds.remove(taskId);
                }
                if (taskIds.isEmpty()) {
                    taskMap.remove(nodeId);
                }
            } else {
                taskMap.remove(nodeId);
            }
        }
    }

    private static String getState(Map output, ICubeInstance ci) {
        String stateValue = MIUserTaskResponse.getSystemAttribute(output, ci, "state");
        if (stateValue == null || stateValue.equals("COMPLETED")) {
            return null;
        }
        return stateValue;
    }

    private static String getTaskId(Map output, ICubeInstance ci) {
        return MIUserTaskResponse.getSystemAttribute(output, ci, "taskId");
    }

    private static String getSystemAttribute(Map output, ICubeInstance ci, String attributeName) {
        NodeList stateNodes;
        XMLElement task;
        XMLElement systemAttributes;
        XMLElement taskService;
        String value = "";
        if (output != null && (taskService = (XMLElement)output.get(PAYLOAD_ELEMENT_NAME)) != null && (systemAttributes = (XMLElement)(task = (XMLElement)taskService.getElementsByTagNameNS(TASK_NAMESPACE, TASK_ELEMENT_NAME).item(0)).getElementsByTagNameNS(TASK_NAMESPACE, "systemAttributes").item(0)) != null && (stateNodes = systemAttributes.getElementsByTagNameNS(TASK_NAMESPACE, attributeName)).getLength() > 0) {
            Node stateE = stateNodes.item(0);
            value = XMLUtil.getNodeValue((Node)stateE);
        }
        return value;
    }

    private void handleTaskServiceResponse(MicroInstructionContext context) throws Throwable {
        String taskNumber;
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        AuditService.getAuditTrail(ctx);
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        String serviceName = this.userTask.getHumanTask().getText() + ".reference";
        CXPartnerLink partnerLink = (CXPartnerLink)sc.getObject(serviceName);
        String convId = partnerLink.getConversationId();
        CXMessageVariable result = (CXMessageVariable)sc.getObject(this.mdServiceTask.getOutputVariableName());
        if (this.userTask.isManualStart()) {
            this.setTitleofCubeInstance((Map)result, (ICubeInstance)ci);
        }
        if ((taskNumber = MIUserTaskResponse.getSystemAttribute((Map)result, (ICubeInstance)ci, TASK_NUMBER_ELEMENT_NAME)) != null && !taskNumber.isEmpty()) {
            AuditUtil.addUserTaskNumberToPayload(ctx, (ICubeInstance)ci, sc.getAbsoluteScopeId(), Long.valueOf(taskNumber), context.getWmp().getBPMNCubeNode().getFlowElement().getId());
        }
        if (!wi.isComplete()) {
            if (MIUserTaskResponse.getState((Map)result, (ICubeInstance)ci) != null) {
                this.registerCallback(wi, sc, ctx, convId);
                MIUserTaskResponse.registerTaskInScope(wi, sc, result, ci);
                wi.markAsOpenPendingComplete();
                MIUserTaskCallback.processOutputData(context, this.userTask, (Map)result, true);
            } else {
                wi.markAsComplete();
                MIUserTaskCallback.processOutputData(context, this.userTask, (Map)result);
                BPMNUtility.insertInstance2Track(context, "COMPLETED");
            }
        }
        String activationIds = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(wi.getNodeActivationContext());
        sc.declareAndSet(convId + ".activationid", (Object)activationIds);
    }

    private void setTitleofCubeInstance(Map output, ICubeInstance ci) {
        String titleValue;
        XMLElement task;
        XMLElement title;
        XMLElement taskService;
        if (output != null && (taskService = (XMLElement)output.get(PAYLOAD_ELEMENT_NAME)) != null && (title = (XMLElement)(task = (XMLElement)taskService.getElementsByTagNameNS(TASK_NAMESPACE, TASK_ELEMENT_NAME).item(0)).getElementsByTagNameNS(TASK_NAMESPACE, TITLE_ELEMENT_NAME).item(0)) != null && (titleValue = XMLUtil.getNodeValue((Node)title)) != null && !titleValue.trim().equals("")) {
            ci.setTitle(titleValue);
        }
    }

    private void registerCallback(IWorkItem wi, IScope sc, ICubeContext ctx, String conversationId) throws Exception {
        IDeliveryService ds = (IDeliveryService)ctx.lookup("__delivery-service");
        String partnerName = this.userTask.getHumanTask().getText() + ".reference";
        CXPartnerLink partner = (CXPartnerLink)sc.getObject(partnerName);
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        CorrelationId cId = new CorrelationId(ci.getProcessClass().getProcessDN(), wi.getKey().toString());
        ICubeProcess cp = ci.getProcessClass();
        ComponentDN pid = cp.getProcessDN();
        SubscriptionInfo sbInfo = null;
        wi.setCustomId(conversationId);
        sbInfo = new SubscriptionInfo(conversationId, cId.toString(), pid, partner.getName(), TASK_SERVICE_CALLBACK_OPERATION, null, ci.getKey());
        sbInfo.getProperties().putAll(partner.getProperties());
        sbInfo.setNodeType("bpel");
        sbInfo.setPortTypeName(new QName(TASK_SERVICE_NAMESPACE, TASK_SERVICE_CALLBACK_PORTTYPE));
        sbInfo.setConversationType(partner.getConversationType());
        try {
            ds.subscribe(sbInfo, ctx);
        }
        catch (Exception e) {
            if (e instanceof CubeException && ((CubeException)((Object)e)).getErrorCode() == 3810) {
                BPELFault bf = new BPELFault(BPELDefs.QN_CONFLICTIING_RECEIVE, e.getMessage());
                throw bf;
            }
            throw e;
        }
    }
}

