/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.engine.types.bpel.CXPartnerLink;
import com.collaxa.cube.xml.dom.DOMUtil;
import com.collaxa.cube.xml.xpath.XPathException;
import com.oracle.bpel.client.BPELFault;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.task.impl.TaskUtil;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.ProcessType;
import oracle.bpel.services.workflow.task.model.SystemAttributesType;
import oracle.bpel.services.workflow.task.model.TaskImpl;
import oracle.bpm.bpmn.engine.logging.BPMNLoggerManager;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttribute;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.integration.platform.common.NMUtil;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MIUserTaskRequest
extends MIBase<Object> {
    private Logger logger = BPMNLoggerManager.getInstance().getLogger(BPELExecutionLogger.class.getName());
    private MDServiceTask mdServiceTask;
    private Map<String, Object> mElementMap = null;
    private UserTask userTask = null;
    public static final String TASK_SERVICE_NAMESPACE = "http://xmlns.oracle.com/bpel/workflow/taskService";
    public static final String TASK_NAMESPACE = "http://xmlns.oracle.com/bpel/workflow/task";
    private static final String TASK_XML_FRAGMENT = "<task xmlns=\"http://xmlns.oracle.com/bpel/workflow/task\">\n</task>";
    private static final String INITIATE_TASKSERVICE_XML_FRAGMENT = "<initiateTask xmlns=\"http://xmlns.oracle.com/bpel/workflow/taskService\">\n<task xmlns=\"http://xmlns.oracle.com/bpel/workflow/task\">\n</task></initiateTask>";
    private static final String REINITIATE_TASKSERVICE_XML_FRAGMENT = "<reinitiateTask xmlns=\"http://xmlns.oracle.com/bpel/workflow/taskService\">\n<task xmlns=\"http://xmlns.oracle.com/bpel/workflow/task\">\n</task></reinitiateTask>";
    public static final String PAYLOAD_ELEMENT_NAME = "payload";
    public static final String TASK_ELEMENT_NAME = "task";
    public static final String SYSATTRS_ELEMENT_NAME = "systemAttributes";
    public static final String STATE_ELEMENT_NAME = "state";
    public static final String TASKID_ELEMENT_NAME = "taskId";
    public static final String TASKSERVICE_PORTTYPE = "TaskService";
    public static final String TASKSERVICE_INIIATETASKMESSAGE = "initiateTaskMessage";
    public static final String TASKSERVICE_INIIATETASKRESPONSEMESSAGE = "initiateTaskResponseMessage";
    public static final String TASKSERVICE_TASKMESSAGE = "taskMessage";
    public static final String TASKSERVICE_INIIATEFAULTMESSAGE = "workflowErrorMessage";
    public static final String INITIATETASK_OP = "initiateTask";
    public static final String RE_INITIATETASK_OP = "reinitiateTask";

    public MIUserTaskRequest(MDServiceTask mdServiceTask, Map<String, Object> map) {
        this.mdServiceTask = mdServiceTask;
        this.userTask = (UserTask)mdServiceTask.getFlowElement();
        this.mElementMap = map;
    }

    @Override
    protected Object doExecute(MicroInstructionContext miContext) throws Throwable {
        IWorkItem wi = miContext.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = miContext.getCubeContext();
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        try {
            this.handleTaskServiceInvoke(ci, wi, sc, ctx, miContext);
        }
        catch (BPELFault e) {
            DataHandlingUtils.trapBPELFaults(miContext, e);
        }
        catch (XPathException e) {
            DataHandlingUtils.trapXPathQueryFailed(miContext, e);
        }
        return null;
    }

    private void handleTaskServiceInvoke(ICubeInstanceImpl ci, IWorkItem wi, IScope sc, ICubeContext ctx, MicroInstructionContext context) throws Throwable {
        String serviceName = this.userTask.getHumanTask().getText() + ".reference";
        CXPartnerLink partnerLink = (CXPartnerLink)sc.getObject(serviceName);
        HashMap<String, Boolean> partnerProperties = partnerLink.getProperties();
        if (partnerProperties == null) {
            partnerProperties = new HashMap<String, Boolean>();
            partnerLink.setProperties(partnerProperties);
        }
        partnerProperties.put("DONNOT_MARK_COMPLETE", true);
        if (this.userTask.getHumanTaskType().isFyi()) {
            partnerProperties.put("DO_NOT_SEND_CALLBACKS", true);
        } else {
            partnerProperties.put("DO_NOT_SEND_CALLBACKS", false);
        }
        String convId = NMUtil.generateConversationId();
        partnerLink.setConversationId(convId);
        String correlatingId = ci.getConversationId();
        HashMap inputs = new HashMap();
        this.processInputData(this.userTask, sc, ctx, wi, inputs, ci, correlatingId);
        CXMessageVariable inputVariable = (CXMessageVariable)sc.getObject(this.mdServiceTask.getInputVariableName());
        inputVariable.putAll(inputs);
    }

    private CXMessageVariable getOutVariable(IScope sc, UserTask userTask) throws Exception {
        String outputVarName = userTask.getDefaultLabel() + "_" + userTask.getId() + "_out";
        return sc.contains(outputVarName) ? (CXMessageVariable)sc.getObject(outputVarName) : null;
    }

    private Map<String, Object> getInitialValues(IScope sc, ICubeContext ctx) throws Exception {
        HashMap<String, Object> initialValues;
        block8: {
            block7: {
                NodeList nodes;
                Element taskServiceOutputElement;
                initialValues = new HashMap<String, Object>();
                if (!this.isReinitiate(sc)) break block7;
                UserTask rUserTask = this.userTask.getReinitiateSource();
                if (rUserTask == null) {
                    return initialValues;
                }
                CXMessageVariable outputVariable = this.getOutVariable(sc, rUserTask);
                if (outputVariable == null || (taskServiceOutputElement = (Element)outputVariable.get((Object)PAYLOAD_ELEMENT_NAME)) == null || (nodes = taskServiceOutputElement.getElementsByTagNameNS(TASK_NAMESPACE, TASK_ELEMENT_NAME)).getLength() <= 0) break block8;
                Sequence dataDeclarationSequence = this.userTask.getInputDataAssociationSet().getArgumentsContainer().getDeclarations();
                Object[] dataDecls = dataDeclarationSequence.toArray();
                int declSize = dataDecls.length - 1;
                String execDataOrTaskVarName = null;
                if (declSize > 0) {
                    DataDeclaration lastArg = (DataDeclaration)dataDecls[declSize];
                    execDataOrTaskVarName = lastArg.getName();
                }
                Element reinitiateElement = (Element)nodes.item(0);
                Element taskElement = DOMUtil.createRootElement((String)TASK_ELEMENT_NAME, (String)TASK_NAMESPACE);
                NodeList payloadNode = (taskElement = (Element)DOMUtil.copyObjHelper((Object)reinitiateElement, (Object)taskElement, (boolean)false, (ICubeContext)ctx)).getElementsByTagNameNS(TASK_NAMESPACE, PAYLOAD_ELEMENT_NAME);
                if (payloadNode.getLength() > 0) {
                    Element payloadElement = (Element)payloadNode.item(0);
                    if (!this.userTask.getReinitiatePolicy().isClear()) {
                        for (int i = 0; i < declSize; ++i) {
                            DataDeclaration datType = (DataDeclaration)dataDecls[i];
                            String elementName = datType.getNativeName();
                            String variableId = datType.getName();
                            SchemaObject object = datType.getType().getDelegate().asSchemaObject();
                            String nameSpace = object.isType() ? TASK_NAMESPACE : object.getNamespace();
                            NodeList argNodes = payloadElement.getElementsByTagNameNS(nameSpace, elementName);
                            if (argNodes.getLength() <= 0) continue;
                            initialValues.put(variableId, argNodes.item(0));
                        }
                    }
                    NodeList payloadChildNodes = payloadElement.getChildNodes();
                    for (int i = 0; i < payloadChildNodes.getLength(); ++i) {
                        payloadElement.removeChild(payloadChildNodes.item(i));
                    }
                }
                if (execDataOrTaskVarName == null) break block8;
                initialValues.put(execDataOrTaskVarName, taskElement);
                break block8;
            }
            Sequence dataDeclarationSequence = this.userTask.getInputDataAssociationSet().getArgumentsContainer().getDeclarations();
            for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
                SchemaObject asSchemaObject = dataDeclaration.getType().getDelegate().asSchemaObject();
                String argName = asSchemaObject.isType() ? dataDeclaration.getNativeName() : asSchemaObject.getName();
                Element element = (Element)this.mElementMap.get(argName);
                if (element == null) continue;
                Document document = DOMUtil.createDocument();
                Element newElement = (Element)XMLUtil.cloneNode((Document)document, (Node)element);
                document.appendChild(newElement);
                initialValues.put(dataDeclaration.getName(), newElement);
            }
        }
        return initialValues;
    }

    private void processInputData(UserTask userTask, IScope sc, ICubeContext ctx, IWorkItem wi, Map payload, ICubeInstanceImpl ci, String conversationId) throws Exception {
        HashMap<String, Element> inputData = new HashMap<String, Element>();
        Map<String, Object> initialValues = this.getInitialValues(sc, ctx);
        Map<String, DataElementVariable> data = DataHandlingUtils.processInputData((FlowNode)userTask, userTask.getInputDataAssociationSet(), sc, ctx, wi, initialValues);
        DataAssociationSet inputAssociation = userTask.getInputDataAssociationSet();
        Sequence dataDeclarationSequence = inputAssociation.getArgumentsContainer().getDeclarations();
        Object[] dataDecls = dataDeclarationSequence.toArray();
        int declSize = dataDecls.length - 1;
        DataDeclaration lastArg = (DataDeclaration)dataDecls[declSize];
        String execDataOrTaskVarName = lastArg.getName();
        DataElementVariable execDataVar = data.get(execDataOrTaskVarName);
        XMLElement execDataObject = (XMLElement)execDataVar.getValue();
        Element element = this.getTaskServiceElement(sc);
        Element taskElement = (Element)element.getElementsByTagNameNS(TASK_NAMESPACE, TASK_ELEMENT_NAME).item(0);
        if (execDataObject != null) {
            taskElement = (Element)DOMUtil.copyObjHelper((Object)execDataObject, (Object)taskElement, (boolean)false, (ICubeContext)ctx);
        }
        this.addTaskAttributesToXml(ctx, userTask, taskElement, sc, wi, ci, conversationId);
        XMLElement payloadElement = this.createPayloadForTaskAlways(taskElement);
        this.processDataAssociations(ctx, dataDecls, payloadElement, data);
        if (this.logger.isLoggable(Level.FINE)) {
            BPELExecutionLogger.LOG.debug(this.getClass().getName(), "processInputData", new Object[]{XMLUtil.toString((Node)element)});
        }
        inputData.put(PAYLOAD_ELEMENT_NAME, element);
        payload.putAll(inputData);
        AuditUtil.addInMessageToPayload(ctx, (ICubeInstance)ci, sc.getAbsoluteScopeId(), payload, wi.getCubeNode().getId());
    }

    private XMLElement createPayloadForTaskAlways(Element taskElement) throws Exception {
        return (XMLElement)taskElement.getElementsByTagNameNS(TASK_NAMESPACE, PAYLOAD_ELEMENT_NAME).item(0);
    }

    private void processDataAssociations(ICubeContext ctx, Object[] dataDecls, Object payload, Map data) throws Exception {
        int declSize = dataDecls.length - 1;
        for (int i = 0; i < declSize; ++i) {
            Element xmlElement;
            DataDeclaration datType = (DataDeclaration)dataDecls[i];
            String elementName = datType.getNativeName();
            String variableId = datType.getName();
            SchemaObject object = datType.getType().getDelegate().asSchemaObject();
            String nameSpace = object.isType() ? TASK_NAMESPACE : object.getNamespace();
            XMLElement payloadElement = (XMLElement)payload;
            DataElementVariable var = (DataElementVariable)data.get(variableId);
            Object val = var.getValue();
            if (val instanceof String) {
                this.addChildElementAndPopulateValue(ctx, PAYLOAD_ELEMENT_NAME, elementName, (Element)((XMLElement)payloadElement.getParentNode()), val);
                continue;
            }
            if (object.isType()) {
                xmlElement = payloadElement.getOwnerDocument().createElementNS(nameSpace, elementName);
                if (val != null) {
                    xmlElement = (Element)DOMUtil.copyObjHelper((Object)val, (Object)xmlElement, (boolean)false, (ICubeContext)ctx);
                }
            } else {
                xmlElement = (Element)val;
            }
            if (xmlElement == null) continue;
            payloadElement.appendChild(payloadElement.getDocument().importNode((Node)xmlElement, true));
        }
    }

    private boolean isReinitiate(IScope scope) throws Exception {
        CXMessageVariable out;
        UserTask rUserTask;
        boolean value = this.userTask.isReinitiate();
        if (value && (rUserTask = this.userTask.getReinitiateSource()) != null && ((out = this.getOutVariable(scope, rUserTask)) == null || out.isEmpty())) {
            return false;
        }
        return value;
    }

    private Element getTaskServiceElement(IScope scope) throws Exception {
        String xmlFragment = this.isReinitiate(scope) ? REINITIATE_TASKSERVICE_XML_FRAGMENT : INITIATE_TASKSERVICE_XML_FRAGMENT;
        return XMLUtil.parseDocument((String)xmlFragment).getDocumentElement();
    }

    private void addTaskAttributesToXml(ICubeContext ctx, UserTask userTask, Element taskElement, IScope sc, IWorkItem wi, ICubeInstanceImpl ci, String conversationId) throws Exception {
        TaskImpl task = (TaskImpl)TaskUtil.getInstance().unmarshal((Node)taskElement);
        Element payload = XMLUtil.parseDocument((String)"<payload xmlns=\"http://xmlns.oracle.com/bpel/workflow/task\"/>").getDocumentElement();
        task.setPayloadAsElement(payload);
        String title = DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(userTask.getSubject(), (FlowNode)userTask, sc, ctx);
        Number priority = DataHandlingUtils.ExpressionEvaluatorHelper.getNumberValueFromExpression(userTask.getPriority(), (FlowNode)userTask, sc, ctx);
        String ownerDefaultValue = ProcessInstanceAttribute.OWNER.isDefaultValue(sc, ctx) ? null : (String)ProcessInstanceAttribute.OWNER.getValue(sc, ctx);
        String taskOwner = DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(userTask.getOwner(), (FlowNode)userTask, ownerDefaultValue, sc, ctx);
        String creator = DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(userTask.getInitiator(), (FlowNode)userTask, (String)ProcessInstanceAttribute.CREATOR.getValue(sc, ctx), sc, ctx);
        String applicationContext = DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(userTask.getApplicationContext(), (FlowNode)userTask, sc, ctx);
        String identityContext = DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(userTask.getIdentificationContext(), (FlowNode)userTask, sc, ctx);
        String identificationKey = DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(userTask.getIdentificationKey(), (FlowNode)userTask, sc, ctx);
        String orgUnit = task.getSystemAttributes().getOrganizationalUnitName();
        if (Str.isEmpty((String)orgUnit) && "".equals(orgUnit = (String)ProcessInstanceAttribute.ORGANIZATIONALUNIT.getValue(sc, ctx))) {
            orgUnit = null;
        }
        if (!Str.isEmpty((String)title)) {
            task.setTitle(title);
        }
        if (!Str.isEmpty((String)applicationContext)) {
            task.setApplicationContext(applicationContext);
        }
        if (!Str.isEmpty((String)identityContext)) {
            task.setIdentityContext(identityContext);
        }
        if (!Str.isEmpty((String)identificationKey)) {
            task.setIdentificationKey(identificationKey);
        }
        if (!Str.isEmpty((String)taskOwner)) {
            String ownerType = (String)ProcessInstanceAttribute.OWNERTYPE.getValue(sc, ctx);
            if (ownerType.equalsIgnoreCase("USER")) {
                task.setOwnerUser(taskOwner);
            } else if (ownerType.equalsIgnoreCase("ROLE")) {
                task.setOwnerRole(taskOwner);
                task.setApplicationContext("OracleBPMProcessRolesApp");
            } else {
                task.setOwnerGroup(taskOwner);
            }
        }
        if (Str.isEmpty((String)creator) && userTask.isManualStart()) {
            creator = wi.getCubeInstance().getCreator();
        }
        if (!Str.isEmpty((String)creator)) {
            task.setCreator(creator);
        }
        if (priority != null && priority.intValue() > 0) {
            task.setPriority(priority.intValue());
        }
        ProcessType type = task.getProcessInfo();
        ObjectFactory factory = new ObjectFactory();
        if (type == null) {
            type = factory.createProcessType();
            task.setProcessInfo(type);
        }
        long instanceId = ci.getId();
        String processId = userTask.getProcess().getId();
        type.setProcessName(userTask.getProcess().getName());
        type.setProcessId(processId);
        type.setInstanceId(instanceId + "");
        SystemAttributesType sysType = task.getSystemAttributes();
        if (sysType == null) {
            sysType = factory.createSystemAttributesType();
        }
        String activityId = userTask.getId();
        String activityName = userTask.getDefaultLabel();
        Lane lane = userTask.getLane();
        String role = lane.getRole();
        HashMap map = wi.getNodeActivationContext();
        int thread = BPMNTokenMetadataUtils.getThreadFromTokenMetadata(map);
        int parentThread = BPMNTokenMetadataUtils.getParentThreadFromTokenMetadata(map);
        sysType.setActivityId(activityId);
        sysType.setActivityName(activityName);
        sysType.setSwimlaneRole(role);
        sysType.setThread(thread);
        sysType.setParentThread(parentThread);
        sysType.setOrganizationalUnitName(orgUnit);
        if (userTask.isManualStart()) {
            task.setIdentificationKey(conversationId);
        }
    }

    private void addChildElementAndPopulateValue(ICubeContext ctx, String parentElementName, String childElementName, Element element, Object value) throws Exception {
        XMLElement parentElement = (XMLElement)element.getElementsByTagNameNS(TASK_NAMESPACE, parentElementName).item(0);
        if (parentElement != null) {
            parentElement.appendChild((Node)parentElement.getDocument().createElementNS(TASK_NAMESPACE, childElementName));
            XMLElement childElement = (XMLElement)element.getElementsByTagNameNS(TASK_NAMESPACE, childElementName).item(0);
            DOMUtil.copyObjHelper((Object)value, (Object)childElement, (boolean)false, (ICubeContext)ctx);
        }
    }
}

