/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.xml.dom.DOMUtil;
import com.collaxa.cube.xml.xpath.XPathException;
import com.oracle.bpel.client.BPELFault;
import java.util.HashMap;
import java.util.Map;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.task.impl.TaskUtil;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.SystemAttributesType;
import oracle.bpel.services.workflow.task.model.TaskImpl;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskResponse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDOperationRef;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.resolver.RuntimeMetadataResolverImpl;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.fabric.common.NormalizedMessage;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MIUserTaskCallback
extends MIBase<Object> {
    private String[] initiateCorrelationSetNames;
    private MDOperationRef operRef;
    private String outputVariable;
    private UserTask userTask;

    public MIUserTaskCallback(UserTask userTask, MDOperationRef operationRef, String outputVariable, String[] initiateCorrelationSetNames) {
        this.operRef = operationRef;
        this.userTask = userTask;
        this.outputVariable = outputVariable;
        this.initiateCorrelationSetNames = initiateCorrelationSetNames;
    }

    public static void processOutputData(MicroInstructionContext context, UserTask userTask) throws Exception {
        ICubeContext ctx = context.getCubeContext();
        NormalizedMessage nm = (NormalizedMessage)ctx.getFromEnvironment("__call-NM");
        Map inputs = null;
        if (nm != null) {
            inputs = nm.getPayload();
        }
        if (inputs != null) {
            MIUserTaskCallback.processOutputData(context, userTask, inputs);
        }
    }

    public static void processOutputData(MicroInstructionContext context, UserTask userTask, Map inputs) throws Exception {
        MIUserTaskCallback.processOutputData(context, userTask, inputs, false);
    }

    public static void processOutputData(MicroInstructionContext context, UserTask userTask, Map inputs, boolean execDataOnly) throws Exception {
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        XMLElement payload = (XMLElement)inputs.get("payload");
        XMLElement taskObject = null;
        if (payload == null) {
            return;
        }
        taskObject = payload.getNamespaceURI().equals("http://xmlns.oracle.com/bpel/workflow/task") && payload.getNodeLocalName().equals("task") ? payload : (XMLElement)payload.getElementsByTagNameNS("http://xmlns.oracle.com/bpel/workflow/task", "task").item(0);
        XMLElement payloadElement = (XMLElement)taskObject.getElementsByTagNameNS("http://xmlns.oracle.com/bpel/workflow/task", "payload").item(0);
        HashMap<String, Object> data = new HashMap<String, Object>();
        DataAssociationSet outputAssociation = userTask.getOutputDataAssociationSet();
        if (payloadElement != null) {
            MIUserTaskCallback.processDataAssociations(ctx, outputAssociation, payloadElement, data);
        }
        Sequence dataDeclarationSequence = outputAssociation.getArgumentsContainer().getDeclarations();
        Object[] dataDecls = dataDeclarationSequence.toArray();
        int declSize = dataDecls.length - 1;
        String execDataOrTaskVarName = null;
        if (declSize > 0) {
            DataDeclaration lastArg = (DataDeclaration)dataDecls[declSize];
            execDataOrTaskVarName = lastArg.getName();
        }
        String outcome = "";
        if (taskObject != null) {
            TaskImpl task = (TaskImpl)TaskUtil.getInstance().unmarshal((Node)taskObject);
            SystemAttributesType sysAttr = task.getSystemAttributes();
            if (sysAttr != null) {
                IdentityType idType = sysAttr.getUpdatedBy();
                if (idType != null) {
                    String userId = idType.getId();
                    String userType = idType.getType();
                    if (userId != null && userId.trim().equals("workflowsystem")) {
                        String taskId = task.getSystemAttributes().getTaskId();
                        String prevUserId = WorkflowUtil.getPreviousTaskApprover((String)taskId);
                        userId = prevUserId != null ? prevUserId : userId;
                        userType = "user";
                    }
                    String updatedBy = userId + "," + userType;
                    ctx.addToEnvironment("USER_TASK_UPDATED_BY", (Object)updatedBy);
                    ctx.addToEnvironment("USER_TASK_NUMBER", (Object)task.getSystemAttributes().getTaskNumber());
                }
                if ((outcome = sysAttr.getOutcome()) == null) {
                    outcome = "";
                }
            }
            task = null;
        } else {
            BPELExecutionLogger.LOG.warn("MIUserTaskCallback", "processOutputData", new Object[]{XMLUtil.toString((Node)payload)});
        }
        data.put("outcome", outcome);
        if (execDataOrTaskVarName != null) {
            data.put(execDataOrTaskVarName, taskObject);
        }
        if (execDataOnly) {
            DataHandlingUtils.processOutputExecDataOnly((FlowNode)userTask, userTask.getOutputDataAssociationSet(), sc, ctx, data, wi, execDataOrTaskVarName, "taskId");
        } else {
            try {
                DataHandlingUtils.processOutputData((FlowNode)userTask, userTask.getOutputDataAssociationSet(), sc, ctx, data, wi);
            }
            catch (BPELFault e) {
                DataHandlingUtils.trapBPELFaults(context, e);
            }
            catch (XPathException e) {
                DataHandlingUtils.trapXPathQueryFailed(context, e);
            }
        }
        AuditUtil.addOutMessageToPayload(ctx, data);
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        if (this.initiateCorrelationSetNames.length > 0) {
            NormalizedMessage nm = (NormalizedMessage)ctx.getFromEnvironment("__call-NM");
            Map inputs = null;
            if (nm != null) {
                inputs = nm.getPayload();
            }
            RuntimeMetadataResolverImpl runtimeResolver = new RuntimeMetadataResolverImpl(context);
            runtimeResolver.getBPELWMPHelper().initiateCorrelationSet(wi, sc, this.initiateCorrelationSetNames, (Object)inputs, this.operRef.getOutputType(), ctx);
        }
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        this.doHandleCallback(context);
        MIUserTaskResponse.unregisterTaskInScope(wi.getKey(), sc, ci);
        return null;
    }

    protected void doHandleCallback(MicroInstructionContext context) throws Throwable {
        IWorkItem wi = context.getWorkItem();
        MIUserTaskCallback.processOutputData(context, this.userTask);
        wi.markAsComplete();
    }

    private static void processDataAssociations(ICubeContext ctx, DataAssociationSet dataAssociationSet, Object payload, Map data) throws Exception {
        Sequence dataDecls = dataAssociationSet.getArgumentsContainer().getDeclarations();
        for (DataDeclaration datType : dataDecls) {
            String elementName = datType.getNativeName();
            String variableId = datType.getName();
            SchemaObject object = datType.getType().getDelegate().asSchemaObject();
            String nameSpace = null;
            nameSpace = object.isType() ? "http://xmlns.oracle.com/bpel/workflow/task" : object.getNamespace();
            XMLElement payloadElement = (XMLElement)payload;
            Element node = null;
            NodeList list = payloadElement.getElementsByTagNameNS(nameSpace, elementName);
            int nodeListLength = list.getLength();
            if (nodeListLength <= 0) continue;
            if (object.isType()) {
                Element element = (Element)list.item(0);
                String namespace = object.getNamespace();
                String outputElementName = datType.getName();
                node = DOMUtil.createRootElement((String)outputElementName, (String)namespace);
                node = (Element)DOMUtil.copyObjHelper((Object)element, (Object)node, (boolean)false, (ICubeContext)ctx);
            } else if (nodeListLength == 1) {
                node = (Element)list.item(0);
            } else {
                Node parentNode;
                for (int count = 0; count < nodeListLength && !(parentNode = (node = (Element)list.item(count)).getParentNode()).getLocalName().equals(payloadElement.getLocalName()); ++count) {
                }
            }
            data.put(variableId, node);
        }
    }
}

