/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.core.IWorkItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceLocal;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.ScopeUtils;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.update.OutcomeUpdateDefinition;
import oracle.bpm.project.model.processes.update.PriorityUpdateDefinition;
import oracle.bpm.project.model.processes.update.ReassignUpdateDefinition;
import oracle.bpm.project.model.processes.update.TaskIdUpdateTargetDefinition;
import oracle.bpm.project.model.processes.update.UpdateDefinition;
import oracle.bpm.project.model.processes.update.UpdateTargetDefinition;
import oracle.bpm.project.model.processes.update.UpdateTargetType;
import oracle.bpm.project.model.processes.update.UpdateTask;
import oracle.bpm.project.model.processes.update.UpdateType;
import oracle.bpm.project.model.processes.update.UserTaskUpdateTargetDefinition;

public class MIUpdateTask
extends MIBase<Object> {
    private final UpdateTask updateTask;

    public MIUpdateTask(UpdateTask updateTask) {
        this.updateTask = updateTask;
    }

    public static List<String> getTaskIds(IScope scope, String userTaskId, boolean applyToAllTasks, List<String> taskIds) throws Exception {
        if (scope.contains("__taskmap_rootscope__")) {
            Map taskMap = (Map)scope.getObject("__taskmap_rootscope__");
            if (userTaskId != null) {
                Set<String> values = ScopeUtils.getTaskIdsSet(userTaskId, taskMap);
                if (values != null) {
                    taskIds.addAll(values);
                }
            } else if (applyToAllTasks) {
                for (String uId : taskMap.keySet()) {
                    Set<String> values = ScopeUtils.getTaskIdsSet(uId, taskMap);
                    if (values == null) continue;
                    taskIds.addAll(values);
                }
            }
        }
        return taskIds;
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        IWorkItem wi = context.getWorkItem();
        IScope scope = wi.getScope();
        ICubeContext cubeContext = context.getCubeContext();
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)cubeContext);
        this.invokeTaskServiceOperation(ci, cubeContext, scope);
        wi.markAsComplete();
        return null;
    }

    private void invokeTaskServiceOperation(ICubeInstanceImpl ci, ICubeContext cubeContext, IScope scope) throws Throwable {
        BPELExecutionLogger.LOG.info(this.getClass().getName(), "invokeTaskServiceOperation", new Object[]{"Updating workflow tasks"});
        IInternalInstanceManagementServiceLocal local = BPMNUtility.getInternalManagementservice(cubeContext);
        UpdateType updateType = this.updateTask.getUpdateType();
        UpdateDefinition updateDefinition = this.updateTask.getUpdateDefinition();
        List<String> targetTaskIds = this.retrieveTaskIds(ci, scope, cubeContext);
        switch (updateType) {
            case UPDATE_OUTCOME: {
                OutcomeUpdateDefinition oDef = (OutcomeUpdateDefinition)updateDefinition;
                Expression outcomeExpr = oDef.getOutcome();
                String outcome = DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(outcomeExpr, (FlowNode)this.updateTask, scope, cubeContext);
                local.updateWorkflowTasksOutcome(targetTaskIds, outcome);
                break;
            }
            case ESCALATE: {
                local.escalateWorkflowTasks(targetTaskIds);
                break;
            }
            case REASSIGN: {
                ReassignUpdateDefinition rDef = (ReassignUpdateDefinition)updateDefinition;
                Expression reassignUserExpr = rDef.getAssignedUser();
                String reassignUser = DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(reassignUserExpr, (FlowNode)this.updateTask, scope, cubeContext);
                local.reassignWorkflowTasks(targetTaskIds, reassignUser);
                break;
            }
            case RESUME: {
                local.resumeWorkflowTasks(targetTaskIds);
                break;
            }
            case SUSPEND: {
                local.suspendWorkflowTasks(targetTaskIds);
                break;
            }
            case WITHDRAW: {
                local.withdrawWorkflowTasks(targetTaskIds);
                break;
            }
            case UPDATE_PRIORITY: {
                PriorityUpdateDefinition pDef = (PriorityUpdateDefinition)updateDefinition;
                Expression prioExpr = pDef.getPriority();
                int priority = DataHandlingUtils.ExpressionEvaluatorHelper.getNumberValueFromExpression(prioExpr, (FlowNode)this.updateTask, scope, cubeContext).intValue();
                local.updatePriorityOfWorkflowTasks(targetTaskIds, priority);
                break;
            }
            case SUSPEND_TIMERS: {
                local.suspendTimersOnWorkflowTasks(targetTaskIds);
                break;
            }
            case RESUME_TIMERS: {
                local.resumeTimersOnWorkflowTasks(targetTaskIds);
            }
        }
    }

    private List<String> retrieveTaskIds(ICubeInstanceImpl ci, IScope expressionScope, ICubeContext cubeContext) throws Exception {
        ArrayList<String> taskIds = new ArrayList<String>();
        String userTaskId = null;
        boolean applyToAllTasks = false;
        UpdateTargetDefinition targetDef = this.updateTask.getUpdateTargetDefinition();
        if (this.updateTask.getUpdateTargetType() == UpdateTargetType.TASK_ID) {
            TaskIdUpdateTargetDefinition taskIdUpdateTargetDefinition = (TaskIdUpdateTargetDefinition)targetDef.as(TaskIdUpdateTargetDefinition.class);
            String taskId = DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(taskIdUpdateTargetDefinition.getTaskId(), (FlowNode)this.updateTask, expressionScope, cubeContext);
            taskIds.add(taskId);
            return taskIds;
        }
        if (this.updateTask.getUpdateTargetType() == UpdateTargetType.USER_TASK) {
            UserTaskUpdateTargetDefinition userTaskUpdateTargetDefinition = (UserTaskUpdateTargetDefinition)targetDef.as(UserTaskUpdateTargetDefinition.class);
            userTaskId = userTaskUpdateTargetDefinition.getTargetUserTask().getId();
        } else if (this.updateTask.getUpdateTargetType() == UpdateTargetType.ALL_USER_TASKS) {
            applyToAllTasks = true;
        }
        IScopeImpl scope = ci.getScopeContext().getRootScope();
        return MIUpdateTask.getTaskIds((IScope)scope, userTaskId, applyToAllTasks, taskIds);
    }
}

