/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.core.map.ICubeElement;
import com.collaxa.cube.engine.ext.bpel.common.BPELWMPHelper;
import com.collaxa.cube.xml.schema.XMLSchemaUtils;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.RulesCalendar;
import oracle.bpm.bpmn.engine.model.ScheduleEntryToCronExpression;
import oracle.bpm.bpmn.engine.model.SchedulingLogger;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.BPMNWaitListener;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MITimerEvent;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDTimerEvent;
import oracle.bpm.bpmn.engine.model.runtime.util.SchedulingHelper;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttribute;
import oracle.bpm.bpmn.engine.service.ClassloaderHelper;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.OutOfCalendarPolicy;
import oracle.bpm.project.model.RescheduleRestrictionsPolicy;
import oracle.bpm.project.model.Schedule;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.integration.platform.blocks.scheduler.StringProperties;
import oracle.soa.common.util.CXStringUtils;
import oracle.soa.management.ComponentDN;

public class MITimerEventDefineExpirationDate
extends MIBase<Date> {
    private MDTimerEvent mdTimerEvent;
    private static final String DEFAULT_PRIORITY = "1";
    private static final String FABRIC_KEY = "FabricKey";
    public static final String TIMER_REPETITIONS = "TIMER_REPETITIONS";
    public static final int NO_REPETITIONS = -1;
    public static final String JOB_COUNT = "JOB_COUNT";
    public static final String JOB_NAME = "JOB_NAME";

    public MITimerEventDefineExpirationDate(MDTimerEvent mdTimerEvent) {
        this.mdTimerEvent = mdTimerEvent;
    }

    public static void unschedule(String compositeDN, String jobName) throws Exception {
        for (StringProperties stringProperties : SchedulingHelper.listScheduled(compositeDN, true)) {
            String jobNameWithSuffix = stringProperties.get(FABRIC_KEY);
            if (!MITimerEventDefineExpirationDate.unbuildJobName(jobNameWithSuffix).equals(jobName)) continue;
            SchedulingHelper.unschedule(compositeDN, jobNameWithSuffix, true);
        }
    }

    @Override
    protected Date doExecute(MicroInstructionContext context) throws Throwable {
        Object dateString;
        Object elementForExpressionContext;
        int jobCount;
        Date date = null;
        String dateExpression = null;
        IWorkItem wi = context.getWorkItem();
        String wiKey = wi.getKey().toString();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        BPMNCubeElement node = context.getNode();
        ICubeInstance cubeInstance = wi.getCubeInstance();
        IScopeImpl rootScope = ((ICubeInstanceImpl)cubeInstance).getScopeContext().getRootScope();
        ComponentDN componentDN = cubeInstance.getComponentDN();
        String compositeDN = componentDN.getCompositeDN();
        BPELWMPHelper.setNamespaceContext((NamespaceContext)BPELWMPHelper.getNamespaceContext((ICubeElement)node, (ICubeContext)ctx), (ICubeContext)ctx);
        Expression forExpr = this.mdTimerEvent.getTimeCycle();
        Expression untilExpr = this.mdTimerEvent.getTimeDate();
        Schedule schedule = this.mdTimerEvent.getSchedule();
        Date startDate = this.mdTimerEvent.getStartDate();
        Date endDate = this.mdTimerEvent.getEndDate();
        Integer repetitions = this.mdTimerEvent.getRepetitions();
        boolean isUsingCalendar = this.mdTimerEvent.isUsingCalendar();
        OutOfCalendarPolicy outOfCalendarPolicy = this.mdTimerEvent.getOutOfCalendarPolicy();
        RescheduleRestrictionsPolicy rescheduleRestrictionsPolicy = this.mdTimerEvent.getRescheduleRestrictionsPolicy();
        Map nodeActivationContext = (Map)ctx.getFromEnvironment("__node_activation-context");
        String calendar = null;
        if (isUsingCalendar) {
            String ou = (String)ProcessInstanceAttribute.ORGANIZATIONALUNIT.getValue(sc, ctx);
            if (Str.isEmpty((String)ou)) {
                ou = DeploymentDescriptorUtil.getBPMOrganization(compositeDN).getProcessOrganizationalUnitName();
            }
            if (!Str.isEmpty((String)ou)) {
                List organizationalUnitList = DeploymentDescriptorUtil.getBPMOrganization(compositeDN).getOrganizationalUnits().getOrganizationalUnit();
                for (OrganizationalUnit organizationalUnit : organizationalUnitList) {
                    if (!organizationalUnit.getOrganizationalUnitName().equals(ou) || organizationalUnit.getCalendarRuleName() == null) continue;
                    calendar = RulesCalendar.buildName(compositeDN, organizationalUnit.getCalendarRuleName());
                    break;
                }
            }
        }
        SchedulingLogger.log("-------------");
        SchedulingLogger.log("Start date: " + startDate);
        SchedulingLogger.log("End date: " + endDate);
        SchedulingLogger.log("Repetitions: " + repetitions);
        SchedulingLogger.log("Calendar: " + calendar);
        if (calendar != null) {
            SchedulingLogger.log("Rescheduling policy: " + outOfCalendarPolicy.getString());
            SchedulingLogger.log("Rescheduling restrictions: " + rescheduleRestrictionsPolicy.getString());
        }
        SchedulingLogger.log("-------------");
        StringProperties stringProperties = new StringProperties();
        stringProperties.put((Object)"WI_KEY", (Object)wiKey);
        stringProperties.put((Object)"BPEL_priority", (Object)DEFAULT_PRIORITY);
        stringProperties.put((Object)"BPEL_componentDN", (Object)componentDN.getStringDN());
        long instanceId = cubeInstance.getId();
        if (!rootScope.contains(JOB_COUNT)) {
            jobCount = 1;
            rootScope.declareAndSet(JOB_COUNT, jobCount);
        } else {
            jobCount = rootScope.getInt(JOB_COUNT);
            rootScope.set(JOB_COUNT, ++jobCount);
        }
        String jobName = instanceId + "." + jobCount;
        nodeActivationContext.put(JOB_NAME, jobName);
        int uniqueSuffix = 1;
        Object flowNode = node.getFlowElement();
        Object object = elementForExpressionContext = ModelVisitorUtil.isStartOfInlineEventHandler((CatchEvent)flowNode.asAnyNode(CatchEvent.class)) ? flowNode.getSubprocess() : flowNode;
        if (forExpr != null) {
            BPMNExpressionMetadata forBPMNExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, forExpr.getExpressionValue(), BPMNExpressionLanguage.XPATH, forExpr.getNamespaces());
            BPMNExpression forBPMNExpression = BPMNExpression.createBPMNExpression(elementForExpressionContext, forBPMNExpressionMetadata, sc);
            String forValue = forBPMNExpression.evaluateString(sc, ctx);
            dateExpression = "For:" + forValue;
            if (!CXStringUtils.isEmpty((String)forValue)) {
                date = new Date(System.currentTimeMillis() + XMLSchemaUtils.parseDuration((String)forValue));
            }
        } else if (untilExpr != null) {
            BPMNExpressionMetadata forBPMNExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, untilExpr.getExpressionValue(), BPMNExpressionLanguage.XPATH, untilExpr.getNamespaces());
            BPMNExpression untilBPMNExpression = BPMNExpression.createBPMNExpression(elementForExpressionContext, forBPMNExpressionMetadata, sc);
            String untilValue = untilBPMNExpression.evaluateString(sc, ctx);
            dateExpression = "Until:" + untilValue;
            if (!CXStringUtils.isEmpty((String)untilValue)) {
                date = XMLSchemaUtils.parseDateTime((String)untilValue).getTime();
            }
        } else if (schedule != null) {
            nodeActivationContext.put(TIMER_REPETITIONS, repetitions);
            if (rescheduleRestrictionsPolicy == RescheduleRestrictionsPolicy.EACH_ENTRY_AS_DIFFERENT_EVENT || !ClassloaderHelper.isLoaded("oracle.bpm.runtime.quartz.trigger.UniqueTriggerWithReschedule")) {
                for (ScheduleEntry scheduleEntry : schedule.getAllEntries()) {
                    String cronExpression = ScheduleEntryToCronExpression.toCronExpression(scheduleEntry);
                    SchedulingHelper.schedule(compositeDN, MITimerEventDefineExpirationDate.buildJobName(jobName, uniqueSuffix), stringProperties, cronExpression, startDate, endDate, calendar, outOfCalendarPolicy, BPMNWaitListener.class, true);
                    ++uniqueSuffix;
                }
            } else {
                LinkedList<String> cronExpressions = new LinkedList<String>();
                for (ScheduleEntry scheduleEntry : schedule.getAllEntries()) {
                    String cronExpression = ScheduleEntryToCronExpression.toCronExpression(scheduleEntry);
                    cronExpressions.add(cronExpression);
                }
                SchedulingHelper.schedule(compositeDN, MITimerEventDefineExpirationDate.buildJobName(jobName, uniqueSuffix), stringProperties, cronExpressions, startDate, endDate, calendar, outOfCalendarPolicy, BPMNWaitListener.class, true);
            }
        }
        if (date != null) {
            if (date.getTime() > System.currentTimeMillis()) {
                dateString = date;
                if (startDate != null || endDate != null || isUsingCalendar) {
                    SchedulingHelper.schedule(compositeDN, MITimerEventDefineExpirationDate.buildJobName(jobName, uniqueSuffix), stringProperties, date, startDate, endDate, calendar, outOfCalendarPolicy, BPMNWaitListener.class, true);
                    date = null;
                }
            } else {
                dateString = MITimerEvent.STR_SKIP;
            }
        } else {
            dateString = MITimerEvent.STR_NEVER;
        }
        nodeActivationContext.put(MITimerEvent.EXPIRATION_DATE, dateString);
        nodeActivationContext.put(MITimerEvent.EXPIRATION_DATE_EXPRESSION, dateExpression);
        return date;
    }

    private static String buildJobName(String jobName, int suffix) {
        return jobName + "." + suffix;
    }

    private static String unbuildJobName(String jobNameWithSuffix) {
        int index = jobNameWithSuffix.lastIndexOf(".");
        return index >= 0 ? jobNameWithSuffix.substring(0, index) : jobNameWithSuffix;
    }
}

