/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.ext.bpel.common.BPELWMPHelper;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.TrappableException;

public class MIThrowException
extends MIBase<Object> {
    private boolean mustPropagateFault;

    public MIThrowException(boolean mustPropagateFault) {
        this.mustPropagateFault = mustPropagateFault;
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        Throwable lastEx = context.getLastException();
        IWorkItem wi = context.getWorkItem();
        Throwable ex = lastEx;
        if (ex instanceof TrappableException) {
            ex = ex.getCause();
        }
        ICubeContext ctx = context.getCubeContext();
        BPELWMPHelper.logException((Throwable)lastEx, (IWorkItem)wi, (ICubeContext)ctx);
        wi.throwException(ex, ctx);
        return this.mustPropagateFault ? Boolean.FALSE : Boolean.TRUE;
    }
}

