/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import java.util.TreeMap;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDScriptTask;
import oracle.bpm.bpmn.engine.model.runtime.scripting.ScriptTaskUtils;
import oracle.bpm.project.model.processes.Process;

public class MIScriptTask
extends MIBase<Object> {
    private MDScriptTask mdScriptTask;
    public static final String EXECUTION_PATH_LOGGER_DESCRIPTION = ExecutionPathLogger.class.getSimpleName();

    public MIScriptTask(MDScriptTask mdScriptTask) {
        this.mdScriptTask = mdScriptTask;
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws CubeException {
        IWorkItem iWorkItem = context.getWorkItem();
        IScope iScope = iWorkItem.getScope();
        ICubeContext iCubeContext = context.getCubeContext();
        String script = this.mdScriptTask.getScript();
        String scriptLanguage = this.mdScriptTask.getLanguage();
        if (scriptLanguage == null) {
            scriptLanguage = ScriptTaskUtils.getDefaultScriptLanguage();
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("wi", iWorkItem);
        map.put("sc", iScope);
        map.put("ctx", iCubeContext);
        map.put("ExecutionPathLogger", new ExecutionPathLogger(context));
        Process process = this.mdScriptTask.getProcess();
        if (process != null) {
            ScriptTaskUtils.bindProcessDataObjects(process, iScope, map);
        }
        ScriptTaskUtils.evaluate(map, scriptLanguage, script);
        if (process != null) {
            ScriptTaskUtils.unbindProcessDataObjects(process, iScope, map);
        }
        iWorkItem.markAsComplete();
        return null;
    }

    private static class ExecutionPathLogger {
        protected MicroInstructionContext context;

        public ExecutionPathLogger(MicroInstructionContext context) {
            this.context = context;
        }

        public void logMessage(String label) throws CubeException {
            this.context.logExecution(label, EXECUTION_PATH_LOGGER_DESCRIPTION);
        }
    }
}

