/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.types.bpel.CXElementVariable;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmn.engine.microkernel.MDIncomingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;

public abstract class MIProcessSingleElementOutputDataAssociations
extends MIBase<Map> {
    protected final MDIncomingMessage mdIncomingMessage;
    protected final MDServiceActivity mdServiceActivity;
    protected boolean saveAsProperty;

    public MIProcessSingleElementOutputDataAssociations(MDServiceActivity mdServiceActivity, MDIncomingMessage mdOutgoingMessage, boolean saveAsProperty) {
        this.mdServiceActivity = mdServiceActivity;
        this.mdIncomingMessage = mdOutgoingMessage;
        this.saveAsProperty = saveAsProperty;
    }

    public static class Step2
    extends MIProcessSingleElementOutputDataAssociations {
        public Step2(MDServiceActivity mdServiceActivity, MDIncomingMessage mdOutgoingMessage, boolean saveAsProperty) {
            super(mdServiceActivity, mdOutgoingMessage, saveAsProperty);
        }

        @Override
        public String getMicroInstructionDescription() {
            return MIProcessSingleElementOutputDataAssociations.class.getSimpleName() + "." + super.getMicroInstructionDescription();
        }

        @Override
        protected Map doExecute(MicroInstructionContext context) throws Throwable {
            String varName;
            ICubeContext ctx = context.getCubeContext();
            IWorkItem wi = context.getWorkItem();
            IScope sc = wi.getScope();
            if (this.saveAsProperty) {
                varName = context.getProperty("VARIABLE_NAME", String.class);
            } else {
                varName = (String)context.removeTokenMetadataProperty("VARIABLE_NAME");
                context.setProperty("VARIABLE_NAME", varName);
            }
            CXElementVariable result = (CXElementVariable)sc.getObject(varName);
            DataAssociationSet outputDataAssociationSet = this.mdIncomingMessage.getOutputDataAssociationSet();
            if (outputDataAssociationSet != null) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put(((DataDeclaration)outputDataAssociationSet.getArgumentsContainer().getDeclarations().iterator().next()).getName(), result.getValue());
                DataHandlingUtils.processOutputData(this.mdServiceActivity.getFlowElement(), outputDataAssociationSet, sc, ctx, data, wi);
            }
            return null;
        }
    }

    public static class Step1
    extends MIProcessSingleElementOutputDataAssociations {
        public Step1(MDServiceActivity mdServiceActivity, MDIncomingMessage mdOutgoingMessage, boolean saveAsProperty) {
            super(mdServiceActivity, mdOutgoingMessage, saveAsProperty);
        }

        @Override
        public String getMicroInstructionDescription() {
            return MIProcessSingleElementOutputDataAssociations.class.getSimpleName() + "." + super.getMicroInstructionDescription();
        }

        @Override
        protected Map doExecute(MicroInstructionContext context) throws Throwable {
            String varName = context.getProperty("DATA_ASSOCIATION_OUTPUT_VARIABLE", String.class);
            if (this.saveAsProperty) {
                context.setProperty("VARIABLE_NAME", varName);
            } else {
                context.setPropertyToAddInTokenMetadata("VARIABLE_NAME", varName);
            }
            return null;
        }
    }
}

