/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.xml.xpath.XPathException;
import com.oracle.bpel.client.BPELFault;
import java.util.Map;
import oracle.bpm.bpmn.engine.microkernel.MDIncomingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.ServiceInteractionUtils;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;

public abstract class MIProcessMessageOutputDataAssociationsForService
extends MIBase<Map> {
    protected final MDIncomingMessage mdIncomingMessage;
    protected final MDServiceActivity mdServiceActivity;
    protected boolean saveAsProperty;

    public MIProcessMessageOutputDataAssociationsForService(MDServiceActivity mdServiceActivity, MDIncomingMessage mdOutgoingMessage, boolean saveAsProperty) {
        this.mdServiceActivity = mdServiceActivity;
        this.mdIncomingMessage = mdOutgoingMessage;
        this.saveAsProperty = saveAsProperty;
    }

    public static class SetContext
    extends MIProcessMessageOutputDataAssociationsForService {
        public SetContext(MDServiceActivity mdServiceActivity, MDIncomingMessage mdOutgoingMessage, boolean saveAsProperty) {
            super(mdServiceActivity, mdOutgoingMessage, saveAsProperty);
        }

        @Override
        public String getMicroInstructionDescription() {
            return MIProcessMessageOutputDataAssociationsForService.class.getSimpleName() + "." + super.getMicroInstructionDescription();
        }

        @Override
        protected Map doExecute(MicroInstructionContext context) throws Throwable {
            String varName = context.getProperty("DATA_ASSOCIATION_OUTPUT_VARIABLE", String.class);
            if (this.saveAsProperty) {
                context.setProperty("VARIABLE_NAME", varName);
            } else {
                context.setPropertyToAddInTokenMetadata("VARIABLE_NAME", varName);
            }
            return null;
        }
    }

    public static class ProcessOutput
    extends MIProcessMessageOutputDataAssociationsForService {
        public ProcessOutput(MDServiceActivity mdServiceActivity, MDIncomingMessage mdOutgoingMessage, boolean saveAsProperty) {
            super(mdServiceActivity, mdOutgoingMessage, saveAsProperty);
        }

        @Override
        public String getMicroInstructionDescription() {
            return MIProcessMessageOutputDataAssociationsForService.class.getSimpleName() + "." + super.getMicroInstructionDescription();
        }

        @Override
        protected Map doExecute(MicroInstructionContext miContext) throws Throwable {
            String varName;
            ICubeContext ctx = miContext.getCubeContext();
            IWorkItem wi = miContext.getWorkItem();
            IScope sc = wi.getScope();
            if (this.saveAsProperty) {
                varName = miContext.getProperty("VARIABLE_NAME", String.class);
            } else {
                varName = (String)miContext.removeTokenMetadataProperty("VARIABLE_NAME");
                miContext.setProperty("VARIABLE_NAME", varName);
            }
            CXMessageVariable result = (CXMessageVariable)sc.getObject(varName);
            DataAssociationSet outputDataAssociationSet = this.mdIncomingMessage.getOutputDataAssociationSet();
            if (outputDataAssociationSet != null) {
                Object payload = ServiceInteractionUtils.isWrappedArguments(this.mdServiceActivity, result) ? ServiceInteractionUtils.unwrapArguments(outputDataAssociationSet, result) : result;
                try {
                    this.doProcessOutput(ctx, wi, sc, outputDataAssociationSet, (Map<String, Object>)payload);
                }
                catch (BPELFault e) {
                    DataHandlingUtils.trapBPELFaults(miContext, e);
                }
                catch (XPathException e) {
                    DataHandlingUtils.trapXPathQueryFailed(miContext, e);
                }
                AuditUtil.addOutMessageToPayload(ctx, (Map<String, Object>)payload);
            }
            return result;
        }

        protected void doProcessOutput(ICubeContext ctx, IWorkItem wi, IScope sc, DataAssociationSet outputDataAssociationSet, Map<String, Object> payload) throws CubeException {
            DataHandlingUtils.processOutputDataForServiceActivities(this.mdServiceActivity.getFlowElement(), this.mdIncomingMessage.getOutputPartNamesMap(), outputDataAssociationSet, sc, ctx, payload, wi, false);
        }
    }
}

