/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.xml.xpath.XPathException;
import com.oracle.bpel.client.BPELFault;
import java.util.Map;
import oracle.bpm.bpmn.engine.microkernel.MDOutgoingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.ServiceInteractionUtils;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;

public class MIProcessMessageInputDataAssociationsForService
extends MIBase<Map> {
    private final MDOutgoingMessage mdOutgoingMessage;
    private final MDServiceActivity mdServiceActivity;

    public MIProcessMessageInputDataAssociationsForService(MDServiceActivity mdServiceActivity, MDOutgoingMessage mdOutgoingMessage) {
        this.mdServiceActivity = mdServiceActivity;
        this.mdOutgoingMessage = mdOutgoingMessage;
    }

    @Override
    protected Map doExecute(MicroInstructionContext miContext) throws Throwable {
        String varName = miContext.getProperty("DATA_ASSOCIATION_INPUT_VARIABLE", String.class);
        ICubeContext ctx = miContext.getCubeContext();
        IWorkItem wi = miContext.getWorkItem();
        IScope sc = wi.getScope();
        CXMessageVariable result = (CXMessageVariable)sc.getObject(varName);
        DataAssociationSet inputDataAssociationSet = this.mdOutgoingMessage.getInputDataAssociationSet();
        Map<String, Object> map = null;
        try {
            map = this.doProcessInput(ctx, wi, sc, inputDataAssociationSet);
            if (ServiceInteractionUtils.isWrappedArguments(this.mdServiceActivity, result)) {
                ServiceInteractionUtils.wrapArguments(inputDataAssociationSet, result, map, result.getMessageType());
            } else {
                result.putAll(map);
            }
            AuditUtil.addInMessageToPayload(miContext.getCubeContext(), (ICubeInstance)miContext.getCubeInstance(), sc.getAbsoluteScopeId(), map, miContext.getNode().getName());
        }
        catch (BPELFault e) {
            DataHandlingUtils.trapBPELFaults(miContext, e);
        }
        catch (XPathException e) {
            DataHandlingUtils.trapXPathQueryFailed(miContext, e);
        }
        return result;
    }

    protected Map<String, Object> doProcessInput(ICubeContext ctx, IWorkItem wi, IScope sc, DataAssociationSet inputDataAssociationSet) throws Exception {
        return DataHandlingUtils.processInputDataForServiceActivities(this.mdServiceActivity.getFlowElement(), this.mdOutgoingMessage.getInputPartNamesMap(), inputDataAssociationSet, sc, ctx, wi);
    }
}

