/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.ext.common.InvokeHandler;
import com.collaxa.cube.engine.ext.common.InvokeOutgoingMetadataResolver;
import com.collaxa.cube.engine.ext.common.RuntimeMetadataResolver;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.resolver.RuntimeMetadataResolverImpl;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.resolver.ServiceTaskMetadataResolverImpl;

public abstract class MIInvokeBase
extends MIBase<Object> {
    protected final MDServiceTask mdServiceTask;
    static final String INVOKE_HANDLER = "INVOKE_HANDLER";

    public MIInvokeBase(MDServiceTask mdServiceTask) {
        this.mdServiceTask = mdServiceTask;
    }

    @Override
    public String getMicroInstructionDescription() {
        return super.getMicroInstructionDescription() + "(" + this.mdServiceTask.getMetadataDescription() + ")";
    }

    protected InvokeHandler getHandler(MicroInstructionContext context) throws Throwable {
        InvokeHandler handler = context.getWmp().getRuntimeContext(INVOKE_HANDLER, InvokeHandler.class);
        if (handler == null) {
            RuntimeMetadataResolverImpl runtimeMetadataResolver = new RuntimeMetadataResolverImpl(context);
            ServiceTaskMetadataResolverImpl metadataResolver = new ServiceTaskMetadataResolverImpl(context, this.mdServiceTask);
            handler = new InvokeHandler((InvokeOutgoingMetadataResolver)metadataResolver, (RuntimeMetadataResolver)runtimeMetadataResolver);
            context.getWmp().setRuntimeContext(INVOKE_HANDLER, handler);
        }
        return handler;
    }

    @Override
    protected String getMicroInstructionDescription(MicroInstructionContext context) {
        return this.getClass().getSimpleName();
    }
}

