/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;

public class MIInsertInstance2Track
extends MIBase<Object> {
    protected boolean close;
    protected boolean persistBeforeEngineDehydration;
    protected String processState = "OPEN";

    public MIInsertInstance2Track(boolean close) {
        this.close = close;
        if (close) {
            this.processState = "COMPLETED";
        }
    }

    public MIInsertInstance2Track(String processState) {
        this.processState = processState;
        if (processState.equals("ERRORED") || processState.equals("SUSPENDED")) {
            this.persistBeforeEngineDehydration = true;
        }
    }

    public MIInsertInstance2Track(boolean close, boolean persistBeforeEngineDehydration) {
        this.close = close;
        if (close) {
            this.processState = "COMPLETED";
        }
        this.persistBeforeEngineDehydration = persistBeforeEngineDehydration;
    }

    @Override
    public Object doExecute(MicroInstructionContext context) throws Throwable {
        this.insertInstance2Track(context);
        if (this.persistBeforeEngineDehydration) {
            BPMNUtility.persistProcessInstances(context.getCubeContext());
        }
        return null;
    }

    protected void insertInstance2Track(MicroInstructionContext context) throws Exception {
        BPMNUtility.insertInstance2Track(context, this.processState);
    }

    public static class MIInsertInstance2TrackProcess
    extends MIInsertInstance2Track {
        public MIInsertInstance2TrackProcess(String processState) {
            super(processState);
        }

        @Override
        protected void insertInstance2Track(MicroInstructionContext context) throws Exception {
            BPMNUtility.insertInstance2TrackProcess(context, this.processState);
        }
    }
}

