/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.IScope;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDGenerateNextToken;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;

public abstract class MIGenerateTokenMicroInstruction
extends MIBase<Object> {
    protected MDGenerateNextToken mdGenerateNextToken;

    protected MIGenerateTokenMicroInstruction(MDGenerateNextToken mdGenerateNextToken) {
        this.mdGenerateNextToken = mdGenerateNextToken;
    }

    @Override
    public final Object doExecute(MicroInstructionContext context) throws CubeException {
        int step;
        int thread;
        int parentThread;
        if (this.mdGenerateNextToken.isCreateNewThread()) {
            parentThread = context.getThread();
            thread = BPMNTokenMetadataUtils.getNewThreadNumber(context.getWorkItem().getScope());
            step = 0;
        } else {
            thread = context.getThread();
            step = context.getStep() + 1;
            parentThread = context.getParentThread();
        }
        return this.doExecute(context, thread, step, parentThread);
    }

    @Override
    public String getMicroInstructionDescription() {
        StringBuilder builder = new StringBuilder();
        BPMNCubeElement source = this.mdGenerateNextToken.getSourceNode();
        String target = this.mdGenerateNextToken.getNextTokenId();
        boolean newThread = this.mdGenerateNextToken.isCreateNewThread();
        builder.append(super.getMicroInstructionDescription());
        builder.append(":");
        builder.append(source.getId());
        builder.append("->");
        builder.append(target);
        if (newThread) {
            builder.append("(N)");
        }
        return builder.toString();
    }

    protected abstract Object doExecute(MicroInstructionContext var1, int var2, int var3, int var4) throws CubeException;

    protected void generateToken(MicroInstructionContext context, int thread, int step, int parentThread, IScope scope) throws CubeException {
        BPMNTokenManager.generateOpenToken(scope, this.mdGenerateNextToken.getSourceNode(), this.mdGenerateNextToken.getNextTokenId(), context.getActivationIds(), parentThread, thread, step, context.getPropertiesToAddInTokenMetadata());
    }

    public static class ToNextActivityInParentScope
    extends MIGenerateTokenMicroInstruction {
        public ToNextActivityInParentScope(MDGenerateNextToken mdGenerateNextToken) {
            super(mdGenerateNextToken);
        }

        @Override
        public String getMicroInstructionDescription() {
            return super.getMicroInstructionDescription() + "(" + this.mdGenerateNextToken.getParentBlockDepth() + ")";
        }

        @Override
        protected Object doExecute(MicroInstructionContext context, int thread, int step, int parentThread) throws CubeException {
            this.generateToken(context, thread, step, parentThread, this.getScope(context));
            return null;
        }

        @Override
        protected String getMicroInstructionDescription(MicroInstructionContext context) {
            return super.getMicroInstructionDescription();
        }

        private IScope getScope(MicroInstructionContext context) {
            IScope result = context.getWorkItem().getScope();
            for (int i = 1; i < this.mdGenerateNextToken.getParentBlockDepth(); ++i) {
                result = result.getParentScope();
            }
            return result;
        }
    }

    public static class ToNextActivity
    extends MIGenerateTokenMicroInstruction {
        public ToNextActivity(MDGenerateNextToken mdGenerateNextToken) {
            super(mdGenerateNextToken);
        }

        @Override
        protected Object doExecute(MicroInstructionContext context, int thread, int step, int parentThread) throws CubeException {
            this.generateToken(context, thread, step, parentThread, context.getWorkItem().getScope());
            return null;
        }
    }

    public static class ToMergigGatewayAsDummy
    extends MIGenerateTokenMicroInstruction {
        private boolean parentScope = false;

        public ToMergigGatewayAsDummy(MDGenerateNextToken mdGenerateNextToken, boolean parentScope) {
            super(mdGenerateNextToken);
            this.parentScope = parentScope;
        }

        @Override
        protected Object doExecute(MicroInstructionContext context, int thread, int step, int parentThread) throws CubeException {
            IScope scope = context.getWorkItem().getScope();
            if (this.parentScope) {
                scope = scope.getParentScope();
            }
            String activationId = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(context.getWorkItem().getNodeActivationContext());
            activationId = BPMNTokenManager.generateDummyToken(this.mdGenerateNextToken.getSourceNode(), scope, activationId, thread, parentThread, step);
            BPMNTokenMetadataUtils.setActivationIdsToTokenMetadata(context.getWorkItem().getNodeActivationContext(), activationId);
            return null;
        }
    }
}

