/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.xml.dom.DOMUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.bpmn.engine.logging.BPMNLoggerManager;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.DataDeclarationBpmnDecorator;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MIBusinessRuleTaskResponse
extends MIBase<Object> {
    private BusinessRuleTask businessRuleTask = null;
    private Logger logger = BPMNLoggerManager.getInstance().getLogger(BPELExecutionLogger.class.getName());
    private MDServiceTask mdServiceTask;
    private String targetNameSpace = null;
    private static final String RESULT_LIST_ELEMENT_NAME = "resultList";
    private static final String MESSAGE_PARTNAME = "payload";

    public MIBusinessRuleTaskResponse(MDServiceTask mdServiceTask, String targetNameSpace) {
        this.mdServiceTask = mdServiceTask;
        this.targetNameSpace = targetNameSpace;
        this.businessRuleTask = (BusinessRuleTask)mdServiceTask.getFlowElement();
    }

    public void processOutputData(DataAssociationSet outputArgumentMapping, IScope sc, ICubeContext ctx, IWorkItem item, Map<String, Object> payload) throws Exception {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "processOutputData", new Object[]{"Start of process output data"});
        XMLElement callBackMessage = (XMLElement)payload.get(MESSAGE_PARTNAME);
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "processOutputData", new Object[]{"Call back message is " + DOMUtil.toXML((Node)callBackMessage)});
        Element resultElement = this.getElement((Element)callBackMessage, RESULT_LIST_ELEMENT_NAME, this.targetNameSpace);
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (resultElement != null) {
            Sequence dataDeclas = outputArgumentMapping.getArgumentsContainer().getDeclarations();
            NodeList list = resultElement.getChildNodes();
            if (list.getLength() < 0) {
                if (this.logger.isLoggable(Level.FINE)) {
                    BPELExecutionLogger.LOG.debug(this.getClass().getName(), "processOutputData", new Object[]{"Result list is empty"});
                }
            } else {
                for (DataDeclaration dataType : dataDeclas) {
                    String dataOutputName = dataType.getName();
                    TypeDescription typeDescription = dataType.getType().getDelegate();
                    SchemaObject object = typeDescription.isArray() ? DataDeclarationBpmnDecorator.getArrayParametricType((ArrayTypeDescription)typeDescription) : typeDescription.asSchemaObject();
                    String nameSpace = object.getNamespace();
                    String elementName = object.getName();
                    BPELExecutionLogger.LOG.debug(this.getClass().getName(), "processOutputData", new Object[]{"Getting element value for " + elementName + " with namespace " + nameSpace});
                    for (int i = 0; i < list.getLength(); ++i) {
                        if (!typeDescription.isArray()) {
                            data.put(dataOutputName, list.item(i));
                            continue;
                        }
                        NodeList nodeList = resultElement.getElementsByTagNameNS(nameSpace, elementName);
                        if (nodeList.getLength() < 0) {
                            if (!this.logger.isLoggable(Level.FINE)) continue;
                            BPELExecutionLogger.LOG.debug(this.getClass().getName(), "processOutputData", new Object[]{"No value for element name " + elementName + " with name space  " + nameSpace});
                            continue;
                        }
                        if (this.logger.isLoggable(Level.FINE)) {
                            BPELExecutionLogger.LOG.debug(this.getClass().getName(), "processOutputData", new Object[]{"Include the value with key as " + dataOutputName + " value as " + XMLUtil.toString((Node)list.item(0))});
                        }
                        data.put(dataOutputName, list);
                        i = i + list.getLength() - 1;
                    }
                }
            }
        }
        DataHandlingUtils.processOutputData((FlowNode)this.businessRuleTask, outputArgumentMapping, sc, ctx, data, item);
        AuditUtil.addOutMessageToPayload(ctx, data);
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "processOutputData", new Object[]{"End of process output data"});
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "doExecuteStatements", new Object[]{"Start of executing the business rule"});
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        this.handleBusinessRuleResponse(ci, wi, sc, ctx);
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "doExecuteStatements", new Object[]{"End of executing the business rule"});
        return null;
    }

    private Element getElement(Element element, String name, String nameSpace) throws CubeException {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "getElement", new Object[]{"Start of getting element with name " + name});
        if (element == null) {
            return null;
        }
        NodeList nodes = element.getElementsByTagNameNS(nameSpace, name);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            return (XMLElement)node;
        }
        BPELExecutionLogger.LOG.error(this.getClass().getName(), "getElement", new Object[]{"Element with name " + name + " and namespace " + nameSpace + "doesn't Exist in " + DOMUtil.toXML((Node)element)});
        Object[] obj = new Object[]{name, nameSpace};
        throw new CubeException(75002, obj);
    }

    private void handleBusinessRuleResponse(ICubeInstanceImpl ci, IWorkItem wi, IScope sc, ICubeContext ctx) throws Throwable {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "handleBusinessRuleResponse", new Object[]{"Start of handle business rule invoke "});
        CXMessageVariable result = (CXMessageVariable)sc.getObject(this.mdServiceTask.getOutputVariableName());
        this.processOutputData(this.businessRuleTask.getOutputDataAssociationSet(), sc, ctx, wi, (Map<String, Object>)result);
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "handleBusinessRuleResponse", new Object[]{"End of handle business rule invoke "});
    }
}

