/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.xml.dom.DOMUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.bpmn.engine.logging.BPMNLoggerManager;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.DataDeclarationBpmnDecorator;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MIBusinessRuleTaskRequest
extends MIBase<Object> {
    private BusinessRuleTask businessRuleTask = null;
    private Logger logger = BPMNLoggerManager.getInstance().getLogger(BPELExecutionLogger.class.getName());
    private MDServiceTask mdServiceTask;
    private Element mInputElement = null;
    private String serviceName = null;
    private String targetNameSpace = null;
    private static final String PARAMETER_LIST_ELEMENT_NAME = "parameterList";
    private static final String MESSAGE_PARTNAME = "payload";
    private static final String NAME_ATTRIBUTE = "name";

    public MIBusinessRuleTaskRequest(MDServiceTask mdServiceTask, String targetNameSpace, String serviceName, Element element) {
        this.mdServiceTask = mdServiceTask;
        this.targetNameSpace = targetNameSpace;
        this.serviceName = serviceName;
        this.mInputElement = element;
        this.businessRuleTask = (BusinessRuleTask)mdServiceTask.getFlowElement();
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "doExecuteStatements", new Object[]{"Start of executing the business rule"});
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        this.handleBusinessRuleInvoke(ci, wi, sc, ctx);
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "doExecuteStatements", new Object[]{"End of executing the business rule"});
        return null;
    }

    private void processInputData(BusinessRuleTask businessRuleTask, IScope sc, ICubeContext ctx, IWorkItem wi, Map<String, Object> payload) throws Exception {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "processInputData", new Object[]{"Start of processInputData"});
        if (this.mInputElement == null) {
            throw new RuntimeException("ERROR: == Input Element not constructed during model loading");
        }
        XMLElement inputElement = (XMLElement)XMLUtil.cloneNode((Node)this.mInputElement);
        inputElement.getOwnerDocument().appendChild((Node)inputElement);
        Attr attr = inputElement.getAttributeNode(NAME_ATTRIBUTE);
        DOMUtil.copyObjHelper((Object)this.serviceName, (Object)attr, (boolean)false, (ICubeContext)ctx);
        Element paramListElement = this.getElement((Element)inputElement, PARAMETER_LIST_ELEMENT_NAME, this.targetNameSpace);
        HashMap<String, XMLElement> inputData = new HashMap<String, XMLElement>();
        DataAssociationSet inputDataAssociationSet = businessRuleTask.getInputDataAssociationSet();
        Map<String, DataElementVariable> data = DataHandlingUtils.processInputData((FlowNode)businessRuleTask, inputDataAssociationSet, sc, ctx, wi);
        if (data != null) {
            Sequence arguments = inputDataAssociationSet.getArgumentsContainer().getDeclarations();
            for (DataDeclaration argument : arguments) {
                String name = argument.getName();
                DataElementVariable var = data.get(name);
                TypeDescription typeDescription = argument.getType().getDelegate();
                SchemaObject schemaObject = typeDescription.isArray() ? DataDeclarationBpmnDecorator.getArrayParametricType((ArrayTypeDescription)typeDescription) : typeDescription.asSchemaObject();
                String elementName = schemaObject.getName();
                String namespace = schemaObject.getNamespace();
                if (var.getStructure() == null) continue;
                Object value = var.getValue();
                if (value != null) {
                    if (value instanceof NodeList) {
                        NodeList nodeList = (NodeList)value;
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Node innerValue = nodeList.item(i);
                            this.addParameterValue(ctx, paramListElement, elementName, namespace, innerValue);
                        }
                        continue;
                    }
                    this.addParameterValue(ctx, paramListElement, elementName, namespace, value);
                    continue;
                }
                BPELExecutionLogger.LOG.debug(this.getClass().getName(), "processInputData", new Object[]{"After evaluating the data handeling element is null for name " + name});
            }
        } else {
            throw new RuntimeException("ERROR: == Data is not evaluated properly");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            BPELExecutionLogger.LOG.debug(this.getClass().getName(), "processInputData", new Object[]{"Input request of business rule service is *** " + XMLUtil.toString((Node)inputElement)});
        }
        inputData.put(MESSAGE_PARTNAME, inputElement);
        payload.putAll(inputData);
        AuditUtil.addInMessageToPayload(ctx, wi.getCubeInstance(), sc.getAbsoluteScopeId(), payload, wi.getCubeNode().getName());
    }

    private void addParameterValue(ICubeContext ctx, Element paramListElement, String elementName, String namespace, Object value) throws CubeException {
        Element parameterElement = paramListElement.getOwnerDocument().createElementNS(namespace, elementName);
        paramListElement.appendChild(parameterElement);
        DOMUtil.copyObjHelper((Object)value, (Object)parameterElement, (boolean)false, (ICubeContext)ctx);
    }

    private Element getElement(Element element, String name, String nameSpace) throws CubeException {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "getElement", new Object[]{"Start of getting element with name " + name});
        NodeList nodes = element.getElementsByTagNameNS(nameSpace, name);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            return (XMLElement)node;
        }
        BPELExecutionLogger.LOG.error(this.getClass().getName(), "getElement", new Object[]{"Element with name " + name + " and namespace " + nameSpace + "doesn't Exist in " + DOMUtil.toXML((Node)element)});
        Object[] obj = new Object[]{name, nameSpace};
        throw new CubeException(75002, obj);
    }

    private void handleBusinessRuleInvoke(ICubeInstanceImpl ci, IWorkItem wi, IScope sc, ICubeContext ctx) throws Throwable {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "handleBusinessRuleInvoke", new Object[]{"Start of handle business rule invoke "});
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        this.processInputData(this.businessRuleTask, sc, ctx, wi, inputs);
        CXMessageVariable inputVariable = (CXMessageVariable)sc.getObject(this.mdServiceTask.getInputVariableName());
        inputVariable.putAll(inputs);
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "handleBusinessRuleInvoke", new Object[]{"End of handle business rule invoke "});
    }
}

