/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.microkernel.MDVariableDeclaration;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;

public abstract class MIBaseCopyVariable<T>
extends MIBase<Object> {
    private final MDVariableDeclaration sourceDeclaration;
    private final MDVariableDeclaration targetDeclaration;

    protected MIBaseCopyVariable(MDVariableDeclaration source, MDVariableDeclaration target) {
        this.sourceDeclaration = source;
        this.targetDeclaration = target;
    }

    protected abstract T createVariable(ICubeContext var1, IScope var2, String var3, QName var4);

    protected abstract void copyVariable(T var1, T var2);

    @Override
    protected final Object doExecute(MicroInstructionContext context) throws Throwable {
        ICubeContext ctx = context.getCubeContext();
        IScope scope = context.getScope();
        IWorkItem wi = context.getWorkItem();
        String synthetizedVariableName = this.getSynthetizedVariableName(this.sourceDeclaration, wi);
        context.setProperty("DATA_ASSOCIATION_OUTPUT_VARIABLE", synthetizedVariableName);
        Object source = scope.getObject(this.sourceDeclaration.getName());
        T target = this.createVariable(ctx, scope, synthetizedVariableName, this.targetDeclaration.getType());
        this.copyVariable(source, target);
        this.setVariableValue(scope.getParentScope(), target);
        return null;
    }

    private String getSynthetizedVariableName(MDVariableDeclaration sourceVariableDeclaration, IWorkItem wi) {
        return sourceVariableDeclaration.getName() + "-" + wi.getKey().toString();
    }
}

