/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.audit.AuditLevel;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.xml.dom.DOMUtil;
import com.oracle.bpel.client.BPELFault;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.analytics.measurement.IElementContext;
import oracle.bpm.analytics.measurement.MeasurementUtil;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.blocks.MultiStartBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.common.SequenceFlowMetadata;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUpdateTask;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDAuditLog;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.bpmn.engine.service.BPMNAuditEvent;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.audit.IAuditService;
import oracle.bpm.bpmn.engine.service.audit.payload.AuditActivityInfo;
import oracle.bpm.bpmn.engine.service.audit.payload.AuditExpressionExecution;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.collections.Sequence;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.project.catalog.type.utils.TaskManagementServiceHelper;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.update.OutcomeUpdateDefinition;
import oracle.bpm.project.model.processes.update.PriorityUpdateDefinition;
import oracle.bpm.project.model.processes.update.ReassignUpdateDefinition;
import oracle.bpm.project.model.processes.update.TaskIdUpdateTargetDefinition;
import oracle.bpm.project.model.processes.update.UpdateDefinition;
import oracle.bpm.project.model.processes.update.UpdateTargetType;
import oracle.bpm.project.model.processes.update.UpdateTask;
import oracle.bpm.project.model.processes.update.UpdateType;
import oracle.bpm.project.model.processes.update.UserTaskUpdateTargetDefinition;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditVariable;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.soa.common.util.XMLUtil;
import org.w3c.dom.Node;

public class MIAuditLog
extends MIBase<Object> {
    private MDAuditLog mdAuditLog;
    private static final Class logClassName = MIAuditLog.class;
    private static final String FAULT_MESSAGE = "FaultMessage";
    private static final String LOOP_COUNT_NAME = "LoopCount";
    private static final String INSTANCE_COUNT_NAME = "InstanceCount";
    private static String INTERVAL_MEASUREMENT_CONTEXT = "IM_CTX_";
    private static String SCOPE_CONTEXT = "AUDIT_SCOPE_CTX_";

    public MIAuditLog(MDAuditLog metadata) {
        this.mdAuditLog = metadata;
    }

    public MDAuditLog getMetadata() {
        return this.mdAuditLog;
    }

    @Override
    public String getMicroInstructionDescription() {
        String desc = this.mdAuditLog.getFlowElement().getId() + (this.mdAuditLog.isEntryPoint() ? "Pre" : "Post");
        return super.getMicroInstructionDescription() + "(" + desc + ")";
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws CubeException {
        String logMethodName = "doExecute";
        if (MIAuditLog.isDummyToken(context.getNodeActivationContext()).booleanValue()) {
            context.getNodeActivationContext().put("SOURCE_ACTIVITY_ID", "");
        }
        FlowNode element = this.mdAuditLog.getFlowElement();
        try {
            boolean willLog;
            String enabledVar = (String)context.getCubeContext().getFromEnvironment("AUDIT_ENABLED");
            IAuditService auditService = AuditServiceFactory.getInstance().getAuditService();
            if (enabledVar == null || Boolean.parseBoolean(enabledVar)) {
                enabledVar = auditService.canLog(context.getCubeContext(), AuditLevel.Minimal) + "";
                context.getCubeContext().addToEnvironment("AUDIT_ENABLED", (Object)enabledVar);
            }
            if (willLog = auditService.canLog(Boolean.parseBoolean(enabledVar), this.getElementContext(context))) {
                this.mdAuditLog.setAuditLevel(Long.valueOf(auditService.getAuditLevel(context.getCubeContext())));
                BPMNAuditEvent event = this.createAuditEvent(context, false);
                if (auditService.canLog(context.getCubeContext(), AuditLevel.Production)) {
                    boolean canLog = auditService.canLog(context.getCubeContext(), AuditLevel.Development, element.getBpmnType());
                    this.handleAuditDetail(context, element, event, canLog, false);
                } else {
                    BPELExecutionLogger.LOG.debug(logClassName, "doExecute", new Object[]{"Audit detail will not be created. Check the Audit Log Level if it is required"});
                }
                ICubeContext ctx = context.getCubeContext();
                String sourceId = context.getSourceActivityId();
                if (this.mdAuditLog.isEntryPoint()) {
                    if (event.getFaultType() == null || event.getFaultType().length() == 0) {
                        this.handleMeasurementMarks(context, auditService, sourceId);
                    }
                    auditService.logAuditInstance(ctx, event);
                } else {
                    this.handleCounters(context, auditService);
                    auditService.logAuditInstance(ctx, event);
                    if (event.getFaultType() == null || event.getFaultType().length() == 0) {
                        this.handleMeasurementMarks(context, auditService, sourceId);
                    }
                }
            } else {
                BPELExecutionLogger.LOG.debug(logClassName, "doExecute", new Object[]{"No audit logging will be performed. Auditing if OFF and it is not required by measurement"});
            }
            if (this.mdAuditLog.getFlowElement().isGateway()) {
                IScopeImpl sc = (IScopeImpl)context.getScope();
                String key = AuditExpressionExecution.getKey(this.mdAuditLog.getFlowElement().getId());
                BPELExecutionLogger.LOG.debug(logClassName, "doExecute", new Object[]{"Checking for GATEWAY EXPRESSION execution for {" + key + "} - ", sc.contains(key)});
                if (sc.contains(key)) {
                    BPELExecutionLogger.LOG.debug(logClassName, "doExecute", new Object[]{"Removing GATEWAY EXPRESSION execution for {" + key + "}"});
                    ((IScopeImpl)context.getScope()).removeLocalVariant(key, true);
                }
            }
        }
        catch (Exception e) {
            throw new CubeException((Throwable)e);
        }
        return null;
    }

    protected BPMNCubeElement getNode(MicroInstructionContext context) {
        return context.getNode();
    }

    private static Boolean isDummyToken(HashMap tokenMetadata) throws CubeException {
        Boolean dummyTokenForMergingGateway = (Boolean)tokenMetadata.get("DUMMY_TOKEN_FOR_MERGING_GATEWAY");
        return dummyTokenForMergingGateway != null && dummyTokenForMergingGateway != false;
    }

    private void handleMeasurementMarks(MicroInstructionContext context, IAuditService auditService, String sourceId) throws Exception {
        String logMethodName = "handleMeasurementMarks";
        BPELExecutionLogger.LOG.debug(logClassName, "handleMeasurementMarks", new Object[]{"BEGIN"});
        if (this.mdAuditLog.hasMeasurementMarks()) {
            for (Measurement m : this.mdAuditLog.getMeasurements()) {
                BPMNAuditEvent measureEvent = null;
                if (this.mdAuditLog.getFlowElement().isGateway()) {
                    BPELExecutionLogger.LOG.debug(logClassName, "handleMeasurementMarks", new Object[]{"Processing measurement mark for gateway - ID {" + m.getId() + "} Label {" + m.getDefaultLabel() + "} Source {" + m.getTransition().getSource().getId() + "} Target {" + m.getTransition().getTarget().getId() + "} isEntryPoint {" + this.mdAuditLog.isEntryPoint() + "} Measurement Type {" + m.getMeasurementType().toString() + "}"});
                    measureEvent = this.createMeasureEventForGateway(context, m, sourceId);
                } else {
                    BPELExecutionLogger.LOG.debug(logClassName, "handleMeasurementMarks", new Object[]{"Processing measurement mark for flow element - ID {" + m.getId() + "} Label {" + m.getDefaultLabel() + "} Source {" + m.getTransition().getSource().getId() + "} Target {" + m.getTransition().getTarget().getId() + "} isEntryPoint {" + this.mdAuditLog.isEntryPoint() + "} Measurement Type {" + m.getMeasurementType().toString() + "}"});
                    measureEvent = this.createMeasureEventForFlow(context, m, sourceId);
                }
                if (measureEvent == null) continue;
                measureEvent.setActivityId(m.getName());
                measureEvent.setActivityName(m.getMeasurementType().toString());
                measureEvent.setLabel(m.getDefaultLabel());
                measureEvent.setFlowElementType(BpmnType.MEASUREMENT.getInnerType().name());
                measureEvent.setActivityType(BpmnType.MEASUREMENT.name());
                ICubeContext cubeContext = context.getCubeContext();
                String scopeId = context.getWorkItem() != null ? context.getWorkItem().getKey().toString() : this.mdAuditLog.getScopeId() + "." + "0";
                switch (m.getMeasurementType()) {
                    case START: {
                        scopeId = this.storeMeasrementContext(cubeContext, m.getId(), scopeId);
                        break;
                    }
                    case STOP: {
                        scopeId = this.getMeasurementContext(cubeContext, m.getRelatedMeasurement().getId());
                        break;
                    }
                }
                if (scopeId.length() == 0) {
                    measureEvent.setScopeId(this.mdAuditLog.getScopeId() + ".0");
                } else {
                    measureEvent.setScopeId(scopeId);
                }
                for (ProjectDataObject var : m.getBusinessIndicators()) {
                    BPELExecutionLogger.LOG.debug(logClassName, "handleMeasurementMarks", new Object[]{"Associating variable {" + var.getName() + "} - {" + var.getDefaultLabel() + "}"});
                    measureEvent.addAssociatedVariable(var.getName());
                }
                ICubeContext ctx = context.getCubeContext();
                if (auditService.canLog(context.getCubeContext(), AuditLevel.Production)) {
                    boolean canLog = auditService.canLog(context.getCubeContext(), AuditLevel.Development, this.mdAuditLog.getFlowElement().getBpmnType());
                    this.handleAuditDetail(context, this.mdAuditLog.getFlowElement(), measureEvent, canLog, true);
                } else {
                    BPELExecutionLogger.LOG.debug(logClassName, "handleMeasurementMarks", new Object[]{"Audit detail will not be created. Check the Audit Log Level if it is required"});
                }
                auditService.logAuditInstance(ctx, measureEvent);
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "handleMeasurementMarks", new Object[]{"END"});
    }

    private void handleCounters(MicroInstructionContext context, IAuditService auditService) throws Exception {
        String logMethodName = "handleCounters";
        if (this.mdAuditLog.hasCounter()) {
            BPELExecutionLogger.LOG.debug(logClassName, "handleCounters", new Object[]{"BEGIN Processing counters"});
            for (Counter c : this.mdAuditLog.getCounters()) {
                BPMNAuditEvent counterEvent = this.createAuditEvent(context, true);
                BPELExecutionLogger.LOG.debug(logClassName, "handleCounters", new Object[]{"Merging counter from activity ID {" + counterEvent.getActivityId() + "} to {" + c.getActivityId() + "}"});
                counterEvent.setOperation(AuditInstanceOperation.MEASUREMENT_COUNTER);
                counterEvent.setAuditInstanceType(AuditInstanceOperation.MEASUREMENT_COUNTER.getType(this.mdAuditLog.isEntryPoint()));
                counterEvent.setFlowElementType(BpmnType.COUNTER.getInnerType().toString());
                for (ProjectDataObject var : c.getBusinessIndicators()) {
                    BPELExecutionLogger.LOG.debug(logClassName, "handleCounters", new Object[]{"Associating variable {" + var.getName() + "} - {" + var.getDefaultLabel() + "}"});
                    counterEvent.addAssociatedVariable(var.getName());
                }
                ICubeContext ctx = context.getCubeContext();
                if (auditService.canLog(context.getCubeContext(), AuditLevel.Production)) {
                    boolean canLog = auditService.canLog(context.getCubeContext(), AuditLevel.Development, this.mdAuditLog.getFlowElement().getBpmnType());
                    this.handleAuditDetail(context, this.mdAuditLog.getFlowElement(), counterEvent, canLog, true);
                } else {
                    BPELExecutionLogger.LOG.debug(logClassName, "handleCounters", new Object[]{"Audit detail will not be created. Check the Audit Log Level if it is required"});
                }
                auditService.logAuditInstance(ctx, counterEvent);
            }
            BPELExecutionLogger.LOG.debug(logClassName, "handleCounters", new Object[]{"END Processing counters"});
        }
    }

    private BPMNAuditEvent createAuditEvent(MicroInstructionContext context, boolean isArtifact) throws CubeException {
        String scopeId;
        String logMethodName = "createAuditEvent";
        IWorkItem iWorkItem = context.getWorkItem();
        FlowNode element = this.mdAuditLog.getFlowElement();
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"BEGIN"});
        HashMap activationContext = context.getNodeActivationContext();
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{activationContext.toString()});
        ICubeInstanceImpl cInstance = context.getCubeInstance();
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"NODE - ID {" + this.getNode(context).getId() + "} Parent Block ID {" + this.getNode(context).getParentBlockId() + "} Process {" + element.getProcess().getDefaultLabel() + "} Type {" + this.getNode(context).getType() + "} Entry {" + this.mdAuditLog.isEntryPoint() + "} Component Type {" + this.mdAuditLog.getComponentType() + "}" + " ECID {" + cInstance.getECID() + "}"});
        BPMNAuditEvent event = null;
        AuditQueryMetadata varMd = this.mdAuditLog.getAuditQueryMetadata();
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"Audit Query Metadata {" + (varMd != null ? varMd.getCompositeDn() : "NULL Metadata!") + "}"});
        event = new BPMNAuditEvent();
        event.setAuditQueryMetadata(varMd);
        event.setAuditLevel(this.mdAuditLog.getAuditLevel());
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(cInstance.getPartitionDate().getTime());
        event.setPartitionDate(c);
        event.setECID(cInstance.getECID());
        if (cInstance.getCubeInstanceEO() != null) {
            event.setTenantId(cInstance.getCubeInstanceEO().getTenantId());
        } else {
            BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"Unable to locate the tenant ID. Setting to 0."});
            event.setTenantId(0L);
        }
        BpmnType flowObjectSubType = this.mdAuditLog.getFlowElement().getBpmnType();
        event.setActivityName(flowObjectSubType == null ? "PROCESS" : flowObjectSubType.name());
        event.setActivityId(this.mdAuditLog.getFlowElement().getId());
        event.setFlowElementType(flowObjectSubType == null ? "PROCESS" : flowObjectSubType.getInnerType().name());
        event.setActivityType(AuditUtil.getActivityType(this.mdAuditLog.getFlowElement(), flowObjectSubType));
        event.setComponentInstanceId(cInstance.getKey().toString());
        event.setComponentName(cInstance.getComponentDN().getComponentName());
        event.setComponentType(this.mdAuditLog.getComponentType());
        event.setCompositeDn(cInstance.getComponentDN().getCompositeDN());
        event.setCompositeInstanceId(cInstance.getCompositeInstanceId());
        event.setCompositeName(cInstance.getComponentDN().getCompositeName());
        event.setProcessName(element.getProcess().getId());
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"Process ID {" + event.getProcessName() + "} Process Name {" + element.getProcess().getDefaultLabel() + "}"});
        event.setStep(-1L);
        Integer loopCount = null;
        Integer scopeCount = null;
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"Loop Counter - SUBPROCESS INSTANCE {" + (element instanceof Subprocess) + "} loopCountAttr {" + (this.mdAuditLog.getLoopCountAttr() != null) + "}"});
        if (this.mdAuditLog.getLoopCountAttr() != null) {
            if (this.mdAuditLog.isInSubprocess()) {
                if (this.mdAuditLog.getLoopCountAttr().containsValue(context.getScope().getParentScope(), context.getCubeContext())) {
                    scopeCount = loopCount = (Integer)this.mdAuditLog.getLoopCountAttr().getValue(context.getScope().getParentScope(), context.getCubeContext());
                }
            } else {
                if (this.mdAuditLog.getLoopCountAttr().containsValue(context.getScope(), context.getCubeContext())) {
                    loopCount = (Integer)this.mdAuditLog.getLoopCountAttr().getValue(context.getScope(), context.getCubeContext());
                }
                if (!isArtifact && flowObjectSubType != BpmnType.SUBPROCESS) {
                    scopeCount = loopCount;
                }
            }
        }
        if (loopCount != null) {
            event.setLoopCount(loopCount.longValue());
            BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"Loop Counter {" + loopCount + "}"});
        } else {
            event.setLoopCount(0L);
        }
        Integer instanceCount = null;
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"Instance Counter - SUBPROCESS INSTANCE {" + (element instanceof Subprocess) + "} instanceCountAttr {" + (this.mdAuditLog.getInstanceCountAttr() != null) + "}"});
        if (this.mdAuditLog.getInstanceCountAttr() != null) {
            if (this.mdAuditLog.isInSubprocess()) {
                if (this.mdAuditLog.getInstanceCountAttr().containsValue(context.getScope().getParentScope(), context.getCubeContext())) {
                    instanceCount = (Integer)this.mdAuditLog.getInstanceCountAttr().getValue(context.getScope().getParentScope(), context.getCubeContext());
                }
            } else if (this.mdAuditLog.getInstanceCountAttr().containsValue(context.getScope(), context.getCubeContext())) {
                instanceCount = (Integer)this.mdAuditLog.getInstanceCountAttr().getValue(context.getScope(), context.getCubeContext());
            }
        }
        if (instanceCount != null) {
            event.setInstanceCount(instanceCount.longValue());
            BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"Instance Counter {" + instanceCount + "}"});
        } else {
            event.setInstanceCount(0L);
        }
        if (iWorkItem != null && iWorkItem.getExpirationDate() != null) {
            c = Calendar.getInstance();
            c.setTime(iWorkItem.getExpirationDate());
            event.setDueDate(c);
        } else {
            event.setDueDate(null);
        }
        event.setOperation(this.mdAuditLog.getAuditInstanceOperation());
        event.setAuditInstanceType(this.mdAuditLog.getAuditInstanceOperation().getType(this.mdAuditLog.isEntryPoint()));
        this.handleException(context, iWorkItem, event);
        event.setInvokedComponentName(null);
        try {
            event.setLabel(element.getDefaultLabel());
        }
        catch (Exception e) {
            throw new CubeException((Throwable)e);
        }
        event.setParentThreadId(Long.valueOf(context.getParentThread()));
        String string = scopeId = iWorkItem != null ? iWorkItem.getKey().toString() : this.mdAuditLog.getScopeId() + "." + "0";
        if (event.getActivityName().equals("CALL_ACTIVITY") || event.getActivityName().equals("SUBPROCESS")) {
            try {
                scopeId = this.mdAuditLog.isEntryPoint() ? this.storeScopeContext(context.getCubeContext(), event.getActivityId(), scopeId, SCOPE_CONTEXT) : this.getScopeContext(context.getCubeContext(), event.getActivityId(), SCOPE_CONTEXT);
            }
            catch (Exception e) {
                throw new CubeException((Throwable)e);
            }
        }
        event.setScopeId(scopeId);
        String scopeName = InstanceAttributeType.getVariableName(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, event.getActivityId(), context.getScope().getAbsoluteScopeId());
        if (this.mdAuditLog.isEntryPoint()) {
            context.getCubeContext().addToEnvironment(scopeName, (Object)event.getScopeId());
        } else {
            context.getCubeContext().removeFromEnvironment(scopeName);
        }
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"SCOPE_ID {" + event.getScopeId() + "}", this.mdAuditLog.isEntryPoint() ? " Saved to {" + scopeName + "}" : ""});
        this.resolveParticipant(element, event, context);
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"Participant resolved to {" + event.getParticipant() + "} user task number {" + event.getUserTaskNumber() + "}"});
        if (this.mdAuditLog.isEntryPoint()) {
            event.setSourceActivity(context.getSourceActivityId());
            List<FlowNode> processTargetActivities = this.mdAuditLog.getProcessTargetActivityId();
            if (processTargetActivities == null || processTargetActivities.size() == 0) {
                event.setTargetActivity(this.mdAuditLog.getFlowElement().getId());
                BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"### CASE 1. No process target activity {" + event.getTargetActivity() + "}"});
            } else if (processTargetActivities.size() == 1) {
                event.setTargetActivity(processTargetActivities.get(0).getId());
                BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"### CASE 2. One process target activity {" + event.getTargetActivity() + "}"});
            } else if (processTargetActivities.size() > 1) {
                for (FlowNode targetElement : processTargetActivities) {
                    if (!MultiStartBlock.isInitiate(context.getCubeContext(), targetElement)) continue;
                    event.setTargetActivity(targetElement.getId());
                    break;
                }
                BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"### CASE 3. Multiple process target activities {" + event.getTargetActivity() + "}"});
            }
        } else if (flowObjectSubType != null && flowObjectSubType.isGateway()) {
            if (flowObjectSubType == BpmnType.EVENT_BASED_GATEWAY) {
                event.setSourceActivity(this.mdAuditLog.getFlowElement().getId());
                event.setTargetActivity(this.getNode(context).getFlowElement().getId());
            } else {
                Gateway gw = (Gateway)this.mdAuditLog.getFlowElement();
                Map<String, HashMap<String, Object>> gTokens = this.getGeneratedTokensMetadata(context);
                Sequence outSequenceFlows = gw.getOutgoingSequenceFlows();
                for (SequenceFlow s : outSequenceFlows) {
                    BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"Outgoing Sequence flow information for a gateway {" + s.getId() + "} source {" + s.getSource().getId() + "} target {" + s.getTarget().getId() + "} activation {" + context.getActivationIds() + "}"});
                    if (!gTokens.containsKey(s.getTarget().getId()) || MIAuditLog.isDummyToken(this.getGeneratedTokensMetadata(context).get(s.getTarget().getId())).booleanValue()) continue;
                    event.setSourceActivity(s.getSource().getId());
                    event.setTargetActivity(s.getTarget().getId());
                    break;
                }
            }
        } else {
            SequenceFlowMetadata sequenceFlowMetadata = this.getNode(context).getSequenceFlowMetadata();
            event.setSourceActivity(this.mdAuditLog.getFlowElement().getId());
            if (!this.mdAuditLog.isInstanceTerminated() && sequenceFlowMetadata != null && sequenceFlowMetadata.getOutgoingSequenceFlow() != null && context.getLastException() == null) {
                event.setTargetActivity(sequenceFlowMetadata.getOutgoingSequenceFlow().getTargetActivityId());
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"Source Activity {" + event.getSourceActivity() + "} Target Activity {" + event.getTargetActivity() + "}"});
        event.setThreadId(Long.valueOf(context.getThread()));
        event.setTitle(this.mdAuditLog.getFlowElement().getName());
        this.handleBusinessIndicators(context, event, isArtifact);
        BPELExecutionLogger.LOG.debug(logClassName, "createAuditEvent", new Object[]{"END"});
        return event;
    }

    private BPMNAuditEvent createMeasureEventForFlow(MicroInstructionContext context, Measurement measurement, String sourceId) throws Exception {
        String logMethodName = "createMeasureEventForFlow";
        BPELExecutionLogger.LOG.debug(logClassName, "createMeasureEventForFlow", new Object[]{"BEGIN"});
        SequenceFlowMetadata sequenceFlowMetadata = this.getNode(context).getSequenceFlowMetadata();
        BPMNAuditEvent measureEvent = null;
        String nodeId = this.mdAuditLog.getFlowElement().getId();
        if (!this.mdAuditLog.isEntryPoint()) {
            measureEvent = this.createFlowMeasureEvent(context, sequenceFlowMetadata.getOutgoingSequenceFlow(), measurement, sourceId, nodeId, false);
        }
        if (measureEvent != null) {
            switch (measurement.getMeasurementType()) {
                case START: {
                    measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_START);
                    measureEvent.setAuditInstanceType(AuditInstanceOperation.MEASUREMENT_START.getType(this.mdAuditLog.isEntryPoint()));
                    break;
                }
                case STOP: {
                    measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_STOP);
                    measureEvent.setAuditInstanceType(AuditInstanceOperation.MEASUREMENT_STOP.getType(this.mdAuditLog.isEntryPoint()));
                    measureEvent.setReferenceId(measurement.getRelatedMeasurement().getName());
                    break;
                }
                case START_STOP: {
                    measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_START_STOP);
                    measureEvent.setAuditInstanceType(AuditInstanceOperation.MEASUREMENT_START_STOP.getType(this.mdAuditLog.isEntryPoint()));
                    break;
                }
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "createMeasureEventForFlow", new Object[]{"END"});
        return measureEvent;
    }

    private BPMNAuditEvent createMeasureEventForGateway(MicroInstructionContext context, Measurement measurement, String sourceId) throws Exception {
        String logMethodName = "createMeasureEventForGateway";
        BPELExecutionLogger.LOG.debug(logClassName, "createMeasureEventForGateway", new Object[]{"BEGIN"});
        BPMNAuditEvent measureEvent = null;
        Gateway gw = (Gateway)this.mdAuditLog.getFlowElement();
        String nodeId = gw.getId();
        if (!this.mdAuditLog.isEntryPoint()) {
            measureEvent = this.createGatewayMeasureEvent(context, measurement, sourceId, nodeId, false);
        }
        if (measureEvent != null) {
            switch (measurement.getMeasurementType()) {
                case START: {
                    measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_START);
                    measureEvent.setAuditInstanceType(AuditInstanceOperation.MEASUREMENT_START.getType(this.mdAuditLog.isEntryPoint()));
                    break;
                }
                case STOP: {
                    measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_STOP);
                    measureEvent.setAuditInstanceType(AuditInstanceOperation.MEASUREMENT_STOP.getType(this.mdAuditLog.isEntryPoint()));
                    measureEvent.setReferenceId(measurement.getRelatedMeasurement().getName());
                    break;
                }
                case START_STOP: {
                    measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_START_STOP);
                    measureEvent.setAuditInstanceType(AuditInstanceOperation.MEASUREMENT_START_STOP.getType(this.mdAuditLog.isEntryPoint()));
                    break;
                }
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "createMeasureEventForGateway", new Object[]{"END"});
        return measureEvent;
    }

    private BPMNAuditEvent createFlowMeasureEvent(MicroInstructionContext context, SequenceFlowInfo sequenceFlowInfo, Measurement measurement, String sourceId, String nodeId, boolean isEntry) throws Exception {
        String logMethodName = "createFlowMeasureEvent";
        BPMNAuditEvent measureEvent = null;
        String flowId = null;
        if (sequenceFlowInfo != null) {
            flowId = sequenceFlowInfo.getId();
            if (measurement.getTransition().getId().equals(flowId)) {
                measureEvent = this.createAuditEvent(context, true);
            } else {
                BPELExecutionLogger.LOG.debug(logClassName, "createFlowMeasureEvent", new Object[]{"The {" + measurement.getMeasurementType().toString() + "} mark {" + measurement.getId() + "} is not on the current sequence flow. This will not be processed"});
            }
        } else if (isEntry) {
            BPELExecutionLogger.LOG.debug(logClassName, "createFlowMeasureEvent", new Object[]{"FLOWNODE Testing for SOURCE {" + measurement.getTransition().getSource().getId() + " == " + sourceId + "} TARGET {" + measurement.getTransition().getTarget().getId() + " == " + nodeId + "}"});
            if (measurement.getTransition().getSource().getId().equals(sourceId) && measurement.getTransition().getTarget().getId().equals(nodeId)) {
                measureEvent = this.createAuditEvent(context, true);
            }
        } else {
            BPELExecutionLogger.LOG.debug(logClassName, "createFlowMeasureEvent", new Object[]{"FLOWNODE Testing for SOURCE {" + measurement.getTransition().getSource().getId() + " == " + nodeId + "}"});
            if (measurement.getTransition().getSource().getId().equals(nodeId)) {
                measureEvent = this.createAuditEvent(context, true);
            }
        }
        return measureEvent;
    }

    private BPMNAuditEvent createGatewayMeasureEvent(MicroInstructionContext context, Measurement measurement, String sourceId, String nodeId, boolean isEntry) throws Exception {
        String logMethodName = "createGatewayMeasureEvent";
        BPELExecutionLogger.LOG.debug(logClassName, "createGatewayMeasureEvent", new Object[]{"BEGIN"});
        BPMNAuditEvent measureEvent = null;
        Map<String, HashMap<String, Object>> generatedTokenMap = this.getGeneratedTokensMetadata(context);
        BPELExecutionLogger.LOG.debug(logClassName, "createGatewayMeasureEvent", new Object[]{"Generate measurement for Node id = " + nodeId + " source id " + sourceId});
        if (isEntry) {
            BPELExecutionLogger.LOG.debug(logClassName, "createGatewayMeasureEvent", new Object[]{"PREAUDIT Testing for SOURCE {" + measurement.getTransition().getSource().getId() + " == " + sourceId + "} TARGET {" + measurement.getTransition().getTarget().getId() + " == " + nodeId + "}"});
            if (measurement.getTransition().getSource().getId().equals(sourceId) && measurement.getTransition().getTarget().getId().equals(nodeId)) {
                measureEvent = this.createAuditEvent(context, true);
                measureEvent.setSourceActivity(measurement.getTransition().getSource().getId());
                measureEvent.setTargetActivity(measurement.getTransition().getTarget().getId());
            } else {
                BPELExecutionLogger.LOG.debug(logClassName, "createGatewayMeasureEvent", new Object[]{"Not generating measurement as transition source id " + measurement.getTransition().getSource().getId() + " doesn't match with Node id = " + nodeId + " source id " + sourceId});
            }
        } else {
            BPELExecutionLogger.LOG.debug(logClassName, "createGatewayMeasureEvent", new Object[]{"POSTAUDIT Testing for SOURCE {" + measurement.getTransition().getSource().getId() + " == " + nodeId + "} TARGET {" + measurement.getTransition().getTarget().getId() + " is in generatedTokenMap " + generatedTokenMap.containsKey(measurement.getTransition().getTarget().getId()) + "}"});
            if (measurement.getTransition().getSource().getId().equals(nodeId) && generatedTokenMap.containsKey(measurement.getTransition().getTarget().getId()) && !MIAuditLog.isDummyToken(generatedTokenMap.get(measurement.getTransition().getTarget().getId())).booleanValue()) {
                measureEvent = this.createAuditEvent(context, true);
                measureEvent.setSourceActivity(measurement.getTransition().getSource().getId());
                measureEvent.setTargetActivity(measurement.getTransition().getTarget().getId());
            } else {
                BPELExecutionLogger.LOG.debug(logClassName, "createGatewayMeasureEvent", new Object[]{"Not generating measurement as transition source id " + measurement.getTransition().getSource().getId() + " doesn't match with Node id = " + nodeId + " source id " + sourceId});
            }
        }
        BPELExecutionLogger.LOG.debug(logClassName, "createGatewayMeasureEvent", new Object[]{"END"});
        return measureEvent;
    }

    private void handleBusinessIndicators(MicroInstructionContext context, BPMNAuditEvent event, boolean isArtifact) throws CubeException {
        String logMethodName = "handleBusinessIndicators";
        Process proc = this.mdAuditLog.getFlowElement().getProcess();
        if (proc != null) {
            Sequence vars = proc.getProject().getProjectDataObjects();
            for (ProjectDataObject var : vars) {
                if (!var.isBusiness()) continue;
                BusinessVariableType varType = var.getBusinessVariableType();
                BPELExecutionLogger.LOG.debug(logClassName, "handleBusinessIndicators", new Object[]{"Business variable {" + var.getId() + "} Name {" + var.getDefaultLabel() + " - " + var.getName() + "} Type {" + varType.toString().substring(0, 1) + "} Raw class {" + var.getRawClass().getName() + "} Storage Type {" + var.getType().getName() + "} isArtifact {" + isArtifact + "}"});
                String name = var.getName();
                AuditUtil.setAuditVariableValue(context.getScope(), this.mdAuditLog.getAuditVariableMetadata(), event, name);
            }
        } else {
            BPELExecutionLogger.LOG.debug(logClassName, "handleBusinessIndicators", new Object[]{"Project is null"});
        }
    }

    private IElementContext getElementContext(MicroInstructionContext context) {
        ICubeInstanceImpl cInstance = context.getCubeInstance();
        BpmnType flowObjectSubType = this.mdAuditLog.getFlowElement().getBpmnType();
        IElementContext eCtx = MeasurementUtil.getElementContext((String)cInstance.getComponentDN().getCompositeDN(), (String)cInstance.getComponentDN().getComponentName(), (String)(flowObjectSubType == null ? "PROCESS" : flowObjectSubType.toString()), (String)this.mdAuditLog.getAuditInstanceOperation().toString(), (String)(this.mdAuditLog.isEntryPoint() ? EAuditInstanceType.START.name() : EAuditInstanceType.END.name()), (String)this.mdAuditLog.getFlowElement().getId());
        return eCtx;
    }

    private void handleAuditDetail(MicroInstructionContext context, FlowNode element, BPMNAuditEvent event, boolean canLog, boolean isArtifact) throws Exception {
        String logMethodName = "handleAuditDetail";
        ICubeContext iCubeContext = context.getCubeContext();
        Map messages = (Map)iCubeContext.removeFromEnvironment("AUDIT_LOG_OUTPUT_MESSAGE");
        if (canLog) {
            BPELExecutionLogger.LOG.debug(logClassName, "handleAuditDetail", new Object[]{"Able to record detail - isArtifact {" + isArtifact + "}"});
            if (messages != null && !this.mdAuditLog.isEntryPoint()) {
                BPELExecutionLogger.LOG.debug(logClassName, "handleAuditDetail", new Object[]{"AUDIT_OUTPUT_MESSAGE ", messages});
                for (Map.Entry entry : messages.entrySet()) {
                    this.putVariableToPayload(iCubeContext, event, (String)entry.getKey(), entry.getValue(), IAuditVariable.Direction.DIRECTION_OUTPUT);
                }
            }
            DataAssociationSet dataSet = null;
            if (element.isDataAssociationsEnabled()) {
                if (element.getBpmnType() != null && element.getBpmnType() == BpmnType.END_EVENT) {
                    InputDataAssociationEnabled inAssoc = (InputDataAssociationEnabled)element.asAnyNode(InputDataAssociationEnabled.class);
                    if (inAssoc != null && (dataSet = inAssoc.getInputDataAssociationSet()) != null) {
                        this.processInDataAssociations(context.getScope(), iCubeContext, event, dataSet, IAuditVariable.Direction.DIRECTION_INPUT);
                    }
                } else {
                    OutputDataAssociationEnabled outAssoc = (OutputDataAssociationEnabled)element.asAnyNode(OutputDataAssociationEnabled.class);
                    if (outAssoc != null && (dataSet = outAssoc.getOutputDataAssociationSet()) != null) {
                        this.processOutDataAssociations(context.getScope(), iCubeContext, event, dataSet, IAuditVariable.Direction.DIRECTION_STATE);
                    }
                }
            }
            IAuditVariable.Direction direction = IAuditVariable.Direction.DIRECTION_STATE;
            if (isArtifact) {
                for (Map.Entry<String, IAuditVariable> entry : event.getVariables().entrySet()) {
                    BPELExecutionLogger.LOG.debug(logClassName, "handleAuditDetail", new Object[]{"Adding Business Indicator {" + entry.getKey() + "}"});
                    this.putVariableToPayload(iCubeContext, event, entry.getKey(), entry.getValue(), direction);
                }
            }
            if (this.mdAuditLog.getLoopCountAttr() != null) {
                this.putVariableToPayload(iCubeContext, event, LOOP_COUNT_NAME, event.getLoopCount(), direction);
            }
            if (this.mdAuditLog.getInstanceCountAttr() != null) {
                this.putVariableToPayload(iCubeContext, event, INSTANCE_COUNT_NAME, event.getInstanceCount(), direction);
            }
            if (context.getLastException() != null) {
                this.putVariableToPayload(iCubeContext, event, FAULT_MESSAGE, context.getLastException().toString(), direction);
            }
            if (!isArtifact && element.isGateway()) {
                IScopeImpl sc = (IScopeImpl)context.getScope();
                String key = AuditExpressionExecution.getKey(event.getActivityId());
                BPELExecutionLogger.LOG.debug(logClassName, "handleAuditDetail", new Object[]{"Checking for GATEWAY EXPRESSION Information {" + key + "} - ", sc.contains(key)});
                List conditionExecList = null;
                if (sc.contains(key)) {
                    conditionExecList = (List)sc.getAsObject(key);
                }
                if (conditionExecList != null && conditionExecList.size() > 0) {
                    StringBuffer sb1 = new StringBuffer();
                    sb1.append("\n GATEWAY AUDIT ").append(" isEntry=" + this.mdAuditLog.isEntryPoint() + "\n");
                    ArrayList<AuditExpressionExecution> execList = new ArrayList<AuditExpressionExecution>();
                    for (Map conditionExec : conditionExecList) {
                        AuditExpressionExecution ae = new AuditExpressionExecution(conditionExec);
                        if (ae.getSequenceFlowId() == null) {
                            this.reslolveSFForGateway(ae);
                        }
                        execList.add(ae);
                        sb1.append(ae.toString()).append("\n");
                    }
                    BPELExecutionLogger.LOG.info(logClassName, "handleAuditDetail", new Object[]{sb1.toString()});
                    conditionExecList.clear();
                    sc.removeLocalVariant(key, true);
                    event.setExpressionExecution(execList);
                } else {
                    BPELExecutionLogger.LOG.debug(logClassName, "handleAuditDetail", new Object[]{"\n GATEWAY AUDIT ", event.getActivityId() + " " + event.getActivityName(), " label {" + event.getLabel() + "}", " - No expression list was found or is empty.", "Is Entry: " + this.mdAuditLog.isEntryPoint()});
                }
            }
            this.handleUpdateTask(context, element, event);
        } else {
            BPELExecutionLogger.LOG.debug(logClassName, "handleAuditDetail", new Object[]{"Audit Detail will only be created for asynchronous activities. Check the Audit Log Level if finer grained logging is required "});
        }
    }

    private void processOutDataAssociations(IScope scope, ICubeContext iCubeContext, BPMNAuditEvent event, DataAssociationSet dataSet, IAuditVariable.Direction direction) throws CubeException {
        Sequence dataAssociations = dataSet.getDataAssignments();
        if (dataAssociations != null && !dataAssociations.isEmpty()) {
            for (DataAssignment assignment : dataAssociations) {
                String name;
                DataAssignmentItem targetItem = assignment.getTarget();
                if (targetItem.getRefs().isEmpty() || !scope.contains(name = (String)targetItem.getRefs().iterator().next())) continue;
                Object value = DataHandlingUtils.getVariableValue(name, scope);
                this.putVariableToPayload(iCubeContext, event, name, value, direction);
            }
        }
    }

    private void processInDataAssociations(IScope scope, ICubeContext iCubeContext, BPMNAuditEvent event, DataAssociationSet dataSet, IAuditVariable.Direction direction) throws CubeException {
        Sequence dataAssociations = dataSet.getDataAssignments();
        if (dataAssociations != null && !dataAssociations.isEmpty()) {
            for (DataAssignment assignment : dataAssociations) {
                String name;
                DataAssignmentItem sourceItem = assignment.getSource();
                DataAssignmentItem targetItem = assignment.getTarget();
                if (sourceItem.getRefs().isEmpty() || !scope.contains(name = (String)sourceItem.getRefs().iterator().next())) continue;
                Object value = DataHandlingUtils.getVariableValue(name, scope);
                String targetName = null;
                if (!targetItem.getRefs().isEmpty()) {
                    targetName = (String)targetItem.getRefs().iterator().next();
                }
                this.putVariableToPayload(iCubeContext, event, targetName != null ? targetName : name, value, direction);
            }
        }
    }

    private void resolveParticipant(FlowNode element, BPMNAuditEvent event, MicroInstructionContext context) throws CubeException {
        String logMethodName = "resolveParticipant";
        Lane lane = element.getLane();
        Role role = null;
        if (lane != null) {
            role = BPMNUtility.getRole(lane);
        }
        if (lane != null && role != null) {
            event.setRoleId(role.getId());
            if (element.is(UserTask.class)) {
                if (this.mdAuditLog.isEntryPoint()) {
                    BPELExecutionLogger.LOG.debug(logClassName, "resolveParticipant", new Object[]{"Processing the pre-audit USER_TASK performer"});
                    List<Participant> participants = null;
                    if (role != null) {
                        Participant participant;
                        try {
                            participants = DeploymentDescriptorUtil.getParticipantsForProcessRole(event.getCompositeDn(), role.getId(), null);
                        }
                        catch (Exception e) {
                            BPELExecutionLogger.LOG.debug(logClassName, "resolveParticipant", new Object[]{"Unable to obtain the participant detail"});
                            event.setParticipant(null);
                        }
                        if (participants != null && participants.size() > 0 && (participant = participants.get(0)).getValue() != null) {
                            String participantType = null;
                            switch (((PrincipleRefType)participant.getValue()).getType()) {
                                case USER: {
                                    participantType = "user";
                                    break;
                                }
                                case GROUP: {
                                    participantType = "group";
                                    break;
                                }
                                case APPROLE: {
                                    participantType = "application_role";
                                    break;
                                }
                            }
                            if (participant.getValue() != null) {
                                event.setParticipant(((PrincipleRefType)participant.getValue()).getName() + "," + participantType);
                            }
                        }
                    }
                } else {
                    BPELExecutionLogger.LOG.debug(logClassName, "resolveParticipant", new Object[]{"Processing the post-audit USER_TASK performer"});
                    String updatedBy = (String)context.getCubeContext().removeFromEnvironment("USER_TASK_UPDATED_BY");
                    event.setParticipant(updatedBy);
                    Long taskNumber = (Long)context.getCubeContext().removeFromEnvironment("USER_TASK_NUMBER");
                    event.setUserTaskNumber(taskNumber);
                }
            }
        }
    }

    private void handleException(MicroInstructionContext context, IWorkItem iWorkItem, BPMNAuditEvent event) {
        Throwable lastException = context.getLastException();
        if (lastException != null) {
            if (lastException instanceof BPELFault) {
                BPELFault bpelFault = (BPELFault)lastException;
                BPELExecutionLogger.LOG.error((Object)("BPELFault {" + String.valueOf(bpelFault.getFaultName()) + "} current Operation {" + event.getOperation() + "}"));
                if (bpelFault.getFaultName().getNamespaceURI().equals("http://schemas.oracle.com/bpel/extension")) {
                    this.setSystemFaultDetail(event, String.valueOf(bpelFault.getFaultName()));
                } else if (iWorkItem != null) {
                    this.setBusinessFaultDetail(event, iWorkItem.getFaultName(), iWorkItem.isPendingRecovery());
                } else {
                    this.setBusinessFaultDetail(event, String.valueOf(bpelFault.getFaultName()), true);
                }
            } else {
                this.setSystemFaultDetail(event, lastException.getMessage());
            }
        } else if (iWorkItem != null && iWorkItem.getFaultName() != null) {
            BPELExecutionLogger.LOG.error((Object)("Business Fault {" + iWorkItem.getFaultName() + "} Current Operation {" + event.getOperation() + "}"));
            this.setBusinessFaultDetail(event, iWorkItem.getFaultName(), iWorkItem.isPendingRecovery());
        }
    }

    private void setSystemFaultDetail(BPMNAuditEvent event, String message) {
        event.setOperation(AuditInstanceOperation.INSTANCE_SYSTEM_FAULT);
        event.setFaultIsrecoverable(false);
        event.setFaultType(message);
    }

    private void setBusinessFaultDetail(BPMNAuditEvent event, String message, boolean recoverable) {
        if (!AuditInstanceOperation.INSTANCE_SUSPENDED.equals((Object)event.getOperation())) {
            event.setOperation(AuditInstanceOperation.INSTANCE_FAULT);
        }
        event.setFaultIsrecoverable(recoverable);
        event.setFaultType(message);
    }

    private void putVariableToPayload(ICubeContext iCubeContext, BPMNAuditEvent event, String name, Object value, IAuditVariable.Direction direction) {
        String logMethodName = "putVariableToPayload";
        IAuditVariable var = null;
        Object varValue = null;
        var = event.getVariable(name);
        if (var == null) {
            var = AuditUtil.createNewAuditVariable();
            var.setName(name);
            if (value instanceof Node) {
                try {
                    varValue = DOMUtil.copyObjHelper((Object)value, (Object)varValue, (boolean)true, (ICubeContext)iCubeContext);
                }
                catch (Exception e) {
                    varValue = XMLUtil.toString((Node)((Node)value));
                }
            } else if (value != null) {
                varValue = String.valueOf(value);
            }
            if (varValue == null) {
                varValue = "";
            }
            var.setValue(varValue);
        }
        var.setDirection(direction);
        BPELExecutionLogger.LOG.debug(logClassName, "putVariableToPayload", new Object[]{"Adding the variable {" + name + "} to the audit log detail"});
        event.addAuditPayloadElement(var);
    }

    private String storeMeasrementContext(ICubeContext ctx, String activityId, String scopeId) throws CubeException {
        return this.storeScopeContext(ctx, activityId, scopeId, INTERVAL_MEASUREMENT_CONTEXT);
    }

    private String storeScopeContext(ICubeContext ctx, String activityId, String scopeId, String ctxKey) throws CubeException {
        String key;
        ICubeInstanceImpl cubeInstance = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        IScopeImpl sc = cubeInstance.getScopeContext().getRootScope();
        if (!sc.contains(key = ctxKey + activityId)) {
            sc.declare(key);
        }
        sc.set(key, (Object)scopeId);
        return scopeId;
    }

    private String getMeasurementContext(ICubeContext ctx, String activityId) throws Exception {
        return this.getScopeContext(ctx, activityId, INTERVAL_MEASUREMENT_CONTEXT);
    }

    private String getScopeContext(ICubeContext ctx, String activityId, String ctxKey) throws CubeException {
        ICubeInstanceImpl cubeInstance = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        IScopeImpl sc = cubeInstance.getScopeContext().getRootScope();
        String key = ctxKey + activityId;
        String scopeId = "";
        if (sc.contains(key)) {
            scopeId = (String)sc.getAsObject(key);
        }
        return scopeId;
    }

    private void reslolveSFForGateway(AuditExpressionExecution ae) {
        String logMethodName = "reslolveSFForGateway";
        Gateway gw = (Gateway)this.mdAuditLog.getFlowElement();
        Sequence inSequenceFlows = gw.getIncomingSequenceFlows();
        for (SequenceFlow s : inSequenceFlows) {
            BPELExecutionLogger.LOG.debug(logClassName, "reslolveSFForGateway", new Object[]{"Incoming Sequence flow information for a gateway {" + s.getId() + "} source {" + s.getSource().getId() + "} target {" + s.getTarget().getId() + "}"});
            if (!ae.getSourceId().equals(s.getSource().getId()) || !ae.getTargetId().equals(s.getTarget().getId())) continue;
            ae.setTargetLabel(s.getTarget().getDefaultLabel());
            ae.setSourceLabel(s.getSource().getDefaultLabel());
            ae.setSequenceFlowId(s.getId());
            ae.setSequenceFlowLabel(s.getDefaultLabel());
            break;
        }
    }

    private Map<String, HashMap<String, Object>> getGeneratedTokensMetadata(MicroInstructionContext context) {
        return context.getGeneratedTokensMetadata();
    }

    private void handleUpdateTask(MicroInstructionContext context, FlowNode element, BPMNAuditEvent event) throws Exception {
        String logMethodName = "handleUpdateTask";
        if (element.is(UpdateTask.class)) {
            AuditActivityInfo activityInfo = new AuditActivityInfo();
            UpdateTask t = (UpdateTask)element.asAnyNode(UpdateTask.class);
            UpdateTargetType targetType = t.getUpdateTargetType();
            activityInfo.addInfo("targetType", targetType.name());
            List<String> taskIds = new ArrayList<String>();
            AuditActivityInfo taskInfo = new AuditActivityInfo();
            AuditActivityInfo taskIdInfo = new AuditActivityInfo();
            switch (targetType) {
                case USER_TASK: {
                    UserTaskUpdateTargetDefinition utt = (UserTaskUpdateTargetDefinition)t.getUpdateTargetDefinition().as(UserTaskUpdateTargetDefinition.class);
                    UserTask ut = utt.getTargetUserTask();
                    taskIds = MIUpdateTask.getTaskIds(context.getScope(), utt.getTargetUserTask().getId(), false, taskIds);
                    for (String id : taskIds) {
                        taskIdInfo.addInfo("taskId id=\"" + id + "\"", (String)null);
                    }
                    taskInfo.addInfo("taskIds", taskIdInfo);
                    taskInfo.addInfo("activityId", utt.getTargetUserTask().getId());
                    taskInfo.addInfo("activityName", ut.getBpmnType().name());
                    taskInfo.addInfo("activityLabel", ut.getDefaultLabel());
                    activityInfo.addInfo("targetActivity", taskInfo);
                    break;
                }
                case ALL_USER_TASKS: {
                    taskIds = MIUpdateTask.getTaskIds(context.getScope(), null, true, taskIds);
                    for (String id : taskIds) {
                        taskIdInfo.addInfo("taskId id=\"" + id + "\"", (String)null);
                    }
                    taskInfo.addInfo("taskIds", taskIdInfo);
                    activityInfo.addInfo("targetActivity", taskInfo);
                    break;
                }
                case TASK_ID: {
                    TaskIdUpdateTargetDefinition ttt = (TaskIdUpdateTargetDefinition)t.getUpdateTargetDefinition().as(TaskIdUpdateTargetDefinition.class);
                    activityInfo.addInfo("expression", ttt.getTaskId().getExpressionValue());
                    activityInfo.addInfo("expressionValue", DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(ttt.getTaskId(), (FlowNode)t, context.getScope(), context.getCubeContext()));
                }
            }
            UpdateDefinition ud = t.getUpdateDefinition();
            UpdateType updateType = t.getUpdateType();
            activityInfo.addInfo("updateType", updateType.name());
            switch (updateType) {
                case UPDATE_OUTCOME: {
                    OutcomeUpdateDefinition oud = (OutcomeUpdateDefinition)ud.as(OutcomeUpdateDefinition.class);
                    activityInfo.addInfo("outcomeExpression", oud.getOutcome().getExpressionValue());
                    activityInfo.addInfo("outcomeExpressionValue", DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(oud.getOutcome(), (FlowNode)t, context.getScope(), context.getCubeContext()));
                    break;
                }
                case UPDATE_PRIORITY: {
                    PriorityUpdateDefinition pud = (PriorityUpdateDefinition)ud.as(PriorityUpdateDefinition.class);
                    activityInfo.addInfo("priorityExpression", pud.getPriority().getExpressionValue());
                    activityInfo.addInfo("priorityExpressionValue", DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(pud.getPriority(), (FlowNode)t, context.getScope(), context.getCubeContext()));
                    break;
                }
                case REASSIGN: {
                    ReassignUpdateDefinition rud = (ReassignUpdateDefinition)ud.as(ReassignUpdateDefinition.class);
                    activityInfo.addInfo("reassignExpression", rud.getAssignedUser().getExpressionValue());
                    activityInfo.addInfo("reassignExpressionValue", DataHandlingUtils.ExpressionEvaluatorHelper.getStringValueFromExpression(rud.getAssignedUser(), (FlowNode)t, context.getScope(), context.getCubeContext()));
                    break;
                }
            }
            activityInfo.addInfo("operation", TaskManagementServiceHelper.getOperationNativeName((UpdateType)t.getUpdateType()));
            activityInfo.addInfo("updateTask", t.getUpdateDefinition().getUpdateTask().getId());
            event.setActivityInfo(activityInfo);
            BPELExecutionLogger.LOG.debug(logClassName, "handleUpdateTask", new Object[]{"UPDATE_TASK DETAIL ", "\n", activityInfo.asXML()});
        }
    }

    private static enum EAuditInstanceType {
        START,
        END;

    }
}

