/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.util.ThreadCountManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.AbstractPairingGatewayMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.AbstractPairingGatewayMicroInstructionMetadata;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.InclusiveGatewayMicroInstructionMetadata;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.scripting.ScriptTaskUtils;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.service.audit.payload.AuditExpressionExecution;

public class InclusiveGatewayMicroInstruction
extends AbstractPairingGatewayMicroInstruction {
    private static final String logClassName = InclusiveGatewayMicroInstruction.class.getName();

    public InclusiveGatewayMicroInstruction(InclusiveGatewayMicroInstructionMetadata metadata) {
        super(metadata);
    }

    @Override
    protected void _bindProcessDataObjects(MicroInstructionContext context) throws CubeException {
        TreeMap<String, Object> bindings = new TreeMap<String, Object>();
        IWorkItem wi = context.getWorkItem();
        IScope scope = wi.getScope();
        ICubeContext iCubeContext = context.getCubeContext();
        bindings.put("wi", wi);
        bindings.put("sc", scope);
        bindings.put("ctx", iCubeContext);
        ScriptTaskUtils.bindProcessDataObjects(((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getProcess(), scope, bindings);
    }

    @Override
    protected int _generateToken(MicroInstructionContext context, String newActivationId, String activationIds, int parentThread, int intThread, int intStep) throws CubeException {
        String targetActivityId;
        String targetId;
        String logMethodName = "_generateToken";
        IWorkItem wi = context.getWorkItem();
        IScope scope = wi.getScope();
        ICubeContext iCubeContext = context.getCubeContext();
        SortedSet<SequenceFlowInfo> sequence = ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getGatewaySequenceFlowMetadata().getOutgoingSequenceFlows();
        int[] flows = new int[]{0};
        boolean defaultPath = true;
        int increasedThreadCount = 0;
        for (SequenceFlowInfo sequenceFlow : sequence) {
            HashMap<String, Object> generatedTokenMetadata;
            targetId = sequenceFlow.getTargetNodeId();
            targetActivityId = sequenceFlow.getTargetActivityId();
            boolean result = sequenceFlow.getConditionEvaluator().evaluate(((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElement(), scope, iCubeContext, wi);
            BPELExecutionLogger.LOG.debug(logClassName, "_generateToken", new Object[]{"Evaluating the condition " + sequenceFlow.getConditionEvaluator().toString() + " for target = " + targetId + " evaluated to " + result});
            if (sequenceFlow.isConditionalFlow() && sequenceFlow.getCondition() != null) {
                List<Map<String, String>> conditionExecList = null;
                AuditExpressionExecution conditionExec = new AuditExpressionExecution(AuditExpressionExecution.GatewayType.INCLUSIVE_GATEWAY, ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElementId(), sequenceFlow.getSourceActivityId(), sequenceFlow.getSourceActivityLabel(), sequenceFlow.getTargetActivityId(), sequenceFlow.getTargetActivityLabel(), sequenceFlow.getSequenceFlowId(), sequenceFlow.getSequenceFlowDefaultLabel(), sequenceFlow.getCondition().toString(), result);
                String auditExpressionKey = AuditExpressionExecution.getKey(((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElementId());
                if (!scope.contains(auditExpressionKey)) {
                    conditionExecList = new ArrayList();
                    scope.declare(auditExpressionKey);
                } else {
                    conditionExecList = (List)scope.getObject(auditExpressionKey);
                }
                conditionExecList.add(conditionExec.asSerializable());
                BPELExecutionLogger.LOG.debug(logClassName, "_generateToken", new Object[]{"Setting GATEWAY EXPRESSION information KEY {" + auditExpressionKey + "} " + conditionExecList});
                scope.set(auditExpressionKey, conditionExecList);
            }
            if (!result) continue;
            defaultPath = false;
            BPELExecutionLogger.LOG.debug(logClassName, "_generateToken", new Object[]{"Creating token for " + targetId + " with activation id " + activationIds});
            String activatioIdwithNewId = this.getOutgoingActivationId(sequenceFlow, flows, activationIds, newActivationId);
            if (((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).isForkingGateway()) {
                ThreadCountManager.increaseThreadCount((IScope)scope);
                ++increasedThreadCount;
                generatedTokenMetadata = BPMNTokenManager.generateOpenToken(scope, ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getCubeElement(), targetId, activatioIdwithNewId, intThread, BPMNTokenMetadataUtils.getNewThreadNumber(scope), 0);
            } else {
                generatedTokenMetadata = BPMNTokenManager.generateOpenToken(scope, ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getCubeElement(), targetId, activatioIdwithNewId, parentThread, intThread, intStep);
            }
            context.addGeneratedTokenMetadata(targetActivityId, generatedTokenMetadata);
        }
        if (defaultPath) {
            HashMap<String, Object> generatedTokenMetadata;
            SequenceFlowInfo unconditionalSequenceFlowInfo = ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getGatewaySequenceFlowMetadata().getDefaultOutgoingSequenceFlow();
            if (unconditionalSequenceFlowInfo == null) {
                throw new CubeException(75000, BPMNUtility.getObjects(wi.getCubeInstance(), ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElement()));
            }
            String activatioIdwithNewId = this.getOutgoingActivationId(unconditionalSequenceFlowInfo, flows, activationIds, newActivationId);
            targetId = unconditionalSequenceFlowInfo.getTargetNodeId();
            targetActivityId = unconditionalSequenceFlowInfo.getTargetActivityId();
            BPELExecutionLogger.LOG.debug(logClassName, "_generateToken", new Object[]{"Default sequence flow target  node id is token " + targetId});
            if (((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).isForkingGateway()) {
                ThreadCountManager.increaseThreadCount((IScope)scope);
                ++increasedThreadCount;
                generatedTokenMetadata = BPMNTokenManager.generateOpenToken(scope, ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getCubeElement(), targetId, activatioIdwithNewId, intThread, BPMNTokenMetadataUtils.getNewThreadNumber(scope), 0);
            } else {
                generatedTokenMetadata = BPMNTokenManager.generateOpenToken(scope, ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getCubeElement(), targetId, activatioIdwithNewId, parentThread, intThread, intStep);
            }
            context.addGeneratedTokenMetadata(targetActivityId, generatedTokenMetadata);
        }
        if (flows[0] == 0 && increasedThreadCount != 0) {
            ThreadCountManager.decreaseThreadCount((IScope)scope);
        }
        return flows[0];
    }
}

