/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.util.ThreadCountManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.AbstractMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.ExclusiveGatewayMicroInstructionMetadata;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.service.audit.payload.AuditExpressionExecution;
import oracle.bpm.project.model.processes.FlowNode;

public class ExclusiveGatewayMicroInstruction
extends AbstractMicroInstruction<ExclusiveGatewayMicroInstructionMetadata> {
    private static final String logClassName = ExclusiveGatewayMicroInstruction.class.getName();

    public ExclusiveGatewayMicroInstruction(ExclusiveGatewayMicroInstructionMetadata metadata) {
        super(metadata);
    }

    @Override
    protected void doExecute(MicroInstructionContext context) throws CubeException {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "doExecute", new Object[]{"Start of executing exclusive gateway "});
        IWorkItem iWorkItem = context.getWorkItem();
        this.generateNextTokens(context);
        iWorkItem.markAsComplete();
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "doExecute", new Object[]{"End of executing exclusive gateway "});
    }

    private boolean isActivationIdExist(IScope scope, FlowNode gNode, String activationId) {
        String flowKey = scope.getAbsoluteScopeId() + "." + gNode.getId() + "." + activationId;
        return scope.contains(flowKey);
    }

    private String getActivationId(MicroInstructionContext context, SequenceFlowInfo sequenceFlow, String activationId, int thread, int parentThread, int step) throws CubeException {
        FlowNode gatewayNode = ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElement();
        String activationIdAfterRemove = activationId;
        if (BPMNUtility.isSequenceFlowGoesToEnd(sequenceFlow, gatewayNode)) {
            activationIdAfterRemove = BPMNTokenManager.generateDummyToken(context.getNode().getCubeElement(), context.getWorkItem().getScope(), activationId, thread, parentThread, step);
        }
        return activationIdAfterRemove;
    }

    private void generateNextTokens(MicroInstructionContext context) throws CubeException {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "generateNextTokens", new Object[]{"Start of generating the next token"});
        String logMethodName = "generateNextTokens";
        IWorkItem iWorkItem = context.getWorkItem();
        ICubeContext iCubeContext = context.getCubeContext();
        IScope iScope = iWorkItem.getScope();
        int intThread = BPMNTokenMetadataUtils.getThreadFromTokenMetadata(iWorkItem.getNodeActivationContext());
        int parentThread = BPMNTokenMetadataUtils.getParentThreadFromTokenMetadata(iWorkItem.getNodeActivationContext());
        int intStep = BPMNTokenMetadataUtils.getStepFromTokenMetadata(iWorkItem.getNodeActivationContext());
        ++intStep;
        String activationId = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(iWorkItem.getNodeActivationContext());
        if (activationId == null) {
            activationId = "";
        }
        String nextToken = null;
        String nextActivityId = null;
        for (SequenceFlowInfo sequenceFlowInfo : ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getGatewaySequenceFlowMetadata().getOutgoingSequenceFlows()) {
            boolean result = sequenceFlowInfo.getConditionEvaluator().evaluate(((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElement(), iScope, iCubeContext, iWorkItem);
            BPELExecutionLogger.LOG.debug(logClassName, "generateNextTokens", new Object[]{" Sequence Flow = " + sequenceFlowInfo.getId(), " Target = " + sequenceFlowInfo.getTargetNodeId(), " Expression = '" + sequenceFlowInfo.getCondition().toString() + "'", "  result = " + result});
            if (!sequenceFlowInfo.isConditionalFlow() || sequenceFlowInfo.getCondition() == null) continue;
            List<Map<String, String>> conditionExecList = null;
            AuditExpressionExecution conditionExec = new AuditExpressionExecution(AuditExpressionExecution.GatewayType.EXCLUSICE_GATEWAY, ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElementId(), sequenceFlowInfo.getSourceActivityId(), sequenceFlowInfo.getSourceActivityLabel(), sequenceFlowInfo.getTargetActivityId(), sequenceFlowInfo.getTargetActivityLabel(), sequenceFlowInfo.getSequenceFlowId(), sequenceFlowInfo.getSequenceFlowDefaultLabel(), sequenceFlowInfo.getCondition().toString(), result);
            if (((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).isAuditable()) {
                String auditExpressionKey = AuditExpressionExecution.getKey(((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElementId());
                if (!iScope.contains(auditExpressionKey)) {
                    conditionExecList = new ArrayList();
                    iScope.declare(auditExpressionKey);
                } else {
                    conditionExecList = (List)iScope.getObject(auditExpressionKey);
                }
                conditionExecList.add(conditionExec.asSerializable());
                BPELExecutionLogger.LOG.debug(logClassName, "generateNextTokens", new Object[]{"Setting GATEWAY EXPRESSION information KEY {" + auditExpressionKey + "} " + conditionExecList});
                iScope.set(auditExpressionKey, conditionExecList);
            }
            if (!result) continue;
            nextToken = sequenceFlowInfo.getTargetNodeId();
            nextActivityId = sequenceFlowInfo.getTargetActivityId();
            activationId = this.getActivationId(context, sequenceFlowInfo, activationId, intThread, parentThread, intStep);
            break;
        }
        HashMap<String, Object> generatedTokenMetadata = null;
        if (nextToken != null) {
            generatedTokenMetadata = BPMNTokenManager.generateOpenToken(iScope, ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getCubeElement(), nextToken, activationId, parentThread, intThread, intStep);
        } else {
            SequenceFlowInfo unconditionalSequenceFlowInfo = ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getGatewaySequenceFlowMetadata().getDefaultOutgoingSequenceFlow();
            if (unconditionalSequenceFlowInfo != null) {
                nextToken = unconditionalSequenceFlowInfo.getTargetNodeId();
                nextActivityId = unconditionalSequenceFlowInfo.getTargetActivityId();
                activationId = this.getActivationId(context, unconditionalSequenceFlowInfo, activationId, intThread, parentThread, intStep);
                BPELExecutionLogger.LOG.debug(logClassName, "generateNextTokens", new Object[]{"Evaluating the default sequence flow "});
                if (nextToken.equals(context.getWorkItem().getCubeNode().getParentBlockId())) {
                    ThreadCountManager.decreaseThreadCount((IScope)context.getWorkItem().getScope());
                    HashMap tokenMetadata = context.getWorkItem().getNodeActivationContext();
                    BPMNTokenMetadataUtils.setStepToTokenMetadata(tokenMetadata, context.getStep());
                    context.getWorkItem().getScope().declareAndSet("EXIT_TOKEN_METADATA", (Object)tokenMetadata);
                } else {
                    generatedTokenMetadata = BPMNTokenManager.generateOpenToken(iScope, ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getCubeElement(), nextToken, activationId, parentThread, intThread, intStep);
                }
            } else {
                throw new CubeException(75000, BPMNUtility.getObjects(iWorkItem.getCubeInstance(), ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElement()));
            }
        }
        if (generatedTokenMetadata != null) {
            context.addGeneratedTokenMetadata(nextActivityId, generatedTokenMetadata);
        }
        BPELExecutionLogger.LOG.debug(logClassName, "generateNextTokens", new Object[]{"End of generating the next token"});
    }
}

