/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateHelper {
    private static final String STANDARD_DATETIME = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String TIMEZONE = "Z";
    private static final String MSEC = "S";

    public static Date formatISO8601(String dateStr) throws ParseException {
        int lastColon = dateStr.lastIndexOf(":");
        if (lastColon == dateStr.length() - 3) {
            dateStr = dateStr.substring(0, lastColon) + dateStr.substring(lastColon + 1);
        }
        String pattern = dateStr.contains(".") ? DateHelper.getPatternWithMsecs(dateStr) : "yyyy-MM-dd'T'HH:mm:ssZ";
        return new SimpleDateFormat(pattern).parse(dateStr);
    }

    public static Calendar date2calendar(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal;
    }

    private static String getPatternWithMsecs(String dateStr) {
        int dotIndex = dateStr.indexOf(".");
        int tzIndex = DateHelper.indexOfTZ(dateStr);
        String repeatS = new String(new char[tzIndex - dotIndex]).replace("\u0000", MSEC);
        return "yyyy-MM-dd'T'HH:mm:ss." + repeatS + TIMEZONE;
    }

    private static int indexOfTZ(String dateStr) {
        int plusIndex = dateStr.lastIndexOf("+");
        int signIndex = plusIndex == -1 ? dateStr.lastIndexOf("-") : plusIndex;
        return signIndex;
    }
}

