/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import java.io.Serializable;

public class ProcessInstance
implements Serializable {
    private String absoluteScopeId;
    private String activityId;
    private long instanceId;
    private String mapElementId;
    private String state;
    private int thread;
    private String workItemKeyURI;
    private static final long serialVersionUID = 5729763901546096492L;

    private ProcessInstance(long instanceId, int thread, String activityId) {
        this.instanceId = instanceId;
        this.thread = thread;
        this.activityId = activityId;
    }

    public static ProcessInstance createWithWorkItemKeyURI(long instanceId, int thread, String workItemKeyURI, String activityId) {
        ProcessInstance result = new ProcessInstance(instanceId, thread, activityId);
        result.workItemKeyURI = workItemKeyURI;
        return result;
    }

    public static ProcessInstance createWithTokenInfo(long instanceId, int thread, String absoluteScopeId, String mapElementId, String activityId) {
        ProcessInstance result = new ProcessInstance(instanceId, thread, activityId);
        result.absoluteScopeId = absoluteScopeId;
        result.mapElementId = mapElementId;
        return result;
    }

    public static ProcessInstance createForQuery(long instanceId, int thread) {
        return new ProcessInstance(instanceId, thread, null);
    }

    public String getActivityId() {
        return this.activityId;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(long instanceId) {
        this.instanceId = instanceId;
    }

    public int getThread() {
        return this.thread;
    }

    public void setThread(int thread) {
        this.thread = thread;
    }

    public String getAbsoluteScopeId() {
        return this.absoluteScopeId;
    }

    public String getWorkItemKeyURI() {
        return this.workItemKeyURI;
    }

    public void setAbsoluteScopeId(String absoluteScopeId) {
        this.absoluteScopeId = absoluteScopeId;
    }

    public void setWorkItemKeyURI(String workItemKeyURI) {
        this.workItemKeyURI = workItemKeyURI;
    }

    public String getMapElementId() {
        return this.mapElementId;
    }

    public void setMapElementId(String mapElementId) {
        this.mapElementId = mapElementId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstance that = (ProcessInstance)o;
        return this.instanceId == that.instanceId && this.thread == that.thread;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public int hashCode() {
        int result = (int)(this.instanceId ^ this.instanceId >>> 32);
        result = 31 * result + this.thread;
        return result;
    }

    public String toString() {
        return "ProcessInstance{instanceId=" + this.instanceId + ", thread=" + this.thread + ", absoluteScopeId='" + this.absoluteScopeId + '\'' + ", workItemKeyURI='" + this.workItemKeyURI + '\'' + ", mapElementId='" + this.mapElementId + '\'' + '}';
    }
}

