/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import com.collaxa.cube.engine.CubeEngineHolder;
import com.collaxa.cube.engine.ICubeEngine;
import com.collaxa.cube.engine.core.CubeInstanceKey;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.util.EngineBeanCache;
import com.collaxa.cube.persistence.dto.CubeInstance;
import com.collaxa.cube.xml.dom.DOMUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.repos.IPersistencyService;
import oracle.bpel.services.workflow.repos.Transaction;
import oracle.bpm.bpmn.engine.instancemanagement.impl.InternalInstanceManagementService;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.AlterFlowXmlModelHelper;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.AppliedChangesResult;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.AppliedChangesSummary;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ApplyChangesPlan;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentInstanceMigrationContext;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentMigrationSupport;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CorrelationKey;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CorrelationProperty;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ResultInfo;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Variable;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.Activity;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.Alterflow;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.CorrelationKeyUpdate;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.DataUpdate;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.FlowUpdate;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.model.PropertyUpdate;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.bpmn.engine.service.Util;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNCubeInstanceManagerLocalBean;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.fabric.composite.CompositeDN;
import oracle.fabric.composite.model.CompositeModel;
import oracle.integration.platform.blocks.migration.ComponentInstanceResultFactory;
import oracle.soa.management.facade.ComponentInstance;
import oracle.soa.management.facade.ComponentInstanceMigrationResult;
import oracle.soa.management.facade.MigrationPlan;
import oracle.soa.management.util.SOAUtil;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MigrateInstanceBetweenRevisionsDelegate {
    private static MigrateInstanceBetweenRevisionsDelegate ourInstance = new MigrateInstanceBetweenRevisionsDelegate();

    private MigrateInstanceBetweenRevisionsDelegate() {
    }

    public static MigrateInstanceBetweenRevisionsDelegate getInstance() {
        return ourInstance;
    }

    public ComponentInstanceMigrationResult execute(Logger logger, ComponentMigrationSupport componentMigrationSupport, ComponentInstance componentInstance, CompositeModel newRevisionCompositeModel, MigrationPlan migrationPlan) throws Exception {
        String failureReason;
        Element componentMigrationPlan;
        ICubeEngine engine = CubeEngineHolder.getEngine((String)BPMNServiceEngine.getInstance().getEngineType());
        ComponentInstanceMigrationContext componentInstanceMigrationContext = ComponentInstanceMigrationContext.create();
        boolean migrated = false;
        logger.info("migrate");
        logger.fine("loading instance...");
        long ci = BPMNServiceEngine.stripCubeInstanceId(componentInstance.getId());
        ICubeInstanceImpl cubeInstance = engine.load(new CubeInstanceKey(ci), componentInstanceMigrationContext.getCubeContext());
        logger.fine("instance loaded.");
        CubeInstance cubeInstanceEO = cubeInstance.getCubeInstanceEO();
        String targetCompositeLabel = newRevisionCompositeModel.getLabel();
        String instanceLabel = cubeInstanceEO.getCompositeLabel();
        logger.info("checking instance is not migrated");
        logger.info("current component label is " + targetCompositeLabel);
        logger.info("instance component label is " + instanceLabel);
        logger.info("synchronizing instance state to new definition...");
        logger.info("generating diff component to instance definition...");
        logger.info("synchronizing instance state based on generated diff...");
        CompositeDN sourceCompositeDn = new CompositeDN(cubeInstance.getComponentDN().getCompositeDN());
        CompositeDN targetCompositeDn = new CompositeDN(newRevisionCompositeModel.getApplicationName(), newRevisionCompositeModel.getName(), newRevisionCompositeModel.getRevision(), targetCompositeLabel);
        String alterFlowNamespaceURI = "http://xmlns.oracle.com/bpmn/alterflow";
        String alterFlowLocalName = "alterflow";
        logger.fine("instance composite dn ->" + cubeInstance.getComponentDN().getCompositeDN_NoLabel());
        IBPMNCubeInstanceManagerLocalBean bean = (IBPMNCubeInstanceManagerLocalBean)EngineBeanCache.getInstanceManagerLocalBean((String)BPMNServiceEngine.getInstance().getEngineType());
        if (migrationPlan != null && (componentMigrationPlan = migrationPlan.getComponentPlan(componentInstance.getCompositeDN().getStringDN() + "/" + componentInstance.getComponentName())) != null) {
            Element migrationPlanElem = (Element)componentMigrationPlan.getElementsByTagNameNS("http://xmlns.oracle.com/bpmn/alterflow", "alterflow").item(0);
            Alterflow alterflow = AlterFlowXmlModelHelper.getInstance().getAlterFlowModel(migrationPlanElem);
            ApplyChangesPlan plan = this.createApplyChangesPlan(alterflow, targetCompositeDn, cubeInstance.getComponentDN().getStringDN());
            FetchProcessInstancesCallable callable = new FetchProcessInstancesCallable(ci);
            Object instances = callable.call();
            logger.finest("instances to migrate = " + instances);
            AppliedChangesSummary changes = bean.applyChanges(cubeInstance.getComponentDN(), (List<ProcessInstance>)instances, plan, false);
            String failureReason2 = this.getFailureReasonFromAppliedChangesSummary(changes);
            if (failureReason2 != null) {
                logger.fine("Execution of migration plan failed");
                return ComponentInstanceResultFactory.getInstance().create(componentInstance.getComponentName(), componentInstance.getServiceEngine().getEngineType(), componentInstance.getId(), false, failureReason2);
            }
            logger.finest(changes.toString());
        }
        boolean bl = migrated = (failureReason = bean.synchronizeInstance(ci, componentInstanceMigrationContext, sourceCompositeDn, targetCompositeDn, componentMigrationSupport, newRevisionCompositeModel, logger)) == null;
        if (migrated) {
            logger.finer("instance state synchronized and ready to migrate.");
            logger.finer("updating instance component definition with label->" + targetCompositeLabel);
            cubeInstanceEO.setCompositeLabel(targetCompositeLabel);
            logger.finer("instance migrated.");
            logger.finer("Migrating instance tracking revision");
            this.migrateInstanceTrackingRevision(String.valueOf(cubeInstance.getId()), this.buildNewTaskDefinitionId(componentInstance, newRevisionCompositeModel), newRevisionCompositeModel.getDN(), newRevisionCompositeModel.getRevision());
        }
        logger.finer("generating migration result for instance.");
        return ComponentInstanceResultFactory.getInstance().create(componentInstance.getComponentName(), componentInstance.getServiceEngine().getEngineType(), componentInstance.getId(), migrated, failureReason);
    }

    private String getFailureReasonFromAppliedChangesSummary(AppliedChangesSummary appliedChangesSummary) {
        boolean failure = false;
        StringBuilder failureReason = new StringBuilder();
        for (AppliedChangesResult appliedChangesResult : (List)appliedChangesSummary.getActionResult()) {
            for (ResultInfo resultInfo : appliedChangesResult.getResultInfos()) {
                if (resultInfo.isSuccess()) continue;
                failureReason.append(resultInfo.getExceptionMessage());
                failureReason.append(". ");
                failure = true;
            }
        }
        return failure ? failureReason.toString() : null;
    }

    private String buildNewTaskDefinitionId(ComponentInstance componentInstance, CompositeModel newRevisionCompositeModel) {
        return SOAUtil.getCompositeDNWithoutLabel((String)newRevisionCompositeModel.getDN()) + "*/" + componentInstance.getComponentName();
    }

    private boolean wasSucceed(AppliedChangesSummary changes) {
        for (AppliedChangesResult result : (List)changes.getActionResult()) {
            for (ResultInfo info : result.getResultInfos()) {
                if (info.isSuccess()) continue;
                return false;
            }
        }
        return true;
    }

    private ApplyChangesPlan createApplyChangesPlan(Alterflow alterflow, CompositeDN targetCompositeDN, String componentDN) throws IOException, SAXException {
        ArrayList<Variable> requestedVariableChanges = new ArrayList<Variable>();
        ArrayList<Variable> requestedInstanceAttributeChanges = new ArrayList<Variable>();
        ArrayList<CorrelationKey> requestedCorrelationKeyChanges = new ArrayList<CorrelationKey>();
        String componentName = SOAUtil.getComponentNameFromComponentDN((String)componentDN);
        for (DataUpdate dataObjectUpdate : alterflow.getDataObjectUpdate()) {
            requestedVariableChanges.add(Variable.create(dataObjectUpdate.getName(), this.createElement(dataObjectUpdate.getValue())));
        }
        for (DataUpdate instanceAttributeUpdate : alterflow.getInstanceAttributeUpdate()) {
            requestedInstanceAttributeChanges.add(Variable.create(instanceAttributeUpdate.getName(), this.createElement(instanceAttributeUpdate.getValue())));
        }
        for (CorrelationKeyUpdate correlationKeyUpdate : alterflow.getCorrelationKeyUpdate()) {
            HashSet<CorrelationProperty> properties = new HashSet<CorrelationProperty>();
            for (PropertyUpdate propertyUpdate : correlationKeyUpdate.getProperties()) {
                properties.add(CorrelationProperty.create(propertyUpdate.getName(), propertyUpdate.getValue()));
            }
            requestedCorrelationKeyChanges.add(CorrelationKey.createForUpdate(correlationKeyUpdate.getName(), properties, correlationKeyUpdate.isReset()));
        }
        HashMap<oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity, oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity> requestedFlowChanges = new HashMap<oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity, oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity>();
        for (FlowUpdate flowUpdate : alterflow.getFlowUpdate()) {
            requestedFlowChanges.put(this.adaptActivity(flowUpdate.getSource(), componentName), this.adaptActivity(flowUpdate.getTarget(), componentName));
        }
        ApplyChangesPlan result = ApplyChangesPlan.create(requestedFlowChanges, requestedVariableChanges, requestedInstanceAttributeChanges, alterflow.getComments(), null);
        result.setCorrelationKeyUpdates(requestedCorrelationKeyChanges);
        result.setBatchSize(alterflow.getBatchSize());
        result.setUpdateInstanceToNewModel(true);
        result.setValidateVariables(alterflow.isValidateVariables());
        result.setTargetCompositeDN(targetCompositeDN);
        result.setCancelChildComponents(false);
        return result;
    }

    private Element createElement(String value) throws IOException, SAXException {
        return DOMUtil.getDocumentBuilder().parse(new InputSource(new StringReader(value))).getDocumentElement();
    }

    private oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity adaptActivity(Activity activity, String componentName) {
        String processId = activity.getProcessId() != null ? activity.getProcessId() : componentName;
        return oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity.create(processId, activity.getId(), activity.getDisplayName());
    }

    private void migrateInstanceTrackingRevision(String instanceId, String newTaskDefinitionId, String newCompositeDN, String newCompositeVersion) throws WorkflowException {
        boolean startTransaction;
        if (Transaction.inTransaction()) {
            startTransaction = false;
        } else {
            Transaction.start((boolean)true);
            startTransaction = true;
        }
        try {
            IPersistencyService persistencyService = Transaction.getPersistencyService();
            persistencyService.migrateTaskCompositeVersion(instanceId, newTaskDefinitionId, newCompositeDN, newCompositeVersion);
        }
        catch (WorkflowException e) {
            throw e;
        }
        finally {
            if (startTransaction) {
                Transaction.close();
            }
        }
    }

    private static class FetchProcessInstancesCallable
    implements Callable<List<ProcessInstance>> {
        private long instanceid;

        FetchProcessInstancesCallable(long instanceid) {
            this.instanceid = instanceid;
        }

        @Override
        public List<ProcessInstance> call() throws Exception {
            return this.buildProcessInstances();
        }

        private List<ProcessInstance> buildProcessInstances() throws Exception {
            ArrayList<ProcessInstance> result = new ArrayList<ProcessInstance>();
            for (IProcessInstance instance : this.queryProcessInstances(String.valueOf(this.instanceid))) {
                result.add(InternalInstanceManagementService.adaptInstance(instance));
            }
            return result;
        }

        private List<IProcessInstance> queryProcessInstances(String instanceId) throws Exception {
            ArrayList<IProcessInstance> result = new ArrayList<IProcessInstance>();
            IInstanceQueryService service = BPMServiceLocator.getInstanceQueryService();
            IBPMContext context = Util.getInternalWorkflowContext();
            IProcessInstance instance = service.getProcessInstance(context, instanceId);
            result.add(instance);
            result.addAll(service.queryParallelInstances(context, instance, new ArrayList()));
            return result;
        }
    }
}

