/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.CubeEngineHolder;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.ICubeEngine;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeContext;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.core.IWorkItemImpl;
import com.collaxa.cube.engine.core.Scope;
import com.collaxa.cube.engine.core.WorkItemLookupTable;
import com.collaxa.cube.engine.core.map.BlockNotFoundException;
import com.collaxa.cube.engine.core.map.NodeNotFoundException;
import com.collaxa.cube.engine.data.DeliveryPersistenceMgr;
import com.collaxa.cube.engine.delivery.IDeliveryService;
import com.collaxa.cube.engine.delivery.SubscriptionInfo;
import com.collaxa.cube.engine.deployment.DeploymentHelper;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import com.collaxa.cube.engine.types.bpel.CXCorrelationSet;
import com.collaxa.cube.engine.util.collections.TokenSet;
import com.collaxa.cube.persistence.IDaoFactory;
import com.collaxa.cube.persistence.dao.IWorkItemDao;
import com.collaxa.cube.persistence.dto.WorkItem;
import com.collaxa.cube.persistence.dto.WorkItemKey;
import com.collaxa.cube.xml.dom.DOMUtil;
import com.oracle.bpel.client.CorrelationId;
import com.oracle.bpel.client.ServerException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceLocal;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMap;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapFactory;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.model.BPMNProcess;
import oracle.bpm.bpmn.engine.model.blocks.BPMNCallableProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.BPMNProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.BPMNScopeDeclarationBlock;
import oracle.bpm.bpmn.engine.model.blocks.BPMNSubProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNBlock;
import oracle.bpm.bpmn.engine.model.blocks.ProcessToFlowNodeAdapter;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ActivityNotFoundException;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ActivityPath;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.AlterFlowModel;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentInstanceMigrationAction;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentInstanceMigrationContext;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentMigrationSupport;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CorrelationKey;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CorrelationProperty;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.DataElementType;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Expression;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.FlowNodeToRuntimeModelMapperImpl;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.IFunctionHelper;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceHandlingException;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceNotInActivityException;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InvalidFlowTargetException;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ResultInfo;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Variable;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.VariableNotFoundException;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.VariableUpdateInfo;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.WorkItemMock;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskWithdraw;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttribute;
import oracle.bpm.bpmn.engine.service.BPMNAuditEvent;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Str;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.instancequery.impl.InstanceQueryInput;
import oracle.fabric.composite.CompositeDN;
import oracle.fabric.composite.model.ComponentModel;
import oracle.soa.common.collections.StringSet;
import oracle.soa.management.ComponentDN;
import oracle.soa.management.facade.ActivityInstance;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class InstanceManipulationHelper {
    private static final InstanceManipulationHelper INSTANCE = new InstanceManipulationHelper();
    private static final Function<DataObject, String> DATAOBJECT_MAPPER = new Function<DataObject, String>(){

        public String eval(DataObject value) {
            return value.getName();
        }
    };
    private static final Function<oracle.bpm.project.model.CorrelationKey, String> CORRELATION_KEY_MAPPER = new Function<oracle.bpm.project.model.CorrelationKey, String>(){

        public String eval(oracle.bpm.project.model.CorrelationKey value) {
            return value.getName();
        }
    };

    private InstanceManipulationHelper() {
    }

    public static InstanceManipulationHelper getInstance() {
        return INSTANCE;
    }

    public static boolean isGrabbedActivity(ActivityInstance activity) {
        Date expirationDate = activity.getExpirationDate();
        return activity.getState() == 8 && expirationDate != null && expirationDate.getTime() == 0L;
    }

    public static void suspendWorkItem(IWorkItem wi) {
        ((IWorkItemImpl)wi).setState(13);
        wi.getCubeInstance().getCubeInstanceEO().setState(2);
    }

    public IScope getProcessScope(ICubeInstanceImpl instance) {
        return (IScope)instance.getScopeContext().getRootScope().getChildScopes().next();
    }

    public ResultInfo grab(ICubeContext ctx, ProcessInstance processInstance, ICubeInstanceImpl instance, Activity sourceActivity, Activity targetActivity, String comment, @Nullable CompositeDN targetCompositeDN, boolean cancelChildComponents, String requester) {
        boolean success;
        ResultInfo result = new ResultInfo();
        try {
            boolean moved;
            BPMNProcess targetBpmnCubeProcess = this.getDeployedBPMNProcess(ctx, instance, targetCompositeDN);
            Process targetProcessModel = targetBpmnCubeProcess.getProcessModel();
            FlowNodeToRuntimeModelMapperImpl mapper = new FlowNodeToRuntimeModelMapperImpl(targetBpmnCubeProcess.getBPMNCubeMap());
            AlterFlowModel targetAlterFlowModel = AlterFlowModel.create(targetProcessModel, mapper);
            AlterFlowModel sourceAlterFlowModel = null;
            if (this.toNewModel(instance, targetCompositeDN)) {
                Process sourceProcessModel = this.getProcessModelForInstance(instance);
                BPMNCubeMap sourceCubeMap = BPMNCubeMapFactory.create(sourceProcessModel);
                FlowNodeToRuntimeModelMapperImpl sourceFlowNodeToRuntimeModelMapper = new FlowNodeToRuntimeModelMapperImpl(sourceCubeMap);
                sourceAlterFlowModel = AlterFlowModel.create(sourceProcessModel, sourceFlowNodeToRuntimeModelMapper);
            }
            if (moved = this.moveIfValid(ctx, processInstance, instance, sourceActivity, targetActivity, sourceAlterFlowModel, targetAlterFlowModel, cancelChildComponents)) {
                FlowNode sourceFlowNode = null;
                if (sourceAlterFlowModel != null) {
                    try {
                        sourceFlowNode = this.getFlowNode(sourceActivity, sourceAlterFlowModel);
                    }
                    catch (ActivityNotFoundException e) {
                        // empty catch block
                    }
                }
                if (sourceFlowNode == null) {
                    sourceFlowNode = this.getFlowNode(sourceActivity, targetAlterFlowModel);
                }
                this.insertGrabAuditEvent(ctx, processInstance, instance, sourceFlowNode, sourceActivity, targetActivity, comment, requester);
            }
            success = true;
        }
        catch (Exception e) {
            success = false;
            String exceptionMessage = e.getMessage() == null ? "Internal error while grabbing." : e.getMessage();
            result.setExceptionMessage(exceptionMessage);
        }
        result.setSuccess(success);
        return result;
    }

    public Iterable<String> getProcessDataObjects(Process process, Scope scope) throws CubeException {
        Subprocess subprocess = this.findInnerSubprocess(scope);
        return DataHandlingUtils.getDataObjectsInScope(process, subprocess).map(DATAOBJECT_MAPPER);
    }

    public Iterable<String> getCorrelationKeys(Process process, Scope scope) throws CubeException {
        Subprocess subprocess = this.findInnerSubprocess(scope);
        return DataHandlingUtils.getCorrelationKeysInScope(process, subprocess).map(CORRELATION_KEY_MAPPER);
    }

    public Iterable<String> getCorrelationKeysForScope(ICubeInstanceImpl instance, String absoluteScopeId) throws CubeException {
        Scope scope = this.getScopeById(instance, absoluteScopeId);
        BaseBPMNBlock block = (BaseBPMNBlock)scope.getBlock();
        NodeContainer nodeContainer = this.getNodeContainer(block);
        HashMap<String, oracle.bpm.project.model.CorrelationKey> correlationKeysScope = new HashMap<String, oracle.bpm.project.model.CorrelationKey>();
        DataHandlingUtils.addCorrelationKeysInContext((CorrelationKeyContainer)nodeContainer, correlationKeysScope);
        return CollectionUtils.asSequence(correlationKeysScope.values()).map(CORRELATION_KEY_MAPPER);
    }

    public Set<Activity> getValidTargets(ComponentDN componentDN, Activity source, Locale locale, IFunctionHelper functionHelper) throws InstanceHandlingException {
        HashSet<Activity> result = new HashSet<Activity>();
        String processId = source.getProcessId();
        ICubeContext ctx = null;
        try {
            ctx = functionHelper.createContext();
            Process processModel = this.getProcessModel(componentDN);
            BPMNCubeMap cubeMap = BPMNCubeMapFactory.create(processModel);
            FlowNodeToRuntimeModelMapperImpl flowNodeToRuntimeModelMapper = new FlowNodeToRuntimeModelMapperImpl(cubeMap);
            AlterFlowModel sourceModel = AlterFlowModel.create(processModel, flowNodeToRuntimeModelMapper);
            BPMNProcess deployedCubeProcess = (BPMNProcess)DeploymentHelper.lookupProcess((ComponentDN)componentDN, (ICubeContext)ctx);
            AlterFlowModel targetModel = AlterFlowModel.create(deployedCubeProcess.getProcessModel(), new FlowNodeToRuntimeModelMapperImpl(deployedCubeProcess.getBPMNCubeMap()));
            sourceModel = this.getSourceAlterFlowModel(source, sourceModel, targetModel);
            String sourceUniqueId = sourceModel.getRuntimeMapper().getRuntimeId(processId, source.getId());
            for (FlowNode flowNode : sourceModel.getValidTargets(sourceUniqueId, targetModel)) {
                String displayName = this.getDisplayName((FlowElement)flowNode, locale);
                Activity activity = Activity.create(processId, flowNode.getId(), displayName);
                boolean added = result.add(activity);
                assert (added) : "The activity was already added as a target[" + componentDN + "," + source + "]->[" + activity + "]";
            }
            HashSet<Activity> hashSet = result;
            return hashSet;
        }
        catch (ServerException e) {
            throw new InstanceHandlingException(e);
        }
        finally {
            functionHelper.destroyContext(ctx);
        }
    }

    public void insertCorrelationKeyUpdateAuditEvent(ICubeContext cubeContext, ICubeInstanceImpl instance, CorrelationKeyUpdate update, String comment, String activityId, String activityName, String activityType) throws InstanceHandlingException {
        System.out.println(">>>>CORRELATION KEY UPDATE->" + instance + ";" + update + ";" + comment);
    }

    public void insertVariableUpdateAuditEvent(ICubeContext cubeContext, ICubeInstanceImpl instance, EntityUpdate update, String comment, String activityId, String activityName, String activityType) throws InstanceHandlingException {
        String logMethodName = "insertVariableUpdateAuditEvent";
        System.out.println(">>>>VARIABLE UPDATE->" + instance + " ;" + update + " ;" + comment);
        DeploymentLogger.LOG.debug(INSTANCE.getClass(), "insertVariableUpdateAuditEvent", new Object[]{"VARIABLE UPDATE->", " Instance {" + instance + "}", " Update {" + update + "}", " Comment {" + comment + "}"});
        try {
            BPMNAuditEvent event = this.newUpdateAuditEvent(cubeContext, instance, comment, activityName);
            event.recordDataChange(update.getName(), update.getOldValue(), update.getNewValue());
            AuditServiceFactory.getInstance().getAuditService().logAuditInstance(cubeContext, event);
        }
        catch (Exception e) {
            throw new InstanceHandlingException(e);
        }
    }

    public void insertVariableUpdateAuditEvent(ICubeContext cubeContext, ICubeInstanceImpl instance, List<EntityUpdate> entityUpdates, String comment, @Nullable String activityId, @Nullable String activityName, @Nullable String activityType) throws InstanceHandlingException {
        String logMethodName = "insertVariableUpdateAuditEvent";
        System.out.println(">>>>VARIABLE UPDATE->" + instance + " ;\n" + entityUpdates + " ;\n" + comment);
        DeploymentLogger.LOG.debug(INSTANCE.getClass(), "insertVariableUpdateAuditEvent", new Object[]{"VARIABLE UPDATE->", " Instance {" + instance + "}", " Updates \n{" + entityUpdates + "}\n", " Comment {" + comment + "}"});
        if (entityUpdates != null && !entityUpdates.isEmpty()) {
            try {
                BPMNAuditEvent event = this.newUpdateAuditEvent(cubeContext, instance, comment, activityName);
                for (EntityUpdate update : entityUpdates) {
                    event.recordDataChange(update.getName(), update.getOldValue(), update.getNewValue());
                }
                AuditServiceFactory.getInstance().getAuditService().logAuditInstance(cubeContext, event);
            }
            catch (Exception e) {
                throw new InstanceHandlingException(e);
            }
        }
    }

    public void insertGrabAuditEvent(ICubeContext cubeContext, ProcessInstance processInstance, ICubeInstanceImpl instance, FlowNode sourceFlowNode, Activity source, Activity target, String comment, String requester) throws InstanceHandlingException {
        String logMethodName = "insertGrabAuditEvent";
        System.out.println(">>>>GRAB->" + processInstance + ";" + source + ";" + target + ";" + comment);
        DeploymentLogger.LOG.debug(INSTANCE.getClass(), "insertGrabAuditEvent", new Object[]{"GRAB ->", " Process Instance{" + processInstance + "}", " Source {" + source + "}", " target {" + target + "}", " Comment {" + comment + "}", " Current compositeDN {" + instance.getComponentDN().getCompositeDN() + "}"});
        try {
            BPMNAuditEvent event = AuditUtil.createNewAuditEvent((ICubeInstance)instance);
            BpmnType flowObjectSubType = sourceFlowNode.getBpmnType();
            event.setActivityName(flowObjectSubType == null ? "PROCESS" : flowObjectSubType.toString());
            event.setOperation(AuditInstanceOperation.FLOW_NODE_MOVED);
            event.setAuditInstanceType(AuditInstanceOperation.FLOW_NODE_MOVED.getType(false));
            event.setActivityId(source.getId());
            event.setTitle(sourceFlowNode.getName());
            event.setFlowElementType(flowObjectSubType == null ? "PROCESS" : flowObjectSubType.getInnerType().name());
            event.setLabel(sourceFlowNode.getDefaultLabel());
            event.setComponentInstanceId(String.valueOf(instance.getKey().getInstanceId()));
            event.setComponentName(instance.getComponentName());
            event.setProcessName(sourceFlowNode.getProcess().getId());
            event.setParticipant(requester);
            event.setThreadId(Long.valueOf(processInstance.getThread()));
            FlowNode scopeNode = sourceFlowNode.getParentObject() != null ? sourceFlowNode.getParentObject() : sourceFlowNode;
            BPMNProcess bpmnCubeProcess = (BPMNProcess)instance.getProcessClass();
            String wiKeyURI = processInstance.getWorkItemKeyURI();
            String scopeId = null;
            scopeId = !Str.isEmpty((String)wiKeyURI) ? new WorkItemKey(wiKeyURI).toString() : bpmnCubeProcess.getCubeMapBuilderContext().getCubeElementId((ProjectObject)scopeNode, "") + ".0";
            event.setScopeId(scopeId);
            event.setComment(comment);
            event.setSourceActivity(source.getId());
            event.setTargetActivity(target.getId());
            event.setLoopCount(0L);
            event.setAuditLevel(Long.valueOf(AuditUtil.getAuditLevel(cubeContext)));
            DeploymentLogger.LOG.debug(INSTANCE.getClass(), "insertGrabAuditEvent", new Object[]{"GRAB -> Logging event", " {" + event.toString() + "}", " source composite DN {" + event.getCompositeDn() + "}"});
            AuditServiceFactory.getInstance().getAuditService().logAuditInstance(cubeContext, event);
        }
        catch (Exception e) {
            DeploymentLogger.LOG.error(InstanceManipulationHelper.class, "insertGrabAuditEvent", new Object[]{"Problem encounted when logging an Audit Event", e});
            throw new InstanceHandlingException(e);
        }
    }

    public Variable getVariableValue(ICubeInstanceImpl instance, String absoluteScopeId, String variableName, boolean isPrimitive, boolean isIncludeLargeDocuments) throws CubeException {
        Scope scope = this.getScopeById(instance, absoluteScopeId);
        Variable variable = scope.contains(variableName) ? this.getVariableValue(scope, variableName, isPrimitive, isIncludeLargeDocuments) : Variable.create(variableName);
        return variable;
    }

    public Scope getScopeById(ICubeInstanceImpl instance, String absoluteScopeId) throws CubeException {
        return (Scope)instance.getScopeContext().getScope(absoluteScopeId);
    }

    public void insertMigrationAuditEvent(ICubeInstanceImpl instance, String comment) {
        System.out.println(">>>>MIGRATION->" + instance.getId() + ";" + comment);
    }

    public VariableUpdateInfo setVariableValue(ProcessInstance processInstance, ICubeInstanceImpl instance, Variable variable, ICubeContext ctx, boolean useInstanceProcessDeclarations, boolean validate, String comment, DataElementType type, @Nullable CompositeDN targetCompositeDN) {
        boolean success;
        VariableUpdateInfo result = new VariableUpdateInfo();
        EntityUpdate entityUpdate = null;
        try {
            entityUpdate = this._setVariableValue(processInstance, instance, variable, ctx, useInstanceProcessDeclarations, validate, type, targetCompositeDN);
            if (entityUpdate == null) {
                return new VariableUpdateInfo(null, null, true);
            }
            success = true;
        }
        catch (Exception e) {
            success = false;
            result.setExceptionMessage(e.getMessage());
        }
        result.setSuccess(success);
        result.setEntityUpdate(entityUpdate);
        return result;
    }

    public Process getProcessModelForInstance(ICubeInstanceImpl instance) throws InstanceHandlingException {
        return this.getProcessModel(this.buildComponentDN(instance));
    }

    public Process getProcessModel(ComponentDN componentDN) throws InstanceHandlingException {
        try {
            ComponentMigrationSupport componentMigrationSupport = BPMNServiceEngine.getInstance().getComponentMigrationSupport();
            CompositeDN compositeDN = new CompositeDN(componentDN.getCompositeDN());
            Project project = componentMigrationSupport.findProject(null, compositeDN);
            Process process = project.findProcess(componentDN.getComponentName());
            if (process == null) {
                throw new InstanceHandlingException("Process " + componentDN.getComponentName() + " not found in project " + compositeDN);
            }
            return process;
        }
        catch (MetadataException e) {
            throw new InstanceHandlingException(e);
        }
    }

    public ComponentDN buildComponentDN(ICubeInstanceImpl instance) {
        return new ComponentDN(instance.getDomainName(), instance.getCompositeName(), instance.getCompositeRevision(), instance.getCompositeLabel(), instance.getComponentName());
    }

    public FlowNode getFlowNode(Activity activity, AlterFlowModel model) throws ActivityNotFoundException {
        String uniqueId = model.getRuntimeMapper().getRuntimeId(activity.getProcessId(), activity.getId());
        AlterFlowModel.NodeLevel nodeLevel = model.getLevelForActivity(uniqueId);
        return nodeLevel.getFlowNode();
    }

    public ResultInfo migrate(ComponentInstanceMigrationContext componentInstanceMigrationContext, ICubeInstanceImpl instance, String comment) {
        ComponentInstanceMigrationAction.MigrateComponentInstanceAction migrateComponentInstanceAction = new ComponentInstanceMigrationAction.MigrateComponentInstanceAction(componentInstanceMigrationContext, BPMNServiceEngine.getInstance().getComponentMigrationSupport(), instance);
        ResultInfo resultInfo = migrateComponentInstanceAction.execute();
        if (resultInfo.isSuccess()) {
            this.insertMigrationAuditEvent(instance, comment);
        }
        return resultInfo;
    }

    public String getAbsoluteScopeId(ProcessInstance processInstance) throws CubeException {
        String absoluteScopeId;
        String wiKeyURI = processInstance.getWorkItemKeyURI();
        if (!Str.isEmpty((String)wiKeyURI)) {
            WorkItemKey wiKey = new WorkItemKey(wiKeyURI);
            absoluteScopeId = wiKey.getScopeId();
        } else {
            absoluteScopeId = processInstance.getAbsoluteScopeId();
        }
        return absoluteScopeId;
    }

    public CorrelationKey getCorrelationKey(ICubeInstanceImpl instance, String absoluteScopeId, String name) throws CubeException, InstanceHandlingException {
        String correlationKeyNativeName;
        Scope scope = this.getScopeById(instance, absoluteScopeId);
        if (!scope.contains(correlationKeyNativeName = this.getCorrelationKeyNativeName(name))) {
            throw new InstanceHandlingException("Correlation Key '" + name + "' does not exist in scope '" + absoluteScopeId + "'");
        }
        CXCorrelationSet correlationSet = (CXCorrelationSet)scope.getObject(correlationKeyNativeName);
        HashSet<CorrelationProperty> properties = new HashSet<CorrelationProperty>();
        boolean initiated = correlationSet.getInitiated();
        Set keys = correlationSet.getProperties().keySet();
        for (QName key : keys) {
            properties.add(CorrelationProperty.create(key, correlationSet.getProperty(key)));
        }
        return CorrelationKey.createForRead(name, properties, initiated);
    }

    public ResultInfo updateCorrelationKey(ICubeContext ctx, ProcessInstance processInstance, ICubeInstanceImpl instance, CorrelationKey correlationKeyUpdate, String comment) {
        boolean success;
        ResultInfo result = new ResultInfo();
        CorrelationKeyUpdate propertiesUpdate = new CorrelationKeyUpdate(correlationKeyUpdate.getName());
        try {
            String absoluteScopeId = this.getAbsoluteScopeId(processInstance);
            Scope scope = this.getScopeById(instance, absoluteScopeId);
            String correlationKeyNativeName = this.getCorrelationKeyNativeName(correlationKeyUpdate.getName());
            if (!scope.contains(correlationKeyNativeName)) {
                return new ResultInfo(null, null, true);
            }
            CXCorrelationSet correlationSet = (CXCorrelationSet)scope.getObject(correlationKeyNativeName);
            if (correlationKeyUpdate.isReset()) {
                CXCorrelationSet newCorrelationSet = new CXCorrelationSet();
                for (Object key : correlationSet.getProperties().keySet()) {
                    newCorrelationSet.getProperties().put(key, null);
                }
                scope.set(correlationKeyNativeName, (Object)newCorrelationSet);
                propertiesUpdate.setReset(true);
            } else {
                for (CorrelationProperty correlationProperty : correlationKeyUpdate.getProperties()) {
                    Object oldValue = correlationSet.getProperties().get(correlationProperty.getName());
                    Object newValue = correlationProperty.getValue();
                    correlationSet.getProperties().put(correlationProperty.getName(), newValue);
                    EntityUpdate property = new EntityUpdate(correlationProperty.getName().toString());
                    property.setOldValue(oldValue);
                    property.setNewValue(newValue);
                    propertiesUpdate.addProperty(property);
                }
            }
            String activityId = null;
            String activityName = null;
            String activityType = null;
            if (processInstance != null) {
                activityId = processInstance.getActivityId();
            }
            this.insertCorrelationKeyUpdateAuditEvent(ctx, instance, propertiesUpdate, comment, activityId, activityName, activityType);
            success = true;
        }
        catch (Exception e) {
            success = false;
            result.setExceptionMessage(e.getMessage());
        }
        result.setSuccess(success);
        return result;
    }

    public Set<Activity> getOpenActivities(ICubeInstanceImpl cubeInstance, Locale locale, ICubeContext ctx) throws CubeException, InstanceHandlingException {
        ProcessInfoRetriever processRetriever = ProcessInfoRetriever.create(this, cubeInstance);
        Set<Activity> activities = this.findOpenActivitiesBasedOnWorkItems(cubeInstance, processRetriever, locale, ctx);
        Set<Activity> activitiesBasedOnTokens = this.findOpenActivitiesBasedOnTokens(cubeInstance, processRetriever, locale, ctx);
        activities.addAll(activitiesBasedOnTokens);
        return activities;
    }

    public Set<Tuple<String, Activity>> findInnerSubProcesses(ICubeInstanceImpl instance, String absoluteScopeId, Locale locale) throws CubeException {
        HashSet<Tuple<String, Activity>> subProcesses = new HashSet<Tuple<String, Activity>>();
        this._findInnerSubProcesses(instance, absoluteScopeId, locale, subProcesses);
        return subProcesses;
    }

    public Set<Variable> getProjectVariables(ICubeInstanceImpl cubeInstance, String absoluteScopeId, boolean isIncludeLargeDocuments) throws CubeException {
        HashSet<Variable> variables = new HashSet<Variable>();
        Scope scope = this.getScopeById(cubeInstance, absoluteScopeId);
        BaseBPMNBlock block = (BaseBPMNBlock)scope.getBlock();
        if (block != null && block instanceof BPMNProcessBlock) {
            BPMNProcessBlock processBlock = (BPMNProcessBlock)block;
            Project container = processBlock.getModel().getProject();
            for (ProjectDataObject dataDeclaration : container.getLocalDeclarations(ProjectDataObject.class)) {
                String name = dataDeclaration.getName();
                Variable variable = this.getVariableValue(cubeInstance, scope.getAbsoluteScopeId(), name, dataDeclaration.getType().isPredefined(), isIncludeLargeDocuments);
                variables.add(variable);
            }
        }
        return variables;
    }

    public Set<Variable> getProcessVariablesInContext(ICubeInstanceImpl cubeInstance, String absoluteScopeId, boolean isIncludeLargeDocuments) throws CubeException {
        return this.getVariablesInContext(cubeInstance, absoluteScopeId, DataObject.class, isIncludeLargeDocuments);
    }

    public Set<Tuple<String, Activity>> findInnerMostSubProcesses(ICubeInstanceImpl instance, String absoluteScopeId, Locale locale) throws CubeException {
        HashSet<Tuple<String, Activity>> innerScopes = new HashSet<Tuple<String, Activity>>();
        Scope scope = this.getScopeById(instance, absoluteScopeId);
        Iterator childScopes = scope.getChildScopes();
        while (childScopes.hasNext()) {
            Scope childScope = (Scope)childScopes.next();
            BaseBPMNBlock block = (BaseBPMNBlock)childScope.getBlock();
            if (block instanceof BPMNScopeDeclarationBlock) {
                BPMNScopeDeclarationBlock declarationBlock = (BPMNScopeDeclarationBlock)block;
                Object declarationNode = declarationBlock instanceof BPMNSubProcessBlock ? ((BPMNSubProcessBlock)declarationBlock).getFlowElement() : ((BPMNCallableProcessBlock)declarationBlock).getFlowElement();
                Activity subProcessActivity = this.createContainerActivity(instance, (FlowNode)declarationNode, childScope, locale);
                Tuple scopeInfo = Tuple.create((Object)childScope.getAbsoluteScopeId(), (Object)subProcessActivity);
                innerScopes.add((Tuple<String, Activity>)scopeInfo);
                continue;
            }
            innerScopes.addAll(this.findInnerMostSubProcesses(instance, childScope.getAbsoluteScopeId(), locale));
        }
        return innerScopes;
    }

    public Activity getScopeActivity(ICubeInstanceImpl instance, String absoluteScopeId, Locale locale) throws CubeException {
        Scope scope = this.getScopeById(instance, absoluteScopeId);
        return this.getScopeActivity(scope, locale);
    }

    public Activity getScopeActivity(Scope scope, Locale locale) throws CubeException {
        ProcessToFlowNodeAdapter nodeContainer;
        BaseBPMNBlock block = (BaseBPMNBlock)scope.getBlock();
        if (block instanceof BPMNProcessBlock) {
            BPMNProcessBlock processBlock = (BPMNProcessBlock)block;
            nodeContainer = new ProcessToFlowNodeAdapter(processBlock.getModel());
        } else if (block instanceof BPMNSubProcessBlock) {
            BPMNSubProcessBlock subProcessBlock = (BPMNSubProcessBlock)block;
            nodeContainer = subProcessBlock.getFlowElement();
        } else if (block instanceof BPMNCallableProcessBlock) {
            BPMNCallableProcessBlock callableBlock = (BPMNCallableProcessBlock)block;
            nodeContainer = callableBlock.getFlowElement();
        } else {
            throw new IllegalArgumentException("The absoluteScopeId is not referencing to a Process or sub process model object.");
        }
        Set<Variable> activityPredefinedAttributes = this.getActivityPredefinedAttributes(scope);
        Activity activity = Activity.create(nodeContainer.getProcess().getId(), nodeContainer.getId(), this.getDisplayName((FlowElement)nodeContainer, locale));
        activity.setAttributes(activityPredefinedAttributes);
        return activity;
    }

    public Set<Variable> getActivityPredefinedAttributes(ICubeInstanceImpl instance, String absoluteScopeId) throws CubeException {
        Scope scope = this.getScopeById(instance, absoluteScopeId);
        return this.getActivityPredefinedAttributes(scope);
    }

    public Set<Variable> getActivityPredefinedAttributes(Scope scope) throws CubeException {
        HashSet<Variable> attributes = new HashSet<Variable>();
        BaseBPMNBlock block = (BaseBPMNBlock)scope.getBlock();
        DataDeclarationContainer dataDeclarationContainer = this.getDataDeclarationContainer(block);
        Sequence dataDeclarations = dataDeclarationContainer.getLocalDeclarations().select((oracle.bpm.collections.Predicate)new ActivityPredefinedVariablePredicate());
        for (DataDeclaration dd : dataDeclarations) {
            String variableName = InstanceAttributeType.getVariableName(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, dataDeclarationContainer.getId(), dd.getName());
            Variable variable = this.getVariableValue(scope, variableName, dd.getType().isPrimitive(), false);
            variable.setEditable(false);
            variable.setName(dd.getName());
            attributes.add(variable);
        }
        return attributes;
    }

    public ProcessInstance getProcessInstance(ICubeInstanceImpl instance, String absoluteScopeId) throws CubeException {
        Scope scope = this.getScopeById(instance, absoluteScopeId);
        return this.getProcessInstance(instance, scope);
    }

    public ProcessInstance getProcessInstance(ICubeInstanceImpl instance, Scope scope) throws CubeException {
        Integer thread = InstanceManipulationHelper.getActivationInstanceThread((IScope)scope);
        return ProcessInstance.createForQuery(instance.getId(), thread);
    }

    public void updateProcessInstanceFlexFields(ICubeInstanceImpl cubeInstance, ProcessInstance processInstance, ICubeContext ctx) throws Exception {
        IInternalInstanceManagementServiceLocal internalManagementservice = BPMNUtility.getInternalManagementservice(ctx);
        IBPMContext bpmContext = BPMNUtility.getInternalWorkflowContext();
        IInstanceQueryService service = BPMServiceLocator.getInstanceQueryService();
        Predicate pred = new Predicate(IColumnConstants.PROCESS_INSTANCEID_COLUMN, 0, (Object)String.valueOf(processInstance.getInstanceId()));
        InstanceQueryInput input = new InstanceQueryInput();
        ArrayList displayColumns = new ArrayList();
        input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
        List instances = service.queryInstances(bpmContext, displayColumns, pred, null, (IInstanceQueryInput)input);
        IProcessInstance iProcessInstance = (IProcessInstance)instances.get(0);
        Scope scope = this.getScopeById(cubeInstance, this.getAbsoluteScopeId(processInstance));
        BPMNUtility.promoteProjectDataObjectToInstance(iProcessInstance, this.getProcessModelForInstance(cubeInstance).getProject(), (IScope)scope);
        internalManagementservice.insertUpdateInstance(bpmContext, iProcessInstance);
    }

    public DataDeclarationContainer getDataDeclarationContainer(BaseBPMNBlock block) {
        Object container;
        if (block instanceof BPMNProcessBlock) {
            BPMNProcessBlock processBlock = (BPMNProcessBlock)block;
            container = processBlock.getModel();
        } else if (block instanceof BPMNSubProcessBlock) {
            BPMNSubProcessBlock subProcessBlock = (BPMNSubProcessBlock)block;
            container = subProcessBlock.getFlowElement();
        } else if (block instanceof BPMNCallableProcessBlock) {
            BPMNCallableProcessBlock callableProcessBlock = (BPMNCallableProcessBlock)block;
            container = callableProcessBlock.getNodeContainer();
        } else {
            throw new IllegalArgumentException("The block should be a process or subProcess block");
        }
        return container;
    }

    private static void unsubscribeWorkItem(ICubeContext ctx, WorkItemKey wiKey, ComponentDN componentDN) throws CubeException {
        IDeliveryService deliveryService = (IDeliveryService)ctx.lookup("__delivery-service");
        CorrelationId correlationId = new CorrelationId(componentDN, wiKey.toString());
        SubscriptionInfo info = DeliveryPersistenceMgr.getSubscription((String)correlationId.toString(), (ICubeContext)ctx);
        if (info != null) {
            info.setState(3);
            DeliveryPersistenceMgr.updateState((SubscriptionInfo)info, (ICubeContext)ctx);
        }
    }

    private static String getNodeActivationContextKey(WorkItemKey wiKey) {
        return wiKey.toURIFormat() + "-" + "NodeActivationContext";
    }

    private static Integer getActivationInstanceThread(IScope scope) throws CubeException {
        HashMap<String, Object> token = BPMNTokenMetadataUtils.getActivationToken(scope);
        return BPMNTokenMetadataUtils.getThreadFromTokenMetadata(token);
    }

    private BPMNProcess getDeployedBPMNProcess(ICubeContext cubeContext, ICubeInstanceImpl instance, CompositeDN targetCompositeDN) throws CubeException {
        BPMNProcess result = targetCompositeDN == null ? (BPMNProcess)instance.getProcessClass() : ComponentMigrationSupport.lookupBpmnProcess(cubeContext, targetCompositeDN.getDN(), instance.getComponentName());
        return result;
    }

    private String getDisplayName(FlowElement element, Locale locale) {
        String displayName = element.getLabel(locale);
        if (displayName.isEmpty()) {
            displayName = element.getDefaultLabel();
        }
        return displayName;
    }

    private Set<Activity> findOpenActivitiesBasedOnTokens(ICubeInstanceImpl cubeInstance, ProcessInfoRetriever processRetriever, Locale locale, ICubeContext ctx) throws CubeException, InstanceHandlingException {
        HashSet<Activity> activities = new HashSet<Activity>();
        IScopeImpl methodScope = this.getMethodScope(cubeInstance);
        TokenSet ts = (TokenSet)methodScope.getLocalVariant("++tokens").getObjectVal();
        TokenSet.Iterator iterator = ts.iterator();
        BPMNProcess deployedProcess = (BPMNProcess)cubeInstance.getProcessClass();
        BPMNCubeMap deployedMap = deployedProcess.getBPMNCubeMap();
        while (iterator.next()) {
            String tokenProcessId;
            BPMNCubeMap tokenCubeMap;
            Object tokenFlowNode;
            String absoluteScopeId = iterator.getScopeId();
            Scope scope = this.getScopeById(cubeInstance, absoluteScopeId);
            String elementId = iterator.getElementId();
            BPMNCubeElement element = this.getCubeElement(elementId, deployedMap);
            if (element != null) {
                tokenFlowNode = element.getFlowElement();
                tokenCubeMap = deployedMap;
                tokenProcessId = deployedProcess.getProcessModel().getId();
            } else {
                tokenFlowNode = processRetriever.findInstanceFlowNode(elementId);
                Process instanceProcessModel = processRetriever.getProcessDefinition();
                tokenCubeMap = BPMNCubeMapFactory.create(instanceProcessModel);
                tokenProcessId = instanceProcessModel.getId();
            }
            if (!this.isEntryPoint(tokenCubeMap, tokenProcessId, elementId) || !tokenFlowNode.isActivity()) continue;
            Iterator tokenIterator = iterator.getValues().iterator();
            while (tokenIterator.hasNext()) {
                Activity activity;
                oracle.bpm.project.model.processes.Activity activityElement = (oracle.bpm.project.model.processes.Activity)tokenFlowNode.asAnyNode(oracle.bpm.project.model.processes.Activity.class);
                if (activityElement.isSubprocess()) {
                    activity = this.createContainerActivity(cubeInstance, (FlowNode)tokenFlowNode, scope, locale);
                } else {
                    int processInstanceThread = BPMNTokenMetadataUtils.getThreadFromTokenMetadata((HashMap)tokenIterator.next());
                    activity = this.createActivity(cubeInstance, (FlowNode)tokenFlowNode, scope, processInstanceThread, locale, null, absoluteScopeId, elementId);
                }
                activities.add(activity);
            }
        }
        return activities;
    }

    private boolean isEntryPoint(BPMNCubeMap map, String processId, String elementId) {
        BPMNCubeMapBuilderContext context = map.getCubeMapBuilderContext();
        BPMNCubeElement element = context.getElementsByTagByProcessId(processId).get(TagInfo.createTagInfo(elementId, Tag.ENTRY_POINT));
        return element != null && element.getId().equals(elementId);
    }

    private BPMNCubeElement getCubeElement(String elementId, BPMNCubeMap map) throws CubeException {
        BPMNCubeElement element;
        try {
            element = (BPMNCubeElement)map.getBlock(elementId);
        }
        catch (BlockNotFoundException e) {
            try {
                element = (BPMNCubeElement)map.getNode(elementId);
            }
            catch (NodeNotFoundException e1) {
                element = null;
            }
        }
        return element;
    }

    private Set<Activity> findOpenActivitiesBasedOnWorkItems(ICubeInstanceImpl cubeInstance, ProcessInfoRetriever retriever, Locale locale, ICubeContext ctx) throws CubeException, InstanceHandlingException {
        HashSet<Activity> activities = new HashSet<Activity>();
        List<WorkItem> items = this.findOpenWorkItems(cubeInstance, ctx);
        if (items != null) {
            BPMNProcess processClass = (BPMNProcess)cubeInstance.getProcessClass();
            for (WorkItem item : items) {
                String nodeId = item.getNodeId();
                BPMNCubeElement bpmnCubeNode = this.getCubeElement(nodeId, processClass.getBPMNCubeMap());
                Object activityNode = bpmnCubeNode != null ? bpmnCubeNode.getFlowElement() : retriever.findInstanceFlowNode(nodeId);
                if (activityNode == null) {
                    throw new ActivityNotFoundException(nodeId);
                }
                if (ModelVisitorUtil.isEventHandler(activityNode)) continue;
                Scope scope = this.getScopeById(cubeInstance, item.getScopeId());
                int processInstanceThread = this.getWorkItemThread(scope, item);
                WorkItemKey workItemKey = new WorkItemKey(item.getCikey(), item.getNodeId(), item.getScopeId(), item.getCountId());
                Activity activity = this.createActivity(cubeInstance, (FlowNode)activityNode, scope, processInstanceThread, locale, workItemKey.toURIFormat(), null, null);
                activities.add(activity);
            }
        }
        return activities;
    }

    private Variable getVariableValue(Scope scope, String variableName, boolean isPrimitive, boolean isIncludeLargeDocuments) throws CubeException {
        Object value = DataHandlingUtils.getVariableValue(variableName, (IScope)scope, isPrimitive);
        QName type = DataHandlingUtils.getVariableType(variableName, (IScope)scope);
        if (!isIncludeLargeDocuments && this.isLargeDocument(value)) {
            value = null;
        }
        Variable result = Variable.create(variableName, value);
        result.setType(type);
        return result;
    }

    private boolean isLargeDocument(Object value) {
        return value instanceof XMLNode && (long)((XMLNode)value).getDocument().getInfosetReader().getDataLength() >= this.getLargeDocumentThreshold();
    }

    private long getLargeDocumentThreshold() {
        long largeDocumentThreshold = BPMNServiceEngine.getInstance().getBPMNConfig().getLargeDocumentThreshold();
        if (largeDocumentThreshold <= 0L) {
            largeDocumentThreshold = 32768L;
        }
        return largeDocumentThreshold;
    }

    private void _findInnerSubProcesses(ICubeInstanceImpl instance, String absoluteScopeId, Locale locale, Set<Tuple<String, Activity>> subProcesses) throws CubeException {
        for (Tuple<String, Activity> childSubProcess : this.findInnerMostSubProcesses(instance, absoluteScopeId, locale)) {
            subProcesses.add(childSubProcess);
            this._findInnerSubProcesses(instance, (String)childSubProcess.getFirst(), locale, subProcesses);
        }
    }

    private Subprocess findInnerSubprocess(Scope scope) throws CubeException {
        BaseBPMNBlock block = (BaseBPMNBlock)scope.getBlock();
        Subprocess result = null;
        boolean found = false;
        do {
            if (block instanceof BPMNSubProcessBlock) {
                result = (Subprocess)((BPMNSubProcessBlock)block).getFlowElement();
                found = true;
            }
            block = (BaseBPMNBlock)block.getParentBlock();
        } while (!found && block != null);
        return result;
    }

    private List<Scope> getScopesPathToRoot(Scope scope) throws CubeException {
        LinkedList<Scope> nodes = new LinkedList<Scope>();
        do {
            BaseBPMNBlock block;
            if (!((block = (BaseBPMNBlock)scope.getBlock()) instanceof BPMNSubProcessBlock) && !(block instanceof BPMNProcessBlock) && !(block instanceof BPMNCallableProcessBlock)) continue;
            nodes.addFirst(scope);
        } while ((scope = (Scope)scope.getParentScope()) != null && !scope.isRootScope());
        return nodes;
    }

    private HashMap getAndResetWorkItemNodeActivationContext(ICubeInstanceImpl instance, WorkItemKey wiKey, WorkItem workItem) throws CubeException {
        Scope scope = this.getScopeById(instance, workItem.getScopeId());
        String nodeActivationContextKey = InstanceManipulationHelper.getNodeActivationContextKey(wiKey);
        HashMap result = null;
        if (scope.contains(nodeActivationContextKey)) {
            result = (HashMap)scope.getAsObject(nodeActivationContextKey);
            scope.set(nodeActivationContextKey, null);
        }
        return result;
    }

    private int getWorkItemThread(Scope scope, WorkItem wi) throws CubeException, InstanceHandlingException {
        HashMap<String, Object> nodeActivationContext = this.getWorkItemNodeActivationContext(scope, wi);
        return BPMNTokenMetadataUtils.getThreadFromTokenMetadata(nodeActivationContext);
    }

    private HashMap<String, Object> getWorkItemNodeActivationContext(Scope scope, WorkItem wi) throws CubeException, InstanceHandlingException {
        WorkItemKey wiKey = new WorkItemKey(wi.getCikey(), wi.getNodeId(), wi.getScopeId(), wi.getCountId());
        String nodeActivationContextKey = InstanceManipulationHelper.getNodeActivationContextKey(wiKey);
        if (scope.contains(nodeActivationContextKey)) {
            return (HashMap)scope.getAsObject(nodeActivationContextKey);
        }
        throw new InstanceHandlingException("NodeActivationContext not found. WorkItem=" + wi + ", Scope=" + scope);
    }

    private void updateProcessTracking(ICubeInstanceImpl cubeInstance, FlowNode targetElement, HashMap tokenMetadata, IScope scope, ICubeContext context, String processState, String targetCubeElementId, String wiKey) throws Exception {
        BPMNUtility.insertInstance2Track((ICubeInstance)cubeInstance, targetElement, tokenMetadata, scope, context, processState, targetCubeElementId, wiKey);
    }

    private boolean toNewModel(ICubeInstanceImpl instance, CompositeDN targetCompositeDN) {
        ComponentMigrationSupport componentMigrationSupport = BPMNServiceEngine.getInstance().getComponentMigrationSupport();
        return targetCompositeDN != null || componentMigrationSupport.isMigrationPending(instance);
    }

    private boolean moveIfValid(ICubeContext ctx, ProcessInstance processInstance, ICubeInstanceImpl instance, Activity source, Activity target, AlterFlowModel instanceAlterFlowModel, AlterFlowModel deployedAlterFlowModel, boolean cancelChildComponents) throws Exception {
        CallActivity callActivity;
        AlterFlowModel sourceModel = instanceAlterFlowModel != null ? instanceAlterFlowModel : deployedAlterFlowModel;
        AlterFlowModel targetModel = deployedAlterFlowModel;
        String sourceUniqueId = (sourceModel = this.getSourceAlterFlowModel(source, sourceModel, targetModel)).getRuntimeMapper().getRuntimeId(source.getProcessId(), source.getId());
        BPMNCubeElement sourceCubeElement = this.getCubeElement(sourceUniqueId, sourceModel.getRuntimeMapper().getCubeMap());
        Object sourceFlowNode = sourceCubeElement.getFlowElement();
        NodeContainer sourceSubprocess = (NodeContainer)sourceFlowNode.asAnyNode(Subprocess.class);
        if (sourceSubprocess == null && (callActivity = (CallActivity)sourceFlowNode.asAnyNode(CallActivity.class)) != null) {
            sourceSubprocess = callActivity.getCalledElement();
        }
        if (processInstance.getActivityId().equals(source.getId()) || sourceSubprocess != null && sourceSubprocess.findDescendant(FlowNode.class, processInstance.getActivityId()) != null) {
            String targetUniqueId = targetModel.getRuntimeMapper().getRuntimeId(target.getProcessId(), target.getId());
            if (sourceModel.getLevelForActivity(sourceUniqueId).getFlowNode().isGateway()) {
                throw new InvalidFlowTargetException("Source activity cannot be a Gateway", processInstance, source, target);
            }
            if (!sourceModel.hasSameLevel(sourceUniqueId, targetModel, targetUniqueId)) {
                throw new InvalidFlowTargetException(processInstance, source, target);
            }
            HashMap<String, Object> tokenMetadata = null;
            try {
                String wiKeyURI = processInstance.getWorkItemKeyURI();
                String absoluteScopeId = processInstance.getAbsoluteScopeId();
                WorkItemKey wiKey = null;
                if (!Str.isEmpty((String)wiKeyURI)) {
                    wiKey = new WorkItemKey(wiKeyURI);
                    absoluteScopeId = wiKey.getScopeId();
                }
                BPMNCubeElement targetCubeElement = this.getCubeElement(targetUniqueId, targetModel.getRuntimeMapper().getCubeMap());
                if (wiKey != null) {
                    tokenMetadata = this.cancelWorkItem(ctx, instance, wiKey, cancelChildComponents);
                } else if (!Str.isEmpty((String)absoluteScopeId)) {
                    assert (processInstance.getMapElementId() != null) : "Map element id must not be null if absoluteScopeId is provided";
                    Object token = this.removeToken(instance, absoluteScopeId, processInstance.getMapElementId());
                    if (token != null) {
                        tokenMetadata = BPMNTokenMetadataUtils.convertToToken(token);
                    }
                } else {
                    throw new InvalidFlowTargetException("Both absoluteScopeId and WorkItemKey URI are null", processInstance, source, target);
                }
                Scope activeScope = this.getScopeById(instance, absoluteScopeId);
                BPMNCubeMap targetCubeMap = deployedAlterFlowModel.getRuntimeMapper().getCubeMap();
                if (!this.isParentBlock(this.getBlock(activeScope.getBlockId(), targetCubeMap), targetCubeElement)) {
                    Scope targetSiblingScope = this.findSiblingScope(activeScope, targetCubeElement, targetCubeMap);
                    absoluteScopeId = targetSiblingScope.getParentScope().getAbsoluteScopeId();
                    this.cancelScope(instance, targetSiblingScope, ctx, cancelChildComponents);
                }
                if (tokenMetadata == null) {
                    throw new InstanceNotInActivityException(processInstance.getInstanceId(), processInstance.getActivityId(), ProcessInstanceAttribute.TITLE.getValue((IScope)activeScope, ctx).toString(), ((FlowElement)sourceModel.getProcessModel().findDescendant(FlowElement.class, processInstance.getActivityId())).toString());
                }
                this.addToken(instance, absoluteScopeId, targetUniqueId, tokenMetadata);
                FlowNode targetFlowNode = ModelUtils.findFlowNode((Process)targetModel.getProcessModel(), (String)target.getId());
                this.updateProcessTracking(instance, targetFlowNode, tokenMetadata, (IScope)this.getScopeById(instance, absoluteScopeId), ctx, processInstance.getState(), targetUniqueId, wiKeyURI);
                return true;
            }
            catch (com.collaxa.cube.engine.core.ActivityNotFoundException anfe) {
                return false;
            }
        }
        return false;
    }

    private BaseBPMNBlock getBlock(String blockId, BPMNCubeMap map) throws CubeException {
        return (BaseBPMNBlock)map.getBlock(blockId);
    }

    private Scope findSiblingScope(Scope activeScope, BPMNCubeElement targetCubeElement, BPMNCubeMap targetCubeMap) throws CubeException {
        Scope result = null;
        if (!activeScope.isRootScope()) {
            Scope currentScope = activeScope;
            Scope parentScope = (Scope)currentScope.getParentScope();
            boolean isParentBlock = false;
            while (parentScope != null && !(isParentBlock = this.isParentBlock(this.getBlock(parentScope.getBlockId(), targetCubeMap), targetCubeElement))) {
                currentScope = parentScope;
                parentScope = (Scope)currentScope.getParentScope();
            }
            if (isParentBlock) {
                result = currentScope;
            }
        }
        return result;
    }

    private void cancelScope(ICubeInstanceImpl ci, Scope scope, ICubeContext ctx, boolean cancelChildComponents) throws Exception {
        IDaoFactory factory = CubeContextHelper.getDaoFactory((ICubeContext)ctx);
        IScopeContext sc = ci.getScopeContext();
        StringSet scopeIds = sc.getScopeTree((IScopeImpl)scope);
        String[] scopeIdArray = scopeIds.toArray();
        int[] wiStates = new int[]{1, 3, 2, 4};
        List wis = factory.getWorkItemDaoBean().getByCikeyAndScopeIdAndState(ci.getId(), scopeIdArray, wiStates, ctx);
        for (WorkItem wi : wis) {
            this.cancelWorkItem(ctx, ci, new WorkItemKey(wi.getCikey(), wi.getNodeId(), wi.getScopeId(), wi.getCountId()), cancelChildComponents);
        }
        ICubeEngine engine = CubeEngineHolder.getEngine((String)BPMNServiceEngine.getInstance().getEngineType());
        Method forceCancelScopeTree = engine.getClass().getDeclaredMethod("forceCancelScopeTree", ICubeInstanceImpl.class, IScopeImpl.class, Boolean.TYPE, ICubeContext.class);
        forceCancelScopeTree.setAccessible(true);
        forceCancelScopeTree.invoke((Object)engine, ci, scope, true, ctx);
        Method releaseScopeTree = engine.getClass().getDeclaredMethod("releaseScopeTree", ICubeInstanceImpl.class, IScopeImpl.class, Boolean.TYPE, ICubeContext.class);
        releaseScopeTree.setAccessible(true);
        releaseScopeTree.invoke((Object)engine, ci, scope, true, ctx);
    }

    private boolean isParentBlock(BaseBPMNBlock block, BPMNCubeElement targetCubeElement) {
        return block.containsChild(targetCubeElement.getId());
    }

    private AlterFlowModel getSourceAlterFlowModel(Activity source, AlterFlowModel sourceModel, AlterFlowModel targetModel) {
        try {
            sourceModel.getRuntimeMapper().getRuntimeId(source.getProcessId(), source.getId());
        }
        catch (ActivityNotFoundException e) {
            sourceModel = targetModel;
        }
        return sourceModel;
    }

    private HashMap<String, Object> cancelWorkItem(ICubeContext ctx, ICubeInstanceImpl instance, WorkItemKey wiKey, boolean cancelChildComponents) throws Exception {
        IWorkItemDao workItemDao = CubeContextHelper.getServerManager((ICubeContext)ctx).getCubeServiceEngine().getJpaDaoFactory().getWorkItemDaoBean();
        WorkItem workItem = workItemDao.get(wiKey, ctx);
        workItem.setExpDate(new Date(0L));
        int state = 8;
        workItem.setState(8);
        WorkItemLookupTable.getTable((ICubeInstanceImpl)instance).put(wiKey, 8);
        workItemDao.update(workItem, ctx);
        InstanceManipulationHelper.unsubscribeWorkItem(ctx, wiKey, this.buildComponentDN(instance));
        this.addIgnoredWorkItemKey(instance, wiKey);
        try {
            MIUserTaskWithdraw.withdrawUserTaskIfExist(ctx, (IScope)this.getScopeById(instance, wiKey.getScopeId()), wiKey);
        }
        catch (BPMException e) {
            // empty catch block
        }
        return this.getAndResetWorkItemNodeActivationContext(instance, wiKey, workItem);
    }

    private void addIgnoredWorkItemKey(ICubeInstanceImpl instance, WorkItemKey wiKey) throws CubeException {
        Set<WorkItemKey> ignoredWorkItems;
        IScopeImpl scope = instance.getScopeContext().getRootScope();
        if (scope.contains("++ignored_expired_wi")) {
            ignoredWorkItems = (Set)scope.getObject("++ignored_expired_wi");
        } else {
            ignoredWorkItems = new HashSet();
            scope.declareAndSet("++ignored_expired_wi", ignoredWorkItems);
        }
        ignoredWorkItems.add(wiKey);
    }

    private Object removeToken(ICubeInstanceImpl instance, String absoluteScopeId, String mapElementId) throws CubeException {
        IScopeImpl methodScope = this.getMethodScope(instance);
        Object token = methodScope.getToken(absoluteScopeId, mapElementId);
        methodScope.removeToken(absoluteScopeId, mapElementId);
        return token;
    }

    private IScopeImpl getMethodScope(ICubeInstanceImpl instance) {
        return (IScopeImpl)instance.getScopeContext().getRootScope().getChildScopes().next();
    }

    private void addToken(ICubeInstanceImpl instance, String absoluteScopeId, String mapElementId, Map<String, Object> token) throws CubeException {
        this.getMethodScope(instance).addToken(absoluteScopeId, mapElementId, token);
    }

    private Process getProcessModel(ComponentDN componentDN, ComponentModel scaComponent) throws MetadataException {
        CompositeDN compositeDN = new CompositeDN(componentDN.getCompositeDN());
        Project projectForInstance = BPMNServiceEngine.getDeployedProjectServiceImpl().findDeployedProject(compositeDN, scaComponent.getComposite());
        return projectForInstance.findProcess(componentDN.getComponentName());
    }

    private DataDeclarationInfo findDataDeclarationInfo(Scope scope, String variableName) throws CubeException {
        BaseBPMNBlock block;
        DataDeclarationInfo result = null;
        NodeContainer nodeContainer = null;
        boolean isProcessBlock = false;
        if (scope.getBlock() instanceof BPMNSubProcessBlock) {
            block = (BPMNSubProcessBlock)scope.getBlock();
            nodeContainer = (NodeContainer)block.getFlowElement();
        } else if (scope.getBlock() instanceof BPMNProcessBlock) {
            block = (BPMNProcessBlock)scope.getBlock();
            nodeContainer = ((BPMNProcessBlock)block).getModel();
            isProcessBlock = true;
        }
        if (nodeContainer != null) {
            DataDeclaration dataDeclaration = nodeContainer.findLocalDeclaration(DataObject.class, variableName);
            if (isProcessBlock && dataDeclaration == null) {
                dataDeclaration = nodeContainer.getProject().findLocalDeclaration(ProjectDataObject.class, variableName);
            }
            if (dataDeclaration != null) {
                result = new DataDeclarationInfo(scope, dataDeclaration);
            }
        }
        if (result == null && !isProcessBlock && !scope.isRootScope()) {
            result = this.findDataDeclarationInfo((Scope)scope.getParentScope(), variableName);
        }
        return result;
    }

    private EntityUpdate _setVariableValue(ProcessInstance processInstance, ICubeInstanceImpl instance, Variable variable, ICubeContext ctx, boolean useInstanceProcessDeclarations, boolean validate, DataElementType type, @Nullable CompositeDN targetCompositeDN) throws Exception {
        Subprocess innerSubprocess;
        Scope scope = this.getScopeById(instance, this.getAbsoluteScopeId(processInstance));
        String varName = variable.getName();
        String nativeName = variable.getNativeName() != null ? variable.getNativeName() : varName;
        switch (type) {
            case DATA_OBJECT: {
                DataDeclarationInfo dataDeclarationInfo = this.findDataDeclarationInfo(scope, nativeName);
                if (dataDeclarationInfo == null) {
                    throw new VariableNotFoundException(nativeName);
                }
                if (dataDeclarationInfo.scope.contains(nativeName)) break;
                DataHandlingUtils.declareAndSet(dataDeclarationInfo.dataDeclaration, (IScope)dataDeclarationInfo.scope, ctx);
                break;
            }
            case PROCESS_INSTANCE_ATTRIBUTE: {
                IScope processScope = this.getProcessScope(instance);
                if (processScope.contains(nativeName)) break;
                ProcessInstanceAttribute.valueOf(variable.getEnumName()).declareAndSetAutoValue(processScope, ctx);
            }
        }
        EntityUpdate result = new EntityUpdate(varName);
        Process processModel = this.getDeployedBPMNProcess(ctx, instance, targetCompositeDN).getBPMNCubeMap().getProcessModel();
        Object newValue = variable.getExpression() != null ? this.evaluateExpression(processModel, variable.getExpression(), scope, ctx) : variable.getValue();
        Object dataObjectVar = scope.getObject(nativeName);
        Object dataObjectValue = DataHandlingUtils.getVariableValue(dataObjectVar);
        Object oldValue = null;
        if (dataObjectValue != null) {
            XMLDocument xmlOldValue = (XMLDocument)DOMUtil.getDocumentBuilder().parse(new InputSource(new StringReader("<data/>")));
            oldValue = DOMUtil.copyObjHelper((Object)dataObjectValue, (Object)xmlOldValue.getDocumentElement(), (boolean)true, (ICubeContext)ctx);
        }
        Object nodeContainer = (innerSubprocess = this.findInnerSubprocess(scope)) != null ? innerSubprocess : processModel;
        DataHandlingUtils.performCopy((IScope)scope, ctx, (IWorkItem)new WorkItemMock((ICubeInstance)instance), newValue, this.createTargetBPMNExpression((NodeContainer)nodeContainer, scope, varName, type));
        dataObjectValue = DataHandlingUtils.getVariableValue(dataObjectVar);
        if (dataObjectValue == null) {
            dataObjectValue = DataHandlingUtils.getVariableValue(dataObjectVar);
        }
        result.setNewValue(dataObjectValue);
        result.setOldValue(oldValue);
        return result;
    }

    private BPMNExpression createTargetBPMNExpression(NodeContainer process, Scope scope, String dataElementName, DataElementType type) throws URISyntaxException, CubeException {
        HashMap<String, URI> namespaceMapping = new HashMap<String, URI>();
        namespaceMapping.put("bpmn", new URI("http://www.omg.org/bpmn20"));
        String expression = type.getValueExpression(dataElementName);
        StringList dataElements = StringList.create();
        dataElements.add((Object)dataElementName);
        BPMNExpressionMetadata metadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)CollectionUtils.asSequence((Collection)dataElements), expression, BPMNExpressionLanguage.XPATH, namespaceMapping);
        Subprocess innerSubProcess = this.findInnerSubprocess(scope);
        Subprocess scopeNodeContainer = innerSubProcess != null ? innerSubProcess : process;
        return BPMNExpression.createBPMNExpression(ModelUtils.getStartFlowNode((NodeContainer)scopeNodeContainer), metadata, (IScope)scope);
    }

    private Object evaluateExpression(Process process, Expression expression, Scope scope, ICubeContext ctx) throws Exception {
        Iterable<String> dataElements = this.getProcessDataObjects(process, scope);
        BPMNExpressionMetadata bpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)CollectionUtils.asSequence(dataElements), expression.getExpressionValue(), BPMNExpressionLanguage.XPATH, expression.getNamespaces());
        Subprocess innerSubProcess = this.findInnerSubprocess(scope);
        Subprocess scopeNodeContainer = innerSubProcess != null ? innerSubProcess : process;
        BPMNExpression bpmnExpression = BPMNExpression.createBPMNExpression((FlowNode)ModelUtils.getStartEvent((NodeContainer)scopeNodeContainer), bpmnExpressionMetadata, (IScope)scope);
        return bpmnExpression.evaluateObject((IScope)scope, ctx);
    }

    private String getCorrelationKeyNativeName(String name) {
        return "__correlationSet_" + name;
    }

    private Activity createActivity(ICubeInstanceImpl instance, FlowNode activityNode, Scope scope, int thread, Locale locale, String workitemKeyURI, String absoluteScopeId, String mapElementId) throws CubeException {
        List<Scope> scopesToRoot = this.getScopesPathToRoot(scope);
        ActivityPath path = ActivityPath.create(instance, scopesToRoot, locale);
        String displayName = this.getDisplayName((FlowElement)activityNode, locale);
        Activity activity = Activity.create(activityNode.getProcess().getId(), activityNode.getId(), displayName, path);
        activity.setWorkItemKeyURI(workitemKeyURI);
        activity.setAbsoluteScopeId(absoluteScopeId);
        activity.setMapElementId(mapElementId);
        ProcessInstance processInstance = ProcessInstance.createForQuery(instance.getId(), thread);
        ActivityPath.addNode(path, scope.getAbsoluteScopeId(), activity, processInstance);
        return activity;
    }

    private Activity createContainerActivity(ICubeInstanceImpl instance, FlowNode activityNode, Scope scope, Locale locale) throws CubeException {
        List<Scope> scopesToRoot = this.getScopesPathToRoot(scope);
        ActivityPath path = ActivityPath.create(instance, scopesToRoot, locale);
        String displayName = this.getDisplayName((FlowElement)activityNode, locale);
        boolean isEventSubprocess = ModelUtils.isEventSubprocess((FlowNode)activityNode);
        return Activity.createContainer(activityNode.getProcess().getId(), activityNode.getId(), displayName, path, isEventSubprocess);
    }

    private List<WorkItem> findOpenWorkItems(ICubeInstanceImpl cubeInstance, ICubeContext ctx) throws CubeException {
        int[] wiStates = new int[]{1, 2, 3, 5, 13};
        IDaoFactory factory = CubeContextHelper.getDaoFactory((ICubeContext)ctx);
        List wis = factory.getWorkItemDaoBean().getByCikeyAndState(cubeInstance.getId(), wiStates, ctx);
        return wis == null ? Collections.emptyList() : wis;
    }

    private <T extends DataDeclaration> Set<Variable> getVariablesInContext(ICubeInstanceImpl cubeInstance, String absoluteScopeId, Class<T> clazz, boolean isIncludeLargeDocuments) throws CubeException {
        HashSet<Variable> variables = new HashSet<Variable>();
        Scope scope = this.getScopeById(cubeInstance, absoluteScopeId);
        BaseBPMNBlock block = (BaseBPMNBlock)scope.getBlock();
        if (block != null) {
            DataDeclarationContainer container = this.getDataDeclarationContainer(block);
            for (DataDeclaration dataDeclaration : container.getLocalDeclarations(clazz)) {
                String name = dataDeclaration.getName();
                Variable variable = this.getVariableValue(cubeInstance, scope.getAbsoluteScopeId(), name, dataDeclaration.getType().isPredefined(), isIncludeLargeDocuments);
                variables.add(variable);
            }
        }
        return variables;
    }

    private NodeContainer getNodeContainer(BaseBPMNBlock block) {
        Process nodeContainer;
        if (block instanceof BPMNProcessBlock) {
            BPMNProcessBlock processBlock = (BPMNProcessBlock)block;
            nodeContainer = processBlock.getModel();
        } else if (block instanceof BPMNSubProcessBlock) {
            BPMNSubProcessBlock subProcessBlock = (BPMNSubProcessBlock)block;
            nodeContainer = (NodeContainer)subProcessBlock.getFlowElement();
        } else if (block instanceof BPMNCallableProcessBlock) {
            BPMNCallableProcessBlock callableProcessBlock = (BPMNCallableProcessBlock)block;
            nodeContainer = callableProcessBlock.getNodeContainer();
        } else {
            throw new IllegalArgumentException("The block should be a process or subProcess block");
        }
        return nodeContainer;
    }

    private BPMNAuditEvent newUpdateAuditEvent(ICubeContext cubeContext, ICubeInstanceImpl instance, String comment, String activityName) throws InstanceHandlingException {
        BPMNAuditEvent event = null;
        try {
            event = AuditUtil.createNewAuditEvent((ICubeInstance)instance);
            event.setOperation(AuditInstanceOperation.INSTANCE_UPDATED);
            event.setComponentInstanceId(String.valueOf(instance.getKey().getInstanceId()));
            event.setComponentName(instance.getComponentName());
            event.setProcessName(instance.getComponentName());
            event.setAuditInstanceType(AuditInstanceOperation.INSTANCE_UPDATED.getType(false));
            event.setComment(comment);
            event.setActivityId(instance.getComponentName());
            event.setActivityName(activityName != null ? activityName : "PROCESS");
            event.setFlowElementType("PROCESS");
            event.setLabel(AuditInstanceOperation.INSTANCE_UPDATED.name());
            event.setTitle(event.getLabel());
            event.setScopeId(event.getActivityId() + ".0");
            event.setAuditLevel(Long.valueOf(AuditUtil.getAuditLevel(cubeContext)));
        }
        catch (Exception e) {
            throw new InstanceHandlingException(e);
        }
        return event;
    }

    private class DataDeclarationInfo {
        public DataDeclaration dataDeclaration;
        public Scope scope;

        DataDeclarationInfo(Scope scope, DataDeclaration dataDeclaration) {
            this.scope = scope;
            this.dataDeclaration = dataDeclaration;
        }
    }

    private class ActivityPredefinedVariablePredicate
    implements oracle.bpm.collections.Predicate<DataDeclaration> {
        private ActivityPredefinedVariablePredicate() {
        }

        public boolean check(DataDeclaration value) {
            return value.getDeclarationType().equals((Object)DataDeclarationType.ACTIVITY_PREDEFINED_VARIABLE);
        }
    }

    private static final class ProcessInfoRetriever {
        private ICubeInstanceImpl cubeInstance;
        private BPMNCubeMap cubeMap;
        private InstanceManipulationHelper helper;
        private Process processModel;

        private ProcessInfoRetriever(InstanceManipulationHelper helper, ICubeInstanceImpl cubeInstance) {
            this.helper = helper;
            this.cubeInstance = cubeInstance;
        }

        public static ProcessInfoRetriever create(InstanceManipulationHelper helper, ICubeInstanceImpl cubeInstance) {
            return new ProcessInfoRetriever(helper, cubeInstance);
        }

        public Process getProcessDefinition() throws InstanceHandlingException {
            if (this.processModel == null) {
                this.processModel = this.helper.getProcessModelForInstance(this.cubeInstance);
            }
            return this.processModel;
        }

        public ICubeInstanceImpl getCubeInstance() {
            return this.cubeInstance;
        }

        public BPMNCubeMap getCubeMap() throws InstanceHandlingException, CubeException {
            if (this.cubeMap == null) {
                this.cubeMap = BPMNCubeMapFactory.create(this.getProcessDefinition());
            }
            return this.cubeMap;
        }

        public FlowNode findInstanceFlowNode(String elementId) throws InstanceHandlingException, CubeException {
            Process processModelForInstance = this.getProcessDefinition();
            return this.helper.getCubeElement(elementId, this.getCubeMap()).getFlowElement();
        }
    }

    public static class EntityUpdate {
        private String name;
        private Object newValue;
        private Object oldValue;

        public EntityUpdate(String name) {
            this.name = name;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public void setOldValue(Object oldValue) {
            this.oldValue = oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public void setNewValue(Object newValue) {
            this.newValue = newValue;
        }

        public String toString() {
            return "oldValue->" + this.getStringValue(this.getOldValue()) + ",newValue->" + this.getStringValue(this.getNewValue());
        }

        public String getName() {
            return this.name;
        }

        private String getStringValue(Object value) {
            String result = value == null ? "" : (value instanceof Node ? DOMUtil.toXML((Node)((Node)value)) : value.toString());
            return result;
        }
    }

    public static class CorrelationKeyUpdate {
        private String name;
        private List<EntityUpdate> properties = new ArrayList<EntityUpdate>();
        private boolean reset;

        CorrelationKeyUpdate(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<EntityUpdate> getProperties() {
            return this.properties;
        }

        public void setProperties(List<EntityUpdate> properties) {
            this.properties = properties;
        }

        public void addProperty(EntityUpdate property) {
            this.getProperties().add(property);
        }

        public boolean isReset() {
            return this.reset;
        }

        public void setReset(boolean reset) {
            this.reset = reset;
        }

        public String toString() {
            return "CorrelationKeyUpdate{name='" + this.name + '\'' + ", properties=" + this.properties + ", reset=" + this.reset + '}';
        }
    }

    static interface ScriptedInstanceManipulationHelper {
        public ResultInfo migrate(ICubeContext var1, ProcessInstance var2, ICubeInstanceImpl var3, String var4);
    }
}

