/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.Scope;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CorrelationKey;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceAttributeInfo;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceContextNode;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceHandlingException;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceManipulationHelper;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceVariableContainer;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Variable;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttribute;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Tuple;
import oracle.bpm.services.instancemanagement.model.IInstanceContextConfiguration;
import oracle.bpm.services.instancemanagement.model.impl.alterflow.LocationInfo;

public class InstanceContextNodeHelper {
    public static void populateNodeInformation(InstanceContextNode node, String absoluteScopeId, ICubeInstanceImpl instance, Locale locale, IInstanceContextConfiguration configuration) throws CubeException, InstanceHandlingException {
        InstanceVariableContainer container = node.getContainer();
        if (configuration.includeProjectDataObjects().booleanValue() && InstanceContextNodeHelper.isProcessScope(instance, absoluteScopeId)) {
            InstanceContextNodeHelper.populateProjectDataObjects(container.getDataObjects(), instance, absoluteScopeId, configuration.includeLargeDocuments());
        }
        if (configuration.includeProcessDataObjects().booleanValue()) {
            InstanceContextNodeHelper.populateProcessDataObjects(container.getDataObjects(), instance, absoluteScopeId, configuration.includeLargeDocuments());
        }
        if (configuration.includeCorrelationKeys().booleanValue()) {
            InstanceContextNodeHelper.populateCorrelationsKeys(container.getCorrelationKeys(), instance, absoluteScopeId);
        }
        if (configuration.includeProcessInstanceAttributes().booleanValue() && InstanceContextNodeHelper.isProcessScope(instance, absoluteScopeId)) {
            InstanceContextNodeHelper.populateProcessInstanceAttributes(container.getInstanceAttributes(), instance, absoluteScopeId);
        }
        if (configuration.includeOpenActivityContainers().booleanValue() && !configuration.includeChildren().booleanValue()) {
            InstanceContextNodeHelper.populateContainerActivities(node.getContainerActivities(), instance, absoluteScopeId, locale, configuration.includeActivityInstanceAttributes());
        }
    }

    public static void populateOpenContainerActivities(Collection<Activity> activities, ICubeInstanceImpl instance, String absoluteScopeId, Locale locale, Boolean includeActivityInstanceAttributes) throws CubeException {
        Set<Tuple<String, Activity>> childrenScopes = InstanceContextNodeHelper.getInstanceManipulationHelper().findInnerSubProcesses(instance, absoluteScopeId, locale);
        InstanceContextNodeHelper._populateContainerActivities(activities, instance, includeActivityInstanceAttributes, childrenScopes, true);
    }

    public static void populateContainerActivities(Collection<Activity> activities, ICubeInstanceImpl instance, String absoluteScopeId, Locale locale, Boolean includeActivityInstanceAttributes) throws CubeException {
        Set<Tuple<String, Activity>> childrenScopes = InstanceContextNodeHelper.getInstanceManipulationHelper().findInnerMostSubProcesses(instance, absoluteScopeId, locale);
        InstanceContextNodeHelper._populateContainerActivities(activities, instance, includeActivityInstanceAttributes, childrenScopes, false);
    }

    public static void populateProcessInstanceAttributes(Set<Variable> processInstanceAttributes, ICubeInstanceImpl instance, String absoluteScopeId) throws CubeException, InstanceHandlingException {
        InstanceContextNodeHelper.fillProcessInstanceAttributes(instance, InstanceContextNodeHelper.getInstanceManipulationHelper(), processInstanceAttributes, absoluteScopeId);
    }

    public static void populateCorrelationsKeys(Set<CorrelationKey> correlationKeys, ICubeInstanceImpl instance, String absoluteScopeId) throws CubeException, InstanceHandlingException {
        for (String correlationKey : InstanceContextNodeHelper.getInstanceManipulationHelper().getCorrelationKeysForScope(instance, absoluteScopeId)) {
            CorrelationKey value = InstanceContextNodeHelper.getInstanceManipulationHelper().getCorrelationKey(instance, absoluteScopeId, correlationKey);
            correlationKeys.add(value);
        }
    }

    public static void populateProjectDataObjects(Set<Variable> dataObjects, ICubeInstanceImpl instance, String absoluteScopeId, boolean isIncludeLargeDocuments) throws CubeException {
        Set<Variable> processVariables = InstanceContextNodeHelper.getInstanceManipulationHelper().getProjectVariables(instance, absoluteScopeId, isIncludeLargeDocuments);
        dataObjects.addAll(processVariables);
    }

    public static boolean isProcessScope(ICubeInstanceImpl instance, String absoluteScopeId) {
        String processScopeId = InstanceContextNodeHelper.getInstanceManipulationHelper().getProcessScope(instance).getAbsoluteScopeId();
        return absoluteScopeId.equals(processScopeId);
    }

    public static void populateProcessDataObjects(Set<Variable> dataObjects, ICubeInstanceImpl instance, String absoluteScopeId, boolean isIncludeLargeDocuments) throws CubeException {
        Set<Variable> processVariables = InstanceContextNodeHelper.getInstanceManipulationHelper().getProcessVariablesInContext(instance, absoluteScopeId, isIncludeLargeDocuments);
        dataObjects.addAll(processVariables);
    }

    public static Iterable<InstanceAttributeInfo> getInstanceAttributes() throws InstanceHandlingException {
        return ProcessInstanceAttribute.getAll().map((Function)new Function<ProcessInstanceAttribute, InstanceAttributeInfo>(){

            public InstanceAttributeInfo eval(ProcessInstanceAttribute value) {
                String variableName = InstanceAttributeType.getVariableName(InstanceAttributeType.PROCESS_INSTANCE_ATTRIBUTE, "", value.getAttrName());
                boolean isEditable = ProcessInstanceAttribute.getWritableProcessInstanceAttributes().contains((Object)value);
                return InstanceAttributeInfo.create(value.name(), value.getAttrName(), variableName, isEditable);
            }
        });
    }

    public static void fillProcessInstanceAttributes(ICubeInstanceImpl instance, InstanceManipulationHelper instanceManipulationHelper, Set<Variable> instanceAttributes, String absoluteScopeId) throws InstanceHandlingException, CubeException {
        Scope scope = instanceManipulationHelper.getScopeById(instance, absoluteScopeId);
        for (InstanceAttributeInfo instanceAttributeInfo : InstanceContextNodeHelper.getInstanceAttributes()) {
            String attributeName = instanceAttributeInfo.getAttributeName();
            String enumName = instanceAttributeInfo.getEnumName();
            Variable value = null;
            try {
                value = Variable.create(attributeName, ProcessInstanceAttribute.valueOf(enumName).getValue((IScope)scope, null));
            }
            catch (NumberFormatException ne) {
                value = Variable.create(attributeName, null);
            }
            value.setEditable(instanceAttributeInfo.isEditable());
            instanceAttributes.add(value);
        }
    }

    public static InstanceManipulationHelper getInstanceManipulationHelper() {
        return InstanceManipulationHelper.getInstance();
    }

    public static String getRealAbsoluteScopeId(ICubeInstanceImpl instance, String absoluteScopeId) {
        if (LocationInfo.isRoot((String)absoluteScopeId)) {
            absoluteScopeId = InstanceContextNodeHelper.getInstanceManipulationHelper().getProcessScope(instance).getAbsoluteScopeId();
        }
        return absoluteScopeId;
    }

    private static void _populateContainerActivities(Collection<Activity> activities, ICubeInstanceImpl instance, Boolean includeActivityInstanceAttributes, Set<Tuple<String, Activity>> childrenScopes, Boolean isforOpenActivities) throws CubeException {
        for (Tuple<String, Activity> childScopeInfo : childrenScopes) {
            Activity childActivity = (Activity)childScopeInfo.getSecond();
            String childAbsoluteScopeId = (String)childScopeInfo.getFirst();
            if (isforOpenActivities.booleanValue() && childActivity.isEventSubProcess().booleanValue()) continue;
            if (includeActivityInstanceAttributes.booleanValue()) {
                Set<Variable> predefinedAttributes = InstanceContextNodeHelper.getInstanceManipulationHelper().getActivityPredefinedAttributes(instance, childAbsoluteScopeId);
                childActivity.setAttributes(predefinedAttributes);
            }
            activities.add(childActivity);
        }
    }
}

