/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CorrelationKey;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceVariableContainer;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Variable;

public class InstanceContextNode
implements Serializable {
    private String absoluteScopeId;
    private Activity activity;
    private Set<InstanceContextNode> children;
    private Set<Activity> containerActivities;
    private ProcessInstance instance;
    private InstanceVariableContainer instanceVariableContainer;
    private Boolean isProcessContext;
    private InstanceContextNode parent;
    private static final long serialVersionUID = 6465955672897500725L;

    private InstanceContextNode(String absoluteScopeId, ProcessInstance nodeInstance, Activity nodeActivity, Boolean isProcessContext) {
        this.absoluteScopeId = absoluteScopeId;
        this.instance = nodeInstance;
        this.activity = nodeActivity;
        this.isProcessContext = isProcessContext;
        this.initCollections();
    }

    public static InstanceContextNode create(String absoluteScopeId, ProcessInstance nodeInstance, Activity nodeActivity, Boolean isProcessContext) {
        return new InstanceContextNode(absoluteScopeId, nodeInstance, nodeActivity, isProcessContext);
    }

    public InstanceContextNode getParent() {
        return this.parent;
    }

    public Collection<InstanceContextNode> getChildren() {
        return this.children;
    }

    public Collection<Activity> getContainerActivities() {
        return this.containerActivities;
    }

    public InstanceVariableContainer getContainer() {
        return this.instanceVariableContainer;
    }

    public String getAbsoluteScopeId() {
        return this.absoluteScopeId;
    }

    public ProcessInstance getProcessInstance() {
        return this.instance;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public void addChild(InstanceContextNode child) {
        this.children.add(child);
    }

    public void addContainerActivity(Activity containerActivity) {
        this.getContainerActivities().add(containerActivity);
    }

    public void setAbsoluteScopeId(String absoluteScopeId) {
        this.absoluteScopeId = absoluteScopeId;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public void setParent(InstanceContextNode parent) {
        this.parent = parent;
    }

    public Boolean isProcessContext() {
        return this.isProcessContext;
    }

    private void initCollections() {
        HashSet<Variable> dataObjects = new HashSet<Variable>();
        HashSet<Variable> instanceAttributes = new HashSet<Variable>();
        HashSet<CorrelationKey> correlationKeys = new HashSet<CorrelationKey>();
        this.instanceVariableContainer = InstanceVariableContainer.create(dataObjects, instanceAttributes, correlationKeys);
        this.children = new HashSet<InstanceContextNode>();
        this.containerActivities = new HashSet<Activity>();
    }
}

