/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ActivityMetaData;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.core.map.ICubeMap;
import com.collaxa.cube.engine.core.map.ICubeNode;
import com.collaxa.cube.engine.core.map.NodeNotFoundException;
import com.collaxa.cube.engine.data.DeliveryPersistenceMgr;
import com.collaxa.cube.engine.delivery.SubscriptionInfo;
import com.collaxa.cube.engine.deployment.DeploymentHelper;
import com.collaxa.cube.engine.types.bpel.CXPartnerLink;
import com.collaxa.cube.persistence.dao.IDeliverySubscriptionDao;
import com.collaxa.cube.persistence.dto.CubeInstanceVO;
import com.collaxa.cube.persistence.dto.DeliverySubscription;
import com.collaxa.cube.persistence.dto.WorkItem;
import com.collaxa.cube.persistence.dto.WorkItemKey;
import com.oracle.bpel.client.CorrelationId;
import com.oracle.bpel.client.util.BeanCache;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMap;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapFactory;
import oracle.bpm.bpmn.engine.map.builder.ServiceLink;
import oracle.bpm.bpmn.engine.model.BPMNProcess;
import oracle.bpm.bpmn.engine.model.blocks.BPMNProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.BPMNSubProcessBlock;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ActivityNotFoundException;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.AlterFlowModel;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentInstanceMigrationAction;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentInstanceMigrationContext;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.FlowNodeToRuntimeModelMapperImpl;
import oracle.bpm.bpmn.engine.model.runtime.util.BpmnEngineMsg;
import oracle.bpm.bpmn.engine.model.runtime.util.ConversationUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.CubeModelUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.DeployerClientLogger;
import oracle.bpm.bpmn.engine.model.runtime.util.Utils;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.Draftable;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.ParticipantEnabled;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.process.notification.NotificationParticipantReference;
import oracle.bpm.resources.Msg;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.fabric.composite.model.PropertyModel;
import oracle.soa.management.ComponentDN;
import oracle.soa.management.CompositeDN;
import oracle.soa.management.util.ComponentInstanceFilter;
import org.jetbrains.annotations.Nullable;

public class ComponentMigrationSupport {
    private BPMNServiceEngine bpmnServiceEngine;
    private List<ComponentMigrationListener> componentMigrationListeners;
    private final Object componentMigrationListenersLock = new Object();
    private static Logger logger = Logger.getAnonymousLogger();

    public ComponentMigrationSupport(BPMNServiceEngine bpmnServiceEngine) {
        this.bpmnServiceEngine = bpmnServiceEngine;
        this.componentMigrationListeners = new ArrayList<ComponentMigrationListener>();
        this.addComponentMigrationListener(new ComponentMigrationListener(){

            @Override
            public void componentInstancesPendingMigration(ICubeContext ctx, oracle.fabric.composite.CompositeDN compositeDN, String componentName) {
                ComponentMigrationSupport.getLogger().info("@@@ componentInstancesPendingMigration for componentDN " + ComponentMigrationSupport.toComponentDN(compositeDN, componentName));
            }

            @Override
            public void componentInstanceMigrated(ICubeContext ctx, oracle.fabric.composite.CompositeDN compositeDN, String componentName, long instanceId) {
                ComponentMigrationSupport.getLogger().info("@@@ componentInstanceMigrated componentDN " + ComponentMigrationSupport.toComponentDN(compositeDN, componentName) + " instanceId " + instanceId);
            }
        });
    }

    public static String toComponentDN(oracle.fabric.composite.CompositeDN compositeDN, String componentName) {
        return compositeDN.getDN() + "/" + componentName;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static Logger getClientLogger() {
        return DeployerClientLogger.getLogger();
    }

    public static boolean isComponentSuspended(ComponentModel component) {
        boolean isComponentSuspended = false;
        PropertyModel property = component.getProperty("bpel.config.suspend");
        if (property != null) {
            isComponentSuspended = Boolean.valueOf(property.getValue());
        }
        return isComponentSuspended;
    }

    public static Sequence<FlowNode> getAllFlowNodes(Process process) {
        return process.getChildrenByType(FlowNode.class).select(ModelUtils.ACTIVTY_LIKE_FLOWNODE_FILTER).flatten(ModelUtils.ONLY_SUB_PROCESS_TRAVERSAL);
    }

    public static BPMNProcess lookupBpmnProcess(ICubeContext cubeContext, String compositeDn, String componentName) throws CubeException {
        return (BPMNProcess)DeploymentHelper.lookupProcess((ComponentDN)new ComponentDN(compositeDn, componentName), (ICubeContext)cubeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponentMigrationListener(ComponentMigrationListener componentMigrationListener) {
        Object object = this.componentMigrationListenersLock;
        synchronized (object) {
            this.componentMigrationListeners.add(componentMigrationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponentMigrationListener(ComponentMigrationListener componentMigrationListener) {
        Object object = this.componentMigrationListenersLock;
        synchronized (object) {
            this.componentMigrationListeners.remove(componentMigrationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyComponentInstancesPendingMigration(ICubeContext ctx, oracle.fabric.composite.CompositeDN componentDN, String componentName) throws Exception {
        Object object = this.componentMigrationListenersLock;
        synchronized (object) {
            for (ComponentMigrationListener componentMigrationListener : this.componentMigrationListeners) {
                componentMigrationListener.componentInstancesPendingMigration(ctx, componentDN, componentName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyComponentInstanceMigrated(ICubeContext ctx, oracle.fabric.composite.CompositeDN componentDN, String componentName, long instanceId) throws Exception {
        Object object = this.componentMigrationListenersLock;
        synchronized (object) {
            for (ComponentMigrationListener componentMigrationListener : this.componentMigrationListeners) {
                componentMigrationListener.componentInstanceMigrated(ctx, componentDN, componentName, instanceId);
            }
        }
    }

    public BPMNServiceEngine getBpmnServiceEngine() {
        return this.bpmnServiceEngine;
    }

    public String getCompositeRevisionDN(String compositeDN) {
        oracle.fabric.composite.CompositeDN actualDN = new oracle.fabric.composite.CompositeDN(compositeDN);
        return new oracle.fabric.composite.CompositeDN(actualDN.getApplicationName(), actualDN.getCompositeName(), actualDN.getRevision(), "").getStringDN();
    }

    public Project findProject(CompositeModel composite, oracle.fabric.composite.CompositeDN compositeDN) throws MetadataException {
        return this.__findProject(composite, compositeDN);
    }

    public boolean isMigrationPending(ICubeInstanceImpl instance) {
        String compositeLabel = instance.getComponentDN().getLabel();
        String instanceCompositeLabel = instance.getCubeInstanceEO().getCompositeLabel();
        return !instanceCompositeLabel.equals(compositeLabel);
    }

    public void suspendComponent(ComponentDN componentDN) throws Exception {
        logger.info("suspend component " + componentDN.toString());
        BPMNServiceEngine.getInstance().suspendComponent(componentDN);
    }

    public void resumeComponent(ComponentDN componentDN) throws Exception {
        logger.info("resume component " + componentDN.toString());
        BPMNServiceEngine.getInstance().resumeComponent(componentDN);
    }

    public Iterable<CubeInstanceVO> getUnsuspendedMigrationPendingInstances(ICubeContext context, CompositeDN compositeDN, String componentName, final String label) throws CubeException {
        return CollectionUtils.select(this.listCubeInstancesByStates(context, compositeDN, componentName), (Predicate)new Predicate<CubeInstanceVO>(){

            public boolean check(@Nullable CubeInstanceVO value) {
                return ComponentMigrationSupport.this.isInstancePendingMigration(value, label);
            }
        });
    }

    public Iterable<CubeInstanceVO> getMigrationPendingInstances(ICubeContext context, CompositeDN compositeDN, String componentName, final String label) throws CubeException {
        return CollectionUtils.select(this.listCubeInstances(context, compositeDN, componentName), (Predicate)new Predicate<CubeInstanceVO>(){

            public boolean check(@Nullable CubeInstanceVO value) {
                return ComponentMigrationSupport.this.isInstancePendingMigration(value, label);
            }
        });
    }

    public CompositeModel findCompositeRevision(String applicationName, String compositeName, String revision) {
        CompositeModel result = null;
        for (CompositeModel runningModel : this.bpmnServiceEngine.getMesh().listComposites()) {
            oracle.fabric.composite.CompositeDN runningCompositeDN = new oracle.fabric.composite.CompositeDN(runningModel.getDN());
            if (!runningCompositeDN.getApplicationName().equals(applicationName) || !runningCompositeDN.getCompositeName().equals(compositeName) || !runningCompositeDN.getRevision().equals(revision)) continue;
            result = runningModel;
            break;
        }
        return result;
    }

    public CompositeModel findCompositeRevision(oracle.fabric.composite.CompositeDN compositeDN) {
        return this.findCompositeRevision(compositeDN.getApplicationName(), compositeDN.getCompositeName(), compositeDN.getRevision());
    }

    public CompositeModel findCompositeRevision(CompositeDN compositeDN) {
        return this.findCompositeRevision(compositeDN.getDomainName(), compositeDN.getCompositeName(), compositeDN.getRevision());
    }

    public CompositeModel findRelatedComposite(oracle.fabric.composite.CompositeDN compositeDN) {
        CompositeModel result = null;
        for (CompositeModel runningModel : this.bpmnServiceEngine.getMesh().listComposites()) {
            oracle.fabric.composite.CompositeDN runningCompositeDN = new oracle.fabric.composite.CompositeDN(runningModel.getDN());
            if (!runningCompositeDN.getApplicationName().equals(compositeDN.getApplicationName()) || !runningCompositeDN.getCompositeName().equals(compositeDN.getCompositeName()) || !runningCompositeDN.getRevision().equals(compositeDN.getRevision()) || runningCompositeDN.getLabel().equals(compositeDN.getLabel())) continue;
            result = runningModel;
            break;
        }
        return result;
    }

    protected CompositeModel findComposite(oracle.fabric.composite.CompositeDN compositeDN) {
        CompositeModel result = null;
        for (CompositeModel runningModel : this.bpmnServiceEngine.getMesh().listComposites()) {
            oracle.fabric.composite.CompositeDN runningCompositeDN = new oracle.fabric.composite.CompositeDN(runningModel.getDN());
            if (!runningCompositeDN.getApplicationName().equals(compositeDN.getApplicationName()) || !runningCompositeDN.getCompositeName().equals(compositeDN.getCompositeName()) || !runningCompositeDN.getRevision().equals(compositeDN.getRevision()) || !runningCompositeDN.getLabel().equals(compositeDN.getLabel())) continue;
            result = runningModel;
            break;
        }
        return result;
    }

    private List<CubeInstanceVO> listCubeInstancesByStates(ICubeContext context, CompositeDN compositeDN, String componentName) throws CubeException {
        ComponentInstanceFilter filter = this.createComponentInstanceFiler(compositeDN, componentName);
        filter.setStates(new int[]{1, 3});
        return this.listCubeInstances(context, filter);
    }

    private List<CubeInstanceVO> listCubeInstances(ICubeContext context, CompositeDN compositeDN, String componentName) throws CubeException {
        ComponentInstanceFilter filter = this.createComponentInstanceFiler(compositeDN, componentName);
        return this.listCubeInstances(context, filter);
    }

    private ComponentInstanceFilter createComponentInstanceFiler(CompositeDN compositeDN, String componentName) {
        ComponentInstanceFilter filter = new ComponentInstanceFilter();
        filter.setCompositeDN(compositeDN.getStringDN());
        filter.setComponentName(componentName);
        return filter;
    }

    private List<CubeInstanceVO> listCubeInstances(ICubeContext context, ComponentInstanceFilter filter) throws CubeException {
        return CubeContextHelper.getServerManager((ICubeContext)context).getCubeServiceEngine().getJpaDaoFactory().getCubeInstanceDaoBean().getInstances(filter, CubeContextHelper.getEngineType((ICubeContext)context));
    }

    private boolean isInstancePendingMigration(CubeInstanceVO instanceVO, String label) {
        return !instanceVO.getCompositeLabel().equals(label);
    }

    private Project __findProject(CompositeModel composite, oracle.fabric.composite.CompositeDN compositeDN) throws MetadataException {
        return BPMNServiceEngine.getDeployedProjectServiceImpl().findProject(compositeDN, composite);
    }

    static {
        logger.setLevel(Level.SEVERE);
        MyConsoleHandler consoleHandler = new MyConsoleHandler();
        consoleHandler.setFormatter(new MySimpleFormatter());
        logger.addHandler(consoleHandler);
        consoleHandler.setLevel(Level.SEVERE);
    }

    private static class MySimpleFormatter
    extends SimpleFormatter {
        private MySimpleFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            return "[" + record.getLevel() + "]: " + record.getMessage() + "\n";
        }
    }

    private static class MyConsoleHandler
    extends ConsoleHandler {
        private MyConsoleHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            super.publish(record);
        }
    }

    static class SubProcessDataObjectsSynchronizer
    extends MSynchronizer<DataObject> {
        SubProcessDataObjectsSynchronizer(ProcessInstanceSynchronizerImpl processInstanceSynchronizer) {
            super(processInstanceSynchronizer);
        }

        @Override
        public void synchronize(ComponentInstanceMigrationContext context, ICubeInstanceImpl cubeInstance) throws Exception {
            super.synchronize(context, cubeInstance);
            IScopeImpl scope = cubeInstance.getScopeContext().getRootScope();
            this.visitScope(context, cubeInstance, scope);
        }

        public Sequence<Diff<DataObject>> getAddedDataObjects() {
            return CollectionUtils.select(this.getDataObjectDiffs(), (Predicate)new Predicate<Diff<DataObject>>(){

                public boolean check(@Nullable Diff<DataObject> value) {
                    return value != null && value.type.equals((Object)DiffType.ADD);
                }
            });
        }

        protected List<Diff<DataObject>> getDataObjectDiffs() {
            return ((ProcessInstanceSynchronizerImpl)this.processInstanceSynchronizer).processDiff.subprocessDataObjectDiffs;
        }

        @Override
        boolean isMigrationCompatible() {
            return true;
        }

        @Override
        boolean isMigrationRecoverable() {
            return true;
        }

        private void visitScope(ComponentInstanceMigrationContext context, ICubeInstanceImpl cubeInstance, IScopeImpl scope) throws CubeException {
            String pBlockId = scope.getBlockId();
            this.logger.info("pBlockId: " + pBlockId);
            if (pBlockId != null) {
                ICubeProcess cs = cubeInstance.getProcessClass();
                ICubeMap map = cs.lookupMapFromElement(pBlockId);
                ICubeBlock block = map.getBlock(pBlockId);
                this.logger.info("block: " + block);
                if (block instanceof BPMNSubProcessBlock) {
                    BPMNSubProcessBlock subProcessBlock = (BPMNSubProcessBlock)block;
                    String subProcessId = ((Subprocess)subProcessBlock.getFlowElement()).getId();
                    this.logger.info("bpmn: " + subProcessId);
                    List<SubProcessDataObjectDiff> subprocessDataObjectDiffs = ((ProcessInstanceSynchronizerImpl)this.processInstanceSynchronizer).processDiff.dataObjectDiffsBySubprocess.get(subProcessId);
                    if (subprocessDataObjectDiffs != null) {
                        for (int i = 0; i < subprocessDataObjectDiffs.size(); ++i) {
                            SubProcessDataObjectDiff dataObjectDiff = subprocessDataObjectDiffs.get(i);
                            if (dataObjectDiff.type.equals((Object)DiffType.ADD)) {
                                Subprocess subProcess = (Subprocess)this.processInstanceSynchronizer.targetProcess.findActivity(subProcessId);
                                DataDeclaration dataObject = subProcess.findLocalDeclaration(dataObjectDiff.name);
                                this.logger.info("sync adding subprocess dataobject " + dataObject.getName());
                                if (!scope.contains(dataObject.getName())) {
                                    DataHandlingUtils.declareAndSet(dataObject, (IScope)scope, context.getCubeContext());
                                    this.logger.info("process dataobject " + dataObject.getName() + " added.");
                                    continue;
                                }
                                this.logger.info("process dataobject " + dataObject.getName() + " already defined.");
                                continue;
                            }
                            if (!dataObjectDiff.type.equals((Object)DiffType.DELETE)) continue;
                            scope.removeLocalVariant(dataObjectDiff.name, true);
                            this.logger.info("sync removing subprocess dataobject " + dataObjectDiff.name);
                        }
                    }
                }
            }
            Iterator scopesIterator = scope.getChildScopes();
            while (scopesIterator.hasNext()) {
                IScopeImpl innerScope = (IScopeImpl)scopesIterator.next();
                this.visitScope(context, cubeInstance, innerScope);
            }
        }
    }

    static class SubProcessDataObjectsDiffer
    extends Differ<DataObject> {
        SubProcessDataObjectsDiffer(Process oldProcess, Process newProcess) {
            super(oldProcess, newProcess, new DataObjectComparator(), new SubProcessDataObjectDiffFactory());
        }

        @Override
        void populateDiffs(List<Diff<DataObject>> result) {
            this._populateDiffs(result, (NodeContainer)this.oldProcess, (NodeContainer)this.newProcess);
        }

        private void _populateDiffs(List<Diff<DataObject>> dataObjectDiffs, NodeContainer oldNodeContainer, NodeContainer newNodeContainer) {
            if (oldNodeContainer == null || newNodeContainer == null) {
                return;
            }
            if (oldNodeContainer instanceof Subprocess) {
                DataObjectDiffSupport dataObjectDiffSupport = new DataObjectDiffSupport();
                dataObjectDiffSupport.calculate(dataObjectDiffs, oldNodeContainer.getLocalDeclarations(DataObject.class), newNodeContainer.getLocalDeclarations(DataObject.class), this.comparator, this.diffFactory);
            }
            Sequence activities = oldNodeContainer.getActivities(Subprocess.class);
            for (Subprocess oldSubprocess : activities) {
                Subprocess newSubprocess = (Subprocess)newNodeContainer.findActivity(oldSubprocess.getId());
                this._populateDiffs(dataObjectDiffs, (NodeContainer)oldSubprocess, (NodeContainer)newSubprocess);
            }
        }
    }

    static class SubProcessDataObjectDiffFactory
    extends DiffFactory<DataObject> {
        SubProcessDataObjectDiffFactory() {
        }

        @Override
        Diff<DataObject> createAddDiff(DiffType type, DataObject newValue) {
            return this.createDiff(type, newValue.getDeclarationContainer().getId(), newValue.getName(), null, newValue);
        }

        @Override
        Diff<DataObject> createDeleteDiff(DiffType type, DataObject oldValue) {
            return this.createDiff(type, oldValue.getDeclarationContainer().getId(), oldValue.getName(), oldValue, null);
        }

        @Override
        Diff<DataObject> createUpdateDiff(DiffType type, DataObject oldValue, DataObject newValue) {
            return this.createDiff(type, oldValue.getDeclarationContainer().getId(), oldValue.getName(), oldValue, newValue);
        }

        private Diff<DataObject> createDiff(DiffType type, String subprocess, String name, DataObject oldValue, DataObject newValue) {
            return new SubProcessDataObjectDiff(type, subprocess, name, oldValue, newValue);
        }
    }

    static class SubProcessDataObjectDiff
    extends DataObjectDiff {
        private String subprocessId;

        SubProcessDataObjectDiff(DiffType type, String subprocessId, String name, DataObject sourceDataObject, DataObject targetDataObject) {
            super(type, name, sourceDataObject, targetDataObject);
            this.subprocessId = subprocessId;
        }

        @Override
        public String toString() {
            return "SubProcessDataObjectDiff{type='" + (Object)((Object)this.type) + '\'' + "subprocessId='" + this.subprocessId + '\'' + ", name='" + this.name + '\'' + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SubProcessDataObjectDiff that = (SubProcessDataObjectDiff)o;
            return !(this.subprocessId != null ? !this.subprocessId.equals(that.subprocessId) : that.subprocessId != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.subprocessId != null ? this.subprocessId.hashCode() : 0);
            return result;
        }

        @Override
        protected void buildMsg() {
            switch (this.type) {
                case DELETE: {
                    this.msg = BpmnEngineMsg.SUBPROCESSDATAOBJECT_DIFF_DELETE(SubProcessDataObjectDiff.getSubprocessLabel(this.sourceDataObject), this.sourceDataObject.getDefaultLabel());
                    break;
                }
                case UPDATE: {
                    this.msg = BpmnEngineMsg.SUBPROCESSDATAOBJECT_DIFF_UPDATE(SubProcessDataObjectDiff.getSubprocessLabel(this.sourceDataObject), this.sourceDataObject.getDefaultLabel());
                    break;
                }
                case ADD: {
                    this.msg = BpmnEngineMsg.SUBPROCESSDATAOBJECT_DIFF_ADD(SubProcessDataObjectDiff.getSubprocessLabel(this.targetDataObject), this.targetDataObject.getDefaultLabel());
                }
            }
        }

        private static String getSubprocessLabel(DataObject dataObject) {
            String result = "";
            DataDeclarationContainer declarationContainer = dataObject.getDeclarationContainer();
            if (declarationContainer != null && declarationContainer instanceof Subprocess) {
                result = ((Subprocess)dataObject.getDeclarationContainer()).getDefaultLabel();
            }
            return result;
        }
    }

    static class ServiceLinksSynchronizer
    extends MSynchronizer<String> {
        ServiceLinksSynchronizer(ProcessInstanceSynchronizerImpl processInstanceSynchronizer) {
            super(processInstanceSynchronizer);
        }

        @Override
        void synchronize(ComponentInstanceMigrationContext context, ICubeInstanceImpl cubeInstance) throws Exception {
            super.synchronize(context, cubeInstance);
            this.logger.info("synchronizing service links...");
            IScopeImpl processBlockScope = (IScopeImpl)cubeInstance.getScopeContext().getRootScope().getChildScopes().next();
            ICubeProcess cs = cubeInstance.getProcessClass();
            ICubeMap map = cs.lookupMapFromElement(processBlockScope.getBlockId());
            BPMNProcessBlock bpmnProcessBlock = (BPMNProcessBlock)map.getBlock(processBlockScope.getBlockId());
            List<Diff<String>> serviceLinkDiffs = ((ProcessInstanceSynchronizerImpl)this.processInstanceSynchronizer).processDiff.serviceLinkDiffs;
            for (Diff<String> serviceLinkDiff : serviceLinkDiffs) {
                Tuple<String, String> serviceLinkTuple = serviceLinkDiff.getValue();
                String serviceLinkName = (String)serviceLinkTuple.getFirst();
                this.logger.info("processing service link: " + serviceLinkName);
                switch (serviceLinkDiff.type) {
                    case ADD: {
                        ServiceLink serviceLink = ConversationUtils.getServiceLinkDeclaration(this.processInstanceSynchronizer.targetCubeMap.getComponentModel(), serviceLinkName, false);
                        this.logger.info("declaring service link: " + serviceLinkName);
                        CXPartnerLink cxPartnerLink = new CXPartnerLink();
                        cxPartnerLink.setName(serviceLinkName);
                        if (serviceLink.isReference()) {
                            cxPartnerLink.getMyRole().setPortType(serviceLink.getCallbackInterfacePortType());
                            cxPartnerLink.getPartnerRole().setPortType(serviceLink.getInterfacePortType());
                        } else {
                            cxPartnerLink.getMyRole().setPortType(serviceLink.getInterfacePortType());
                            cxPartnerLink.getPartnerRole().setPortType(serviceLink.getCallbackInterfacePortType());
                        }
                        processBlockScope.declareAndSet(cxPartnerLink.getName(), (Object)cxPartnerLink);
                        break;
                    }
                    case DELETE: {
                        this.logger.info("removing service link: " + serviceLinkName);
                        processBlockScope.removeLocalVariant(serviceLinkName, true);
                    }
                }
            }
            this.logger.info("service links synchronized.");
        }

        @Override
        boolean isMigrationCompatible() {
            return true;
        }

        @Override
        boolean isMigrationRecoverable() {
            return true;
        }
    }

    static class ServiceLinksDiffSupport
    extends DiffSupport<String> {
        ServiceLinksDiffSupport() {
        }
    }

    static class ServiceLinksDiffer
    extends Differ<String> {
        public ServiceLinksDiffer(Process oldProcess, Process newProcess) {
            super(oldProcess, newProcess, new ServiceLinkComparator(), new ServiceLinkDiffFactory());
        }

        @Override
        void populateDiffs(List<Diff<String>> diffs) {
            ServiceLinksDiffSupport serviceLinksDiffSupport = new ServiceLinksDiffSupport();
            serviceLinksDiffSupport.calculate(diffs, this.findServiceLinks(this.oldProcess), this.findServiceLinks(this.newProcess), this.comparator, this.diffFactory);
        }

        private Sequence<String> findServiceLinks(Process process) {
            HashMap<String, String> serviceLinks = new HashMap<String, String>();
            Sequence<FlowNode> nodes = ComponentMigrationSupport.getAllFlowNodes(process);
            for (FlowNode flowNode : nodes) {
                if (flowNode.isDraftable() && ((Draftable)flowNode.asAnyNode(Draftable.class)).isDraft()) continue;
                String serviceLinkName = null;
                if (flowNode instanceof ParticipantEnabled) {
                    serviceLinkName = ((ParticipantEnabled)flowNode).getParticipantRef().getId();
                }
                if (serviceLinkName == null && flowNode.getBpmnType() == BpmnType.NOTIFICATION_TASK) {
                    NotificationTask notificationTask = (NotificationTask)flowNode.asAnyNode(NotificationTask.class);
                    serviceLinkName = new NotificationParticipantReference((Activity)notificationTask).getId();
                }
                if (serviceLinkName == null) continue;
                serviceLinks.put(serviceLinkName, serviceLinkName);
            }
            return CollectionUtils.asSequence(serviceLinks.values());
        }
    }

    static class ServiceLinkDiffFactory
    extends DiffFactory<String> {
        ServiceLinkDiffFactory() {
        }

        @Override
        Diff<String> createAddDiff(DiffType type, String newValue) {
            return this.createDiff(type, newValue);
        }

        @Override
        Diff<String> createDeleteDiff(DiffType type, String oldValue) {
            return this.createDiff(type, oldValue);
        }

        @Override
        Diff<String> createUpdateDiff(DiffType type, String oldValue, String newValue) {
            return null;
        }

        private Diff<String> createDiff(DiffType type, String value) {
            return new ServiceLinkDiff(type, value);
        }
    }

    static class ServiceLinkDiff
    extends Diff<String> {
        String serviceLink;

        public ServiceLinkDiff(DiffType diffType, String serviceLink) {
            super(diffType);
            this.serviceLink = serviceLink;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceLinkDiff that = (ServiceLinkDiff)o;
            return !(this.serviceLink != null ? !this.serviceLink.equals(that.serviceLink) : that.serviceLink != null);
        }

        public int hashCode() {
            return this.serviceLink != null ? this.serviceLink.hashCode() : 0;
        }

        @Override
        public String toString() {
            return "ServiceLinkDiff{type='" + (Object)((Object)this.type) + '\'' + "serviceLink='" + this.serviceLink + '\'' + '}';
        }

        @Override
        protected Msg getMsg() {
            return null;
        }

        @Override
        protected Tuple<String, String> getValue() {
            return Tuple.create((Object)this.serviceLink, (Object)this.serviceLink);
        }
    }

    static class ServiceLinkComparator
    implements Comparator<String> {
        ServiceLinkComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }

    static class ProjectDataObjectsSynchronizer
    extends BaseDataObjectsSynchronizer {
        ProjectDataObjectsSynchronizer(ProcessInstanceSynchronizerImpl processInstanceSynchronizer) {
            super(processInstanceSynchronizer);
        }

        @Override
        protected List<Diff<DataObject>> getDataObjectDiffs() {
            return ((ProcessInstanceSynchronizerImpl)this.processInstanceSynchronizer).processDiff.projectDataObjectDiffs;
        }
    }

    static class ProjectDataObjectsDiffer
    extends BaseDataObjectsDiffer {
        ProjectDataObjectsDiffer(Process oldProcess, Process newProcess) {
            super(oldProcess, newProcess);
        }

        @Override
        protected Sequence<DataObject> getDataObjects(NodeContainer nodeContainer) {
            return nodeContainer.getProject().getLocalDeclarations(DataObject.class);
        }
    }

    static class ProcessDiff {
        List<Diff<FlowNode>> activityDiffs;
        Map<String, List<SubProcessDataObjectDiff>> dataObjectDiffsBySubprocess;
        List<Diff<DataObject>> processDataObjectDiffs;
        List<Diff<DataObject>> projectDataObjectDiffs;
        List<Diff<String>> serviceLinkDiffs;
        List<Diff<DataObject>> subprocessDataObjectDiffs;

        public ProcessDiff(List<Diff<FlowNode>> activityDiffs, List<Diff<DataObject>> processDataObjectDiffs, List<Diff<DataObject>> subprocessDataObjectDiffs, List<Diff<DataObject>> projectDataObjectDiffs, List<Diff<String>> serviceLinkDiffs) {
            this.activityDiffs = activityDiffs;
            this.processDataObjectDiffs = processDataObjectDiffs;
            this.subprocessDataObjectDiffs = subprocessDataObjectDiffs;
            this.projectDataObjectDiffs = projectDataObjectDiffs;
            this.serviceLinkDiffs = serviceLinkDiffs;
            this.load();
        }

        private void load() {
            this.dataObjectDiffsBySubprocess = new HashMap<String, List<SubProcessDataObjectDiff>>();
            for (int i = 0; i < this.subprocessDataObjectDiffs.size(); ++i) {
                SubProcessDataObjectDiff subProcessDataObjectDiff = (SubProcessDataObjectDiff)this.subprocessDataObjectDiffs.get(i);
                List<SubProcessDataObjectDiff> dataObjectDiffsForSubprocess = this.dataObjectDiffsBySubprocess.get(subProcessDataObjectDiff.subprocessId);
                if (dataObjectDiffsForSubprocess == null) {
                    dataObjectDiffsForSubprocess = new ArrayList<SubProcessDataObjectDiff>();
                    this.dataObjectDiffsBySubprocess.put(subProcessDataObjectDiff.subprocessId, dataObjectDiffsForSubprocess);
                }
                dataObjectDiffsForSubprocess.add(subProcessDataObjectDiff);
            }
        }
    }

    static class ProcessDataObjectsSynchronizer
    extends BaseDataObjectsSynchronizer {
        ProcessDataObjectsSynchronizer(ProcessInstanceSynchronizerImpl processInstanceSynchronizer) {
            super(processInstanceSynchronizer);
        }

        @Override
        protected List<Diff<DataObject>> getDataObjectDiffs() {
            return ((ProcessInstanceSynchronizerImpl)this.processInstanceSynchronizer).processDiff.processDataObjectDiffs;
        }
    }

    static class DiffSupport<S> {
        protected Logger logger = ComponentMigrationSupport.getLogger();

        DiffSupport() {
        }

        void calculate(List<Diff<S>> diffs, Sequence<S> sequenceOld, Sequence<S> sequenceNew, Comparator<S> comparator, DiffFactory<S> diffFactory) {
            Object dataObject;
            this.logger.finest("sequenceOld: " + sequenceOld);
            this.logger.finest("sequenceNew: " + sequenceNew);
            List oldList = CollectionUtils.sort(sequenceOld, comparator);
            List newList = CollectionUtils.sort(sequenceNew, comparator);
            this.logger.finest("oldList: " + oldList);
            this.logger.finest("newList: " + newList);
            int oldIndex = 0;
            int newIndex = 0;
            while (oldIndex < oldList.size() && newIndex < newList.size()) {
                this.logger.finest("oldIndex: " + oldIndex);
                this.logger.finest("newIndex: " + newIndex);
                Object oldObject = oldList.get(oldIndex);
                Object newObject = newList.get(newIndex);
                int compare = comparator.compare(oldObject, newObject);
                if (compare < 0) {
                    this.logger.finest("DELETE: " + oldIndex);
                    diffs.add(diffFactory.createDeleteDiff(DiffType.DELETE, oldObject));
                    ++oldIndex;
                    continue;
                }
                if (compare == 0) {
                    Diff<S> updateDiff = diffFactory.createUpdateDiff(DiffType.UPDATE, oldObject, newObject);
                    if (updateDiff != null) {
                        diffs.add(updateDiff);
                    }
                    this.logger.finest("UPDATE: " + oldIndex);
                    ++oldIndex;
                    ++newIndex;
                    continue;
                }
                this.logger.finest("ADD: " + newIndex);
                diffs.add(diffFactory.createAddDiff(DiffType.ADD, newObject));
                ++newIndex;
            }
            while (oldIndex < oldList.size()) {
                dataObject = oldList.get(oldIndex);
                diffs.add(diffFactory.createDeleteDiff(DiffType.DELETE, dataObject));
                ++oldIndex;
            }
            while (newIndex < newList.size()) {
                dataObject = newList.get(newIndex);
                diffs.add(diffFactory.createAddDiff(DiffType.ADD, dataObject));
                ++newIndex;
            }
            this.logger.finest("diffs: " + diffs);
        }
    }

    static class DataObjectsDiffer
    extends BaseDataObjectsDiffer {
        DataObjectsDiffer(Process oldProcess, Process newProcess) {
            super(oldProcess, newProcess);
        }

        @Override
        protected Sequence<DataObject> getDataObjects(NodeContainer nodeContainer) {
            return nodeContainer.getLocalDeclarations(DataObject.class);
        }
    }

    static class DataObjectDiffSupport
    extends DiffSupport<DataObject> {
        DataObjectDiffSupport() {
        }
    }

    static class DataObjectDiffFactory
    extends DiffFactory<DataObject> {
        DataObjectDiffFactory() {
        }

        @Override
        Diff<DataObject> createAddDiff(DiffType type, DataObject newValue) {
            return this.createDiff(type, newValue.getName(), null, newValue);
        }

        @Override
        Diff<DataObject> createDeleteDiff(DiffType type, DataObject oldValue) {
            return this.createDiff(type, oldValue.getName(), oldValue, null);
        }

        @Override
        Diff<DataObject> createUpdateDiff(DiffType type, DataObject oldValue, DataObject newValue) {
            return this.createDiff(type, oldValue.getName(), oldValue, newValue);
        }

        private Diff<DataObject> createDiff(DiffType type, String name, @Nullable DataObject oldValue, @Nullable DataObject newValue) {
            return new DataObjectDiff(type, name, oldValue, newValue);
        }
    }

    static class DataObjectDiff
    extends Diff<DataObject> {
        protected Msg msg;
        protected String name;
        protected DataObject sourceDataObject;
        protected DataObject targetDataObject;

        DataObjectDiff(DiffType type, String name, DataObject sourceDataObject, DataObject targetDataObject) {
            super(type);
            this.name = name;
            this.sourceDataObject = sourceDataObject;
            this.targetDataObject = targetDataObject;
            this.buildMsg();
        }

        @Override
        public String toString() {
            return "DataObjectDiff{type='" + (Object)((Object)this.type) + '\'' + ", name='" + this.name + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataObjectDiff that = (DataObjectDiff)o;
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        protected void buildMsg() {
            switch (this.type) {
                case DELETE: {
                    this.msg = BpmnEngineMsg.DATAOBJECT_DIFF_DELETE(this.sourceDataObject.getDefaultLabel());
                    break;
                }
                case UPDATE: {
                    this.msg = BpmnEngineMsg.DATAOBJECT_DIFF_UPDATE(this.sourceDataObject.getDefaultLabel());
                    break;
                }
                case ADD: {
                    this.msg = BpmnEngineMsg.DATAOBJECT_DIFF_ADD(this.targetDataObject.getDefaultLabel());
                }
            }
        }

        @Override
        protected Msg getMsg() {
            return this.msg;
        }

        @Override
        protected Tuple<DataObject, DataObject> getValue() {
            return Tuple.create((Object)this.sourceDataObject, (Object)this.targetDataObject);
        }
    }

    static class DataObjectComparator
    implements Comparator<DataObject> {
        DataObjectComparator() {
        }

        @Override
        public int compare(DataObject o1, DataObject o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    static class ActivityDiffSupport
    extends DiffSupport<FlowNode> {
        ActivityDiffSupport() {
        }
    }

    static class ActivityDiffFactory
    extends DiffFactory<FlowNode> {
        private AlterFlowModel sourceAlterFlowModel;
        private AlterFlowModel targetAlterFlowModel;

        ActivityDiffFactory(AlterFlowModel sourceAlterFlowModel, AlterFlowModel targetAlterFlowModel) {
            this.sourceAlterFlowModel = sourceAlterFlowModel;
            this.targetAlterFlowModel = targetAlterFlowModel;
        }

        @Override
        Diff<FlowNode> createAddDiff(DiffType type, FlowNode newValue) {
            ActivityDiff activityDiff = this.createDiff(type, DiffLevel.COMPATIBLE, newValue.getId(), null, newValue);
            if (newValue.getBpmnType() == BpmnType.BOUNDARY_EVENT) {
                BoundaryEvent boundaryEvent = (BoundaryEvent)newValue.asAnyNode(BoundaryEvent.class);
                activityDiff.addActivityDiffItem(ActivityDiffItemType.ADDED_BOUNDARY_EVENT, BpmnEngineMsg.ACTIVITYDIFFITEM_ADDED_BOUNDARY_EVENT(newValue.getDefaultLabel(), boundaryEvent.getBoundaryActivity().getDefaultLabel()));
            } else if (ModelUtils.isEventSubprocess((FlowNode)newValue)) {
                activityDiff.addActivityDiffItem(ActivityDiffItemType.ADDED_EVENT_SUBPROCESS, BpmnEngineMsg.ACTIVITYDIFFITEM_ADDED_EVENT_SUBPROCESS(newValue.getDefaultLabel()));
            } else if (ModelUtils.isCallActivity((FlowNode)newValue)) {
                activityDiff.addActivityDiffItem(ActivityDiffItemType.ADDED_CALL_ACTIVITY, BpmnEngineMsg.ACTIVITYDIFFITEM_ADDED_CALL_ACTIVITY(newValue.getDefaultLabel()));
            }
            return activityDiff;
        }

        @Override
        Diff<FlowNode> createDeleteDiff(DiffType type, FlowNode oldValue) {
            ActivityDiff activityDiff = this.createDiff(type, DiffLevel.INCOMPATIBLE, oldValue.getId(), oldValue, null);
            if (oldValue.isGateway()) {
                Gateway gateway = (Gateway)oldValue.asAnyNode(Gateway.class);
                if (gateway.getBpmnType() != BpmnType.EXCLUSIVE_GATEWAY) {
                    activityDiff.addActivityDiffItem(ActivityDiffItemType.REMOVED_NON_EXCLUSIVE_GATEWAY, BpmnEngineMsg.ACTIVITYDIFFITEM_REMOVED_NON_EXCLUSIVE_GATEWAY(gateway.getDefaultLabel()));
                }
            } else if (ModelUtils.isSubprocess((FlowNode)oldValue)) {
                activityDiff.addActivityDiffItem(ActivityDiffItemType.REMOVED_SUBPROCESS, BpmnEngineMsg.ACTIVITYDIFFITEM_REMOVED_SUBPROCESS(oldValue.getDefaultLabel()));
            }
            return activityDiff;
        }

        @Override
        Diff<FlowNode> createUpdateDiff(DiffType type, FlowNode oldValue, FlowNode newValue) {
            ActivityDiff activityDiff = this.createDiff(type, DiffLevel.IDENTICAL, oldValue.getId(), oldValue, newValue);
            ActivityDiff result = null;
            if (oldValue.isDraftable() && ((Draftable)oldValue.asAnyNode(Draftable.class)).isDraft() && newValue.isDraftable() && ((Draftable)newValue.asAnyNode(Draftable.class)).isDraft()) {
                return result;
            }
            if (oldValue.getBpmnType() != newValue.getBpmnType()) {
                activityDiff.addActivityDiffItem(ActivityDiffItemType.UPDATED_BPMN_TYPE, BpmnEngineMsg.ACTIVITYDIFFITEM_UPDATED_BPMN_TYPE(oldValue.getDefaultLabel(), oldValue.getBpmnType(), newValue.getBpmnType()));
            } else {
                Subprocess newSubprocess;
                Subprocess oldSubprocess;
                if (newValue.isActivity()) {
                    UserTask newUserTask;
                    UserTask oldUserTask;
                    Activity oldActivity = (Activity)oldValue.asAnyNode(Activity.class);
                    Activity newActivity = (Activity)newValue.asAnyNode(Activity.class);
                    if (oldActivity.isUserTask() && newActivity.isUserTask() && this.isUserTaskChangeIncompatibleUnrecoverable(oldUserTask = (UserTask)oldActivity.asActivity(UserTask.class), newUserTask = (UserTask)newActivity.asActivity(UserTask.class))) {
                        activityDiff.addActivityDiffItem(ActivityDiffItemType.UPDATED_HUMAN_TASK_IMPLEMENTATION, BpmnEngineMsg.ACTIVITYDIFFITEM_UPDATED_HUMAN_TASK_IMPLEMENTATION(oldActivity.getDefaultLabel()));
                    }
                }
                if (ModelUtils.isEventSubprocess((FlowNode)newValue)) {
                    oldSubprocess = (Subprocess)oldValue.asAnyNode(Subprocess.class);
                    if (this.isEventSubprocessChangeIncompatibleUnrecoverable(oldSubprocess, newSubprocess = (Subprocess)newValue.asAnyNode(Subprocess.class))) {
                        activityDiff.addActivityDiffItem(ActivityDiffItemType.UPDATED_EVENT_SUBPROCESS_INTERRUPTING_FLAG, BpmnEngineMsg.ACTIVITYDIFFITEM_UPDATED_EVENT_SUBPROCESS_INTERRUPTING_FLAG(oldSubprocess.getDefaultLabel()));
                    }
                } else if (ModelUtils.isSubprocess((FlowNode)newValue)) {
                    oldSubprocess = (Subprocess)oldValue.asAnyNode(Subprocess.class);
                    if (this.isSubprocessChangeIncompatibleUnrecoverable(oldSubprocess, newSubprocess = (Subprocess)newValue.asAnyNode(Subprocess.class))) {
                        activityDiff.addActivityDiffItem(ActivityDiffItemType.UPDATED_SUBPROCESS_LOOP_CHARACTERISTICS, BpmnEngineMsg.ACTIVITYDIFFITEM_UPDATED_SUBPROCESS_LOOP_CHARACTERISTICS(oldSubprocess.getDefaultLabel(), oldSubprocess.getLoopCharacteristicsType(), newSubprocess.getLoopCharacteristicsType()));
                    }
                } else if (ModelUtils.isBoundaryEvent((FlowNode)newValue)) {
                    BoundaryEvent newBoundaryEvent;
                    BoundaryEvent oldBoundaryEvent = (BoundaryEvent)oldValue.asAnyNode(BoundaryEvent.class);
                    if (this.isBoundaryEventChangeIncompatibleUnrecoverable(oldBoundaryEvent, newBoundaryEvent = (BoundaryEvent)newValue.asAnyNode(BoundaryEvent.class))) {
                        activityDiff.addActivityDiffItem(ActivityDiffItemType.UPDATED_BOUNDARY_EVENT_INTERRUPTING_FLAG, BpmnEngineMsg.ACTIVITYDIFFITEM_UPDATED_BOUNDARY_EVENT_INTERRUPTING_FLAG(oldBoundaryEvent.getDefaultLabel(), oldBoundaryEvent.getBoundaryActivity().getDefaultLabel(), oldBoundaryEvent.cancelActivity(), newBoundaryEvent.cancelActivity()));
                    }
                } else if (ModelUtils.isCallActivity((FlowNode)newValue)) {
                    activityDiff.addActivityDiffItem(ActivityDiffItemType.UPDATED_CALL_ACTIVITY, BpmnEngineMsg.ACTIVITYDIFFITEM_UPDATED_CALL_ACTIVITY(oldValue.getDefaultLabel()));
                } else if (newValue.isGateway() && newValue.getBpmnType() != BpmnType.EXCLUSIVE_GATEWAY) {
                    Gateway oldGateway = (Gateway)oldValue.asAnyNode(Gateway.class);
                    Gateway newGateway = (Gateway)newValue.asAnyNode(Gateway.class);
                    if ((oldGateway.getDirection() == GatewayDirection.DIVERGING || oldGateway.getDirection() == GatewayDirection.MIXED) && oldGateway.getOutgoingSequenceFlows().toArray().length != newGateway.getOutgoingSequenceFlows().toArray().length) {
                        activityDiff.addActivityDiffItem(ActivityDiffItemType.UPDATED_GATEWAY_FLOWS, BpmnEngineMsg.ACTIVITYDIFFITEM_UPDATED_GATEWAY_FLOWS(oldGateway.getDefaultLabel()));
                    }
                }
                if (this.isFlowNodeLevelChange(oldValue, newValue)) {
                    activityDiff.addActivityDiffItem(ActivityDiffItemType.UPDATED_ACTIVITY_LEVEL, BpmnEngineMsg.ACTIVITYDIFFITEM_UPDATED_ACTIVITY_LEVEL(oldValue.getDefaultLabel()));
                }
            }
            if (activityDiff.getLevel() != DiffLevel.IDENTICAL) {
                result = activityDiff;
            }
            return result;
        }

        private boolean stringDiffers(String oldValue, String newValue) {
            return oldValue == null || !oldValue.equals(newValue);
        }

        private boolean isUserTaskChangeIncompatibleUnrecoverable(UserTask oldUserTask, UserTask newUserTask) {
            HumanTask oldHumanTask = oldUserTask.getHumanTask();
            HumanTask newHumanTask = newUserTask.getHumanTask();
            return this.stringDiffers(oldHumanTask.getId(), newHumanTask.getId()) || this.stringDiffers(oldHumanTask.getHumanTaskNativeName(), newHumanTask.getHumanTaskNativeName()) || this.stringDiffers(oldHumanTask.getTargetNamespace(), newHumanTask.getTargetNamespace());
        }

        private boolean isSubprocessChangeIncompatibleUnrecoverable(Subprocess oldSubprocess, Subprocess newSubprocess) {
            return oldSubprocess.getLoopCharacteristicsType() != newSubprocess.getLoopCharacteristicsType();
        }

        private boolean isBoundaryEventChangeIncompatibleUnrecoverable(BoundaryEvent oldBoundaryEvent, BoundaryEvent newBoundaryEvent) {
            return oldBoundaryEvent.cancelActivity() != newBoundaryEvent.cancelActivity();
        }

        private boolean isEventSubprocessChangeIncompatibleUnrecoverable(Subprocess oldSubprocess, Subprocess newSubprocess) {
            StartEvent oldStartEvent = ModelUtils.getStartEvent((NodeContainer)oldSubprocess);
            StartEvent newStartEvent = ModelUtils.getStartEvent((NodeContainer)newSubprocess);
            return oldStartEvent.isInterrupting() != newStartEvent.isInterrupting();
        }

        private boolean isFlowNodeLevelChange(FlowNode oldValue, FlowNode newValue) {
            try {
                List<FlowElement> oldFlowNodeLevelStack = this.sourceAlterFlowModel.getActivityLevelList(oldValue.getId());
                List<FlowElement> newFlowNodeLevelStack = this.targetAlterFlowModel.getActivityLevelList(newValue.getId());
                return !AlterFlowModel.compareStack(oldFlowNodeLevelStack, newFlowNodeLevelStack);
            }
            catch (ActivityNotFoundException e) {
                return false;
            }
        }

        private ActivityDiff createDiff(DiffType type, DiffLevel level, String activityId, FlowNode sourceActivity, FlowNode targetActivity) {
            return new ActivityDiff(type, level, activityId, sourceActivity, targetActivity);
        }
    }

    static class ActivityComparator
    implements Comparator<FlowNode> {
        ActivityComparator() {
        }

        @Override
        public int compare(FlowNode o1, FlowNode o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }

    static class ActivitiesSynchronizer
    extends MSynchronizer<FlowNode> {
        public ActivitiesSynchronizer(ProcessInstanceSynchronizerImpl processInstanceSynchronizer) {
            super(processInstanceSynchronizer);
        }

        @Override
        public void synchronize(ComponentInstanceMigrationContext context, ICubeInstanceImpl cubeInstance) throws Exception {
            super.synchronize(context, cubeInstance);
            this.synchronize(context, cubeInstance, false);
        }

        @Override
        void verify(ComponentInstanceMigrationContext context, ICubeInstanceImpl cubeInstance) throws Exception {
            super.verify(context, cubeInstance);
            this.synchronize(context, cubeInstance, true);
        }

        @Override
        boolean isMigrationCompatible() {
            return this.getIncompatibleDiffs().isEmpty();
        }

        @Override
        boolean isMigrationRecoverable() {
            return this.getUnrecoverableDiffs().isEmpty();
        }

        private void synchronize(ComponentInstanceMigrationContext context, ICubeInstanceImpl cubeInstance, boolean verifyMode) throws Exception {
            this.logger.info("synchronizing activities...");
            List workItems = BeanCache.getInstanceManagerLocalBean((String)CubeContextHelper.getEngineType((ICubeContext)context.getCubeContext())).getActivities(cubeInstance.getId());
            this.logger.info("workitems processing...");
            for (WorkItem workItem : workItems) {
                this.logger.info("workItem: " + workItem);
                this.logger.info("state: " + workItem.getState());
                String nodeId = workItem.getNodeId();
                this.logger.info("NodeId: " + nodeId);
                if (ActivityMetaData.isOpen((int)workItem.getState())) {
                    MIBPMNActivityNode node = (MIBPMNActivityNode)this.processInstanceSynchronizer.sourceCubeMap.getNode(nodeId);
                    this.logger.info("node: " + node);
                    try {
                        ICubeNode nodeInTargetCubeMap = this.processInstanceSynchronizer.targetCubeMap.getNode(nodeId);
                        this.logger.info("node: " + nodeInTargetCubeMap);
                        if (verifyMode) continue;
                        this.migrateSubscriptionId(context.getCubeContext(), node, workItem);
                        continue;
                    }
                    catch (NodeNotFoundException e) {
                        this.logger.severe("Node " + node.getFlowElement().getName() + "[" + node.getFlowElement().getBpmnType() + "] does not exist in new process cube map");
                        this.logger.severe("instanceId: " + workItem.getCikey());
                        this.logger.severe("nodeId: " + workItem.getNodeId());
                        this.logger.severe("scopeId: " + workItem.getScopeId());
                        this.logger.severe("countId: " + workItem.getCountId());
                        this.logger.severe("WorkItemKey: " + new WorkItemKey(workItem.getCikey(), workItem.getNodeId(), workItem.getScopeId(), workItem.getCountId()).toURIFormat());
                        throw new ComponentInstanceMigrationAction.MigrateComponentInstanceException(BpmnEngineMsg.MIGRATIONERROR_FLOWELEMENTNOTFOUND(node.getFlowElement().getDefaultLabel()).getString(), BpmnEngineMsg.MIGRATIONSOLUTION_FLOWELEMENTNOTFOUND(node.getFlowElement().getDefaultLabel()).getString());
                    }
                }
                this.logger.info("ignore workItem " + workItem + " since it is neither open-active or open-faulted.");
            }
            this.logger.info("workitems synchronized...");
            this.logger.info("tokens processing...");
            IScopeImpl rootScope = cubeInstance.getScopeContext().getRootScope();
            if (!rootScope.getChildScopes().hasNext()) {
                throw new RuntimeException("Only valid for running instances");
            }
            IScopeImpl next = (IScopeImpl)rootScope.getChildScopes().next();
            IScopeImpl methodScope = next.getMethodScope();
            Object val = methodScope.getLocalVariant("++tokens").getObjectVal();
            this.logger.info("tokens processed.");
            this.logger.info("activities synchronized.");
        }

        private void migrateSubscriptionId(ICubeContext cubeContext, MIBPMNActivityNode node, WorkItem workItem) throws Exception {
            this.logger.info(">>>>>>>>Running subscription id script");
            if (CubeModelUtils.isReceiveActivity(node)) {
                DeliverySubscription newDlvSubscription;
                oracle.fabric.composite.CompositeDN sourceCompositeDN = this.processInstanceSynchronizer.sourceCompositeDn;
                oracle.fabric.composite.CompositeDN targetCompositeDN = this.processInstanceSynchronizer.targetCompositeDn;
                String componentName = this.processInstanceSynchronizer.componentName;
                WorkItemKey wiKey = new WorkItemKey(workItem.getCikey(), workItem.getNodeId(), workItem.getScopeId(), workItem.getCountId());
                CorrelationId oldCorrelationId = new CorrelationId(new ComponentDN(sourceCompositeDN.getDN(), componentName), wiKey.toURIFormat());
                this.logger.info("oldCorrelationId->" + oldCorrelationId.toString());
                CorrelationId newCorrelationId = new CorrelationId(new ComponentDN(targetCompositeDN.getDN(), componentName), wiKey.toURIFormat());
                this.logger.info("newCorrelationId->" + newCorrelationId.toString());
                SubscriptionInfo info = DeliveryPersistenceMgr.getSubscription((String)oldCorrelationId.toString(), (ICubeContext)cubeContext);
                this.logger.info("Got subscription info->" + info);
                DeliverySubscription oldDlvSubscription = info.getDeliverySubscriptionEO();
                SubscriptionInfo newInfo = DeliveryPersistenceMgr.getSubscription((String)newCorrelationId.toString(), (ICubeContext)cubeContext);
                if (newInfo != null) {
                    newDlvSubscription = newInfo.getDeliverySubscriptionEO();
                } else {
                    newDlvSubscription = new DeliverySubscription();
                    newDlvSubscription.setNew(true);
                }
                this.copyDeliverySubscription(oldDlvSubscription, newDlvSubscription);
                newDlvSubscription.setSubscriberId(newCorrelationId.toString());
                oldDlvSubscription.setState(3);
                IDeliverySubscriptionDao daoBean = CubeContextHelper.getDaoFactory((ICubeContext)cubeContext).getDeliverySubscriptionDaoBean();
                this.logger.info("About to stale subscription info");
                daoBean.update(oldDlvSubscription, cubeContext);
                this.logger.info("subscription info marked as stale!!!!");
                this.logger.info("Creating new subscription");
                if (newDlvSubscription.isNew()) {
                    daoBean.insert(newDlvSubscription, cubeContext);
                } else {
                    daoBean.update(newDlvSubscription, cubeContext);
                }
                this.logger.info("New subscription created!!!");
            }
        }

        private void copyDeliverySubscription(DeliverySubscription oldDeliverySubscription, DeliverySubscription newDeliverySubscription) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, NoSuchFieldException {
            LinkedList<String> excludedMethodsToCopyList = new LinkedList<String>();
            excludedMethodsToCopyList.add("getSubscriberId");
            excludedMethodsToCopyList.add("getDecodedProps");
            Utils.copyObject(oldDeliverySubscription, newDeliverySubscription, excludedMethodsToCopyList);
            Utils.copyField(oldDeliverySubscription, newDeliverySubscription, "cacheVersion");
        }

        private Sequence<Diff<FlowNode>> getIncompatibleDiffs() {
            return this.getThresholdedDiffs(DiffLevel.INCOMPATIBLE);
        }

        private Sequence<Diff<FlowNode>> getUnrecoverableDiffs() {
            return this.getThresholdedDiffs(DiffLevel.INCOMPATIBLE_UNRECOVERABLE);
        }

        private Sequence<Diff<FlowNode>> getThresholdedDiffs(final DiffLevel diffLevelThreshold) {
            Sequence filteredDiffSequence = CollectionUtils.select(((ProcessInstanceSynchronizerImpl)this.processInstanceSynchronizer).processDiff.activityDiffs, (Predicate)new Predicate<Diff<FlowNode>>(){

                public boolean check(@Nullable Diff<FlowNode> value) {
                    return value != null && diffLevelThreshold.compareTo(value.getLevel()) <= 0;
                }
            });
            return filteredDiffSequence;
        }

        private Sequence<Diff<FlowNode>> getActivitiesInConflictSequence() {
            return this.getIncompatibleDiffs();
        }
    }

    static abstract class MSynchronizer<T> {
        protected Logger logger = ComponentMigrationSupport.getLogger();
        protected ProcessInstanceSynchronizerImpl processInstanceSynchronizer;

        protected MSynchronizer(ProcessInstanceSynchronizerImpl processInstanceSynchronizer) {
            this.processInstanceSynchronizer = processInstanceSynchronizer;
        }

        abstract boolean isMigrationCompatible();

        abstract boolean isMigrationRecoverable();

        void synchronize(ComponentInstanceMigrationContext context, ICubeInstanceImpl cubeInstance) throws Exception {
            this.logger.info("synchronizing " + cubeInstance + "...");
        }

        void verify(ComponentInstanceMigrationContext context, ICubeInstanceImpl cubeInstance) throws Exception {
            this.logger.info("verifying " + cubeInstance + "...");
        }
    }

    static abstract class DiffFactory<S> {
        DiffFactory() {
        }

        abstract Diff<S> createAddDiff(DiffType var1, S var2);

        abstract Diff<S> createDeleteDiff(DiffType var1, S var2);

        abstract Diff<S> createUpdateDiff(DiffType var1, S var2, S var3);
    }

    static abstract class Differ<T> {
        protected Comparator<T> comparator;
        protected DiffFactory<T> diffFactory;
        protected Logger logger = ComponentMigrationSupport.getLogger();
        protected Process newProcess;
        protected Process oldProcess;

        private Differ(Process oldProcess, Process newProcess, Comparator<T> comparator, DiffFactory<T> diffFactory) {
            this.oldProcess = oldProcess;
            this.newProcess = newProcess;
            this.comparator = comparator;
            this.diffFactory = diffFactory;
        }

        public List<Diff<T>> calculate() {
            ArrayList<Diff<T>> result = new ArrayList<Diff<T>>();
            this.populateDiffs(result);
            return result;
        }

        abstract void populateDiffs(List<Diff<T>> var1);
    }

    static abstract class BaseDataObjectsSynchronizer
    extends MSynchronizer<DataObject> {
        BaseDataObjectsSynchronizer(ProcessInstanceSynchronizerImpl processInstanceSynchronizer) {
            super(processInstanceSynchronizer);
        }

        @Override
        public void synchronize(ComponentInstanceMigrationContext context, ICubeInstanceImpl cubeInstance) throws Exception {
            super.synchronize(context, cubeInstance);
            IScopeImpl rootScope = cubeInstance.getScopeContext().getRootScope();
            IScopeImpl processBlockScope = (IScopeImpl)rootScope.getChildScopes().next();
            ICubeMap map = cubeInstance.getProcessClass().lookupMapFromElement(processBlockScope.getBlockId());
            BPMNProcessBlock processBlock = (BPMNProcessBlock)map.getBlock(processBlockScope.getBlockId());
            this.logger.info("bpmn: " + processBlock.getFlowElement().getName());
            List<Diff<DataObject>> dataObjectDiffs = this.getDataObjectDiffs();
            for (int i = 0; i < dataObjectDiffs.size(); ++i) {
                DataObjectDiff dataObjectDiff = (DataObjectDiff)dataObjectDiffs.get(i);
                if (dataObjectDiff.type.equals((Object)DiffType.ADD)) {
                    DataObject dataObject = (DataObject)this.processInstanceSynchronizer.targetProcess.findDeclaration(dataObjectDiff.name);
                    this.logger.info("sync adding process dataobject " + dataObject.getName());
                    if (!processBlockScope.contains(dataObject.getName())) {
                        DataHandlingUtils.declareAndSet((DataDeclaration)dataObject, (IScope)processBlockScope, context.getCubeContext());
                        this.logger.info("process dataobject " + dataObject.getName() + " added.");
                        continue;
                    }
                    this.logger.info("process dataobject " + dataObject.getName() + " already defined.");
                    continue;
                }
                if (!dataObjectDiff.type.equals((Object)DiffType.DELETE)) continue;
                processBlockScope.removeLocalVariant(dataObjectDiff.name, true);
                this.logger.info("sync removing process dataobject " + dataObjectDiff.name);
            }
        }

        public Sequence<Diff<DataObject>> getAddedDataObjects() {
            Sequence filteredDiffSequence = CollectionUtils.select(this.getDataObjectDiffs(), (Predicate)new Predicate<Diff<DataObject>>(){

                public boolean check(@Nullable Diff<DataObject> value) {
                    return value.type.equals((Object)DiffType.ADD);
                }
            });
            return filteredDiffSequence;
        }

        protected abstract List<Diff<DataObject>> getDataObjectDiffs();

        @Override
        boolean isMigrationCompatible() {
            return true;
        }

        @Override
        boolean isMigrationRecoverable() {
            return true;
        }
    }

    static abstract class BaseDataObjectsDiffer
    extends Differ<DataObject> {
        BaseDataObjectsDiffer(Process oldProcess, Process newProcess) {
            super(oldProcess, newProcess, new DataObjectComparator(), new DataObjectDiffFactory());
        }

        protected abstract Sequence<DataObject> getDataObjects(NodeContainer var1);

        @Override
        void populateDiffs(List<Diff<DataObject>> result) {
            this._populateDiffs(result, (NodeContainer)this.oldProcess, (NodeContainer)this.newProcess);
        }

        private void _populateDiffs(List<Diff<DataObject>> dataObjectDiffs, NodeContainer oldNodeContainer, NodeContainer newNodeContainer) {
            DataObjectDiffSupport dataObjectDiffSupport = new DataObjectDiffSupport();
            dataObjectDiffSupport.calculate(dataObjectDiffs, this.getDataObjects(oldNodeContainer), this.getDataObjects(newNodeContainer), this.comparator, this.diffFactory);
        }
    }

    public static class RevisionProcessInstanceSynchronizerImpl
    extends ProcessInstanceSynchronizerImpl {
        public RevisionProcessInstanceSynchronizerImpl(ComponentMigrationSupport componentMigrationSupport, oracle.fabric.composite.CompositeDN sourceCompositeDn, oracle.fabric.composite.CompositeDN targetCompositeDn, String componentName) {
            super(componentMigrationSupport, sourceCompositeDn, targetCompositeDn, componentName);
        }

        @Override
        protected void loadTargetProcess(ComponentInstanceMigrationContext componentInstanceMigrationContext) throws MetadataException, CubeException {
            BPMNProcess targetbpmnProcess = ComponentMigrationSupport.lookupBpmnProcess(componentInstanceMigrationContext.getCubeContext(), this.getTargetCompositeDn().getDN(), this.getComponentName());
            this.targetProcess = targetbpmnProcess.getProcessModel();
            this.targetCubeMap = targetbpmnProcess.getBPMNCubeMap();
        }

        @Override
        protected void loadSourceProcess(ComponentInstanceMigrationContext componentInstanceMigrationContext) throws MetadataException, CubeException {
            BPMNProcess sourceBpmnProcess = ComponentMigrationSupport.lookupBpmnProcess(componentInstanceMigrationContext.getCubeContext(), this.getSourceCompositeDn().getDN(), this.getComponentName());
            this.sourceProcess = sourceBpmnProcess.getProcessModel();
            this.sourceCubeMap = sourceBpmnProcess.getBPMNCubeMap();
        }
    }

    public static class LabelProcessInstanceSynchronizerImpl
    extends ProcessInstanceSynchronizerImpl {
        public LabelProcessInstanceSynchronizerImpl(ComponentMigrationSupport componentMigrationSupport, oracle.fabric.composite.CompositeDN sourceCompositeDn, oracle.fabric.composite.CompositeDN targetCompositeDn, String componentName) {
            super(componentMigrationSupport, sourceCompositeDn, targetCompositeDn, componentName);
        }

        @Override
        protected void loadSourceProcess(ComponentInstanceMigrationContext context) throws MetadataException, CubeException {
            Project sourceProject = this.getComponentMigrationSupport().findProject(null, this.getSourceCompositeDn());
            this.sourceProcess = sourceProject.findProcess(this.getComponentName());
            this.sourceCubeMap = BPMNCubeMapFactory.create(this.sourceProcess);
        }

        @Override
        protected void loadTargetProcess(ComponentInstanceMigrationContext context) throws MetadataException, CubeException {
            CompositeModel targetCompositeModel;
            ComponentModel targetComponent = context.getTargetComponent();
            if (targetComponent == null) {
                logger.info("finding target component using " + this.getTargetCompositeDn().getDN());
                targetCompositeModel = this.getComponentMigrationSupport().findComposite(this.getTargetCompositeDn());
                targetComponent = targetCompositeModel.getComponent(this.getComponentName());
            } else {
                logger.info("using context target component from: " + targetComponent.getComposite().getDN());
                targetCompositeModel = targetComponent.getComposite();
            }
            Project targetProject = this.getComponentMigrationSupport().findProject(targetCompositeModel, this.getTargetCompositeDn());
            this.targetProcess = targetProject.findProcess(this.getComponentName());
            this.targetCubeMap = BPMNCubeMapFactory.create(this.targetProcess, targetComponent);
        }
    }

    public static class ActivityDiffItem {
        private ActivityDiffItemType activityDiffItemType;
        private Msg msg;
        private static final long serialVersionUID = 7970065800083900122L;

        ActivityDiffItem(ActivityDiffItemType activityDiffItemType, Msg msg) {
            this.activityDiffItemType = activityDiffItemType;
            this.msg = msg;
        }

        public ActivityDiffItemType getActivityDiffItemType() {
            return this.activityDiffItemType;
        }

        public Msg getMsg() {
            return this.msg;
        }
    }

    public static class ActivityDiff
    extends Diff<FlowNode> {
        private List<ActivityDiffItem> activityDiffItems;
        private String activityId;
        private Msg msg;
        private FlowNode sourceActivity;
        private FlowNode targetActivity;

        ActivityDiff(DiffType diffType, DiffLevel level, String activityId, FlowNode sourceActivity, FlowNode targetActivity) {
            super(diffType, level);
            this.activityId = activityId;
            this.sourceActivity = sourceActivity;
            this.targetActivity = targetActivity;
            this.activityDiffItems = new ArrayList<ActivityDiffItem>();
            this.buildMsg();
        }

        public List<ActivityDiffItem> getActivityDiffItems() {
            return this.activityDiffItems;
        }

        public String getActivityId() {
            return this.activityId;
        }

        @Override
        public String toString() {
            return "ActivityDiff{type='" + (Object)((Object)this.type) + '\'' + "activityId='" + this.activityId + '\'' + "level='" + (Object)((Object)this.getLevel()) + '}';
        }

        public void addActivityDiffItem(ActivityDiffItemType activityItemDiffType, Msg msg) {
            this.activityDiffItems.add(new ActivityDiffItem(activityItemDiffType, msg));
        }

        public boolean hasItems() {
            return this.activityDiffItems.size() > 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActivityDiff that = (ActivityDiff)o;
            return !(this.activityId != null ? !this.activityId.equals(that.activityId) : that.activityId != null);
        }

        public int hashCode() {
            return this.activityId != null ? this.activityId.hashCode() : 0;
        }

        @Override
        protected Msg getMsg() {
            return this.msg;
        }

        @Override
        protected DiffLevel getLevel() {
            ActivityDiffItem activityDiffItem = (ActivityDiffItem)CollectionUtils.max(this.activityDiffItems, (Comparator)new Comparator<ActivityDiffItem>(){

                @Override
                public int compare(ActivityDiffItem o1, ActivityDiffItem o2) {
                    return o1.getActivityDiffItemType().getDiffLevel().compareTo(o2.getActivityDiffItemType().getDiffLevel());
                }
            });
            DiffLevel diffLevel = super.getLevel();
            if (activityDiffItem != null) {
                diffLevel = diffLevel.compareTo(activityDiffItem.getActivityDiffItemType().getDiffLevel()) < 0 ? activityDiffItem.getActivityDiffItemType().getDiffLevel() : diffLevel;
            }
            return diffLevel;
        }

        @Override
        protected Tuple<FlowNode, FlowNode> getValue() {
            return Tuple.create((Object)this.sourceActivity, (Object)this.targetActivity);
        }

        private void buildMsg() {
            switch (this.type) {
                case DELETE: {
                    this.msg = BpmnEngineMsg.ACTIVITY_DIFF_DELETE(this.sourceActivity.getDefaultLabel());
                    break;
                }
                case UPDATE: {
                    this.msg = BpmnEngineMsg.ACTIVITY_DIFF_UPDATE(this.sourceActivity.getDefaultLabel());
                    break;
                }
                case ADD: {
                    this.msg = BpmnEngineMsg.ACTIVITY_DIFF_ADD(this.targetActivity.getDefaultLabel());
                }
            }
        }
    }

    public static class ActivitiesDiffer
    extends Differ<FlowNode> {
        public ActivitiesDiffer(Process oldProcess, AlterFlowModel sourceAlterFlowModel, Process newProcess, AlterFlowModel targetAlterFlowModel) {
            super(oldProcess, newProcess, new ActivityComparator(), new ActivityDiffFactory(sourceAlterFlowModel, targetAlterFlowModel));
        }

        @Override
        void populateDiffs(List<Diff<FlowNode>> result) {
            ActivityDiffSupport activityDiffSupport = new ActivityDiffSupport();
            activityDiffSupport.calculate(result, ComponentMigrationSupport.getAllFlowNodes(this.oldProcess), ComponentMigrationSupport.getAllFlowNodes(this.newProcess), this.comparator, this.diffFactory);
        }
    }

    public static abstract class ProcessInstanceSynchronizerImpl
    implements ProcessInstanceSynchronizer {
        BPMNCubeMap sourceCubeMap;
        Process sourceProcess;
        BPMNCubeMap targetCubeMap;
        Process targetProcess;
        private ActivitiesSynchronizer activitiesSynchronizer;
        private ComponentMigrationSupport componentMigrationSupport;
        private String componentName;
        private ProcessDataObjectsSynchronizer processDataObjectsSynchronizer;
        private ProcessDiff processDiff;
        private ProjectDataObjectsSynchronizer projectDataObjectsSynchronizer;
        private ServiceLinksSynchronizer serviceLinksSynchronizer;
        private AlterFlowModel sourceAlterFlowModel;
        private oracle.fabric.composite.CompositeDN sourceCompositeDn;
        private SubProcessDataObjectsSynchronizer subProcessDataObjectsSynchronizer;
        private AlterFlowModel targetAlterFlowModel;
        private oracle.fabric.composite.CompositeDN targetCompositeDn;
        private static final long serialVersionUID = -8460082470683640780L;

        public ProcessInstanceSynchronizerImpl(ComponentMigrationSupport componentMigrationSupport, oracle.fabric.composite.CompositeDN sourceCompositeDn, oracle.fabric.composite.CompositeDN targetCompositeDn, String componentName) {
            this.componentMigrationSupport = componentMigrationSupport;
            this.sourceCompositeDn = sourceCompositeDn;
            this.targetCompositeDn = targetCompositeDn;
            this.componentName = componentName;
        }

        public oracle.fabric.composite.CompositeDN getSourceCompositeDn() {
            return this.sourceCompositeDn;
        }

        public oracle.fabric.composite.CompositeDN getTargetCompositeDn() {
            return this.targetCompositeDn;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public void build(ComponentInstanceMigrationContext context) throws CubeException, MetadataException {
            this.loadSourceProcess(context);
            this.loadTargetProcess(context);
            FlowNodeToRuntimeModelMapperImpl sourceFlowNodeToRuntimeModelMapper = new FlowNodeToRuntimeModelMapperImpl(this.sourceCubeMap);
            this.sourceAlterFlowModel = AlterFlowModel.create(this.sourceProcess, sourceFlowNodeToRuntimeModelMapper);
            FlowNodeToRuntimeModelMapperImpl targetFlowNodeToRuntimeModelMapper = new FlowNodeToRuntimeModelMapperImpl(this.targetCubeMap);
            this.targetAlterFlowModel = AlterFlowModel.create(this.targetProcess, targetFlowNodeToRuntimeModelMapper);
            List<Diff<DataObject>> subProcessDataObjectDiffs = new SubProcessDataObjectsDiffer(this.sourceProcess, this.targetProcess).calculate();
            logger.info("SubProcess DataObject diffs: " + subProcessDataObjectDiffs);
            List<Diff<DataObject>> dataObjectDiffs = new DataObjectsDiffer(this.sourceProcess, this.targetProcess).calculate();
            List<Diff<DataObject>> projectDataObjectDiffs = new ProjectDataObjectsDiffer(this.sourceProcess, this.targetProcess).calculate();
            logger.info("DataObject diffs: " + dataObjectDiffs);
            List<Diff<String>> serviceLinkDiffs = new ServiceLinksDiffer(this.sourceProcess, this.targetProcess).calculate();
            logger.info("service link diffs: " + serviceLinkDiffs);
            List activityDiffs = new ActivitiesDiffer(this.sourceProcess, this.sourceAlterFlowModel, this.targetProcess, this.targetAlterFlowModel).calculate();
            logger.info("activity diffs: " + activityDiffs);
            this.processDiff = new ProcessDiff(activityDiffs, dataObjectDiffs, subProcessDataObjectDiffs, projectDataObjectDiffs, serviceLinkDiffs);
            logger.info("creating sync process dataobjects...");
            this.processDataObjectsSynchronizer = new ProcessDataObjectsSynchronizer(this);
            logger.info("creating sync project dataobjects...");
            this.projectDataObjectsSynchronizer = new ProjectDataObjectsSynchronizer(this);
            logger.info("creating sync subprocess dataobjects...");
            this.subProcessDataObjectsSynchronizer = new SubProcessDataObjectsSynchronizer(this);
            logger.info("creating sync service links...");
            this.serviceLinksSynchronizer = new ServiceLinksSynchronizer(this);
            logger.info("creating sync activities...");
            this.activitiesSynchronizer = new ActivitiesSynchronizer(this);
        }

        @Override
        public void synchronize(ComponentInstanceMigrationContext context, ICubeInstanceImpl cubeInstance) throws Exception {
            logger.info("sync process dataobjects...");
            this.processDataObjectsSynchronizer.synchronize(context, cubeInstance);
            logger.info("sync project dataobjects...");
            this.projectDataObjectsSynchronizer.synchronize(context, cubeInstance);
            logger.info("sync subprocess dataobjects...");
            this.subProcessDataObjectsSynchronizer.synchronize(context, cubeInstance);
            logger.info("sync service links...");
            this.serviceLinksSynchronizer.synchronize(context, cubeInstance);
            logger.info("sync activities...");
            this.activitiesSynchronizer.synchronize(context, cubeInstance);
        }

        @Override
        public void verify(ComponentInstanceMigrationContext context, ICubeInstanceImpl cubeInstance) throws Exception {
            logger.info("verifying process dataobjects...");
            this.processDataObjectsSynchronizer.verify(context, cubeInstance);
            logger.info("verifying project dataobjects...");
            this.projectDataObjectsSynchronizer.verify(context, cubeInstance);
            logger.info("verifying subprocess dataobjects...");
            this.subProcessDataObjectsSynchronizer.verify(context, cubeInstance);
            logger.info("verifying service links...");
            this.serviceLinksSynchronizer.verify(context, cubeInstance);
            logger.info("verifying activities...");
            this.activitiesSynchronizer.verify(context, cubeInstance);
        }

        @Override
        public boolean isMigrationCompatible() {
            return this.activitiesSynchronizer.isMigrationCompatible() && this.serviceLinksSynchronizer.isMigrationCompatible() && this.subProcessDataObjectsSynchronizer.isMigrationCompatible() && this.processDataObjectsSynchronizer.isMigrationCompatible() && this.projectDataObjectsSynchronizer.isMigrationCompatible();
        }

        public Sequence<Diff<FlowNode>> getUnrecoverableDiffs() {
            return this.activitiesSynchronizer.getUnrecoverableDiffs();
        }

        public boolean isMigrationRecoverable() {
            return this.activitiesSynchronizer.isMigrationRecoverable() && this.serviceLinksSynchronizer.isMigrationRecoverable() && this.subProcessDataObjectsSynchronizer.isMigrationRecoverable() && this.processDataObjectsSynchronizer.isMigrationRecoverable() && this.projectDataObjectsSynchronizer.isMigrationRecoverable();
        }

        public Sequence<Diff<DataObject>> getAddedDataObjects() {
            return CollectionUtils.concat((Iterable[])new Iterable[]{this.projectDataObjectsSynchronizer.getAddedDataObjects(), this.processDataObjectsSynchronizer.getAddedDataObjects(), this.subProcessDataObjectsSynchronizer.getAddedDataObjects()});
        }

        public Sequence<Diff<FlowNode>> getActivitiesInConflict() {
            return this.activitiesSynchronizer.getActivitiesInConflictSequence();
        }

        protected abstract void loadTargetProcess(ComponentInstanceMigrationContext var1) throws MetadataException, CubeException;

        protected abstract void loadSourceProcess(ComponentInstanceMigrationContext var1) throws MetadataException, CubeException;

        protected ComponentMigrationSupport getComponentMigrationSupport() {
            return this.componentMigrationSupport;
        }
    }

    public static abstract class Diff<T> {
        protected DiffType type;
        private DiffLevel level;

        Diff(DiffType type) {
            this(type, DiffLevel.COMPATIBLE);
        }

        Diff(DiffType type, DiffLevel level) {
            this.type = type;
            this.level = level;
        }

        public String toString() {
            return "Diff{type=" + (Object)((Object)this.type) + "level=" + (Object)((Object)this.level) + "}";
        }

        protected abstract Msg getMsg();

        protected abstract Tuple<T, T> getValue();

        protected DiffType getType() {
            return this.type;
        }

        protected DiffLevel getLevel() {
            return this.level;
        }
    }

    public static interface ProcessInstanceSynchronizer {
        public void synchronize(ComponentInstanceMigrationContext var1, ICubeInstanceImpl var2) throws Exception;

        public void verify(ComponentInstanceMigrationContext var1, ICubeInstanceImpl var2) throws Exception;

        public boolean isMigrationCompatible();
    }

    public static interface ComponentMigrationListener {
        public void componentInstancesPendingMigration(ICubeContext var1, oracle.fabric.composite.CompositeDN var2, String var3) throws Exception;

        public void componentInstanceMigrated(ICubeContext var1, oracle.fabric.composite.CompositeDN var2, String var3, long var4) throws Exception;
    }

    public static enum DiffLevel {
        IDENTICAL,
        COMPATIBLE,
        INCOMPATIBLE,
        INCOMPATIBLE_UNRECOVERABLE;

    }

    static enum ActivityDiffItemType {
        ADDED_BOUNDARY_EVENT(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        ADDED_EVENT_SUBPROCESS(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        ADDED_CALL_ACTIVITY(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        REMOVED_NON_EXCLUSIVE_GATEWAY(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        REMOVED_SUBPROCESS(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        UPDATED_BPMN_TYPE(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        UPDATED_HUMAN_TASK_IMPLEMENTATION(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        UPDATED_SUBPROCESS_LOOP_CHARACTERISTICS(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        UPDATED_BOUNDARY_EVENT_INTERRUPTING_FLAG(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        UPDATED_EVENT_SUBPROCESS_INTERRUPTING_FLAG(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        UPDATED_CALL_ACTIVITY(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        UPDATED_ACTIVITY_LEVEL(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        UPDATED_GATEWAY_DIRECTION(DiffLevel.INCOMPATIBLE_UNRECOVERABLE),
        UPDATED_GATEWAY_FLOWS(DiffLevel.INCOMPATIBLE_UNRECOVERABLE);

        private DiffLevel diffLevel;

        private ActivityDiffItemType(DiffLevel diffLevel) {
            this.diffLevel = diffLevel;
        }

        public DiffLevel getDiffLevel() {
            return this.diffLevel;
        }
    }

    static enum DiffType {
        ADD,
        DELETE,
        UPDATE;

    }
}

