/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import com.collaxa.cube.engine.CubeContextFactory;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.CubeEngineHolder;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.ICubeEngine;
import com.collaxa.cube.engine.core.CubeInstanceKey;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.data.CubeInstancePersistenceMgr;
import com.collaxa.cube.engine.dispatch.DispatchHelper;
import com.collaxa.cube.engine.dispatch.message.IMessage;
import com.collaxa.cube.engine.dispatch.message.IMessageHandler;
import com.collaxa.cube.engine.dispatch.message.process.ProcessMessage;
import com.collaxa.cube.engine.ejb.interfaces.ICubeEngineLocalBean;
import com.collaxa.cube.engine.util.EngineBeanCache;
import com.collaxa.cube.persistence.dao.ICubeInstanceDao;
import com.collaxa.cube.persistence.dto.CubeInstance;
import com.collaxa.cube.persistence.dto.CubeInstanceVO;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CheckInstanceCompatibilityBetweenRevisionsDelegate;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentInstanceMigrationContext;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentMigrationSupport;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.MigrateInstanceBetweenRevisionsDelegate;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ResultInfo;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.bpmn.engine.service.ResumeComponentMessage;
import oracle.bpm.bpmn.engine.service.ejb.interfaces.IBPMNCubeEngineLocalBean;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;
import oracle.fabric.common.FabricDeploymentException;
import oracle.fabric.composite.CompositeDN;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.fabric.composite.model.PropertyModel;
import oracle.soa.management.ComponentDN;
import oracle.soa.management.facade.ComponentInstance;
import oracle.soa.management.facade.ComponentInstanceMigrationReport;
import oracle.soa.management.facade.ComponentInstanceMigrationResult;
import oracle.soa.management.facade.InstanceMigrationContext;
import oracle.soa.management.facade.MigrationPlan;
import oracle.soa.management.util.ComponentInstanceFilter;
import oracle.soa.management.util.SOAUtil;

public abstract class ComponentInstanceMigrationAction {
    protected BPMNServiceEngine bpmnServiceEngine;
    protected ComponentInstanceMigrationContext componentInstanceMigrationContext;
    protected ComponentMigrationSupport componentMigrationSupport;

    protected ComponentInstanceMigrationAction(ComponentInstanceMigrationContext componentInstanceMigrationContext, ComponentMigrationSupport componentMigrationSupport) {
        this.componentInstanceMigrationContext = componentInstanceMigrationContext;
        this.componentMigrationSupport = componentMigrationSupport;
        this.bpmnServiceEngine = componentMigrationSupport.getBpmnServiceEngine();
    }

    public ComponentMigrationSupport getComponentMigrationSupport() {
        return this.componentMigrationSupport;
    }

    public ComponentInstanceMigrationContext getComponentInstanceMigrationContext() {
        return this.componentInstanceMigrationContext;
    }

    protected Logger getLogger() {
        ComponentInstanceMigrationAction componentInstanceMigrationAction = this;
        return componentInstanceMigrationAction.componentMigrationSupport.getLogger();
    }

    protected Logger getClientLogger() {
        ComponentInstanceMigrationAction componentInstanceMigrationAction = this;
        return componentInstanceMigrationAction.componentMigrationSupport.getClientLogger();
    }

    public static class PreProcessTargetComponentAction
    extends ComponentInstanceMigrationAction {
        private ComponentModel targetComponent;

        public PreProcessTargetComponentAction(ComponentInstanceMigrationContext componentInstanceMigrationContext, ComponentMigrationSupport componentMigrationSupport, ComponentModel targetComponent) {
            super(componentInstanceMigrationContext, componentMigrationSupport);
            this.targetComponent = targetComponent;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void execute() throws Exception {
            block7: {
                Logger logger;
                block6: {
                    logger = this.getLogger();
                    logger.info("preprocess target component...");
                    ComponentDN newComponentDN = new ComponentDN(this.targetComponent.getComposite().getDN(), this.targetComponent.getName());
                    logger.info("deploying new component " + newComponentDN);
                    logger.info("finding current component for composite revision " + this.getComponentMigrationSupport().getCompositeRevisionDN(newComponentDN.getStringDN()));
                    CompositeModel currentActiveComposite = this.getComponentMigrationSupport().findCompositeRevision(new CompositeDN(this.getComponentMigrationSupport().getCompositeRevisionDN(newComponentDN.getStringDN())));
                    if (currentActiveComposite == null) break block6;
                    ComponentModel currentComponent = currentActiveComposite.getComponent(this.targetComponent.getName());
                    if (currentComponent != null) {
                        ComponentDN currentComponentDN = new ComponentDN(currentComponent.getComposite().getDN(), currentComponent.getName());
                        logger.info("current active component is " + currentComponentDN);
                        ComponentMigrationSupport.LabelProcessInstanceSynchronizerImpl newProcessInstanceSynchronizer = new ComponentMigrationSupport.LabelProcessInstanceSynchronizerImpl(this.componentMigrationSupport, new CompositeDN(currentComponent.getComposite().getDN()), new CompositeDN(this.targetComponent.getComposite().getDN()), currentComponent.getName());
                        this.componentInstanceMigrationContext.setTargetComponent(this.targetComponent);
                        newProcessInstanceSynchronizer.build(this.componentInstanceMigrationContext);
                        logger.info("verifying migration recoverable...");
                        boolean migrationRecoverable = newProcessInstanceSynchronizer.isMigrationRecoverable();
                        logger.info("migrationRecoverable=" + migrationRecoverable);
                        if (!migrationRecoverable) {
                            logger.info("Component " + newComponentDN + " has unrecoverable incompatibilities with existing component " + currentComponentDN + ".");
                            this.getClientLogger().severe("Component " + newComponentDN + " has unrecoverable incompatibilities with existing component " + currentComponentDN + ".");
                            Sequence<ComponentMigrationSupport.Diff<FlowNode>> unrecoverableDiffs = newProcessInstanceSynchronizer.getUnrecoverableDiffs();
                            for (ComponentMigrationSupport.Diff unrecoverableDiff : unrecoverableDiffs) {
                                if (!(unrecoverableDiff instanceof ComponentMigrationSupport.ActivityDiff)) continue;
                                ComponentMigrationSupport.ActivityDiff activityDiff = (ComponentMigrationSupport.ActivityDiff)unrecoverableDiff;
                                List<ComponentMigrationSupport.ActivityDiffItem> activityDiffItems = activityDiff.getActivityDiffItems();
                                for (ComponentMigrationSupport.ActivityDiffItem activityDiffItem : activityDiffItems) {
                                    Msg msg = activityDiffItem.getMsg();
                                    if (msg == null) continue;
                                    logger.info("Unrecoverable incompatibility: " + msg.getString());
                                    this.getClientLogger().info("Unrecoverable incompatibility: " + msg.getString());
                                }
                            }
                            if (!BPMNServiceEngine.isForceDeploy(this.targetComponent)) {
                                logger.info("failing.");
                                throw new FabricDeploymentException("Component " + newComponentDN + " has unrecoverable incompatibilities with existing component " + currentComponentDN + ".");
                            }
                            logger.info("forcing deploy.");
                            this.getClientLogger().info("forcing deploy.");
                        }
                        break block7;
                    } else {
                        logger.info("there is no previous component. this is a new component.");
                    }
                    break block7;
                }
                logger.info("there is no previous composite.");
            }
            this.getLogger().info("target component preprocessed.");
        }
    }

    public static class PreProcessSourceComponentAction
    extends ComponentInstanceMigrationAction {
        private ComponentModel sourceComponent;

        public PreProcessSourceComponentAction(ComponentInstanceMigrationContext componentInstanceMigrationContext, ComponentMigrationSupport componentMigrationSupport, ComponentModel sourceComponent) {
            super(componentInstanceMigrationContext, componentMigrationSupport);
            this.sourceComponent = sourceComponent;
        }

        public void execute() throws Exception {
            Logger logger = this.getLogger();
            logger.info("undeploying base component " + this.sourceComponent.getComposite().getDN() + "/" + this.sourceComponent.getName());
            logger.info("finding overwriting component for " + this.sourceComponent.getComposite().getDN() + "/" + this.sourceComponent.getName());
            ComponentMigrationSupport componentMigrationSupport = this.getComponentMigrationSupport();
            CompositeModel composite = componentMigrationSupport.findRelatedComposite(new CompositeDN(this.sourceComponent.getComposite().getDN()));
            if (composite != null) {
                logger.info("overwriting composite found " + composite.getDN());
                ComponentModel newComponent = composite.getComponent(this.sourceComponent.getName());
                if (newComponent == null) {
                    logger.info("overwriting component not found. No component removes allowed in redeploy component!");
                    throw new FabricDeploymentException("There is no overwriting component for " + this.sourceComponent.getName() + ". Component remove is unsupported on overwrite with keep instances running.");
                }
            } else {
                logger.info("overwriting composite not found!");
            }
        }
    }

    public static class PostOverwriteComponentAction
    extends ComponentInstanceMigrationAction {
        private ComponentModel sourceComponent;
        private ComponentModel targetComponent;

        public PostOverwriteComponentAction(ComponentInstanceMigrationContext componentInstanceMigrationContext, ComponentMigrationSupport componentMigrationSupport, ComponentModel sourceComponent, ComponentModel targetComponent) {
            super(componentInstanceMigrationContext, componentMigrationSupport);
            this.sourceComponent = sourceComponent;
            this.targetComponent = targetComponent;
        }

        public void execute() throws Exception {
            Logger logger = this.getLogger();
            if (this.targetComponent != null) {
                this.componentMigrationSupport.notifyComponentInstancesPendingMigration(this.componentInstanceMigrationContext.getCubeContext(), new CompositeDN(this.sourceComponent.getComposite().getDN()), this.sourceComponent.getName());
                if (BPMNServiceEngine.getInstance().getClusterInterface().isLeader()) {
                    logger.info("scheduling post processing for overwrite...");
                    OverwriteComponentMessage message = new OverwriteComponentMessage(new ComponentDN(this.targetComponent.getComposite().getDN(), this.targetComponent.getName()));
                    new OverwriteComponentMessageHandler().handle((IMessage)message);
                } else {
                    logger.info("skipping post processing for overwrite.");
                }
            }
        }
    }

    public static class OverwriteComponentMessageHandler
    implements IMessageHandler {
        public IMessage handle(IMessage msg) {
            Logger logger = ComponentMigrationSupport.getLogger();
            OverwriteComponentMessage myProcessMessage = (OverwriteComponentMessage)msg;
            try {
                logger.info("executing post-undeploy in message handler...");
                ICubeEngineLocalBean bean = EngineBeanCache.getEngineLocalBean((String)myProcessMessage.getEngineType());
                IBPMNCubeEngineLocalBean engineLocalBean = (IBPMNCubeEngineLocalBean)bean;
                logger.info("delegating migrate processing to engine local bean");
                engineLocalBean.onComponentOverwrite(myProcessMessage.newComponentDN);
                logger.info("post-undeploy processed.");
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "exception happened while executing post-undeploy.", e);
            }
            return null;
        }
    }

    public static class OverwriteComponentMessage
    extends ProcessMessage {
        private ComponentDN newComponentDN;

        OverwriteComponentMessage(ComponentDN newComponentDN) {
            super(newComponentDN, "bpmn");
            this.newComponentDN = newComponentDN;
        }
    }

    public static class MigrateSourceToTargetComponentAction
    extends ComponentInstanceMigrationAction {
        private ComponentDN targetComponentDn;
        private static final int MAX_PAGE_SIZE = 100;

        public MigrateSourceToTargetComponentAction(ComponentInstanceMigrationContext componentInstanceMigrationContext, ComponentMigrationSupport componentMigrationSupport, ComponentDN targetComponentDn) {
            super(componentInstanceMigrationContext, componentMigrationSupport);
            this.targetComponentDn = targetComponentDn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws Exception {
            ICubeEngine iCubeEngine = CubeEngineHolder.getEngine((String)"bpmn");
            ComponentDN newComponentDN = this.targetComponentDn;
            Logger logger = this.getLogger();
            logger.info("on overwrite component " + newComponentDN);
            logger.info("fetch unsuspended instances for old component " + newComponentDN);
            ComponentInstanceFilter filter = new ComponentInstanceFilter();
            filter.setCompositeDN(newComponentDN.getCompositeDN());
            filter.setComponentName(newComponentDN.getComponentName());
            filter.setStates(new int[]{1, 3});
            filter.setPageSize(100);
            ICubeInstanceDao cubeInstanceDao = CubeContextHelper.getServerManager((ICubeContext)this.getComponentInstanceMigrationContext().getCubeContext()).getCubeServiceEngine().getJpaDaoFactory().getCubeInstanceDaoBean();
            int unsuspendInstances = cubeInstanceDao.getNumberOfInstances(filter, "bpmn");
            if (unsuspendInstances > 100) {
                String pattern = "There are more instances than maximum threshold for auto migration. Only {0} of {1} instances will be considered for migration";
                this.getClientLogger().warning(MessageFormat.format(pattern, 100, unsuspendInstances));
            }
            if (unsuspendInstances > 0) {
                logger.info("there are unsuspended instances");
                logger.info("fetch unsuspended instances for overwritten component " + newComponentDN);
                List cubeInstances = cubeInstanceDao.getInstances(filter, "bpmn");
                logger.info("calculate synch based on component diff");
                for (CubeInstanceVO innerCubeInstance : cubeInstances) {
                    long cikey = innerCubeInstance.getCikey();
                    logger.info("processing instance " + cikey);
                    String instanceCompositeLabel = innerCubeInstance.getCompositeLabel();
                    String componentName = newComponentDN.getComponentName();
                    CompositeDN sourceCompositeDn = new CompositeDN(newComponentDN.getApplicationName(), newComponentDN.getCompositeName(), newComponentDN.getRevision(), instanceCompositeLabel);
                    CompositeDN targetCompositeDn = new CompositeDN(SOAUtil.getCompositeDNFromComponentDN((String)this.targetComponentDn.getStringDN()));
                    logger.info("obtaining component synch " + sourceCompositeDn.getStringDN() + "->" + targetCompositeDn.getStringDN());
                    ComponentMigrationSupport.ProcessInstanceSynchronizer processInstanceSynchronizer = this.componentInstanceMigrationContext.getProcessInstanceSynchronizer(sourceCompositeDn.getStringDN(), targetCompositeDn.getStringDN(), componentName);
                    if (processInstanceSynchronizer == null) {
                        logger.info("building component synch " + sourceCompositeDn.getStringDN() + "->" + targetCompositeDn.getStringDN());
                        ComponentMigrationSupport.LabelProcessInstanceSynchronizerImpl newProcessInstanceSynchronizer = new ComponentMigrationSupport.LabelProcessInstanceSynchronizerImpl(this.componentMigrationSupport, sourceCompositeDn, targetCompositeDn, componentName);
                        newProcessInstanceSynchronizer.build(this.componentInstanceMigrationContext);
                        processInstanceSynchronizer = newProcessInstanceSynchronizer;
                        this.componentInstanceMigrationContext.setProcessInstanceSynchronizer(sourceCompositeDn.getStringDN(), targetCompositeDn.getStringDN(), componentName, processInstanceSynchronizer);
                    }
                    logger.info("checking compatibility");
                    if (!processInstanceSynchronizer.isMigrationCompatible()) continue;
                    logger.info("synch based on component diff");
                    ICubeContext cubeContext = CubeContextFactory.newInstance().create("bpmn");
                    try {
                        iCubeEngine.startUpdateRequest(cubeContext);
                        this.componentInstanceMigrationContext.setCubeContext(cubeContext);
                        ICubeInstanceImpl cubeInstance = CubeInstancePersistenceMgr.load((CubeInstanceKey)new CubeInstanceKey(cikey), (ICubeContext)cubeContext);
                        processInstanceSynchronizer.synchronize(this.componentInstanceMigrationContext, cubeInstance);
                        logger.info("update componentdn, not migration pending");
                        innerCubeInstance.setCompositeLabel(newComponentDN.getLabel());
                        this.getComponentMigrationSupport().notifyComponentInstanceMigrated(cubeContext, new CompositeDN(newComponentDN.getCompositeDN()), newComponentDN.getComponentName(), cubeInstance.getId());
                        --unsuspendInstances;
                        iCubeEngine.endRequest(cubeContext);
                    }
                    finally {
                        if (cubeContext != null) {
                            cubeContext.close();
                        }
                    }
                }
            }
            if (unsuspendInstances > 0) {
                logger.info("there are unsuspended instances that cannot be migrated, suspend component " + newComponentDN);
                try {
                    this.getComponentMigrationSupport().suspendComponent(newComponentDN);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to suspend component '" + newComponentDN + "'", e);
                    throw e;
                }
            }
            logger.info("resuming component " + newComponentDN);
            ICubeContext cubeContext = CubeContextFactory.newInstance().create("bpmn");
            try {
                CubeContextHelper.bindProcessDN((ComponentDN)newComponentDN, (ICubeContext)cubeContext);
                DispatchHelper.dispatchLocal((IMessage)new ResumeComponentMessage(newComponentDN, BPMNServiceEngine.getInstance().getEngineType()), (ICubeContext)cubeContext);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to resume component '" + newComponentDN + "'", e);
                throw e;
            }
            finally {
                if (cubeContext != null) {
                    cubeContext.close();
                }
            }
            logger.info("on overwrite component " + newComponentDN + " finished.");
        }
    }

    public static class MigrateInstanceBetweenRevisions
    extends ComponentInstanceMigrationAction {
        public MigrateInstanceBetweenRevisions(ComponentInstanceMigrationContext componentInstanceMigrationContext, ComponentMigrationSupport componentMigrationSupport) {
            super(componentInstanceMigrationContext, componentMigrationSupport);
        }

        public ComponentInstanceMigrationResult execute(ComponentInstance componentInstance, CompositeModel newRevisionCompositeModel, MigrationPlan migrationPlan, ICubeContext iCubeContext, InstanceMigrationContext instanceMigrationContext) throws Exception {
            return MigrateInstanceBetweenRevisionsDelegate.getInstance().execute(this.getLogger(), this.getComponentMigrationSupport(), componentInstance, newRevisionCompositeModel, migrationPlan);
        }
    }

    public static class MigrateComponentInstanceException
    extends Exception {
        private final String solutionMessage;

        public MigrateComponentInstanceException(String message) {
            this(message, (String)null);
        }

        public MigrateComponentInstanceException(String message, Throwable cause) {
            this(message, null, cause);
        }

        public MigrateComponentInstanceException(String message, String solutionMessage) {
            super(message);
            this.solutionMessage = solutionMessage;
        }

        public MigrateComponentInstanceException(String message, String solutionMessage, Throwable cause) {
            super(message, cause);
            this.solutionMessage = solutionMessage;
        }

        public String getSolutionMessage() {
            return this.solutionMessage;
        }
    }

    public static class MigrateComponentInstanceAction
    extends ComponentInstanceMigrationAction {
        private ICubeInstanceImpl cubeInstance;

        public MigrateComponentInstanceAction(ComponentInstanceMigrationContext componentInstanceMigrationContext, ComponentMigrationSupport componentMigrationSupport, ICubeInstanceImpl cubeInstance) {
            super(componentInstanceMigrationContext, componentMigrationSupport);
            this.cubeInstance = cubeInstance;
        }

        public ResultInfo execute() {
            Logger logger = this.getLogger();
            ICubeContext cubeContext = this.getComponentInstanceMigrationContext().getCubeContext();
            logger.info("migrate");
            CubeInstance cubeInstanceEO = this.cubeInstance.getCubeInstanceEO();
            String componentLabel = this.cubeInstance.getComponentDN().getLabel();
            String instanceLabel = cubeInstanceEO.getCompositeLabel();
            logger.info("checking instance is not migrated");
            logger.info("current component label is " + componentLabel);
            logger.info("instance component label is " + instanceLabel);
            if (instanceLabel.equals(componentLabel)) {
                logger.info("instance already migrated.");
                return new ResultInfo("instance already migrated.", null, true);
            }
            try {
                logger.info("instance is migration pending...");
                logger.info("migration requires instance to be suspend");
                logger.info("checking instance suspended");
                boolean isInstanceSuspended = this.cubeInstance.getState() == 2;
                logger.info("checking component suspended");
                boolean isComponentSuspended = false;
                ComponentModel component = this.cubeInstance.getProcessClass().getScaComponent();
                PropertyModel property = component.getProperty("bpel.config.suspend");
                if (property != null) {
                    isComponentSuspended = Boolean.valueOf(property.getValue());
                }
                boolean isSuspended = isInstanceSuspended || isComponentSuspended;
                logger.info("synchronizing instance state to new definition...");
                logger.info("generating diff component to instance definition...");
                logger.info("synchronizing instance state based on generated diff...");
                CompositeDN targetCompositeDn = new CompositeDN(this.cubeInstance.getComponentDN().getCompositeDN());
                CompositeDN sourceCompositeDn = new CompositeDN(targetCompositeDn.getApplicationName(), targetCompositeDn.getCompositeName(), targetCompositeDn.getRevision(), instanceLabel);
                ComponentMigrationSupport.ProcessInstanceSynchronizer processInstanceSynchronizer = this.componentInstanceMigrationContext.getProcessInstanceSynchronizer(sourceCompositeDn.getDN(), targetCompositeDn.getDN(), this.cubeInstance.getComponentDN().getComponentName());
                try {
                    if (processInstanceSynchronizer == null) {
                        ComponentMigrationSupport.LabelProcessInstanceSynchronizerImpl processInstanceSynchronizerImpl = new ComponentMigrationSupport.LabelProcessInstanceSynchronizerImpl(this.componentMigrationSupport, sourceCompositeDn, targetCompositeDn, this.cubeInstance.getComponentDN().getComponentName());
                        processInstanceSynchronizerImpl.build(this.componentInstanceMigrationContext);
                        processInstanceSynchronizer = processInstanceSynchronizerImpl;
                        this.componentInstanceMigrationContext.setProcessInstanceSynchronizer(sourceCompositeDn.getDN(), targetCompositeDn.getDN(), this.cubeInstance.getComponentDN().getComponentName(), processInstanceSynchronizer);
                    }
                    processInstanceSynchronizer.verify(this.componentInstanceMigrationContext, this.cubeInstance);
                    processInstanceSynchronizer.synchronize(this.componentInstanceMigrationContext, this.cubeInstance);
                }
                catch (MigrateComponentInstanceException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MigrateComponentInstanceException("failed to build process instance synchronizer.", e);
                }
                logger.info("instance state synchronized and ready to migrate.");
                logger.info("updating instance component definition...");
                cubeInstanceEO.setCompositeLabel(componentLabel);
                logger.info("instance migrated.");
                try {
                    this.getComponentMigrationSupport().notifyComponentInstanceMigrated(this.componentInstanceMigrationContext.getCubeContext(), new CompositeDN(this.cubeInstance.getComponentDN().getCompositeDN()), this.cubeInstance.getComponentName(), this.cubeInstance.getId());
                }
                catch (Exception e) {
                    throw new MigrateComponentInstanceException("failed to update instance state.", e);
                }
                if (isInstanceSuspended) {
                    logger.info("resuming instance.");
                    try {
                        this.bpmnServiceEngine.resumeInstance(this.cubeInstance.getId());
                    }
                    catch (Exception e) {
                        throw new MigrateComponentInstanceException("Can not resume instance", e);
                    }
                }
                logger.info("generating migration result for instance.");
                return new ResultInfo("", "", true);
            }
            catch (MigrateComponentInstanceException e) {
                return new ResultInfo(e.getSolutionMessage(), e.getMessage(), false);
            }
        }
    }

    public static class CheckInstanceCompatibilityBetweenRevisions
    extends ComponentInstanceMigrationAction {
        public CheckInstanceCompatibilityBetweenRevisions(ComponentInstanceMigrationContext componentInstanceMigrationContext, ComponentMigrationSupport componentMigrationSupport) {
            super(componentInstanceMigrationContext, componentMigrationSupport);
        }

        public ComponentInstanceMigrationReport execute(InstanceMigrationContext instanceMigrationContext, ComponentInstance instance, CompositeModel newRevision) throws Exception {
            return CheckInstanceCompatibilityBetweenRevisionsDelegate.getInstance().execute(this.getLogger(), this.getComponentMigrationSupport(), instance, newRevision);
        }
    }
}

