/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.CubeInstanceKey;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.data.CubeInstancePersistenceMgr;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentInstanceMigrationAction;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentInstanceMigrationContext;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ComponentMigrationSupport;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.collections.Sequence;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.fabric.composite.CompositeDN;
import oracle.fabric.composite.model.CompositeModel;
import oracle.integration.platform.blocks.migration.ComponentInstanceReportFactory;
import oracle.soa.management.facade.ComponentInstance;
import oracle.soa.management.facade.ComponentInstanceMigrationReport;
import oracle.soa.management.facade.MigrationFeasibility;

public class CheckInstanceCompatibilityBetweenRevisionsDelegate {
    private static CheckInstanceCompatibilityBetweenRevisionsDelegate ourInstance = new CheckInstanceCompatibilityBetweenRevisionsDelegate();

    private CheckInstanceCompatibilityBetweenRevisionsDelegate() {
    }

    public static CheckInstanceCompatibilityBetweenRevisionsDelegate getInstance() {
        return ourInstance;
    }

    public ComponentInstanceMigrationReport execute(Logger logger, ComponentMigrationSupport componentMigrationSupport, ComponentInstance componentInstance, CompositeModel newCompositeRevision) throws CubeException, MetadataException, WorkflowException, BPMException {
        MigrationFeasibility migrationFeasibility;
        logger.log(Level.FINE, "checking if instance is in running state...");
        String incompatibilityReason = null;
        IProcessInstance processInstance = BPMServiceLocator.getInstanceQueryService().getProcessInstance(BPMNUtility.getInternalWorkflowContext(), String.valueOf(BPMNServiceEngine.stripCubeInstanceId(componentInstance.getId())));
        if (componentInstance.getNormalizedState() != 0 || !processInstance.getSystemAttributes().getState().equals("OPEN")) {
            migrationFeasibility = MigrationFeasibility.Incompatible;
            incompatibilityReason = "instance is not in running state";
        } else {
            boolean verified;
            logger.log(Level.FINE, "checking compatibility...");
            ComponentInstanceMigrationContext componentInstanceMigrationContext = ComponentInstanceMigrationContext.create();
            logger.log(Level.FINE, "loading instance...");
            long ci = BPMNServiceEngine.stripCubeInstanceId(componentInstance.getId());
            ICubeInstanceImpl cubeInstance = CubeInstancePersistenceMgr.load((CubeInstanceKey)new CubeInstanceKey(ci), (ICubeContext)componentInstanceMigrationContext.getCubeContext());
            logger.log(Level.FINE, "instance loaded.");
            logger.log(Level.FINE, "creating process instance synchronizer...");
            ComponentMigrationSupport.RevisionProcessInstanceSynchronizerImpl revisionProcessInstanceSynchronizer = new ComponentMigrationSupport.RevisionProcessInstanceSynchronizerImpl(componentMigrationSupport, new CompositeDN(cubeInstance.getComponentDN().getCompositeDN()), new CompositeDN(newCompositeRevision.getDN()), cubeInstance.getComponentName());
            revisionProcessInstanceSynchronizer.build(componentInstanceMigrationContext);
            logger.log(Level.FINE, "verify...");
            try {
                revisionProcessInstanceSynchronizer.verify(componentInstanceMigrationContext, cubeInstance);
                verified = true;
            }
            catch (ComponentInstanceMigrationAction.MigrateComponentInstanceException e) {
                verified = false;
            }
            catch (Exception e) {
                verified = false;
            }
            logger.log(Level.FINE, "verified");
            logger.log(Level.FINE, "loading migration feasibility and incompatibility reason...");
            StringBuilder incompatibilityReasonStringBuilder = new StringBuilder();
            if (revisionProcessInstanceSynchronizer.isMigrationCompatible() || verified) {
                migrationFeasibility = MigrationFeasibility.Automatic;
                incompatibilityReason = null;
            } else if (revisionProcessInstanceSynchronizer.isMigrationRecoverable()) {
                migrationFeasibility = MigrationFeasibility.Manual;
                CheckInstanceCompatibilityBetweenRevisionsDelegate.reportDiffs(revisionProcessInstanceSynchronizer.getActivitiesInConflict(), revisionProcessInstanceSynchronizer.getAddedDataObjects(), incompatibilityReasonStringBuilder);
                incompatibilityReason = incompatibilityReasonStringBuilder.toString();
            } else {
                migrationFeasibility = MigrationFeasibility.Incompatible;
                CheckInstanceCompatibilityBetweenRevisionsDelegate.reportDiffs(revisionProcessInstanceSynchronizer.getUnrecoverableDiffs(), null, incompatibilityReasonStringBuilder);
                incompatibilityReason = incompatibilityReasonStringBuilder.toString();
            }
            logger.log(Level.FINE, "migration feasibility and incompatibility loaded.");
        }
        logger.log(Level.FINE, "migrationFeasibility " + migrationFeasibility);
        logger.log(Level.FINE, "incompatibilityReason " + incompatibilityReason);
        logger.log(Level.FINE, "creating componentInstanceMigrationReport...");
        ComponentInstanceMigrationReport componentInstanceMigrationReport = incompatibilityReason != null ? ComponentInstanceReportFactory.getInstance().create(componentInstance.getComponentName(), componentInstance.getId(), migrationFeasibility, incompatibilityReason) : ComponentInstanceReportFactory.getInstance().create(componentInstance.getComponentName(), componentInstance.getId(), migrationFeasibility);
        logger.log(Level.FINE, "componentInstanceMigrationReport created.");
        return componentInstanceMigrationReport;
    }

    private static void reportDiffs(Sequence<ComponentMigrationSupport.Diff<FlowNode>> flowNodeDiffs, Sequence<ComponentMigrationSupport.Diff<DataObject>> dataObjectDiffs, StringBuilder stringBuilder) {
        if (flowNodeDiffs != null) {
            for (ComponentMigrationSupport.Diff flowNodeDiff : flowNodeDiffs) {
                stringBuilder.append("- ");
                stringBuilder.append(flowNodeDiff.getMsg().getString());
                stringBuilder.append("\n");
                List<ComponentMigrationSupport.ActivityDiffItem> activityDiffItems = ((ComponentMigrationSupport.ActivityDiff)flowNodeDiff).getActivityDiffItems();
                for (ComponentMigrationSupport.ActivityDiffItem activityDiffItem : activityDiffItems) {
                    stringBuilder.append("\t");
                    stringBuilder.append("- ");
                    stringBuilder.append(activityDiffItem.getMsg().getString());
                    stringBuilder.append("\n");
                }
            }
        }
        if (dataObjectDiffs != null) {
            for (ComponentMigrationSupport.Diff dataObjectDiff : dataObjectDiffs) {
                stringBuilder.append("- ");
                stringBuilder.append(dataObjectDiff.getMsg().getString());
                stringBuilder.append("\n");
            }
        }
    }
}

