/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.CorrelationKey;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Variable;
import oracle.fabric.composite.CompositeDN;

public class ApplyChangesPlan {
    private int batchSize = 50;
    private boolean cancelChildComponents = true;
    private String comment;
    private List<CorrelationKey> correlationKeyUpdates = Collections.emptyList();
    private List<Variable> dataObjectUpdates;
    private Map<Activity, Activity> flowUpdates;
    private List<Variable> instanceAttributeUpdates;
    private String requester;
    private CompositeDN targetCompositeDN;
    private boolean updateInstanceToNewModel = false;
    private boolean validateVariables = true;
    private static final int DEFAULT_BATCH_SIZE = 50;

    private ApplyChangesPlan() {
    }

    public static ApplyChangesPlan create(Map<Activity, Activity> flowUpdates, List<Variable> dataObjectUpdates, List<Variable> instanceAttributeUpdates, String comment, String requester) {
        ApplyChangesPlan plan = new ApplyChangesPlan();
        plan.setFlowUpdates(flowUpdates);
        plan.setDataObjectUpdates(dataObjectUpdates);
        plan.setInstanceAttributeUpdates(instanceAttributeUpdates);
        plan.setComment(comment);
        plan.setRequester(requester);
        return plan;
    }

    public static ApplyChangesPlan create(Map<Activity, Activity> flowUpdates, String comment, String requester) {
        return ApplyChangesPlan.create(flowUpdates, null, null, comment, requester);
    }

    public static ApplyChangesPlan create(List<Variable> dataObjectUpdates, List<Variable> instanceAttributeUpdates, String comment, String requester) {
        return ApplyChangesPlan.create(null, dataObjectUpdates, instanceAttributeUpdates, comment, requester);
    }

    public boolean isUpdateInstanceToNewModel() {
        return this.updateInstanceToNewModel;
    }

    public void setUpdateInstanceToNewModel(boolean updateInstanceToNewModel) {
        this.updateInstanceToNewModel = updateInstanceToNewModel;
    }

    public Map<Activity, Activity> getFlowUpdates() {
        return Collections.unmodifiableMap(this.flowUpdates);
    }

    public List<Variable> getDataObjectUpdates() {
        return Collections.unmodifiableList(this.dataObjectUpdates);
    }

    public List<Variable> getInstanceAttributeUpdates() {
        return Collections.unmodifiableList(this.instanceAttributeUpdates);
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isValidateVariables() {
        return this.validateVariables;
    }

    public void setValidateVariables(boolean validateVariables) {
        this.validateVariables = validateVariables;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setInstanceAttributeUpdates(List<Variable> instanceAttributeUpdates) {
        this.instanceAttributeUpdates = instanceAttributeUpdates;
    }

    public List<CorrelationKey> getCorrelationKeyUpdates() {
        return this.correlationKeyUpdates;
    }

    public void setCorrelationKeyUpdates(List<CorrelationKey> correlationKeyUpdates) {
        this.correlationKeyUpdates = correlationKeyUpdates;
    }

    public CompositeDN getTargetCompositeDN() {
        return this.targetCompositeDN;
    }

    public void setTargetCompositeDN(CompositeDN targetCompositeDN) {
        this.targetCompositeDN = targetCompositeDN;
    }

    public boolean isCancelChildComponents() {
        return this.cancelChildComponents;
    }

    public void setCancelChildComponents(boolean cancelChildComponents) {
        this.cancelChildComponents = cancelChildComponents;
    }

    public String getRequester() {
        return this.requester;
    }

    public void setRequester(String requester) {
        this.requester = requester;
    }

    private void setFlowUpdates(Map<Activity, Activity> flowUpdates) {
        this.flowUpdates = flowUpdates;
    }

    private void setDataObjectUpdates(List<Variable> dataObjectUpdates) {
        this.dataObjectUpdates = dataObjectUpdates;
    }

    private void setComment(String comment) {
        this.comment = comment;
    }
}

