/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ActivityNotFoundException;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.FlowNodeToRuntimeModelMapper;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.Draftable;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;

public class AlterFlowModel {
    private final Map<String, NodeLevel> activitiesToLevels = new HashMap<String, NodeLevel>();
    private Map<String, GatewayRefCount> gwRefCounts = new HashMap<String, GatewayRefCount>();
    private Stack<ParsingContext> levelStack = new Stack();
    private final Map<NodeLevel, List<NodeDescription>> levelsToFlowElements = new HashMap<NodeLevel, List<NodeDescription>>();
    private int nextLevel = 0;
    private final Map<NodeDescription, NodeLevel> nodeDescriptionToLevels = new HashMap<NodeDescription, NodeLevel>();
    private Process processModel;
    private FlowNodeToRuntimeModelMapper runtimeMapper;
    private Map<String, Integer> traversedNodes = new HashMap<String, Integer>();
    private Set<String> visitedNodes = new TreeSet<String>();

    private AlterFlowModel() {
    }

    public static AlterFlowModel create(Process process, FlowNodeToRuntimeModelMapper mapper) {
        AlterFlowModel result = new AlterFlowModel();
        result.setProcessModel(process);
        result.setRuntimeMapper(mapper);
        result.traverseModel(process);
        return result;
    }

    public static boolean compareStack(List<FlowElement> stack, List<FlowElement> stackInOtherModel) {
        if (stack == stackInOtherModel) {
            return true;
        }
        ListIterator<FlowElement> e1 = stack.listIterator();
        ListIterator<FlowElement> e2 = stackInOtherModel.listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            FlowElement o1 = e1.next();
            FlowElement o2 = e2.next();
            assert (o1 != null);
            assert (o2 != null);
            if (o1.getId().equals(o2.getId())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public boolean hasSameLevel(String uniqueActivityId, AlterFlowModel otherModel, String otherUniqueActivityId) throws ActivityNotFoundException {
        NodeLevel level1 = this.getLevelForActivity(uniqueActivityId);
        NodeLevel level2 = otherModel.getLevelForActivity(otherUniqueActivityId);
        return level1.equals(level2);
    }

    public boolean hasSameLevel(String uniqueActivityId, String otherUniqueActivityId) throws ActivityNotFoundException {
        NodeLevel level1 = this.getLevelForActivity(uniqueActivityId);
        NodeLevel level2 = this.getLevelForActivity(otherUniqueActivityId);
        return level1.equals(level2);
    }

    public Sequence<FlowNode> getValidTargets(String uniqueActivityId, AlterFlowModel otherModel) throws ActivityNotFoundException {
        NodeLevel nodeLevel = this.getLevelForActivity(uniqueActivityId);
        List<NodeDescription> validTargets = otherModel.getLevelsToFlowElements().get(nodeLevel);
        Sequence result = CollectionUtils.map(validTargets, (Function)new Function<NodeDescription, FlowNode>(){

            public FlowNode eval(NodeDescription value) {
                return value.node;
            }
        });
        return result;
    }

    public Sequence<FlowElement> getActivityLevelStack(String processId, String nodeId) throws ActivityNotFoundException {
        return this.getActivityLevelStack(this.getRuntimeMapper().getRuntimeId(processId, nodeId));
    }

    public Sequence<FlowElement> getActivityLevelStack(String uniqueActivityId) throws ActivityNotFoundException {
        NodeLevel nodeLevel = this.getLevelForActivity(uniqueActivityId);
        return CollectionUtils.asSequence(nodeLevel.getStack());
    }

    public List<FlowElement> getActivityLevelList(String uniqueActivityId) throws ActivityNotFoundException {
        NodeLevel nodeLevel = this.getLevelForActivity(uniqueActivityId);
        return nodeLevel.getStack();
    }

    public Set<LevelStackDiff> compareActivityLevelStack(AlterFlowModel otherModel) {
        HashSet<LevelStackDiff> result = new HashSet<LevelStackDiff>();
        for (Map.Entry<String, NodeLevel> entry : this.activitiesToLevels.entrySet()) {
            String uniqueSourceId = entry.getKey();
            NodeLevel nodeLevel = entry.getValue();
            try {
                List<FlowElement> stackInOtherModel = otherModel.getLevelForActivity(uniqueSourceId).getStack();
                if (AlterFlowModel.compareStack(nodeLevel.getStack(), stackInOtherModel)) continue;
                result.add(new LevelStackDiff((FlowElement)nodeLevel.getFlowNode(), LevelStackDiffType.CHANGED, uniqueSourceId));
            }
            catch (ActivityNotFoundException e) {
                result.add(new LevelStackDiff((FlowElement)nodeLevel.getFlowNode(), LevelStackDiffType.DELETED, uniqueSourceId));
            }
        }
        return result;
    }

    public Map<NodeLevel, List<NodeDescription>> getLevelsToFlowElements() {
        return Collections.unmodifiableMap(this.levelsToFlowElements);
    }

    public Map<NodeDescription, NodeLevel> getNodeDescriptionToLevels() {
        return Collections.unmodifiableMap(this.nodeDescriptionToLevels);
    }

    public NodeLevel getLevelForActivity(String uniqueFlowNodeId) throws ActivityNotFoundException {
        NodeLevel nodeLevel = this.activitiesToLevels.get(uniqueFlowNodeId);
        if (nodeLevel == null) {
            throw new ActivityNotFoundException(uniqueFlowNodeId);
        }
        return nodeLevel;
    }

    public void setRuntimeMapper(FlowNodeToRuntimeModelMapper runtimeMapper) {
        this.runtimeMapper = runtimeMapper;
    }

    public FlowNodeToRuntimeModelMapper getRuntimeMapper() {
        return this.runtimeMapper;
    }

    public void setProcessModel(Process processModel) {
        this.processModel = processModel;
    }

    public Process getProcessModel() {
        return this.processModel;
    }

    private static void printLevels(Map<NodeLevel, List<NodeDescription>> map) {
        for (NodeLevel nodeLevel : map.keySet()) {
            List<NodeDescription> values = map.get(nodeLevel);
            System.out.println("Level: " + nodeLevel.getLevelMarker().getLabel(Locale.getDefault()));
            for (NodeDescription value : values) {
                System.out.println("\t\t" + value.name + " - " + value.id);
            }
        }
    }

    private static List<FlowElement> createActivityLevelStack(Stack<ParsingContext> levelStack, FlowNode flowNode) {
        ArrayList<FlowElement> result = new ArrayList<FlowElement>();
        for (int i = 0; i < levelStack.size(); ++i) {
            result.add(i, ((ParsingContext)levelStack.get((int)i)).flowElementMarker);
        }
        result.add((FlowElement)flowNode);
        return result;
    }

    private int getNextLevel() {
        return ++this.nextLevel;
    }

    private void traverseModel(Process process) {
        this.levelStack.push(this.createContext(this.getNextLevel(), (FlowElement)process));
        this.traverseFromStart((NodeContainer)process);
        this.levelStack.pop();
    }

    private void traverseFromStart(NodeContainer container) {
        for (FlowNode flowNode : ModelUtils.getStartNodes((NodeContainer)container)) {
            this.levelStack.push(this.createContext(this.getNextLevel(), (FlowElement)flowNode));
            this.visitNode(flowNode);
            this.levelStack.pop();
            this.traverse(flowNode);
        }
        this.traverseEventSubprocesses(container);
    }

    private ParsingContext createContext(int level, FlowElement flowElementMarker) {
        return this.createContext(level, null, flowElementMarker);
    }

    private void traverseEventSubprocesses(NodeContainer container) {
        for (Subprocess eventSubprocess : this.getEventSubprocesses(container)) {
            this.levelStack.push(this.createContext(this.getNextLevel(), (FlowElement)eventSubprocess));
            this.traverse(eventSubprocess, false);
            this.levelStack.pop();
        }
    }

    private Sequence<Subprocess> getEventSubprocesses(NodeContainer container) {
        return container.getActivities(Subprocess.class).select((Predicate)new Predicate<Subprocess>(){

            public boolean check(Subprocess value) {
                return value != null && value.isTriggeredByEvent();
            }
        });
    }

    private void traverse(FlowNode flowNode) {
        GatewayRefCount reference;
        this.visitNode(flowNode);
        boolean result = this.traverseTargets(flowNode);
        if ((flowNode.getOutgoingSequenceFlows().isEmpty() || result) && (reference = this.levelStack.peek().gRefCount) != null) {
            this.decRefCount(reference.id);
            if (this.getRefCount(reference.gReference) <= 0) {
                this.traverse(reference.gReference);
            }
        }
        this.traverseBoundaryEvents(flowNode);
    }

    private boolean traverseTargets(FlowNode flowNode) {
        boolean mustDecRefcount = false;
        int outgoingSequenceFlowLength = flowNode.getOutgoingSequenceFlows().toArray().length;
        BpmnType bpmnType = flowNode.getBpmnType();
        ParsingContext context = this.levelStack.peek();
        Activity activity = (Activity)flowNode.asAnyNode(Activity.class);
        boolean hasInterruptingBoundaryEvents = false;
        if (activity != null) {
            for (BoundaryEvent event : activity.getActivityBoundaryEvents()) {
                if (!event.cancelActivity()) continue;
                ++outgoingSequenceFlowLength;
                hasInterruptingBoundaryEvents = true;
            }
        }
        if (context.gRefCount != null && (!bpmnType.isGateway() && outgoingSequenceFlowLength > 1 || bpmnType == BpmnType.EXCLUSIVE_GATEWAY || hasInterruptingBoundaryEvents)) {
            context.gRefCount.referenceCount += outgoingSequenceFlowLength - 1;
        }
        for (SequenceFlow sequenceFlow : flowNode.getOutgoingSequenceFlows()) {
            FlowNode target = sequenceFlow.getTarget();
            String uniqueFlowNodeId = this.getUniqueFlowNodeId((FlowElement)target);
            boolean traversed = this.wasNodeTraversed(uniqueFlowNodeId);
            if (target.isGateway() && this.isConvergingGateway(((Gateway)target).getDirection())) {
                this.traverseNodeByType(target);
                continue;
            }
            if (!traversed) {
                int incomingSequenceFlowLength = target.getIncomingSequenceFlows().toArray().length;
                this.traverseNode(uniqueFlowNodeId, incomingSequenceFlowLength);
                this.traverseNodeByType(target);
                continue;
            }
            if (context.gRefCount == null) continue;
            mustDecRefcount = true;
        }
        return mustDecRefcount;
    }

    private void traverseNode(String uniqueFlowNodeId, int incomingSequenceFlowLength) {
        Integer refCount = this.traversedNodes.get(uniqueFlowNodeId);
        if (refCount == null) {
            this.traversedNodes.put(uniqueFlowNodeId, incomingSequenceFlowLength - 1);
        } else {
            this.traversedNodes.put(uniqueFlowNodeId, refCount - 1);
        }
    }

    private boolean wasNodeTraversed(String uniqueFlowNodeId) {
        Integer refCount = this.traversedNodes.get(uniqueFlowNodeId);
        return refCount != null && refCount <= 0;
    }

    private void traverseNodeByType(FlowNode target) {
        if (target.isDraftable() && ((Draftable)target.asAnyNode(Draftable.class)).isDraft()) {
            this.traverse(target);
            return;
        }
        switch (target.getBpmnType()) {
            case CALL_ACTIVITY: {
                this.traverse((CallActivity)target);
                break;
            }
            case SUBPROCESS: {
                this.traverse((Subprocess)target);
                break;
            }
            case EXCLUSIVE_GATEWAY: {
                this.traverseExclusiveGateway((Gateway)target);
                break;
            }
            case EVENT_BASED_GATEWAY: {
                this.traverseEventBasedGateway((Gateway)target);
                break;
            }
            case PARALLEL_GATEWAY: 
            case INCLUSIVE_GATEWAY: 
            case COMPLEX_GATEWAY: {
                this.traverse((Gateway)target);
                break;
            }
            default: {
                this.traverse(target);
            }
        }
    }

    private void traverseBoundaryEvents(FlowNode flowNode) {
        Activity activity = (Activity)flowNode.asAnyNode(Activity.class);
        if (activity != null) {
            for (BoundaryEvent boundaryEvent : activity.getActivityBoundaryEvents()) {
                ParsingContext context = this.levelStack.peek();
                if (context.gRefCount != null) {
                    ++context.gRefCount.referenceCount;
                }
                this.levelStack.push(this.createContext(this.getNextLevel(), context.gRefCount, (FlowElement)boundaryEvent));
                this.markVisited((FlowNode)boundaryEvent);
                this.levelStack.pop();
                if (!boundaryEvent.cancelActivity()) {
                    this.levelStack.push(this.createContext(this.getNextLevel(), context.gRefCount, (FlowElement)boundaryEvent));
                    this.traverse((FlowNode)boundaryEvent);
                    this.levelStack.pop();
                    continue;
                }
                this.traverse((FlowNode)boundaryEvent);
            }
        }
    }

    private void traverse(CallActivity callActivity) {
        this.visitNode((FlowNode)callActivity);
        this.traverseModel(callActivity.getCalledElement());
        this.traverseTargets((FlowNode)callActivity);
    }

    private void traverse(Subprocess subprocess) {
        this.traverse(subprocess, true);
    }

    private void traverse(Subprocess subprocess, boolean visitNode) {
        if (visitNode) {
            this.visitNode((FlowNode)subprocess);
        }
        this.levelStack.push(this.createContext(this.getNextLevel(), (FlowElement)subprocess));
        this.traverseFromStart((NodeContainer)subprocess);
        this.levelStack.pop();
        this.traverseBoundaryEvents((FlowNode)subprocess);
        this.traverseTargets((FlowNode)subprocess);
    }

    private void traverse(Gateway gateway) {
        GatewayDirection direction = gateway.getDirection();
        if (this.isConvergingGateway(direction)) {
            this.decRefCount(gateway);
            if (this.getRefCount(gateway) > 0) {
                return;
            }
            this.visitNode((FlowNode)gateway);
            this.levelStack.pop();
        }
        this.visitNode((FlowNode)gateway);
        if (this.isDivergingGateway(direction)) {
            SequenceFlow[] sequenceFlows = (SequenceFlow[])gateway.getOutgoingSequenceFlows().toArray((Object[])new SequenceFlow[0]);
            GatewayRefCount reference = this.createGatewayRefCount(gateway, sequenceFlows.length);
            int nextLevel = this.getNextLevel();
            this.levelStack.push(this.createContext(nextLevel, reference, (FlowElement)gateway));
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                this.traverseNodeByType(sequenceFlow.getTarget());
            }
        } else {
            ParsingContext context = this.levelStack.peek();
            if (context.gRefCount != null) {
                int outgoingSequenceFlowLength = gateway.getOutgoingSequenceFlows().toArray().length;
                context.gRefCount.referenceCount += outgoingSequenceFlowLength - 1;
            }
            for (SequenceFlow sequenceFlow : gateway.getOutgoingSequenceFlows()) {
                this.traverseNodeByType(sequenceFlow.getTarget());
            }
        }
    }

    private void traverseEventBasedGateway(Gateway gateway) {
        this.visitNode((FlowNode)gateway);
        Sequence sequenceFlows = gateway.getOutgoingSequenceFlows();
        int actualLevel = this.getNextLevel();
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            this.levelStack.push(this.createContext(actualLevel, (FlowElement)sequenceFlow.getTarget()));
            this.visitNode(sequenceFlow.getTarget());
            this.levelStack.pop();
            this.traverse(sequenceFlow.getTarget());
        }
    }

    private void traverseExclusiveGateway(Gateway gateway) {
        this.traverse((FlowNode)gateway);
    }

    private boolean isConvergingGateway(GatewayDirection direction) {
        return direction == GatewayDirection.CONVERGING || direction == GatewayDirection.MIXED;
    }

    private boolean isDivergingGateway(GatewayDirection direction) {
        return direction == GatewayDirection.DIVERGING || direction == GatewayDirection.MIXED;
    }

    private GatewayRefCount createGatewayRefCount(Gateway gateway, int refCount) {
        Gateway mergingGateway = gateway.getMergingGateway();
        GatewayRefCount count = new GatewayRefCount();
        count.id = this.getFullQualifiedId((FlowElement)mergingGateway);
        count.referenceCount = refCount;
        count.gReference = mergingGateway;
        this.gwRefCounts.put(count.id, count);
        return count;
    }

    private void incRefCount(Gateway gateway) {
        ++this.gwRefCounts.get((Object)this.getFullQualifiedId((FlowElement)gateway)).referenceCount;
    }

    private int getRefCount(Gateway gateway) {
        return this.gwRefCounts.get((Object)this.getFullQualifiedId((FlowElement)gateway)).referenceCount;
    }

    private boolean decRefCount(Gateway gateway) {
        return this.decRefCount(this.getFullQualifiedId((FlowElement)gateway));
    }

    private boolean decRefCount(String fqid) {
        return --this.gwRefCounts.get((Object)fqid).referenceCount == 0;
    }

    private NodeLevel createNodeLevel(FlowNode flowNode) {
        ParsingContext context = this.levelStack.peek();
        return new NodeLevel(context.level, context.flowElementMarker, flowNode, AlterFlowModel.createActivityLevelStack(this.levelStack, flowNode));
    }

    private void markVisited(FlowNode flowNode) {
        String uniqueFlowNodeId = this.getUniqueFlowNodeId((FlowElement)flowNode);
        this.visitedNodes.add(uniqueFlowNodeId);
    }

    private void visitNode(FlowNode flowNode) {
        String uniqueFlowNodeId = this.getUniqueFlowNodeId((FlowElement)flowNode);
        boolean visited = this.visitedNodes.contains(uniqueFlowNodeId);
        if (!visited) {
            this.visitedNodes.add(uniqueFlowNodeId);
            NodeDescription nodeDescription = this.createNodeDescription(flowNode);
            NodeLevel nodeLevel = this.createNodeLevel(flowNode);
            Object previous = this.nodeDescriptionToLevels.put(nodeDescription, nodeLevel);
            assert (previous == null);
            previous = this.activitiesToLevels.put(uniqueFlowNodeId, nodeLevel);
            assert (previous == null);
            List<NodeDescription> values = this.levelsToFlowElements.get(nodeLevel);
            if (values == null) {
                values = new ArrayList<NodeDescription>(100);
                previous = this.levelsToFlowElements.put(nodeLevel, values);
                assert (previous == null);
            }
            values.add(nodeDescription);
        }
    }

    private String getUniqueFlowNodeId(FlowElement flowNode) {
        try {
            return this.getRuntimeMapper().getRuntimeId(flowNode);
        }
        catch (ActivityNotFoundException e) {
            assert (false);
            throw new RuntimeException(e);
        }
    }

    private NodeDescription createNodeDescription(FlowNode flowNode) {
        return new NodeDescription(flowNode);
    }

    private String getFullQualifiedId(FlowElement flowNode) {
        StringBuilder result = new StringBuilder(flowNode.getId());
        Process process = flowNode.getProcess();
        for (ProjectObject parent = flowNode.getParentObject(); parent != null && parent != process; parent = parent.getParentObject()) {
            result.insert(0, ".").insert(0, parent.getId());
        }
        return result.toString();
    }

    private ParsingContext createContext(int level, GatewayRefCount ref, FlowElement flowElementMarker) {
        ParsingContext context = new ParsingContext();
        context.level = level;
        context.gRefCount = ref;
        context.flowElementMarker = flowElementMarker;
        return context;
    }

    private class NodeDescription {
        private String id;
        private String name;
        private FlowNode node;
        private String nodeId;
        private String parentid;
        private String parentName;

        private NodeDescription(FlowNode node) {
            this.node = node;
            this.nodeId = node.getId();
            this.id = AlterFlowModel.this.getFullQualifiedId((FlowElement)node);
            this.name = node.getLabel(Locale.getDefault());
            this.parentid = AlterFlowModel.this.getFullQualifiedId((FlowElement)node.getParentObject());
            this.parentName = node.getParentObject().getLabel(Locale.getDefault());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeDescription that = (NodeDescription)o;
            return this.nodeId.equals(that.nodeId);
        }

        public int hashCode() {
            return this.nodeId.hashCode();
        }

        public String toString() {
            return "NodeDescription{nodeId='" + this.nodeId + '\'' + '}';
        }
    }

    private class Level {
        private int level;
        private FlowElement levelMarker;

        protected Level(int level, FlowElement levelMarker) {
            this.level = level;
            this.levelMarker = levelMarker;
        }

        public int getLevel() {
            return this.level;
        }

        public FlowElement getLevelMarker() {
            return this.levelMarker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Level level = (Level)o;
            return this.levelMarker.getId().equals(level.levelMarker.getId());
        }

        public int hashCode() {
            return this.levelMarker.getId().hashCode();
        }

        public String toString() {
            return "NodeLevel{level=" + this.level + ", levelMarker=" + this.levelMarker + '}';
        }
    }

    private static class ParsingContext {
        public FlowElement flowElementMarker;
        GatewayRefCount gRefCount;
        int level;

        private ParsingContext() {
        }

        public ParsingContext clone(int newLevel) {
            ParsingContext context = new ParsingContext();
            context.gRefCount = this.gRefCount;
            context.level = newLevel;
            context.flowElementMarker = this.flowElementMarker;
            return context;
        }

        public String toString() {
            return String.valueOf(this.level) + (this.gRefCount != null ? ",gw=" + this.gRefCount.gReference.getLabel(Locale.getDefault()) + ",refCount=" + this.gRefCount.referenceCount : "") + ",marker=" + this.flowElementMarker.getLabel(Locale.getDefault());
        }
    }

    private static class GatewayRefCount {
        Gateway gReference;
        String id;
        int referenceCount;

        private GatewayRefCount() {
        }
    }

    public class NodeLevel
    extends Level {
        private final FlowNode flowNode;
        private final List<FlowElement> stack;

        protected NodeLevel(int level, FlowElement levelMarker, FlowNode flowNode, List<FlowElement> stack) {
            super(level, levelMarker);
            this.flowNode = flowNode;
            this.stack = stack;
        }

        public FlowNode getFlowNode() {
            return this.flowNode;
        }

        public List<FlowElement> getStack() {
            return this.stack;
        }
    }

    public static class LevelStackDiff {
        private FlowElement element;
        private String sourceUniqueId;
        private LevelStackDiffType type;

        public LevelStackDiff(FlowElement element, LevelStackDiffType type, String sourceUniqueId) {
            this.element = element;
            this.type = type;
            this.sourceUniqueId = sourceUniqueId;
        }

        public FlowElement getElement() {
            return this.element;
        }

        public LevelStackDiffType getType() {
            return this.type;
        }

        public String getSourceUniqueId() {
            return this.sourceUniqueId;
        }
    }

    public static enum LevelStackDiffType {
        DELETED,
        CHANGED;

    }
}

