/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.Scope;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Activity;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.InstanceManipulationHelper;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ProcessInstance;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.Tuple3;

public class ActivityPath
implements Serializable,
Iterable<Tuple3<String, Activity, ProcessInstance>> {
    private List<String> absoluteScopeIdsPath = new ArrayList<String>();
    private List<Activity> activitiesPath = new ArrayList<Activity>();
    private List<ProcessInstance> processInstancesPath = new ArrayList<ProcessInstance>();
    private static final long serialVersionUID = -6881399840461955724L;

    private ActivityPath() {
    }

    public static ActivityPath create(ICubeInstanceImpl instance, List<Scope> scopesPath, Locale locale) throws CubeException {
        ActivityPath path = new ActivityPath();
        for (Scope scope : scopesPath) {
            InstanceManipulationHelper helper = InstanceManipulationHelper.getInstance();
            Activity activity = helper.getScopeActivity(scope, locale);
            ProcessInstance processInstance = helper.getProcessInstance(instance, scope);
            ActivityPath.addNode(path, scope.getAbsoluteScopeId(), activity, processInstance);
        }
        return path;
    }

    public static void addNode(ActivityPath path, String absoluteScopeId, Activity activity, ProcessInstance processInstance) {
        path.absoluteScopeIdsPath.add(absoluteScopeId);
        path.activitiesPath.add(activity);
        path.processInstancesPath.add(processInstance);
    }

    public List<ProcessInstance> getProcessInstancesPath() {
        return this.processInstancesPath;
    }

    public List<String> getAbsoluteScopeIdsPath() {
        return this.absoluteScopeIdsPath;
    }

    public List<Activity> getActivitiesPath() {
        return this.activitiesPath;
    }

    public int getPathLength() {
        return this.activitiesPath.size();
    }

    @Override
    public Iterator<Tuple3<String, Activity, ProcessInstance>> iterator() {
        return new LocationIterator();
    }

    private class LocationIterator
    implements Iterator<Tuple3<String, Activity, ProcessInstance>> {
        int cursor = 0;

        private LocationIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ActivityPath.this.absoluteScopeIdsPath.size();
        }

        @Override
        public Tuple3<String, Activity, ProcessInstance> next() {
            Activity activity = (Activity)ActivityPath.this.activitiesPath.get(this.cursor);
            String absoluteScopeId = (String)ActivityPath.this.absoluteScopeIdsPath.get(this.cursor);
            ProcessInstance instance = (ProcessInstance)ActivityPath.this.processInstancesPath.get(this.cursor);
            ++this.cursor;
            return Tuple.create((Object)absoluteScopeId, (Object)activity, (Object)instance);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

