/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.instancehandling;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.ActivityPath;
import oracle.bpm.bpmn.engine.model.runtime.instancehandling.Variable;

public class Activity
implements Serializable {
    private String absoluteScopeId;
    private Set<Variable> attributes;
    private String displayName;
    private String id;
    private Boolean isContainer;
    private Boolean isEventSubProcess;
    private String mapElementId;
    private ActivityPath path;
    private String processId;
    private String workItemKeyURI;
    private static final long serialVersionUID = 6344841463500604703L;

    private Activity(String processId, String id, String displayName, ActivityPath path, Boolean isContainer, Boolean isEventSubProcess) {
        this.processId = processId;
        this.id = id;
        this.displayName = displayName;
        this.path = path;
        this.isContainer = isContainer;
        this.isEventSubProcess = isEventSubProcess;
        this.attributes = Collections.emptySet();
    }

    public static Activity createContainer(String processId, String activityId, String displayName, ActivityPath path, Boolean isEventSubProcess) {
        return new Activity(processId, activityId, displayName, path, true, isEventSubProcess);
    }

    public static Activity create(String processId, String activityId, String displayName, ActivityPath path) {
        return new Activity(processId, activityId, displayName, path, false, false);
    }

    public static Activity create(String processId, String activityId, String displayName) {
        return new Activity(processId, activityId, displayName, null, false, false);
    }

    public static Activity create(String processId, String activityId) {
        return new Activity(processId, activityId, null, null, false, false);
    }

    public String getId() {
        return this.id;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ActivityPath getPath() {
        return this.path;
    }

    public Boolean isContainer() {
        return this.isContainer;
    }

    public String toString() {
        return "Activity{id='" + this.id + '\'' + ", processId='" + this.processId + '\'' + ", displayName='" + this.displayName + '\'' + '}';
    }

    public Set<Variable> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<Variable> attributes) {
        this.attributes = attributes;
    }

    public Boolean isEventSubProcess() {
        return this.isEventSubProcess;
    }

    public String getAbsoluteScopeId() {
        return this.absoluteScopeId;
    }

    public void setAbsoluteScopeId(String absoluteScopeId) {
        this.absoluteScopeId = absoluteScopeId;
    }

    public String getMapElementId() {
        return this.mapElementId;
    }

    public void setMapElementId(String mapElementId) {
        this.mapElementId = mapElementId;
    }

    public String getWorkItemKeyURI() {
        return this.workItemKeyURI;
    }

    public void setWorkItemKeyURI(String workItemKeyURI) {
        this.workItemKeyURI = workItemKeyURI;
    }
}

