/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.model.runtime.CharacteristicsRuntimeHelper;
import oracle.bpm.bpmn.engine.model.runtime.InstanceAttributeSupport;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathUtil;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultiInstanceRuntimeHelper
extends CharacteristicsRuntimeHelper<MultiInstance> {
    private InstanceAttributeSupport<Boolean> completionConditionInstanceAttribute;
    private InstanceAttributeSupport<XMLDocument> inputDataItemInstanceAttribute;
    private InstanceAttributeSupport<Integer> loopCounterInstanceAttribute;
    private InstanceAttributeSupport<List<Node>> loopDataInputInstanceAttribute;
    private InstanceAttributeSupport<List<Node>> loopDataOutputInstanceAttribute;
    private InstanceAttributeSupport<Integer> numberOfActiveInstancesInstanceAttribute;
    private InstanceAttributeSupport<Integer> numberOfCompletedInstancesInstanceAttribute;
    private InstanceAttributeSupport<Integer> numberOfInstancesInstanceAttribute;
    private InstanceAttributeSupport<Integer> numberOfTerminatedInstancesInstanceAttribute;
    private InstanceAttributeSupport<XMLDocument> outputDataItemInstanceAttribute;
    public static final QName COMPLETIONCONDITIONSIGNAL = new QName("http://www.omg.org/bpmn20/runtime", "completionConditionSignal");

    public MultiInstanceRuntimeHelper(FlowNode flowNode, MultiInstance characteristics) {
        super(flowNode, characteristics);
        this.loopCounterInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.LOOP_COUNTER);
        this.numberOfInstancesInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.NUMBER_OF_INSTANCES);
        this.numberOfActiveInstancesInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.NUMBER_OF_ACTIVE_INSTANCES);
        this.numberOfCompletedInstancesInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.NUMBER_OF_COMPLETED_INSTANCES);
        this.numberOfTerminatedInstancesInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.NUMBER_OF_TERMINATED_INSTANCES);
        this.inputDataItemInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.INPUT_DATAITEM);
        this.outputDataItemInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.OUTPUT_DATAITEM);
        this.loopDataInputInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.LOOP_DATAINPUT);
        this.loopDataOutputInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.LOOP_DATAOUTPUT);
        this.completionConditionInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.COMPLETION_CONDITION);
    }

    public boolean isSequential() {
        return ((MultiInstance)this.getCharacteristics()).isSequential();
    }

    public boolean isParallel() {
        return !this.isSequential();
    }

    public InstanceAttributeSupport<Integer> getLoopCounterInstanceAttribute() {
        return this.loopCounterInstanceAttribute;
    }

    public InstanceAttributeSupport<Integer> getNumberOfInstancesInstanceAttribute() {
        return this.numberOfInstancesInstanceAttribute;
    }

    public InstanceAttributeSupport<Integer> getNumberOfActiveInstancesInstanceAttribute() {
        return this.numberOfActiveInstancesInstanceAttribute;
    }

    public InstanceAttributeSupport<Integer> getNumberOfCompletedInstancesInstanceAttribute() {
        return this.numberOfCompletedInstancesInstanceAttribute;
    }

    public InstanceAttributeSupport<Integer> getNumberOfTerminatedInstancesInstanceAttribute() {
        return this.numberOfTerminatedInstancesInstanceAttribute;
    }

    public InstanceAttributeSupport<XMLDocument> getInputDataItemInstanceAttribute() {
        return this.inputDataItemInstanceAttribute;
    }

    public InstanceAttributeSupport<XMLDocument> getOutputDataItemInstanceAttribute() {
        return this.outputDataItemInstanceAttribute;
    }

    public InstanceAttributeSupport<List<Node>> getLoopDataInputInstanceAttribute() {
        return this.loopDataInputInstanceAttribute;
    }

    public InstanceAttributeSupport<List<Node>> getLoopDataOutputInstanceAttribute() {
        return this.loopDataOutputInstanceAttribute;
    }

    public InstanceAttributeSupport<Boolean> getCompletionConditionInstanceAttribute() {
        return this.completionConditionInstanceAttribute;
    }

    public SchemaObject getInputDataItemSchemaObject() {
        return this.getArrayElementSchemaObject(((MultiInstance)this.getCharacteristics()).getLoopDataInput().getType());
    }

    public SchemaObject getOutputDataItemSchemaObject() {
        return this.getArrayElementSchemaObject(((MultiInstance)this.getCharacteristics()).getLoopDataOutput().getType());
    }

    public int evaluateLoopCardinality(IScope iScope, ICubeContext iCubeContext) throws CubeException {
        Expression loopCardinalityExpression = ((MultiInstance)this.getCharacteristics()).getLoopCardinality();
        BPMNExpressionMetadata bpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, loopCardinalityExpression.getExpressionValue(), BPMNExpressionLanguage.XPATH, loopCardinalityExpression.getNamespaces());
        BPMNExpression bpmnExpression = BPMNExpression.createBPMNExpression(this.getFlowNode(), bpmnExpressionMetadata, iScope);
        Number number = bpmnExpression.evaluateNumber(iScope, iCubeContext);
        return number.intValue();
    }

    public boolean evaluateCompletionCondition(IScope iScope, ICubeContext iCubeContext) throws CubeException {
        Expression completionCondition = ((MultiInstance)this.getCharacteristics()).getCompletionCondition();
        BPMNExpressionMetadata bpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, completionCondition.getExpressionValue(), BPMNExpressionLanguage.XPATH, completionCondition.getNamespaces());
        BPMNExpression bpmnExpression = BPMNExpression.createBPMNExpression(this.getFlowNode(), bpmnExpressionMetadata, iScope);
        return bpmnExpression.evaluateBoolean(iScope, iCubeContext);
    }

    public void declareAndSetLoopDataInput(IWorkItem iWorkItem, IScope iScope, ICubeContext iCubeContext) throws CubeException {
        this.logDebug(iWorkItem, "Executing declare and set loop data input value...");
        String loopDataInputRef = ((MultiInstance)this.getCharacteristics()).getLoopDataInput().getName();
        this.logDebug(iWorkItem, "loopDataInputRef: " + loopDataInputRef);
        if (loopDataInputRef != null) {
            List<Node> loopDataInputValue = null;
            if (this.getFlowNode() instanceof InputDataAssociationEnabled) {
                InputDataAssociationEnabled inputDataAssociationEnabled = (InputDataAssociationEnabled)this.getFlowNode();
                DataAssociationSet dataAssociationSet = inputDataAssociationEnabled.getInputDataAssociationSet();
                Sequence dataAssociations = dataAssociationSet.getDataAssignments();
                this.logDebug(iWorkItem, "searching for source expression for " + loopDataInputRef + "...");
                for (DataAssignment dataAssignment : dataAssociations) {
                    this.logDebug(iWorkItem, "dataAssociation: " + dataAssignment);
                    if (!dataAssignment.getTarget().getRefs().contains((Object)loopDataInputRef)) continue;
                    this.logDebug(iWorkItem, "dataAssociation found.");
                    BPMNExpressionMetadata sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)dataAssignment.getSource().getRefs(), dataAssignment.getSource().getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, dataAssignment.getSource().getExpression().getNamespaces());
                    BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(this.getFlowNode(), sourceBpmnExpressionMetadata, iScope);
                    this.logDebug(iWorkItem, "evaluating source expression: '" + dataAssignment.getSource().getExpression().getExpressionValue() + "'");
                    loopDataInputValue = BPMNXPathUtil.convNodeListToList(sourceBPMNExpression.evaluateNodeList(iScope, iCubeContext), iScope, iCubeContext);
                    this.logDebug(iWorkItem, "value obtained is: '" + loopDataInputValue);
                    break;
                }
            }
            if (loopDataInputValue != null) {
                this.logDebug(iWorkItem, "declaring loop data Input");
                this.logDebug(iWorkItem, "loop data Input #= " + loopDataInputValue.size());
                this.getLoopDataInputInstanceAttribute().declareAndSet(iScope, iCubeContext, loopDataInputValue);
                Expression loopCardinalityExpression = ((MultiInstance)this.getCharacteristics()).getLoopCardinality();
                this.logDebug(iWorkItem, "loopCardinalityExpression: " + loopCardinalityExpression);
                this.logDebug(iWorkItem, "loopDataInputValue instanceof NodeList: " + (loopDataInputValue instanceof NodeList));
            } else {
                this.logDebug(iWorkItem, "failed to calculate loop data input value.");
                throw new CubeException((Throwable)new IllegalArgumentException("Failed to resolve multi-instance loopDataInput value for activity. " + this.getFlowNode().getName()));
            }
        }
    }

    public void declareAndSetLoopDataOutputValue(IWorkItem iWorkItem, IScope iScope, ICubeContext iCubeContext) throws CubeException {
        this.logDebug(iWorkItem, "Executing declare and set loop data output value...");
        Integer numberOfInstancesAttribute = this.getNumberOfInstancesInstanceAttribute().getValue(iScope, iCubeContext);
        this.logDebug(iWorkItem, "numberOfInstanceAttribute: " + numberOfInstancesAttribute);
        SchemaObject outputDataItemSchemaObject = this.getOutputDataItemSchemaObject();
        ArrayList<XMLElement> list = new ArrayList<XMLElement>();
        for (int i = 0; i < numberOfInstancesAttribute; ++i) {
            XMLElement xmlElement = (XMLElement)DataHandlingUtils.createRootElement("outputDataItem", outputDataItemSchemaObject, iCubeContext);
            xmlElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
            list.add(xmlElement);
        }
        this.getLoopDataOutputInstanceAttribute().declareAndSet(iScope, iCubeContext, list);
    }

    public void publishDataOutput(IScope iScope, ICubeContext iCubeContext, IWorkItem iWorkItem) throws CubeException {
        List<Node> loopDataOutputValue;
        if (((MultiInstance)this.getCharacteristics()).getLoopDataOutput() != null && (loopDataOutputValue = this.getLoopDataOutputInstanceAttribute().getValue(iScope, iCubeContext)) != null) {
            String loopDataOutputRef = ((MultiInstance)this.getCharacteristics()).getLoopDataOutput().getName();
            this.logDebug(iWorkItem, "loopDataOutputRef: " + loopDataOutputRef);
            if (loopDataOutputRef != null) {
                NodeList loopDataOutputTargetNodeList = null;
                NodeList loopDataOutputXMLNodeList = BPMNXPathUtil.convListToNodeList(loopDataOutputValue);
                if (this.getFlowNode() instanceof OutputDataAssociationEnabled) {
                    OutputDataAssociationEnabled outputDataAssociationEnabled = (OutputDataAssociationEnabled)this.getFlowNode();
                    DataAssociationSet dataAssociationSet = outputDataAssociationEnabled.getOutputDataAssociationSet();
                    Sequence dataAssociations = dataAssociationSet.getDataAssignments();
                    this.logDebug(iWorkItem, "searching for target expression for " + loopDataOutputRef + "...");
                    for (DataAssignment dataAssignment : dataAssociations) {
                        this.logDebug(iWorkItem, "dataAssociation: " + dataAssignment);
                        if (!dataAssignment.getSource().getRefs().contains((Object)loopDataOutputRef)) continue;
                        this.logDebug(iWorkItem, "dataAssociation found.");
                        Expression targetExpression = dataAssignment.getTarget().getExpression();
                        BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)dataAssignment.getTarget().getRefs(), targetExpression.getExpressionValue(), BPMNExpressionLanguage.XPATH, targetExpression.getNamespaces());
                        BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(this.getFlowNode(), targetBpmnExpressionMetadata, iScope);
                        this.logDebug(iWorkItem, "evaluating target expression: '" + targetExpression.getExpressionValue() + "'");
                        loopDataOutputTargetNodeList = targetBPMNExpression.evaluateNodeList(iScope, iCubeContext);
                        this.logDebug(iWorkItem, "value obtained is: '" + loopDataOutputTargetNodeList);
                        break;
                    }
                }
                if (loopDataOutputTargetNodeList != null) {
                    this.logDebug(iWorkItem, "loop data Output #= " + loopDataOutputTargetNodeList.getLength());
                    this.logDebug(iWorkItem, "copying loop data output...");
                    BPMNXPathUtil.copyList(loopDataOutputXMLNodeList, loopDataOutputTargetNodeList, null, iScope, iCubeContext);
                    this.logDebug(iWorkItem, "copying loop data output");
                } else {
                    this.logDebug(iWorkItem, "failed to calculate loop data output value.");
                    throw new CubeException((Throwable)new IllegalArgumentException("Failed to resolve multi-instance loopDataOutput value for activity. " + this.getFlowNode().getName()));
                }
            }
        }
    }

    private SchemaObject getArrayElementSchemaObject(@NotNull CatalogType catalogType) {
        SchemaObject schemaObject = null;
        if (catalogType.isArray()) {
            schemaObject = catalogType.getElementType().getDelegate().asSchemaObject();
        }
        return schemaObject;
    }

    private void logDebug(IWorkItem iWorkItem, Object message) {
        DataHandlingUtils.DataHandlingLogger.debug(iWorkItem, this.getFlowNode(), message);
    }

    private void logDebug(IWorkItem iWorkItem, Object message, Throwable throwable) {
        DataHandlingUtils.DataHandlingLogger.debug(iWorkItem, this.getFlowNode(), message, throwable);
    }
}

