/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.delivery.IDeliveryService;
import com.collaxa.cube.engine.delivery.SubscriptionInfo;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.oracle.bpel.client.BPELFault;
import com.oracle.bpel.client.CorrelationId;
import java.util.Calendar;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.metadata.routingslip.model.RoutingSlip;
import oracle.bpel.services.workflow.task.IInitiateTaskResponse;
import oracle.bpel.services.workflow.task.impl.SimpleApprovalTaskUtil;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpm.bpmn.engine.model.nodes.ManualTaskNode;
import oracle.bpm.bpmn.engine.model.runtime.BaseBPMNActivityWMP;
import oracle.integration.platform.common.NMUtil;
import oracle.soa.management.ComponentDN;

public class ManualTaskWMP
extends BaseBPMNActivityWMP<ManualTaskNode> {
    private static final String MANUAL_TASK_CALLBACK_CLASS = "oracle.bpm.bpmn.engine.model.runtime.ManualTaskCallback";

    public ManualTaskWMP(ManualTaskNode node) {
        super(node);
    }

    @Override
    protected void doExecuteStatements(IWorkItem iWorkItem, IScope iScope, ICubeContext iCubeContext) throws Throwable {
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)iCubeContext);
        this.handleTaskServiceInvoke(ci, iWorkItem, iScope, iCubeContext);
    }

    @Override
    protected void doHandleCallback(IWorkItem wi, ICubeContext ctx) throws Throwable {
        wi.markAsComplete();
    }

    private void handleTaskServiceInvoke(ICubeInstanceImpl ci, IWorkItem wi, IScope sc, ICubeContext ctx) throws Throwable {
        boolean manualTaskInWaitMode = false;
        if (manualTaskInWaitMode) {
            Task task = new ObjectFactory().createTask();
            task.setTitle("Manual task");
            Calendar startDate = Calendar.getInstance();
            task.setStartDate(startDate);
            try {
                oracle.bpel.services.workflow.common.model.ObjectFactory commonObjectFactory = new oracle.bpel.services.workflow.common.model.ObjectFactory();
                PrincipleRefType principle = commonObjectFactory.createPrincipleRefType();
                principle.setName("weblogic");
                principle.setType("USER");
                String instanceId = String.valueOf(ci.getId());
                task.setIdentificationKey(instanceId);
                RoutingSlip routingSlip = SimpleApprovalTaskUtil.createSimpleRoutingSlip((PrincipleRefType)principle);
                IInitiateTaskResponse initiateTaskResponse = this.getWorkflowServiceClient().getTaskService().initiateTask(task, routingSlip);
                SimpleApprovalTaskUtil.setOnTaskCompletedCallback((RoutingSlip)routingSlip, (String)MANUAL_TASK_CALLBACK_CLASS);
                String convId = NMUtil.generateConversationId();
                this.registerCallback(wi, sc, ctx, convId, task);
                task = initiateTaskResponse.getTask();
                if (!wi.isComplete()) {
                    wi.markAsOpenPendingComplete();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            wi.markAsComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IWorkflowServiceClient getWorkflowServiceClient() {
        IWorkflowServiceClient wfClient = null;
        Class<IWorkflowServiceClient> clazz = IWorkflowServiceClient.class;
        synchronized (IWorkflowServiceClient.class) {
            wfClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"REMOTELOCAL");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return wfClient;
        }
    }

    private void registerCallback(IWorkItem wi, IScope sc, ICubeContext ctx, String conversationId, Task task) throws Throwable {
        IDeliveryService ds = (IDeliveryService)ctx.lookup("__delivery-service");
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        CorrelationId cId = new CorrelationId(ci.getProcessClass().getProcessDN(), wi.getKey().toString());
        ICubeProcess cp = ci.getProcessClass();
        ComponentDN pid = cp.getProcessDN();
        SubscriptionInfo sbInfo = null;
        wi.setCustomId(conversationId);
        sbInfo = new SubscriptionInfo(conversationId, cId.toString(), pid, null, null, null, ci.getKey());
        sbInfo.setNodeType("bpel");
        task.setIdentificationKey(sbInfo.getSubscriberId());
        try {
            ds.subscribe(sbInfo, ctx);
        }
        catch (CubeException e) {
            e.printStackTrace();
            if (e.getErrorCode() == 3810) {
                BPELFault bf = new BPELFault(BPELDefs.QN_CONFLICTIING_RECEIVE, e.getMessage());
                throw bf;
            }
            throw e;
        }
    }
}

