/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextFactory;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.agents.AgentLogger;
import com.collaxa.cube.engine.dispatch.DispatchHelper;
import com.collaxa.cube.engine.dispatch.message.IMessage;
import com.collaxa.cube.engine.dispatch.message.instance.ExpirationMessage;
import com.collaxa.cube.persistence.dto.WorkItemKey;
import java.util.Date;
import oracle.bpm.bpmn.engine.model.SchedulingLogger;
import oracle.integration.platform.blocks.scheduler.SchedulerJob;
import oracle.integration.platform.blocks.scheduler.StringProperties;
import oracle.soa.management.ComponentDN;

public class BPMNWaitListener
implements SchedulerJob {
    public static final String PRIORITY = "BPEL_priority";
    public static final String INSTANCE_ID = "BPEL_instanceID";
    public static final String COMPONENT_DN = "BPEL_componentDN";
    public static final String WI_KEY = "WI_KEY";

    public void execute(String compositeDN, String key, StringProperties opaqueProperties) {
        try {
            String wiKeyStr;
            if (opaqueProperties.containsKey((Object)WI_KEY)) {
                wiKeyStr = opaqueProperties.get(WI_KEY);
                SchedulingLogger.log("\n" + new Date() + " " + " Sending expiration message... (" + wiKeyStr + ")");
            } else {
                wiKeyStr = key;
            }
            WorkItemKey wiKey = new WorkItemKey(wiKeyStr);
            String priorityStr = opaqueProperties.get(PRIORITY);
            int priority = Integer.valueOf(priorityStr);
            String instanceIdStr = opaqueProperties.get(INSTANCE_ID);
            String componentDN = opaqueProperties.get(COMPONENT_DN);
            String debugStr = "WiKey=" + wiKeyStr + ":componentDN=" + componentDN + (instanceIdStr != null ? ":InstanceID=" + Integer.valueOf(instanceIdStr) : "") + ":Priority=" + priority;
            AgentLogger.LOG.debug("ExpirationAgent", "Scheduled Job Completed", new Object[]{debugStr});
            ExpirationMessage em = new ExpirationMessage(new ComponentDN(componentDN), wiKey, priority, "bpmn");
            ICubeContext ctx = CubeContextFactory.newInstance().create("bpmn");
            DispatchHelper.scheduleLocal((IMessage)em, (ICubeContext)ctx);
        }
        catch (CubeException ce) {
            ce.printStackTrace();
        }
    }
}

