/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.nodes;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.core.IWorkManager;
import com.collaxa.cube.engine.core.IWorkPerformer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.common.GatewaySequenceFlowMetadata;
import oracle.bpm.bpmn.engine.model.common.GatewaySequenceFlowMetadataSupport;
import oracle.bpm.bpmn.engine.model.common.SequenceFlowMetadata;
import oracle.bpm.bpmn.engine.model.nodes.AbstractGatewayNode;
import oracle.bpm.bpmn.engine.model.runtime.BaseBPMNGatewayWMP;
import oracle.bpm.bpmn.engine.model.runtime.MultiInstanceRuntimeHelper;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.ExclusiveGatewayMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.ExclusiveGatewayMicroInstructionMetadata;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.MultiInstance;

public class MultiInstanceLoopNode
extends AbstractGatewayNode<Activity>
implements ExclusiveGatewayMicroInstructionMetadata {
    private GatewaySequenceFlowMetadata gatewaySequenceFlowMetadata = new GatewaySequenceFlowMetadataSupport();
    private MultiInstanceRuntimeHelper runtimeHelper;

    public MultiInstanceLoopNode(BPMNCubeMapBuilderContext context, String idSuffix, String name, Activity activity, MultiInstance multiInstance) {
        super(context, idSuffix, name, activity.getBpmnType(), activity);
        this.runtimeHelper = new MultiInstanceRuntimeHelper((FlowNode)activity, multiInstance);
    }

    public MultiInstanceRuntimeHelper getRuntimeHelper() {
        return this.runtimeHelper;
    }

    @Override
    public GatewaySequenceFlowMetadata getGatewaySequenceFlowMetadata() {
        return this.gatewaySequenceFlowMetadata;
    }

    public Expression getLoopExpression() {
        XPathExpression loopExpression = null;
        try {
            HashMap<String, URI> namespaces = new HashMap<String, URI>();
            namespaces.put("bpmn", new URI("http://www.omg.org/bpmn20"));
            loopExpression = new XPathExpression(MessageFormat.format("bpmn:getActivityInstanceAttribute(\"{0}\",\"{1}\")<=bpmn:getActivityInstanceAttribute(\"{0}\",\"{2}\") and not(bpmn:getActivityInstanceAttribute(\"{0}\",\"{3}\"))", ((Activity)this.getFlowElement()).getId(), this.getRuntimeHelper().getLoopCounterInstanceAttribute().getPredefinedVariableElement().getName(), this.getRuntimeHelper().getNumberOfInstancesInstanceAttribute().getPredefinedVariableElement().getName(), this.getRuntimeHelper().getCompletionConditionInstanceAttribute().getPredefinedVariableElement().getName()), namespaces);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return loopExpression;
    }

    public void init(ICubeContext ctx) throws CubeException {
        MultitInstanceLoopWMP wmp = new MultitInstanceLoopWMP(this);
        this.init((IWorkManager)wmp, (IWorkPerformer)wmp);
    }

    public void uninit(ICubeContext ctx) throws CubeException {
    }

    @Override
    public SequenceFlowMetadata getSequenceFlowMetadata() {
        throw new UnsupportedOperationException("getSequenceFlowMetadata use: getGatewaySequenceFlowMetadata");
    }

    @Override
    public boolean hasOutgoingSequenceFlows() {
        return this.getGatewaySequenceFlowMetadata().getOutgoingSequenceFlows().size() > 0;
    }

    @Override
    public boolean isAuditable() {
        return false;
    }

    @Override
    protected void initGenerateNextTokenMicroInstructions() {
        this.addMicroInstruction(new ExclusiveGatewayMicroInstruction(this));
    }

    private static class MultitInstanceLoopWMP
    extends BaseBPMNGatewayWMP<MultiInstanceLoopNode> {
        private MultitInstanceLoopWMP(MultiInstanceLoopNode node) {
            super(node);
        }

        @Override
        protected void doExecuteStatements(IWorkItem iWorkItem, IScope iScope, ICubeContext iCubeContext) throws Throwable {
            Integer loopCounter = ((MultiInstanceLoopNode)this.getBPMNCubeNode()).getRuntimeHelper().getLoopCounterInstanceAttribute().getValue(iScope, iCubeContext) + 1;
            ((MultiInstanceLoopNode)this.getBPMNCubeNode()).getRuntimeHelper().getLoopCounterInstanceAttribute().setValue(iScope, iCubeContext, loopCounter);
            super.doExecuteStatements(iWorkItem, iScope, iCubeContext);
        }
    }
}

