/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.nodes;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.util.ThreadCountManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.model.nodes.BasePairingGatewayNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.ComplexGatewayMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.ComplexGatewayMicroInstructionMetadata;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.bpmn.engine.service.audit.payload.AuditExpressionExecution;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.Gateway;

public class ComplexGatewayNode
extends BasePairingGatewayNode<ComplexGateway>
implements ComplexGatewayMicroInstructionMetadata {
    private static final String logClassName = ComplexGatewayNode.class.getName();

    public ComplexGatewayNode(BPMNCubeMapBuilderContext context, String name, ComplexGateway complexGateway) {
        super(context, name, complexGateway);
        this.addMicroInstruction(new ComplexGatewayMicroInstruction(this));
    }

    public boolean ignoreToken(IScope scope, ICubeContext ctx, int activationId) throws CubeException {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "ignoreToken", new Object[]{"Start of ignore token"});
        String stateObjectName = PredefinedVariablesHelper.STATE.getName();
        String keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + stateObjectName + "." + activationId;
        boolean state = false;
        if (!scope.contains(keyName)) {
            scope.declareAndSet(keyName, state);
        } else {
            state = scope.getBoolean(keyName);
        }
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "ignoreToken", new Object[]{"End of ignore token = " + state});
        return state;
    }

    @Override
    protected boolean canActivateBasedOnTokens(IScope scope, ICubeContext ctx, Object token, boolean ignoreToken) throws Exception {
        boolean activate = false;
        boolean conditionResult = false;
        HashMap<String, Object> removedToken = BPMNTokenMetadataUtils.convertToToken(token);
        String activationIdsOfRemovedToken = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(removedToken);
        String[] activationIds = activationIdsOfRemovedToken.split(",");
        ArrayList<String> removedActivationIds = new ArrayList<String>();
        for (int i = 0; i < activationIds.length; ++i) {
            if (activationIds[i].equals("")) continue;
            int activationId = Integer.parseInt(activationIds[i]);
            String flowKeyPrefix = scope.getAbsoluteScopeId() + "." + ((ComplexGateway)this.getFlowElement()).getId() + ".";
            String flowKey = flowKeyPrefix + activationId;
            if (!scope.contains(flowKey) || (ignoreToken = this.ignoreToken(scope, ctx, activationId)) || removedToken.get("DUMMY_TOKEN_FOR_MERGING_GATEWAY") != null) continue;
            this.setActivationCount(scope, ctx, activationId);
            this.setState(scope, ctx, activationId);
            conditionResult = this.evaluateCondition(scope, ctx, removedToken);
            if (!conditionResult) continue;
            removedActivationIds.add("" + activationId);
            this.setActivationIdsFromRemovedToken(removedToken, activationIds, removedActivationIds);
            PredefinedVariablesHelper.getPredefinedVariablesForProjectObject(this.getFlowElement(), this.getFlowElement());
            String state = PredefinedVariablesHelper.STATE.getName();
            String keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + state + "." + activationId;
            scope.set(keyName, true);
            this.insertInstance2Track(scope, ctx, removedToken, "COMPLETED");
            this.processConsumedToken(scope, ctx, removedToken, removedActivationIds);
            this.decreaseThreads(scope, flowKey);
        }
        if (!conditionResult) {
            activate = super.canActivateBasedOnTokens(scope, ctx, token, ignoreToken);
            BPELExecutionLogger.LOG.debug(this.getClass().getName(), "canActivate", new Object[]{"Can activate of super method " + activate});
        }
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "canActivate", new Object[]{"End of canActivate of overwrite method"});
        this.uniinitVariables(scope);
        if (ignoreToken) {
            removedToken.put("ignoreToken", true);
            this.processConsumedToken(scope, ctx, removedToken);
            return true;
        }
        return conditionResult || activate;
    }

    @Override
    protected void removeActivationIdDataFromScope(IScope scope, ICubeContext ctx, int activationId) throws CubeException {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "removeActivationIdDataFromScope", new Object[]{"Start of removing activation id metadata for  = " + activationId});
        String activationObjectName = PredefinedVariablesHelper.ACTIVATION_COUNT.getName();
        String keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + activationObjectName + "." + activationId;
        scope.set(keyName, null);
        String stateObjectName = PredefinedVariablesHelper.STATE.getName();
        keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + stateObjectName + "." + activationId;
        scope.set(keyName, null);
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "removeActivationIdDataFromScope", new Object[]{"End of removing activation id metadata for  = " + activationId});
    }

    private void decreaseThreads(IScope scope, String flowKey) throws CubeException {
        if (ModelVisitorUtil.isCancelPendingFlows((Gateway)this.getFlowElement())) {
            ThreadCountManager.resetThreadCount((IScope)scope);
            ThreadCountManager.increaseThreadCount((IScope)scope);
        } else {
            ThreadCountManager.decreaseThreadCount((IScope)scope);
        }
    }

    private void setActivationCount(IScope scope, ICubeContext ctx, int activationId) throws Exception {
        String counterObjectName = PredefinedVariablesHelper.ACTIVATION_COUNT.getName();
        String keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + counterObjectName + "." + activationId;
        int availableTokens = 0;
        if (!scope.contains(keyName)) {
            availableTokens = 1;
            scope.declareAndSet(keyName, availableTokens);
        } else {
            int availableToken = scope.getInt(keyName);
            availableTokens = availableToken + 1;
            scope.set(keyName, availableTokens);
        }
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "evaluateCondition", new Object[]{"Available token for key  =  " + keyName + " = " + availableTokens});
        this.setVariableValue(scope, PredefinedVariablesHelper.ACTIVATION_COUNT.getName(), availableTokens);
    }

    private void setState(IScope scope, ICubeContext ctx, int activationId) throws Exception {
        String stateName = PredefinedVariablesHelper.STATE.getName();
        String keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + stateName + "." + activationId;
        boolean state = false;
        if (!scope.contains(keyName)) {
            scope.declareAndSet(keyName, state);
        } else {
            state = scope.getBoolean(keyName);
        }
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "evaluateCondition", new Object[]{"Activation state of the gateway  =  " + keyName + " = " + state});
        scope.set(keyName, state);
        InstanceAttributeType.getVariableName(InstanceAttributeType.GATEWAY_INSTANCE_ATTRIBUTE, ((ComplexGateway)this.getFlowElement()).getName(), PredefinedVariablesHelper.STATE.getName());
        this.setVariableValue(scope, PredefinedVariablesHelper.STATE.getName(), state);
    }

    private void setVariableValue(IScope scope, String attrName, Object value) throws CubeException {
        String variableName = InstanceAttributeType.getVariableName(InstanceAttributeType.GATEWAY_INSTANCE_ATTRIBUTE, ((ComplexGateway)this.getFlowElement()).getName(), attrName);
        if (scope.contains(variableName)) {
            scope.set(variableName, value);
        } else {
            scope.declareAndSet(variableName, value);
        }
    }

    private void uniinitVariables(IScope scope) throws CubeException {
        String counterVar;
        String stateVariable = InstanceAttributeType.getVariableName(InstanceAttributeType.GATEWAY_INSTANCE_ATTRIBUTE, ((ComplexGateway)this.getFlowElement()).getName(), PredefinedVariablesHelper.STATE.getName());
        if (scope.contains(stateVariable)) {
            scope.set(stateVariable, null);
        }
        if (scope.contains(counterVar = InstanceAttributeType.getVariableName(InstanceAttributeType.GATEWAY_INSTANCE_ATTRIBUTE, ((ComplexGateway)this.getFlowElement()).getName(), PredefinedVariablesHelper.ACTIVATION_COUNT.getName()))) {
            scope.set(counterVar, null);
        }
    }

    private boolean evaluateCondition(IScope scope, ICubeContext ctx, HashMap<String, Object> token) throws CubeException {
        String logMethodName = "evaluateCondition";
        BPELExecutionLogger.LOG.debug(logClassName, "evaluateCondition", new Object[]{"Start of evaluating the expression"});
        Expression expression = ((ComplexGateway)this.getFlowElement()).getActivationCondition();
        if (expression == null || expression.getExpressionValue() == null || expression.getExpressionValue().equals("")) {
            throw new CubeException(75001, BPMNUtility.getObjects(scope.getCubeInstance(), this.getFlowElement()));
        }
        String strExpression = expression.getExpressionValue();
        BPMNExpressionMetadata forBPMNExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, strExpression, BPMNExpressionLanguage.XPATH, expression.getNamespaces());
        BPMNExpression forBPMNExpression = BPMNExpression.createBPMNExpression(this.getFlowElement(), forBPMNExpressionMetadata, scope);
        boolean condition = forBPMNExpression.evaluateBoolean(scope, ctx);
        List<Map<String, String>> conditionExecList = null;
        String activitySourceId = (String)BPMNTokenMetadataUtils.getPropertyFromTokenMetadata(token, "SOURCE_ACTIVITY_ID");
        AuditExpressionExecution conditionExec = new AuditExpressionExecution(AuditExpressionExecution.GatewayType.COMPLEX_GATEWAY, ((ComplexGateway)this.getFlowElement()).getId(), activitySourceId, ((ComplexGateway)this.getFlowElement()).getId(), strExpression, condition);
        BPELExecutionLogger.LOG.debug(logClassName, "evaluateCondition", new Object[]{"Condition result for expression " + strExpression + " is " + condition + "\n{" + conditionExec.toString() + "}"});
        String auditExpressionKey = AuditExpressionExecution.getKey(((ComplexGateway)this.getFlowElement()).getId());
        if (!scope.contains(auditExpressionKey)) {
            conditionExecList = new ArrayList();
            scope.declare(auditExpressionKey);
        } else {
            conditionExecList = (List)scope.getObject(auditExpressionKey);
        }
        conditionExecList.add(conditionExec.asSerializable());
        BPELExecutionLogger.LOG.debug(logClassName, "evaluateCondition", new Object[]{"Setting GATEWAY EXPRESSION information KEY {" + auditExpressionKey + "} " + conditionExecList});
        scope.set(auditExpressionKey, conditionExecList);
        return condition;
    }
}

