/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.nodes;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkManager;
import com.collaxa.cube.engine.core.IWorkPerformer;
import com.collaxa.cube.engine.util.ThreadCountManager;
import com.collaxa.cube.engine.util.TokenManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.nodes.AbstractGatewayNode;
import oracle.bpm.bpmn.engine.model.runtime.BaseBPMNGatewayWMP;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.AbstractMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.IMicroInstructionMetadata;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;

public abstract class BasePairingGatewayNode<T extends Gateway>
extends AbstractGatewayNode<T> {
    public BasePairingGatewayNode(BPMNCubeMapBuilderContext context, String name, T gateway) {
        super(context, name, gateway);
        if (gateway.getDirection() == GatewayDirection.DIVERGING) {
            this.addMicroInstruction(new MIInsertInstance2TrackGateway(this));
        }
    }

    public void init(ICubeContext iCubeContext) throws CubeException {
        BaseBPMNGatewayWMP<BasePairingGatewayNode> wmp = new BaseBPMNGatewayWMP<BasePairingGatewayNode>(this);
        this.init((IWorkManager)wmp, (IWorkPerformer)wmp);
    }

    @Override
    public void activate(IScope scope, ICubeContext ctx) throws Exception {
    }

    public void uninit(ICubeContext ctx) throws CubeException {
    }

    public boolean canActivateAsSimpleNode(IScope scope, ICubeContext ctx) throws Exception {
        GatewayDirection direction = ((Gateway)this.getFlowElement()).getDirection();
        if (direction != null && direction.equals((Object)GatewayDirection.DIVERGING)) {
            return TokenManager.containsOpenToken((IScope)scope, (String)this.getId());
        }
        return false;
    }

    @Override
    public boolean canActivate(IScope scope, ICubeContext ctx) throws Exception {
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "canActivate", new Object[]{this.getClass().getName(), "canActivate", "start"});
        Queue queue = BPMNTokenManager.getTokenObject(scope, this.getId());
        if (queue == null) {
            return false;
        }
        Object o = queue.remove();
        if (this.canActivateAsSimpleNode(scope, ctx)) {
            if (queue.size() == 0) {
                TokenManager.consumeOpenToken((IScope)scope, (String)this.getId());
            }
            this.processConsumedToken(scope, ctx, BPMNTokenMetadataUtils.convertToToken(o));
            return true;
        }
        return this.canActivateBasedOnTokens(scope, ctx, queue, o, false);
    }

    public Gateway getMergingGateway() {
        return ((Gateway)this.getFlowElement()).getMergingGateway();
    }

    public boolean isForkingGateway() {
        GatewayDirection direction = ((Gateway)this.getFlowElement()).getDirection();
        return direction.equals((Object)GatewayDirection.DIVERGING) || direction.equals((Object)GatewayDirection.MIXED);
    }

    protected final boolean canActivateBasedOnTokens(IScope scope, ICubeContext ctx, Queue queue, Object token, boolean ignoreToken) throws Exception {
        boolean result;
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "canActivate", new Object[]{"Token object = " + queue});
        Object currentToken = token;
        do {
            result = this.canActivateBasedOnTokens(scope, ctx, currentToken, ignoreToken);
            if (queue.size() == 0) {
                TokenManager.consumeOpenToken((IScope)scope, (String)this.getId());
                currentToken = null;
                continue;
            }
            if (result) continue;
            currentToken = queue.remove();
        } while (!result && currentToken != null);
        return result;
    }

    protected void setActivationIdsFromRemovedToken(HashMap<String, Object> removedToken, String[] activationIds, List removedActivationIds) {
        String moveActivationIds = "";
        for (int i = 0; i < activationIds.length; ++i) {
            if (removedActivationIds.contains(activationIds[i])) continue;
            moveActivationIds = moveActivationIds.equals("") ? activationIds[i] : moveActivationIds + "," + activationIds[i];
        }
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "canActivate", new Object[]{"Moving activation ids " + moveActivationIds});
        BPMNTokenMetadataUtils.setActivationIdsToTokenMetadata(removedToken, moveActivationIds);
    }

    protected void decrementThreadCount(IScope scope, boolean ignoreToken) throws CubeException {
        ThreadCountManager.decreaseThreadCount((IScope)scope);
    }

    protected String processConsumedToken(IScope scope, ICubeContext ctx, HashMap<String, Object> token, List removedActivationIds) throws CubeException {
        if (!this.isForkingGateway()) {
            String activationId = (String)removedActivationIds.get(0);
            String stepKey = BPMNTokenMetadataUtils.getMergeGatewayStepKey(((Gateway)this.getFlowElement()).getId(), activationId);
            int step = scope.getInt(stepKey);
            scope.set(stepKey, null);
            String threadKey = BPMNTokenMetadataUtils.getMergeGatewayThreadey(((Gateway)this.getFlowElement()).getId(), activationId);
            int thread = scope.getInt(threadKey);
            scope.set(threadKey, null);
            String parentThreadKey = BPMNTokenMetadataUtils.getMergeGatewayParentThreadey(((Gateway)this.getFlowElement()).getId(), activationId);
            int parentThread = scope.getInt(parentThreadKey);
            scope.set(parentThreadKey, null);
            BPMNTokenMetadataUtils.setStepToTokenMetadata(token, step);
            BPMNTokenMetadataUtils.setThreadToTokenMetadata(token, thread);
            BPMNTokenMetadataUtils.setParentThreadInTokenMetadata(token, parentThread);
        }
        return super.processConsumedToken(scope, ctx, token);
    }

    protected void removeActivationIdDataFromScope(IScope scope, ICubeContext ctx, int activationId) throws CubeException {
    }

    protected boolean canActivateBasedOnTokens(IScope scope, ICubeContext ctx, Object token, boolean ignoreToken) throws Exception {
        HashMap<String, Object> removedToken = BPMNTokenMetadataUtils.convertToToken(token);
        String activationIdsOfRemovedToken = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(removedToken);
        boolean activate = false;
        ArrayList<String> removedActivationIds = new ArrayList<String>();
        BPELExecutionLogger.LOG.debug(this.getClass().getName(), "canActivate", new Object[]{"Removed token =" + activationIdsOfRemovedToken});
        String flowKeyPrefix = scope.getAbsoluteScopeId() + "." + ((Gateway)this.getFlowElement()).getId() + ".";
        String[] activationIds = activationIdsOfRemovedToken.split(",");
        for (int i = 0; i < activationIds.length; ++i) {
            if (activationIds[i].equals("")) continue;
            int activationId = Integer.parseInt(activationIds[i]);
            String flowKey = flowKeyPrefix + activationId;
            if (!scope.contains(flowKey)) continue;
            String flows = (String)scope.getAsObject(flowKey);
            BPELExecutionLogger.LOG.debug(this.getClass().getName(), "canActivate", new Object[]{"No of flows for activation id " + activationId + " = " + flows});
            if (flows == null) continue;
            int flowInt = Integer.parseInt(flows);
            if (flowInt == 1) {
                if (scope.contains(flowKey)) {
                    scope.set(flowKey, null);
                }
                removedActivationIds.add("" + activationId);
                this.removeActivationIdDataFromScope(scope, ctx, activationId);
                BPELExecutionLogger.LOG.debug(this.getClass().getName(), "canActivate", new Object[]{"can activate for " + activationId + " = true"});
                activate = true;
            } else {
                scope.set(flowKey, (Object)Integer.toString(--flowInt));
            }
            if (removedToken.get("DUMMY_TOKEN_FOR_MERGING_GATEWAY") != null) continue;
            this.decrementThreadCount(scope, ignoreToken);
            this.insertInstance2Track(scope, ctx, removedToken, "COMPLETED");
        }
        if (activate) {
            this.setActivationIdsFromRemovedToken(removedToken, activationIds, removedActivationIds);
            this.processConsumedToken(scope, ctx, removedToken, removedActivationIds);
        }
        return activate;
    }

    protected void insertInstance2Track(IScope scope, ICubeContext ctx, HashMap<String, Object> removedToken, String state) throws Exception {
        String targetCubeElementId = this.getCubeElement().getId();
        BPMNUtility.insertInstance2Track(scope.getCubeInstance(), this.getFlowElement(), removedToken, scope, ctx, state, targetCubeElementId, null);
    }

    private class MIInsertInstance2TrackGateway
    extends AbstractMicroInstruction {
        public MIInsertInstance2TrackGateway(IMicroInstructionMetadata metadata) {
            super(metadata);
        }

        @Override
        protected void doExecute(MicroInstructionContext context) throws CubeException {
            oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext newContext = new oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext(context.getWorkItem(), context.getCubeContext(), (BPMNCubeElement)context.getNode(), null);
            try {
                BPMNUtility.insertInstance2Track(newContext, "COMPLETED");
            }
            catch (Exception e) {
                throw new CubeException((Throwable)e);
            }
        }
    }
}

