/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.deploy.validation;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.deployment.DeploymentException;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.model.deploy.validation.IValidation;
import oracle.bpm.bpmn.engine.runtime.features.SequenceFlowToEndActivityFeature;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.Draftable;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.soa.scac.ValidationFault;

public class StrictGatewayValidation
implements IValidation {
    @Override
    public void validate(Process processModel, ValidationFault vf) throws CubeException {
        String methodName = "validate";
        String labelName = processModel.getName();
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{" Start of Validating  gateway for process  " + labelName});
        Sequence sequence = processModel.getSequenceFlows();
        this.validateParingGateway(vf, (Sequence<SequenceFlow>)sequence, labelName);
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{" End of Validating  gateway for process  " + labelName});
    }

    public boolean isForkingGatewayType(BpmnType type) {
        String methodName = "isForkingGateway";
        Class cls = type.getBpmnClass();
        String className = cls.getName();
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Class name bpmn type " + className});
        return className.equals(ParallelGateway.class.getName()) || className.equals(InclusiveGateway.class.getName()) || className.equals(ComplexGateway.class.getName());
    }

    private void validateParingGateway(ValidationFault vf, Sequence<SequenceFlow> sequence, String labelName) throws CubeException {
        String methodName = "validateParingGateway";
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{" Start of set paring gateway for " + labelName});
        HashMap gatewayTargetMap = new HashMap();
        ArrayList<Gateway> forkingGateways = new ArrayList<Gateway>();
        for (SequenceFlow sequenceFlow : sequence) {
            FlowNode sourceNode = sequenceFlow.getSource();
            if (sourceNode.getBpmnType().equals((Object)BpmnType.SUBPROCESS)) {
                Subprocess subProcess = (Subprocess)sourceNode;
                labelName = labelName + "[ sub process " + subProcess.getName();
                this.validateParingGateway(vf, (Sequence<SequenceFlow>)subProcess.getSequenceFlows(), labelName);
            } else if (!(!sourceNode.getBpmnType().equals((Object)BpmnType.CALL_ACTIVITY) || sourceNode.isDraftable() && ((Draftable)sourceNode.asAnyNode(Draftable.class)).isDraft())) {
                Process callableProcess = ((CallActivity)sourceNode).getCalledElement();
                labelName = labelName + "[ sub process " + callableProcess.getName();
                this.validateParingGateway(vf, (Sequence<SequenceFlow>)callableProcess.getSequenceFlows(), labelName);
            }
            String nodeId = sourceNode.getId();
            DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Source node = " + sourceNode.getDefaultLabel() + "[" + sourceNode.getId() + "] class " + sourceNode.getClass().getName()});
            BpmnType bpmnType = sourceNode.getBpmnType();
            if (this.isForkingGatewayType(bpmnType) && !forkingGateways.contains(sourceNode) && ((Gateway)sourceNode).getDirection().equals((Object)GatewayDirection.DIVERGING)) {
                DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Adding gateway node " + sourceNode.getDefaultLabel() + "[" + sourceNode.getId() + "] in forking gateway list"});
                forkingGateways.add((Gateway)sourceNode);
            }
            if (!bpmnType.isGateway() || gatewayTargetMap.containsKey(nodeId)) continue;
            Sequence seq = sourceNode.getOutgoingSequenceFlows();
            for (SequenceFlow flow : seq) {
                this.addAbstractTargetActivityNode(flow, flow, gatewayTargetMap, nodeId, new HashSet<FlowNode>());
            }
        }
        for (Gateway node : forkingGateways) {
            this.setMergingGatewayAndOutOfFlowActivity(node, gatewayTargetMap);
        }
        this.dumpResults(forkingGateways, gatewayTargetMap);
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{" End of set paring gateway "});
    }

    private void dumpResults(List forkingGateways, Map gatewayTargetMap) {
        String methodName = "dumpResults";
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"start dumping validation results"});
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Gateway map results"});
        for (String nodeId : gatewayTargetMap.keySet()) {
            DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Target nodes for gateway " + nodeId + " -> "});
            List targetList = (List)gatewayTargetMap.get(nodeId);
            for (int i = 0; i < targetList.size(); ++i) {
                DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"                                      " + ((TargetNodeInfo)targetList.get(i)).getNode().getId()});
            }
        }
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"marging gateway status"});
        for (int i = 0; i < forkingGateways.size(); ++i) {
            Gateway gateway = (Gateway)forkingGateways.get(i);
            Gateway mGateway = gateway.getMergingGateway();
            String mStr = "--NOMerginGateway-";
            if (mGateway != null) {
                mStr = mGateway.getId();
            }
            DeploymentLogger.LOG.info(this.getClass().getName(), methodName, new Object[]{"Merging gateway for " + gateway.getDefaultLabel() + "[" + gateway.getId() + "] => " + mStr});
        }
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"start dumping validation results"});
    }

    private void addAbstractTargetActivityNode(SequenceFlow startFlow, SequenceFlow flow, Map gatewayTargetMap, String sourceNode, Set<FlowNode> visitedNodes) {
        String methodName = "addAbstractTargetActivityNode";
        FlowNode node = flow.getTarget();
        if (visitedNodes.contains(node)) {
            return;
        }
        visitedNodes.add(node);
        BpmnType bpmnType = node.getBpmnType();
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"BPMN Type = " + bpmnType.getString()});
        String nodeId = null;
        if (node != null) {
            nodeId = node.getId();
        }
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Gateway id for flow = " + flow.getId() + " node = " + nodeId + " class = " + node.getClass().getName()});
        ArrayList<FlowNode> targetNodes = new ArrayList<FlowNode>();
        if (bpmnType.isGateway() && bpmnType != BpmnType.EVENT_BASED_GATEWAY) {
            if (node != null) {
                targetNodes.add(node);
            }
        } else {
            List<FlowNode> eventsWithActivity;
            boolean targetNodeAdded = false;
            if ((node instanceof Activity || node instanceof BoundaryEvent) && (eventsWithActivity = this.getAllActivities(node)).size() > 1) {
                for (FlowNode aNode : eventsWithActivity) {
                    targetNodes.add(aNode);
                    Iterator iter = aNode.getOutgoingSequenceFlows().iterator();
                    if (iter.hasNext()) {
                        SequenceFlow aNodeTargetFlow = (SequenceFlow)iter.next();
                        this.addAbstractTargetActivityNode(aNodeTargetFlow, aNodeTargetFlow, gatewayTargetMap, aNode.getId(), visitedNodes);
                    }
                    targetNodeAdded = true;
                }
            }
            if (!targetNodeAdded) {
                Iterator iter = node.getOutgoingSequenceFlows().iterator();
                if (iter.hasNext()) {
                    this.addAbstractTargetActivityNode(startFlow, (SequenceFlow)iter.next(), gatewayTargetMap, sourceNode, visitedNodes);
                } else {
                    targetNodes.add(node);
                }
            }
        }
        for (FlowNode flowNode : targetNodes) {
            ArrayList<TargetNodeInfo> targetNodeList = (ArrayList<TargetNodeInfo>)gatewayTargetMap.get(sourceNode);
            if (targetNodeList == null) {
                targetNodeList = new ArrayList<TargetNodeInfo>();
                gatewayTargetMap.put(sourceNode, targetNodeList);
            }
            DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Target node for flow " + startFlow.getDefaultLabel() + "[" + startFlow.getId() + "] is " + this.getLabel(flowNode)});
            targetNodeList.add(new TargetNodeInfo(flowNode, startFlow));
        }
    }

    private boolean isTargetListSame(List<TargetNodeInfo> targets) {
        String methodName = "isTargetListSame";
        HashSet<String> set = new HashSet<String>();
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Start of checking targets"});
        for (TargetNodeInfo info : targets) {
            FlowNode node = info.getNode();
            if (node.getBpmnType().equals((Object)BpmnType.END_EVENT)) continue;
            DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Gateway id " + node.getId()});
            set.add(node.getId());
        }
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Start of checking targets " + set.size()});
        return set.size() == 1;
    }

    private void setMergingGatewayAndOutOfFlowActivity(Gateway node, Map gatewayTargetMap) throws DeploymentException {
        String gNodeId = node.getId();
        String methodName = "setMergingGatewayAndOutOfFlowActivity";
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Start of setting merge gateway for node " + this.getLabel((FlowNode)node)});
        Gateway mergingGateway = node.getMergingGateway();
        if (mergingGateway == null) {
            DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Merging gateway is null and using runtime logic to get merging gateway"});
            mergingGateway = this.getMergingGateway(node, gatewayTargetMap);
        }
        if (mergingGateway == null) {
            Object[] obj = new Object[]{node.getDefaultLabel() + "[" + gNodeId + "]", node.getProcess().getDefaultLabel() + "[" + node.getProcess().getId() + "]"};
            throw new DeploymentException(78001, obj);
        }
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Merge gateway for  node " + this.getLabel((FlowNode)node) + " is " + this.getLabel((FlowNode)mergingGateway)});
        node.setMergingGateway(mergingGateway);
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"End of setting merge gateway for node " + this.getLabel((FlowNode)node)});
        this.setEndActivityFlowPath(node, gatewayTargetMap);
    }

    private String getLabel(FlowNode node) {
        return node.getDefaultLabel() + "[" + node.getId() + "]";
    }

    private String getPathsToEndId(List<String> pathsToEnd, List<String> pathsToMerge, String pathToId, FlowNode fNode, Gateway gNode, Map gatewayTargetMap, Set doneKey, HashMap donePaths) {
        String methodName = "getPathsToEndId";
        if (gNode != null && pathToId != null) {
            String nodeId = fNode.getId();
            List targetNodes = (List)gatewayTargetMap.get(nodeId);
            String previousPathToId = null;
            DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Start of getting end path for " + this.getLabel(fNode)});
            if (targetNodes != null) {
                for (TargetNodeInfo targetNode : targetNodes) {
                    FlowNode node = targetNode.getNode();
                    String doneKeyName = targetNode.toString();
                    if (doneKey.contains(doneKeyName)) {
                        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Already processed  " + this.getLabel(node) + " with source sequence flow " + targetNode.getSourceSequenceFlow().getId()});
                        if (pathToId == null) continue;
                        ArrayList<String> newPaths = new ArrayList<String>();
                        String firstPart = pathToId.split("::")[0];
                        for (String pathToMerge : pathsToMerge) {
                            if (!pathToMerge.contains(nodeId) || !pathToMerge.contains(firstPart) || pathToMerge.contains(pathToId) || donePaths.containsKey(pathToMerge) && firstPart.equals(donePaths.get(pathToMerge))) continue;
                            newPaths.add(pathToMerge.replace(firstPart, pathToId));
                            donePaths.put(pathToMerge, firstPart);
                        }
                        for (String newPath : newPaths) {
                            if (pathsToMerge.contains(newPath)) continue;
                            pathsToMerge.add(newPath);
                        }
                        continue;
                    }
                    doneKey.add(doneKeyName);
                    if (pathToId != null) {
                        previousPathToId = pathToId;
                    } else {
                        pathToId = previousPathToId;
                    }
                    pathToId = pathToId == null || pathToId.equals("") ? targetNode.toString() : pathToId + "::" + targetNode.toString();
                    if (!node.getId().equals(gNode.getMergingGateway().getId())) {
                        if (node.getBpmnType().equals((Object)BpmnType.END_EVENT)) {
                            pathsToEnd.add(pathToId);
                            DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Path goes to End from forking gateway is " + pathToId});
                            pathToId = previousPathToId;
                            continue;
                        }
                        pathToId = this.getPathsToEndId(pathsToEnd, pathsToMerge, pathToId, node, gNode, gatewayTargetMap, doneKey, donePaths);
                        continue;
                    }
                    DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Node " + this.getLabel((FlowNode)gNode) + " connected " + this.getLabel((FlowNode)gNode.getMergingGateway()) + " via " + pathToId});
                    pathsToMerge.add(pathToId);
                    pathToId = previousPathToId;
                }
            }
        }
        return null;
    }

    private boolean isActivityPartOfMergePath(String id, List<String> mergPaths) {
        for (String mergePath : mergPaths) {
            if (mergePath.indexOf(id) < 0) continue;
            DeploymentLogger.LOG.debug(this.getClass().getName(), "isExclusiveGatewayPartOfMergePath", new Object[]{" ID " + id + " is part of merge path " + mergePath});
            return true;
        }
        return false;
    }

    private String getNodeIdFromToken(String token) {
        return token.split("->")[1];
    }

    private String getSourceSeqIdFromToken(String token) {
        return token.split("->")[0];
    }

    private List<FlowNode> getAllActivities(FlowNode node) {
        ArrayList<FlowNode> allActivities = new ArrayList<FlowNode>();
        Activity baseActivity = null;
        if (ModelVisitorUtil.comesFromEventBasedGateway(node)) {
            FlowNode ebg = ((SequenceFlow)node.getIncomingSequenceFlows().iterator().next()).getSource();
            for (SequenceFlow flow : ebg.getOutgoingSequenceFlows()) {
                allActivities.add(flow.getTarget());
            }
        } else if (node.isEvent()) {
            baseActivity = ((BoundaryEvent)node).getBoundaryActivity();
            if (baseActivity != null) {
                allActivities.add((FlowNode)baseActivity);
            }
        } else if (node.isActivity()) {
            baseActivity = (Activity)node;
            allActivities.add((FlowNode)baseActivity);
        } else if (node.isGateway() && node.getBpmnType() == BpmnType.EVENT_BASED_GATEWAY) {
            for (SequenceFlow flows : node.getOutgoingSequenceFlows()) {
                allActivities.add(flows.getTarget());
            }
        }
        if (baseActivity != null) {
            Sequence bEvents = baseActivity.getActivityBoundaryEvents();
            for (BoundaryEvent cancelEvent : bEvents) {
                if (!cancelEvent.cancelActivity() && !(cancelEvent instanceof ErrorEventDefinition)) continue;
                allActivities.add((FlowNode)cancelEvent);
            }
        }
        return allActivities;
    }

    private TargetNodeInfo getFirstActivityGoesToEnd(Gateway gNode, String pathToEnd, List<String> pathsToMerge) throws DeploymentException {
        String methodName = "getFirstActivityGoesToEnd";
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Start of finding first activity from " + pathToEnd});
        String[] paths = pathToEnd.split("::");
        TargetNodeInfo firstActivity = null;
        Process process = gNode.getProcess();
        NodeContainer nodeContainer = gNode.getParentObject();
        if (paths.length == 1) {
            String sequenceFlowId = this.getSourceSeqIdFromToken(paths[0]);
            DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Finding sequence flow for id " + sequenceFlowId + " in process " + process.getDefaultLabel() + "[" + process.getId() + "]"});
            SequenceFlow sequencFlow = nodeContainer.findSequenceFlow(sequenceFlowId);
            FlowNode node = sequencFlow.getTarget();
            if (node == null) {
                Object[] obj = new Object[]{process.getDefaultLabel() + "[" + process.getId() + "][" + nodeContainer.getName() + "]", pathToEnd};
                throw new DeploymentException(78002, obj);
            }
            firstActivity = new TargetNodeInfo(node, sequencFlow);
        } else {
            String previousToken = null;
            for (int i = paths.length - 1; i >= 0; --i) {
                SequenceFlow flow;
                String fromSequenceFlow;
                String currentToken = paths[i];
                String nodeId = this.getNodeIdFromToken(currentToken);
                String sourcsFlowId = this.getSourceSeqIdFromToken(currentToken);
                DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Finding activity is process  " + nodeId});
                FlowNode node = nodeContainer.findNode(nodeId);
                DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Gateway which goes to end via " + this.getLabel(node)});
                if (node.getBpmnType().equals((Object)BpmnType.EXCLUSIVE_GATEWAY)) {
                    if (this.isActivityPartOfMergePath(currentToken, pathsToMerge)) {
                        if (previousToken != null) {
                            fromSequenceFlow = this.getSourceSeqIdFromToken(previousToken);
                            flow = nodeContainer.findSequenceFlow(fromSequenceFlow);
                            firstActivity = new TargetNodeInfo(flow.getTarget(), flow);
                            break;
                        }
                        throw new RuntimeException("Exclusive Gateway is last activity, Check the process model or contact oracle support");
                    }
                } else if (node instanceof BoundaryEvent || node instanceof Activity) {
                    List<FlowNode> checkNodesInMergePaths = this.getAllActivities(node);
                    for (FlowNode checkNodes : checkNodesInMergePaths) {
                        String activityId = checkNodes.getId();
                        if (!this.isActivityPartOfMergePath(sourcsFlowId + "->" + activityId, pathsToMerge) || previousToken == null) continue;
                        String fromSequenceFlow2 = this.getSourceSeqIdFromToken(previousToken);
                        SequenceFlow flow2 = nodeContainer.findSequenceFlow(fromSequenceFlow2);
                        firstActivity = new TargetNodeInfo(flow2.getTarget(), flow2);
                        return firstActivity;
                    }
                }
                if (i == 0) {
                    fromSequenceFlow = this.getSourceSeqIdFromToken(currentToken);
                    flow = nodeContainer.findSequenceFlow(fromSequenceFlow);
                    if (flow == null) {
                        Object[] obj = new Object[]{fromSequenceFlow, process.getDefaultLabel() + "[" + process.getId() + "][" + nodeContainer.getName() + "]"};
                        throw new DeploymentException(78003, obj);
                    }
                    FlowNode targetNode = flow.getTarget();
                    if (targetNode == null) {
                        Object[] obj = new Object[]{fromSequenceFlow, process.getDefaultLabel() + "[" + process.getId() + "][" + nodeContainer.getName() + "]"};
                        throw new DeploymentException(78004, obj);
                    }
                    firstActivity = new TargetNodeInfo(targetNode, flow);
                }
                previousToken = currentToken;
            }
        }
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"First activty which is out of merging gateway is " + this.getLabel(firstActivity.getNode()) + " Source Sequence flow " + firstActivity.getSourceSequenceFlow().getId()});
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"End of finding first activity from " + pathToEnd});
        return firstActivity;
    }

    private void setEndActivityFlowPath(Gateway node, Map gatewayTargetMap) throws DeploymentException {
        String methodName = "setEndActivityFlowPath";
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Start of setting end activity to gateway " + this.getLabel((FlowNode)node)});
        ArrayList<String> pathsToEnd = new ArrayList<String>();
        ArrayList<String> pathsToMerge = new ArrayList<String>();
        this.getPathsToEndId(pathsToEnd, pathsToMerge, "", (FlowNode)node, node, gatewayTargetMap, new HashSet(), new HashMap());
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Number of flows goes to end without connecting to merge gateway is" + pathsToEnd.size()});
        for (String pathToEnd : pathsToEnd) {
            FlowNode sourceNode;
            SequenceFlowToEndActivityFeature sequenceFlowFeature;
            TargetNodeInfo firstNodeInfo = this.getFirstActivityGoesToEnd(node, pathToEnd, pathsToMerge);
            FlowNode firstNode = firstNodeInfo.getNode();
            DeploymentLogger.LOG.info(this.getClass().getName(), methodName, new Object[]{"First activity which goes to end for gateway " + this.getLabel((FlowNode)node) + " is " + this.getLabel(firstNode)});
            if (node.getMergingGateway().getBpmnType() == BpmnType.COMPLEX_GATEWAY) {
                DeploymentLogger.LOG.warn(this.getClass().getName(), methodName, new Object[]{"Sequence flow goes to end without going to merging gateway In this case instance will not wait for out of flow path based on token execution"});
            }
            if ((sequenceFlowFeature = (SequenceFlowToEndActivityFeature)(sourceNode = firstNodeInfo.getSourceSequenceFlow().getSource()).getFeature(SequenceFlowToEndActivityFeature.class)) == null) {
                sequenceFlowFeature = SequenceFlowToEndActivityFeature.getSequenceFlowToEndActivityFearure();
                sourceNode.getFeatures().extendFeature((Feature)sequenceFlowFeature);
            }
            DeploymentLogger.LOG.info(this.getClass().getName(), methodName, new Object[]{"Sequence flow which goes to merge gateway is" + firstNodeInfo.getSourceSequenceFlow().getId()});
            sequenceFlowFeature.addValue(sequenceFlowFeature.getEndActivityFlowInfo(firstNodeInfo.getSourceSequenceFlow(), (FlowNode)node.getMergingGateway()));
        }
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Start of setting end activity to gateway " + this.getLabel((FlowNode)node)});
    }

    private boolean isConvergingGateway(FlowNode node) {
        if (node.getBpmnType().equals((Object)BpmnType.PARALLEL_GATEWAY) || node.getBpmnType().equals((Object)BpmnType.COMPLEX_GATEWAY) || node.getBpmnType().equals((Object)BpmnType.INCLUSIVE_GATEWAY)) {
            return ((Gateway)node).getDirection().equals((Object)GatewayDirection.CONVERGING);
        }
        return false;
    }

    private boolean isDivergingGateway(FlowNode node) {
        if (node.getBpmnType().equals((Object)BpmnType.PARALLEL_GATEWAY) || node.getBpmnType().equals((Object)BpmnType.COMPLEX_GATEWAY) || node.getBpmnType().equals((Object)BpmnType.INCLUSIVE_GATEWAY)) {
            return ((Gateway)node).getDirection().equals((Object)GatewayDirection.DIVERGING);
        }
        return false;
    }

    private TargetNodeInfo getConvergingGateway(TargetNodeInfo node, Map<String, List<TargetNodeInfo>> gatewayTargetMap) {
        FlowNode tNode;
        String methodName = "getConvergingGateway";
        TargetNodeInfo convergeGateway = null;
        List<TargetNodeInfo> targetNodes = gatewayTargetMap.get(node.getNode().getId());
        if (targetNodes == null) {
            DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Null  target nodes for " + this.getLabel(node.getNode())});
            return null;
        }
        ArrayList<TargetNodeInfo> nodes = new ArrayList<TargetNodeInfo>(targetNodes);
        boolean isCurrentNodeConverging = this.isConvergingGateway(node.getNode());
        for (int i = 0; !(i >= nodes.size() || this.isDivergingGateway(tNode = ((TargetNodeInfo)nodes.get(i)).getNode()) && isCurrentNodeConverging); ++i) {
            if (this.isConvergingGateway(tNode)) {
                convergeGateway = (TargetNodeInfo)nodes.get(i);
                break;
            }
            List<TargetNodeInfo> rTargetNodes = gatewayTargetMap.get(tNode.getId());
            if (rTargetNodes == null) continue;
            nodes.addAll(rTargetNodes);
        }
        return convergeGateway;
    }

    private Gateway getMergingGateway(Gateway node, Map gatewayTargetMap) {
        String methodName = "getMergingGateway";
        String id = node.getId();
        List originalTargets = (List)gatewayTargetMap.get(id);
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Get merging gateway for id = " + id});
        ArrayList<TargetNodeInfo> targetGateways = new ArrayList<TargetNodeInfo>(originalTargets);
        String forkLevel = ModelUtils.getActivityLevel((FlowNode)node);
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Activity level for " + this.getLabel((FlowNode)node) + " is " + forkLevel});
        for (int i = 0; i < targetGateways.size(); ++i) {
            TargetNodeInfo info = (TargetNodeInfo)targetGateways.get(i);
            TargetNodeInfo nextConvergeGateway = null;
            if (info.getNode().getBpmnType().equals((Object)BpmnType.END_EVENT)) continue;
            if (this.isConvergingGateway(info.getNode())) {
                String joinLevel = ModelUtils.getActivityLevel((FlowNode)info.getNode());
                DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Activity level for converging " + this.getLabel(info.getNode()) + " is " + joinLevel});
                if (forkLevel.equals(joinLevel)) {
                    return (Gateway)info.getNode();
                }
                nextConvergeGateway = this.getConvergingGateway(info, gatewayTargetMap);
            } else {
                nextConvergeGateway = this.getConvergingGateway(info, gatewayTargetMap);
            }
            if (nextConvergeGateway == null || ((Object)targetGateways).equals(nextConvergeGateway)) continue;
            targetGateways.add(nextConvergeGateway);
        }
        return null;
    }

    private Gateway getMergingGatewayOld(Gateway node, Map gatewayTargetMap) {
        String methodName = "getMergingGateway";
        String id = node.getId();
        List originalTargets = (List)gatewayTargetMap.get(id);
        DeploymentLogger.LOG.debug(this.getClass().getName(), methodName, new Object[]{"Get merging gatewat for id = " + id});
        ArrayList<TargetNodeInfo> targets = new ArrayList<TargetNodeInfo>(originalTargets.size());
        for (TargetNodeInfo info : originalTargets) {
            TargetNodeInfo convergeGateway;
            if (info.getNode().getBpmnType().equals((Object)BpmnType.END_EVENT) || (convergeGateway = this.getConvergingGateway(info, gatewayTargetMap)) == null) continue;
            targets.add(convergeGateway);
        }
        HashSet<String> replaceSet = new HashSet<String>();
        int i = 0;
        boolean listChanged = false;
        while (true) {
            TargetNodeInfo tNodeInfo;
            String currentNode;
            boolean isSame;
            if (isSame = this.isTargetListSame(targets)) {
                return (Gateway)((TargetNodeInfo)targets.get(0)).getNode();
            }
            if (targets.size() <= i) {
                if (!listChanged) break;
                i = 0;
                listChanged = false;
            }
            if (replaceSet.contains(currentNode = (tNodeInfo = (TargetNodeInfo)targets.get(i)).getNode().getId())) {
                targets.remove(tNodeInfo);
                listChanged = true;
                continue;
            }
            List tagertNodeList = (List)gatewayTargetMap.get(tNodeInfo.getNode().getId());
            if (tagertNodeList != null && tagertNodeList.size() > 0) {
                boolean canReplace = false;
                for (int j = 0; j < tagertNodeList.size(); ++j) {
                    TargetNodeInfo rNodeInfo = this.getConvergingGateway((TargetNodeInfo)tagertNodeList.get(j), gatewayTargetMap);
                    Object rNode = null;
                    if (rNodeInfo == null && !this.isConverginGatewayInsideSplitGateway(node, ((TargetNodeInfo)tagertNodeList.get(j)).getNode())) continue;
                    if (rNodeInfo == null && this.isConverginGatewayInsideSplitGateway(node, ((TargetNodeInfo)tagertNodeList.get(j)).getNode())) {
                        targets.remove(tagertNodeList.get(j));
                        replaceSet.add(((TargetNodeInfo)tagertNodeList.get(j)).getNode().getId());
                        continue;
                    }
                    String replaceNode = rNode.getId();
                    if (replaceSet.contains(replaceNode) || currentNode.equals(replaceNode)) continue;
                    targets.add(0, rNodeInfo);
                    canReplace = true;
                    listChanged = true;
                    ++i;
                }
                if (canReplace) {
                    targets.remove(tNodeInfo);
                    replaceSet.add(currentNode);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        return null;
    }

    private boolean isConverginGatewayInsideSplitGateway(Gateway splitGateway, FlowNode convergingGateway) {
        String level = ModelUtils.getCurrentLevel((FlowNode)convergingGateway);
        String id = splitGateway.getId();
        return level.equals(id);
    }

    private class TargetNodeInfo {
        private FlowNode node = null;
        private SequenceFlow sourceGflow = null;

        public TargetNodeInfo(FlowNode node, SequenceFlow flow) {
            this.node = node;
            this.sourceGflow = flow;
        }

        public FlowNode getNode() {
            return this.node;
        }

        public SequenceFlow getSourceSequenceFlow() {
            return this.sourceGflow;
        }

        public String toString() {
            return this.sourceGflow.getId() + "->" + this.node.getId();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof TargetNodeInfo && ((TargetNodeInfo)obj).getNode().getId().equals(this.node.getId());
        }
    }
}

