/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.deploy.schema;

import com.collaxa.cube.engine.deployment.DeploymentLogger;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryService;
import oracle.bpm.analytics.cube.persistence.PersistenceService;
import oracle.bpm.analytics.cube.persistence.model.CubeActivity;
import oracle.bpm.analytics.cube.persistence.model.CubeActivitySequenceFlow;
import oracle.bpm.analytics.cube.persistence.model.CubeNametab;
import oracle.bpm.analytics.cube.persistence.model.CubeNametabRange;
import oracle.bpm.analytics.cube.persistence.model.CubeProcess;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataServiceLocal;
import oracle.bpm.analytics.measurement.metadata.MeasurementMetadataServiceFactory;
import oracle.bpm.bpmn.engine.map.builder.ModelCreator;
import oracle.bpm.bpmn.engine.map.builder.ModelCreatorFactoryHelper;
import oracle.bpm.bpmn.engine.model.deploy.schema.AuditVariableMapper;
import oracle.bpm.bpmn.engine.model.deploy.schema.FlexFieldAutoMapper;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableRange;
import oracle.bpm.collections.Sequence;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.data.MeasurementType;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.ApplicationInfo;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditVariableRange;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.bpm.services.organization.model.ApplicationRoles;
import oracle.bpm.services.organization.model.Organization;
import oracle.bpm.services.organization.model.ProcessRoleType;
import oracle.fabric.blocks.ImplementationType;
import oracle.fabric.common.FabricDeploymentException;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;

public class BpmnDesignSchema {
    private HashMap<FlowNode, CubeActivity> activityMap = new HashMap();
    private AuditVariableMapper m_auditVariableMapper = null;
    private HashSet<String> m_callableProcesses = new HashSet();
    private ComponentModel m_componentModel;
    private CompositeModel m_composite;
    private boolean m_compositeDeployed = false;
    private List<AuditQueryVariableRange> m_currentAuditVariableRanges = null;
    private List<String> m_deployedDN;
    private Map<Integer, String[]> m_flexDateNameMap = null;
    private FlexFieldAutoMapper m_flexFieldAutoMapper = null;
    private Map<Integer, String[]> m_flexNumberNameMap = null;
    private Map<Integer, String[]> m_flexStringNameMap = null;
    private boolean m_isCallableProcess = false;
    private Organization m_organization = null;
    private PersistenceService m_pcs = null;
    private CubeProcess m_proc = null;
    private HashSet<NodeContainer> m_processes = new HashSet();
    private Process m_processModel = null;
    private static final String Y = "Y";
    private static final String N = "N";
    private static final String CALLABLE = "CALLABLE";
    private static final String logClassName = BpmnDesignSchema.class.getName();

    public BpmnDesignSchema(ComponentModel componentModel, List<String> deployedDN) {
        String logMethodName = "constructor";
        this.log("constructor", "bpmn designSchema");
        this.m_componentModel = componentModel;
        this.m_deployedDN = deployedDN;
        this.m_composite = this.m_componentModel.getComposite();
        this.m_compositeDeployed = this.m_deployedDN.contains(this.m_componentModel.getComposite().getDN());
        try {
            InitialContext context = new InitialContext();
            this.m_pcs = (PersistenceService)context.lookup("BPMAnalytics#oracle.bpm.analytics.cube.persistence.PersistenceService");
        }
        catch (NamingException e) {
            DeploymentLogger.LOG.error(logClassName, "constructor", new Object[]{"Failure to locate BPMAnalytics#oracle.bpm.analytics.cube.persistence.PersistenceService", e});
            e.printStackTrace();
        }
    }

    public BpmnDesignSchema(ComponentModel componentModel, List<String> deployedDN, Organization organization) {
        this(componentModel, deployedDN);
        this.m_organization = organization;
    }

    private BpmnDesignSchema(ComponentModel componentModel, List<String> deployedDN, Organization organization, Process processModel) {
        this(componentModel, deployedDN, organization);
        this.m_processModel = processModel;
        this.m_flexFieldAutoMapper = new FlexFieldAutoMapper(this.m_componentModel, this.m_processModel);
        this.m_isCallableProcess = true;
    }

    public void init() throws Exception {
        String logMethodName = "init";
        this.log("init", "bpmn designSchema");
        if (this.m_processModel == null) {
            ModelCreator modelCreator = ModelCreatorFactoryHelper.getFactory().getModelCreator(this.m_componentModel);
            this.m_processModel = modelCreator.createModel();
            this.m_flexFieldAutoMapper = new FlexFieldAutoMapper(this.m_componentModel, this.m_processModel);
        }
    }

    public void undeploy() throws Exception {
        String logMethodName = "undeploy";
        this.log("undeploy", "Invoked for " + this.m_composite.getDN() + "/" + this.m_componentModel.getName());
        List<CubeProcess> cubeProcesses = this.getExistingProcesses();
        Timestamp undeployDate = new Timestamp(System.currentTimeMillis());
        if (cubeProcesses.size() <= 0) {
            return;
        }
        IMeasurementMetadataServiceLocal mService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceLocal();
        mService.updateBAMComponentStatus(this.m_componentModel, AuditInstanceOperation.COMPONENT_UNDEPLOYED);
        if (cubeProcesses != null) {
            CubeProcess lastProcess = null;
            for (CubeProcess cubeProcess : cubeProcesses) {
                if (cubeProcess == null) continue;
                this.log("undeploy", "Fetched process: " + cubeProcess.getCompositeDN() + "/" + cubeProcess.getProcessName());
                this.m_pcs.undeployProcess(cubeProcess);
                lastProcess = cubeProcess;
                this.m_pcs.createProcessSpecificView(cubeProcess.getCompositeDN(), cubeProcess.getProcessName(), cubeProcess.getAnalyticsViewIdentifier(), true);
            }
            if (lastProcess.getTemplateName() != null && lastProcess.getTemplateName().length() > 0) {
                this.m_pcs.createTemplateSpecificView(this.m_componentModel.getComposite().getDN(), lastProcess.getProcessName(), lastProcess.getTemplateName(), true);
            }
        }
    }

    public void markMigrated() throws Exception {
        String logMethodName = "markMigrated";
        this.log("markMigrated", "Invoked for " + this.m_composite.getDN() + "/" + this.m_componentModel.getName());
        List<CubeProcess> cubeProcesses = this.getExistingProcesses();
        if (cubeProcesses != null) {
            for (CubeProcess cubeProcess : cubeProcesses) {
                this.log("markMigrated", "Fetched process: " + cubeProcess.getProcessName());
                this.m_pcs.migrateProcess(cubeProcess);
            }
        }
    }

    public void markSuspended() throws Exception {
        String logMethodName = "suspend";
        String compositeName = this.m_composite.getName();
        String domainName = this.m_composite.getDomain();
        String revision = this.m_composite.getRevision();
        String label = this.m_composite.getLabel();
        String processName = this.m_componentModel.getName();
        this.m_pcs.suspendProcess(domainName, compositeName, revision, label, processName);
        IMeasurementMetadataServiceLocal mService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceLocal();
        mService.updateBAMComponentStatus(this.m_componentModel, AuditInstanceOperation.COMPONENT_SUSPENDED);
        this.log("suspend", this.m_composite.getDN() + "/" + processName + " component suspended");
    }

    public void markResumed() throws Exception {
        String logMethodName = "resume";
        String compositeName = this.m_composite.getName();
        String domainName = this.m_composite.getDomain();
        String revision = this.m_composite.getRevision();
        String label = this.m_composite.getLabel();
        String processName = this.m_componentModel.getName();
        this.m_pcs.resumeProcess(domainName, compositeName, revision, label, processName);
        IMeasurementMetadataServiceLocal mService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceLocal();
        mService.updateBAMComponentStatus(this.m_componentModel, AuditInstanceOperation.COMPONENT_DEPLOYED);
        this.log("resume", this.m_composite.getDN() + "/" + processName + " component resumed");
    }

    public void setActive(boolean active) throws Exception {
        String logMethodName = "setActive(" + active + ")";
        this.log(logMethodName, "Invoked for " + this.m_composite.getDN() + "/" + this.m_componentModel.getName());
        List<CubeProcess> cubeProcesses = this.getExistingProcesses();
        if (cubeProcesses != null) {
            for (CubeProcess cubeProcess : cubeProcesses) {
                IMeasurementMetadataServiceLocal mService;
                if (cubeProcess == null) continue;
                this.log(logMethodName, "Fetched process: " + cubeProcess.getCompositeDN() + "/" + cubeProcess.getProcessName());
                if (active) {
                    this.m_pcs.activateProcess(cubeProcess.getDomainName(), cubeProcess.getCompositeName(), cubeProcess.getCompositeRevision(), cubeProcess.getCompositeLabel(), cubeProcess.getProcessName());
                    mService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceLocal();
                    mService.updateBAMComponentStatus(this.m_componentModel, AuditInstanceOperation.COMPONENT_DEPLOYED);
                    continue;
                }
                this.m_pcs.retireProcess(cubeProcess.getDomainName(), cubeProcess.getCompositeName(), cubeProcess.getCompositeRevision(), cubeProcess.getCompositeLabel(), cubeProcess.getProcessName());
                mService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceLocal();
                mService.updateBAMComponentStatus(this.m_componentModel, AuditInstanceOperation.COMPONENT_RETIRED);
            }
        }
    }

    public void rollback() {
        try {
            this.m_pcs.removeAllFromComposite(this.m_composite.getDN());
            if (this.m_proc != null) {
                this.log("rollback", "Remove process " + this.m_proc.getProcessName() + " from persistence");
                this.m_pcs.remove(this.m_proc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanup() {
    }

    public void populateAll() throws Exception {
        this.populate();
        try {
            if (!this.m_compositeDeployed && !this.m_isCallableProcess) {
                IMeasurementMetadataServiceLocal mService = MeasurementMetadataServiceFactory.getMeasurementMetadataServiceLocal();
                ArrayList<IAuditVariableRange> ranges = new ArrayList<IAuditVariableRange>();
                if (this.m_currentAuditVariableRanges != null) {
                    for (AuditQueryVariableRange auditQueryVariableRange : this.m_currentAuditVariableRanges) {
                        IAuditVariableRange range = AuditUtil.createAuditvariableRange(auditQueryVariableRange);
                        ranges.add(range);
                    }
                    if (this.m_auditVariableMapper != null) {
                        this.m_auditVariableMapper.getAuditMetadata().setAllRanges(ranges);
                    }
                }
                for (ComponentModel componentModel : this.m_composite.getComponentList()) {
                    if (componentModel == null || !componentModel.getImplementationType().equals((Object)ImplementationType.BPMN)) continue;
                    mService.deployBAMDataObjects(componentModel, this.m_auditVariableMapper.getAuditMetadata());
                }
            }
        }
        catch (Exception e) {
            throw new FabricDeploymentException((Throwable)e);
        }
    }

    public void populate() throws Exception {
        String logMethodName = "populate";
        this.log("populate", "BEGIN");
        try {
            this.m_proc = this.populateProcess(this.m_processModel);
            this.populateActivities(this.m_proc, (NodeContainer)this.m_processModel);
            for (NodeContainer container : this.m_processes) {
                Sequence measures = container.getMeasurements();
                for (Measurement m : measures) {
                    this.log("populate", "measure: " + m.getName());
                    this.populateMeasure(this.m_proc, m);
                }
                Sequence flows = container.getSequenceFlows();
                for (SequenceFlow f : flows) {
                    this.populateSequenceFlow(f, this.m_pcs);
                }
            }
            this.populateRoles(this.m_proc);
        }
        catch (Exception e) {
            if (this.m_pcs != null) {
                // empty if block
            }
            e.printStackTrace();
            throw e;
        }
        this.log("populate", "Capturing the variable metadata for the Composite DN {" + this.m_componentModel.getComposite().getDN() + "}");
        this.populateAuditVariableMetadata(this.m_proc);
        try {
            this.m_pcs.createProcessSpecificView(this.m_componentModel.getComposite().getDN(), this.m_proc.getProcessName(), this.m_processModel.getAnalyticsViewIdentifier(), false);
            this.m_pcs.resetProcessSpecificViewIdentifiers(this.m_componentModel.getComposite().getName(), this.m_proc.getProcessName(), this.m_processModel.getAnalyticsViewIdentifier());
            if (this.m_processModel.getProject() != null && this.m_processModel.getProject().getPreferences() != null) {
                String templateName = this.m_processModel.getProject().getPreferences().getTemplateName();
                String templateViewIdentifier = this.m_processModel.getProject().getPreferences().getTemplateViewIdentifier();
                if (templateViewIdentifier != null && templateViewIdentifier.length() > 0) {
                    this.m_pcs.createTemplateSpecificView(this.m_componentModel.getComposite().getDN(), this.m_proc.getProcessName(), templateName, false);
                    this.m_pcs.resetTemplateSpecificViewIdentifiers(templateName, templateViewIdentifier);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_flexFieldAutoMapper.populateFlexFields();
        this.log("populate", "END");
    }

    protected void populateActivities(CubeProcess proc, NodeContainer container) throws Exception {
        String logMethodName = "populateActivities";
        if (container != null) {
            this.m_processes.add(container);
            Sequence flowNodes = container.getFlowNodes();
            for (FlowNode a : flowNodes) {
                CallActivity ca;
                Process callableProcess;
                this.log("populateActivities", "flowNode: " + a.getName());
                this.populateFlowNode(proc, a);
                if (!a.isActivity()) continue;
                this.log("populateActivities", a.getName() + " is Activity Type");
                Activity activity = (Activity)a.asAnyNode(Activity.class);
                if (activity.isSubprocess()) {
                    this.log("populateActivities", a.getName() + " is a Subprocess");
                    Subprocess subprocess = (Subprocess)a.asAnyNode(Subprocess.class);
                    this.populateActivities(proc, (NodeContainer)subprocess);
                }
                if (activity.isCallActivity() && (callableProcess = (ca = (CallActivity)activity).getCalledElement()) != null) {
                    String calledElementName = ca.getCalledElementName();
                    this.log("populateActivities", "Called Element: " + ca.getCalledElementName());
                    if (!this.m_callableProcesses.contains(calledElementName) && !this.isProcessRecordCreated(callableProcess)) {
                        this.log("populateActivities", "populating called element: " + calledElementName);
                        this.m_callableProcesses.add(calledElementName);
                        BpmnDesignSchema schema = new BpmnDesignSchema(this.m_componentModel, this.m_deployedDN, this.m_organization, callableProcess);
                        schema.populate();
                    } else {
                        this.log("populateActivities", "Called Element " + calledElementName + " is already populated");
                    }
                }
                for (BoundaryEvent be : ((Activity)a.asAnyNode(Activity.class)).getActivityBoundaryEvents()) {
                    this.populateFlowNode(proc, (FlowNode)be);
                }
            }
        }
    }

    protected CubeProcess populateProcess(Process processModel) throws Exception {
        String logMethodName = "populateProcess";
        String compositeDN = this.m_composite.getDN();
        String compositename = this.m_composite.getName();
        String domainname = this.m_composite.getDomain();
        String revision = this.m_composite.getRevision();
        String label = processModel.getDefaultLabel();
        String bpmnid = processModel.getId();
        String processtype = "BPMN";
        String scalabel = this.m_composite.getLabel();
        Date date = new Date();
        Timestamp creationdate = new Timestamp(date.getTime());
        String organizationalUnitId = this.m_organization.getProcessOrganizationalUnitId();
        String templateName = null;
        String templateViewIdentifier = null;
        ApplicationInfo applicationInfo = null;
        String applicationLinkDisplayName = null;
        String category = null;
        String tags = null;
        if (processModel.getProject() != null && processModel.getProject().getPreferences() != null) {
            templateName = processModel.getProject().getPreferences().getTemplateName();
            templateViewIdentifier = processModel.getProject().getPreferences().getTemplateViewIdentifier();
            StringBuffer grants = new StringBuffer();
            List grantsList = processModel.getProject().getPreferences().getDatabaseGrantees();
            for (int i = 0; i < grantsList.size(); ++i) {
                grants.append((String)grantsList.get(i));
                if (i >= grantsList.size() - 1) continue;
                grants.append(",");
            }
        }
        if (processModel.getApplicationInfo() != null && (applicationInfo = processModel.getApplicationInfo()) != null) {
            applicationLinkDisplayName = applicationInfo.getLinkName();
            category = applicationInfo.getCategory();
            tags = applicationInfo.getColumnTags();
        }
        this.log("populateProcess", "compositeDN: " + compositeDN);
        this.log("populateProcess", "compositename: " + compositename);
        this.log("populateProcess", "domainname: " + domainname);
        this.log("populateProcess", "revision: " + revision);
        this.log("populateProcess", "bpmnid: " + bpmnid);
        this.log("populateProcess", "scalabel: " + scalabel);
        this.log("populateProcess", "label: " + label);
        this.log("populateProcess", "Timestamp: " + creationdate);
        this.log("populateProcess", "organizationalUnitId: " + organizationalUnitId);
        this.log("populateProcess", "applicationLinkDisplayName: " + applicationLinkDisplayName);
        this.log("populateProcess", "category: " + category);
        this.log("populateProcess", "tags: " + tags);
        if (this.m_isCallableProcess) {
            return this.m_pcs.createProcess(compositeDN, compositename, creationdate, domainname, label, bpmnid, processtype, revision, scalabel, Long.valueOf(1L), organizationalUnitId, CALLABLE, processModel.getAnalyticsViewIdentifier(), templateName, templateViewIdentifier, applicationLinkDisplayName, category, tags);
        }
        return this.m_pcs.createProcess(compositeDN, compositename, creationdate, domainname, label, bpmnid, processtype, revision, scalabel, Long.valueOf(1L), organizationalUnitId, null, processModel.getAnalyticsViewIdentifier(), templateName, templateViewIdentifier, applicationLinkDisplayName, category, tags);
    }

    protected void populateMeasure(CubeProcess process, Measurement measurement) throws Exception {
        String logMethodName = "populateFlowNode";
        String name = measurement.getName();
        String label = measurement.getDefaultLabel();
        MeasurementType mt = measurement.getMeasurementType();
        String type = mt.getValue();
        String sourceCode = measurement.toString();
        this.log("populateFlowNode", "MeasureName: " + name);
        this.log("populateFlowNode", "activityType: " + type);
        this.log("populateFlowNode", "measurelabel: " + label);
        this.log("populateFlowNode", "sourcecode: " + sourceCode);
        CubeActivity cubeActivity = this.m_pcs.createActivity(process, name, type, sourceCode.toCharArray(), label);
    }

    protected void populateCounter(CubeProcess process, Counter counter) {
    }

    protected void populateFlowNode(CubeProcess process, FlowNode activity) throws Exception {
        String logMethodName = "populateFlowNode";
        String name = activity.getName();
        String type = activity.getBpmnType().name();
        String label = activity.getDefaultLabel();
        String sourceCode = activity.toString();
        this.log("populateFlowNode", "activityName: " + name);
        this.log("populateFlowNode", "activityType: " + type);
        this.log("populateFlowNode", "label: " + label);
        this.log("populateFlowNode", "sourcecode: " + sourceCode);
        CubeActivity cubeActivity = this.m_pcs.createActivity(process, name, type, sourceCode.toCharArray(), label);
        this.activityMap.put(activity, cubeActivity);
        this.populateGlobalCreationTask(activity, process, cubeActivity);
    }

    protected void populateSequenceFlow(SequenceFlow flow, PersistenceService pcs) throws Exception {
        String logMethodName = "populateSequenceFlow";
        FlowNode source = flow.getSource();
        FlowNode target = flow.getTarget();
        CubeActivity sourceActivity = this.activityMap.get(source);
        CubeActivity targetActivity = this.activityMap.get(target);
        String isNormalFlow = N;
        String isConditionFlow = N;
        String isExceptionFlow = N;
        String condition = null;
        String label = flow.getDefaultLabel();
        this.log("populateSequenceFlow", "SequenceFlow label: " + label);
        this.log("populateSequenceFlow", "sourceActivity: " + sourceActivity.getActivityName());
        this.log("populateSequenceFlow", "targetActivity: " + targetActivity.getActivityName());
        if (flow.isNormalFlow()) {
            isNormalFlow = Y;
        } else if (flow.isConditionalFlow()) {
            Expression exp;
            isConditionFlow = Y;
            ConditionalFlow cf = flow.asConditionalFlow();
            if (cf != null && (exp = cf.getCondition()) != null) {
                condition = flow.toConditionalFlow().getCondition().getExpressionValue();
            }
        } else if (flow.isExceptionFlow()) {
            isExceptionFlow = Y;
        }
        CubeActivitySequenceFlow cubeSequenceFlow = pcs.createActivitySequenceFlow(sourceActivity, targetActivity, label, isNormalFlow, isConditionFlow, isExceptionFlow, condition);
    }

    private List<CubeProcess> getExistingProcesses() throws Exception {
        InitialContext context = new InitialContext();
        CompositeModel composite = this.m_componentModel.getComposite();
        String compositeName = composite.getName();
        String domainName = composite.getDomain();
        String revision = composite.getRevision();
        String label = composite.getLabel();
        PersistenceQueryService pqs = (PersistenceQueryService)context.lookup("BPMAnalytics#oracle.bpm.analytics.cube.persistence.PersistenceQueryService");
        List cubeProcesses = pqs.selectCubeProcess(domainName, compositeName, revision, label);
        return cubeProcesses;
    }

    private void populateAuditVariableMetadata(CubeProcess cubeProcess) throws Exception {
        String logMethodName = "populateAuditVariableMetadata";
        this.log("populateAuditVariableMetadata", "BEGIN");
        try {
            Project project = this.m_processModel.getProject();
            this.m_currentAuditVariableRanges = new ArrayList<AuditQueryVariableRange>();
            this.m_auditVariableMapper = new AuditVariableMapper(this.m_composite.getDN());
            Sequence variables = project.getProjectDataObjects();
            this.log("populateAuditVariableMetadata", "There are {" + (variables != null ? variables.toArray().length : 0) + "} project variables for DN {" + this.m_composite.getDN() + "}");
            if (variables != null && !variables.isEmpty()) {
                boolean metadataRecorded = false;
                for (ProjectDataObject obj : variables) {
                    if (!obj.isBusiness()) continue;
                    String name = obj.getName();
                    String type = obj.getBusinessVariableType().toString().substring(0, 1);
                    String dataType = obj.getType().getName();
                    this.log("populateAuditVariableMetadata", "Variable metadata information {" + name + ", " + type + ", " + dataType + ", " + obj.isBusiness() + "}");
                    this.m_auditVariableMapper.addVariableMetadata(name, dataType, type);
                    metadataRecorded = true;
                    if (obj.getBusinessVariableData() == null) continue;
                    BusinessVariableData.Range[] ranges = obj.getBusinessVariableData().getRange();
                    for (int i = 0; i < ranges.length; ++i) {
                        AuditQueryVariableRange range = new AuditQueryVariableRange();
                        range.setCompositeDN(this.m_componentModel.getComposite().getDN());
                        range.setExtensionId(0L);
                        range.setVarLabel(name);
                        range.setRangeName(ranges[i].getName());
                        range.setNumberRangeStart(ranges[i].getStart());
                        range.setNumberRangeEnd(ranges[i].getFinish());
                        this.m_currentAuditVariableRanges.add(range);
                    }
                }
                if (metadataRecorded) {
                    this.m_flexDateNameMap = this.prepareVariableMap(this.m_auditVariableMapper.getAuditMetadata().getDateNames(), this.m_auditVariableMapper.getAuditMetadata().getDateTypes());
                    this.m_flexNumberNameMap = this.prepareVariableMap(this.m_auditVariableMapper.getAuditMetadata().getNumberNames(), this.m_auditVariableMapper.getAuditMetadata().getNumberTypes());
                    this.m_flexStringNameMap = this.prepareVariableMap(this.m_auditVariableMapper.getAuditMetadata().getStringNames(), this.m_auditVariableMapper.getAuditMetadata().getStringTypes());
                    this.printMaps();
                    CubeNametab cubeNametab = this.m_pcs.createNametab(cubeProcess, this.m_flexDateNameMap, this.m_flexNumberNameMap, this.m_flexStringNameMap);
                    this.populateRange(cubeNametab, this.m_currentAuditVariableRanges);
                }
            }
            if (!this.m_compositeDeployed && !this.m_isCallableProcess) {
                AuditUtil.insertVariableMetadata(this.m_auditVariableMapper.getAuditMetadata(), this.m_currentAuditVariableRanges);
            }
        }
        catch (Exception e) {
            DeploymentLogger.LOG.error(logClassName, "populateAuditVariableMetadata", new Object[]{"Unable to persist the business indicator meta data for the Audit Core. Caused by: " + e.toString()});
            throw e;
        }
        this.log("populateAuditVariableMetadata", "END");
    }

    private void populateRange(CubeNametab cubeNametab, List<AuditQueryVariableRange> allRanges) throws Exception {
        for (AuditQueryVariableRange range : allRanges) {
            String rangeName = range.getRangeName();
            String rangeOperator = null;
            String indicatorName = range.getVarLabel();
            BigDecimal numberRangeStart = range.getNumberRangeStart();
            BigDecimal numberRangeEnd = range.getNumberRangeEnd();
            Timestamp datetimeRangeStart = null;
            Timestamp datetimeRangeEnd = null;
            CubeNametabRange cubeNametabRange = this.m_pcs.createNametabRange(cubeNametab, rangeName, rangeOperator, indicatorName, numberRangeStart, numberRangeEnd, datetimeRangeStart, datetimeRangeEnd);
            cubeNametab.addCubeNametabRange(cubeNametabRange);
        }
    }

    private Map<Integer, String[]> prepareVariableMap(List<String> biNameList, List<String> biTypeList) {
        String logMethodName = "prepareVariableMap";
        this.log("prepareVariableMap", "BEGIN");
        HashMap<Integer, String[]> flexMap = new HashMap<Integer, String[]>();
        if (biNameList == null || biTypeList == null) {
            this.log("prepareVariableMap", "one of the input parameter is null");
            return flexMap;
        }
        for (int i = 0; i < biNameList.size(); ++i) {
            String biName = biNameList.get(i);
            String biType = biTypeList.get(i);
            if (biName == null || biName.startsWith("#")) continue;
            this.log("prepareVariableMap", "adding to flexMap: " + i + ", " + biName + ":" + biType);
            flexMap.put(i + 1, new String[]{biName, biType});
        }
        this.log("prepareVariableMap", "END");
        return flexMap;
    }

    private void printMaps() {
        String logMethodName = "printMaps";
        this.log("printMaps", "BEGIN");
        StringBuffer numberNames = new StringBuffer("flexNumberNameMap:  ");
        for (Map.Entry<Integer, String[]> entry : this.m_flexNumberNameMap.entrySet()) {
            numberNames.append(entry.getKey()).append(":").append(entry.getValue()[0]).append(",  ");
        }
        this.log("printMaps", numberNames.toString());
        StringBuffer stringNames = new StringBuffer("flexStringNameMap:  ");
        for (Map.Entry<Integer, String[]> entry : this.m_flexStringNameMap.entrySet()) {
            stringNames.append(entry.getKey()).append(":").append(entry.getValue()[0]).append(",  ");
        }
        this.log("printMaps", stringNames.toString());
        StringBuffer dateNames = new StringBuffer("flexDateNameMap:  ");
        for (Map.Entry<Integer, String[]> entry : this.m_flexDateNameMap.entrySet()) {
            dateNames.append(entry.getKey()).append(":").append(entry.getValue()[0]).append(",  ");
        }
        this.log("printMaps", dateNames.toString());
    }

    private void log(String methodName, String msg) {
        DeploymentLogger.LOG.debug(logClassName, methodName, new Object[]{msg});
    }

    private void populateRoles(CubeProcess process) throws Exception {
        String logMethodName = "populateRoles";
        this.log("populateRoles", "\n Need to populate the roles into BPM_CUBE_ROLE table ...");
        if (this.m_organization != null && this.m_organization.isSetApplicationRoles()) {
            String isProcessOwnerRole;
            ProcessRoleType processRoleType;
            ApplicationRoleType applicationRoleType;
            int i;
            ArrayList<ApplicationRoleType> processOwnerApplicationRoleList = new ArrayList<ApplicationRoleType>();
            ArrayList<ApplicationRoleType> swimlaneApplicationRoleList = new ArrayList<ApplicationRoleType>();
            this.categorizeApplicationRoles(this.m_organization.getApplicationRoles(), processOwnerApplicationRoleList, swimlaneApplicationRoleList);
            if (!processOwnerApplicationRoleList.isEmpty()) {
                this.log("populateRoles", "\n processOwnerApplicationRoleList.size(): " + processOwnerApplicationRoleList.size());
                for (i = 0; i < processOwnerApplicationRoleList.size(); ++i) {
                    applicationRoleType = (ApplicationRoleType)processOwnerApplicationRoleList.get(i);
                    if (applicationRoleType == null || (processRoleType = applicationRoleType.getProcessRole()) == null || processRoleType.getId() == null) continue;
                    this.log("populateRoles", "\n processRoleType.getId(): " + processRoleType.getId() + "\n processRoleType.getName(): " + processRoleType.getName());
                    isProcessOwnerRole = Y;
                    this.m_pcs.createRole(process, processRoleType.getId(), processRoleType.getName(), applicationRoleType.getName(), isProcessOwnerRole);
                }
            }
            if (!swimlaneApplicationRoleList.isEmpty()) {
                this.log("populateRoles", "\n swimlaneApplicationRoleList.size(): " + swimlaneApplicationRoleList.size());
                for (i = 0; i < swimlaneApplicationRoleList.size(); ++i) {
                    applicationRoleType = (ApplicationRoleType)swimlaneApplicationRoleList.get(i);
                    if (applicationRoleType == null || (processRoleType = applicationRoleType.getProcessRole()) == null || processRoleType.getId() == null) continue;
                    this.log("populateRoles", "\n processRoleType.getId(): " + processRoleType.getId() + "\n processRoleType.getName(): " + processRoleType.getName());
                    isProcessOwnerRole = N;
                    this.m_pcs.createRole(process, processRoleType.getId(), processRoleType.getName(), applicationRoleType.getName(), isProcessOwnerRole);
                }
            }
        }
    }

    private void categorizeApplicationRoles(ApplicationRoles applicationRoles, List<ApplicationRoleType> processOwnerApplicationRoleList, List<ApplicationRoleType> swimlaneApplicationRoleList) {
        List applicationRoleTypeList;
        String logMethodName = "categorizeApplicationRoles";
        this.log("categorizeApplicationRoles", "\n Need to categorize the roles into processOwner roles and swimland roles ...");
        if (applicationRoles != null && processOwnerApplicationRoleList != null && swimlaneApplicationRoleList != null && (applicationRoleTypeList = applicationRoles.getApplicationRole()) != null && !applicationRoleTypeList.isEmpty()) {
            for (int j = 0; j < applicationRoleTypeList.size(); ++j) {
                ApplicationRoleType applicationRoleType = (ApplicationRoleType)applicationRoleTypeList.get(j);
                if (applicationRoleType == null || applicationRoleType.getProcessRole() == null || applicationRoleType.getProcessRole().getId() == null) continue;
                if (applicationRoleType.getProcessRole().getId().equals("ProcessOwner")) {
                    processOwnerApplicationRoleList.add(applicationRoleType);
                    continue;
                }
                swimlaneApplicationRoleList.add(applicationRoleType);
            }
        }
    }

    private void populateGlobalCreationTask(FlowNode flowNode, CubeProcess cubeProcess, CubeActivity cubeActivity) throws Exception {
        String logMethodName = "populateGlobalCreationTask";
        this.log("populateGlobalCreationTask", "\n Need to populate BPM_CUBE_GLOBALCREATETASK for each Global creation task ...");
        Map<String, String> processRolesMap = DeploymentDescriptorUtil.getProcessRoles(this.m_organization);
        this.log("populateGlobalCreationTask", "\n processRolesMap: " + processRolesMap);
        if (flowNode != null && flowNode.getBpmnType() != null && flowNode.getBpmnType() != BpmnType.BOUNDARY_EVENT && flowNode.getBpmnType() == BpmnType.USER_TASK && ((UserTask)flowNode.asAnyNode(UserTask.class)).isManualStart()) {
            Role role;
            this.log("populateGlobalCreationTask", "\n Global creation task found");
            String taskMetadataId = null;
            String taskComponentName = this.getTaskComponentName(flowNode);
            if (taskComponentName != null) {
                taskMetadataId = cubeProcess.getCompositeDN() + "/" + taskComponentName;
            }
            this.log("populateGlobalCreationTask", " taskMetadataId: " + taskMetadataId);
            Lane lane = flowNode.getLane();
            if (lane != null && (role = BPMNUtility.getRole(lane)) != null && role.getId() != null) {
                String logicalRoleId = role.getId();
                this.log("populateGlobalCreationTask", "\n logicalRoleId: " + logicalRoleId);
                String physicalRole = processRolesMap.get(logicalRoleId);
                this.log("populateGlobalCreationTask", "\n physicalRole: " + physicalRole);
                String applicationContext = ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value();
                this.log("populateGlobalCreationTask", "\n applicationContext: " + applicationContext);
                if (cubeProcess != null && cubeProcess.getProcessId() != null && cubeActivity != null) {
                    this.log("populateGlobalCreationTask", "\n processId:" + cubeProcess.getProcessId());
                    this.log("populateGlobalCreationTask", "\n physicalRole:" + physicalRole);
                    this.log("populateGlobalCreationTask", "\n activityName:" + flowNode.getId());
                    this.log("populateGlobalCreationTask", "\n activityLabel:" + flowNode.getDefaultLabel());
                    this.log("populateGlobalCreationTask", "\n applicationContext:" + applicationContext);
                    this.m_pcs.createGlobalCreationTask(cubeProcess, cubeActivity.getActivityId(), flowNode.getId(), flowNode.getDefaultLabel(), physicalRole, applicationContext, taskMetadataId, null, null);
                    cubeProcess.setHasGlobalCreationTasks(Y);
                    this.m_pcs.updateProcess(cubeProcess);
                }
            }
        }
    }

    private String getTaskComponentName(FlowNode flowNode) {
        String logMethodName = "getTaskComponentName";
        String componentName = null;
        if (flowNode != null && flowNode.getId() != null && flowNode.getProcess() != null) {
            Process process = flowNode.getProcess();
            Activity activity = process.findActivity(flowNode.getId());
            if (activity != null && activity.toUserTask() != null && activity.toUserTask().getHumanTask() != null) {
                componentName = activity.toUserTask().getHumanTask().getHumanTaskNativeName();
            } else {
                this.log("getTaskComponentName", "\n activity or userTask or humanTask is null");
            }
        } else {
            this.log("getTaskComponentName", "\n flowNode or process is null");
        }
        this.log("getTaskComponentName", "\n componentName: " + componentName);
        return componentName;
    }

    private boolean isProcessRecordCreated(Process processModel) throws Exception {
        String compositeName = this.m_composite.getName();
        String domainName = this.m_composite.getDomain();
        String revision = this.m_composite.getRevision();
        String processName = processModel.getId();
        String processType = "BPMN";
        String scalabel = this.m_composite.getLabel();
        InitialContext context = new InitialContext();
        PersistenceQueryService pqs = (PersistenceQueryService)context.lookup("BPMAnalytics#oracle.bpm.analytics.cube.persistence.PersistenceQueryService");
        CubeProcess cubeProcesses = pqs.selectCubeProcess(domainName, compositeName, revision, scalabel, processName, processType);
        return cubeProcesses != null;
    }
}

