/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.deploy.schema;

import com.collaxa.cube.engine.deployment.DeploymentLogger;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.fabric.common.FabricDeploymentException;

public class AuditVariableMapper {
    IAuditVariableMetadata currentDeployment = null;
    private static final Class logClassName = AuditVariableMapper.class;
    private static Map<String, EVariableType> sVariableTypeMap = new HashMap<String, EVariableType>();

    public AuditVariableMapper(String compositeDn) throws Exception {
        if (this.currentDeployment == null) {
            this.currentDeployment = AuditUtil.createNewAuditVariableMetadata();
        } else {
            this.currentDeployment.markAllAsUnused();
        }
        this.currentDeployment.setCompositeDn(compositeDn);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addVariableMetadata(String name, String dataType, String metricsType) {
        int slot;
        String logMethodName = "addVariableMetadata";
        String mt = null;
        int n = slot = this.currentDeployment != null ? this.currentDeployment.getSlot("#" + name) : -1;
        if (slot <= 0) {
            this.addMetadata(name, dataType, metricsType);
            return;
        }
        EVariableType currentType = this.getVariableType(this.currentDeployment.getType("#" + name));
        EVariableType varType = this.getVariableType(dataType);
        if (varType != currentType) {
            String msg = "The variable with the name {" + name + "} already exists with data type of {" + (Object)((Object)currentType) + "} which is incompatible with " + "the new type of {" + (Object)((Object)varType) + "}. Please revert the datatype of use a different variable name.";
            DeploymentLogger.LOG.error(logClassName, "addVariableMetadata", new Object[]{msg});
            throw new FabricDeploymentException(msg);
        }
        mt = metricsType.length() > 1 ? metricsType.substring(0, 1).toUpperCase() : metricsType;
        switch (varType) {
            case DATE: {
                this.currentDeployment.setDateMetadata(slot, name, dataType, mt);
                return;
            }
            case NUMBER: {
                this.currentDeployment.setNumberMetadata(slot, name, dataType, mt);
                return;
            }
            case STRING: {
                this.currentDeployment.setStringMetadata(slot, name, dataType, mt);
                return;
            }
        }
        DeploymentLogger.LOG.debug(logClassName, "addVariableMetadata", new Object[]{"Unable to recognize the variable data type {" + dataType + "} for variable {" + name + "}"});
    }

    public IAuditVariableMetadata getAuditMetadata() {
        return this.currentDeployment;
    }

    private void addMetadata(String name, String dataType, String metricsType) {
        String logMethodName = "addVariableMetadata";
        DeploymentLogger.LOG.debug(logClassName, "addVariableMetadata", new Object[]{"BEGIN"});
        String mt = null;
        mt = metricsType.length() > 1 ? metricsType.substring(0, 1).toUpperCase() : metricsType;
        EVariableType vx = this.getVariableType(dataType);
        if (vx == null) {
            DeploymentLogger.LOG.debug(logClassName, "addVariableMetadata", new Object[]{"Unable to find Variable tyep for data Type " + dataType});
            return;
        }
        switch (vx) {
            case DATE: {
                this.currentDeployment.addDateVariable(name, mt);
                break;
            }
            case NUMBER: {
                this.currentDeployment.addNumberVariable(name, mt, dataType);
                break;
            }
            case STRING: {
                this.currentDeployment.addStringVariable(name, mt, dataType);
                break;
            }
            default: {
                DeploymentLogger.LOG.debug(logClassName, "addVariableMetadata", new Object[]{"Unable to recognize the variable data type {" + dataType + "} for variable {" + name + "}"});
            }
        }
        DeploymentLogger.LOG.debug(logClassName, "addVariableMetadata", new Object[]{"END"});
    }

    private EVariableType getVariableType(String dataType) {
        EVariableType vx = sVariableTypeMap.get(dataType.toLowerCase());
        return vx;
    }

    static {
        sVariableTypeMap.put("Time", EVariableType.DATE);
        sVariableTypeMap.put("Int", EVariableType.NUMBER);
        sVariableTypeMap.put("String", EVariableType.STRING);
        sVariableTypeMap.put("Bool", EVariableType.STRING);
        sVariableTypeMap.put("boolean", EVariableType.STRING);
        sVariableTypeMap.put("Decimal", EVariableType.NUMBER);
        sVariableTypeMap.put("Real", EVariableType.NUMBER);
        sVariableTypeMap.put("time", EVariableType.DATE);
        sVariableTypeMap.put("dateTime", EVariableType.DATE);
        sVariableTypeMap.put("int", EVariableType.NUMBER);
        sVariableTypeMap.put("string", EVariableType.STRING);
        sVariableTypeMap.put("bool", EVariableType.STRING);
        sVariableTypeMap.put("real", EVariableType.NUMBER);
        sVariableTypeMap.put("decimal", EVariableType.NUMBER);
        sVariableTypeMap.put("number", EVariableType.NUMBER);
        sVariableTypeMap.put("date", EVariableType.DATE);
    }

    public class VariableUnit {
        boolean inUse;
        String metricsType;
        String modelType;
        String name;
        int slot;

        public VariableUnit(String name, String modelType, String metricsType, boolean inUse) {
            this.name = name;
            this.metricsType = metricsType;
            this.modelType = modelType;
            this.inUse = inUse;
        }
    }

    private static enum EVariableType {
        DATE,
        NUMBER,
        STRING,
        UNKNOWN;

        private static final long serialVersionUID = 1L;
    }
}

