/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.common;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.bpm.bpmn.engine.model.common.GatewaySequenceFlowMetadata;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.project.model.processes.BpmnSequenceFlowType;

public class GatewaySequenceFlowMetadataSupport
implements GatewaySequenceFlowMetadata {
    private SequenceFlowInfo defaultOutgoingSequenceFlow;
    private SortedSet<SequenceFlowInfo> incomingSequenceFlows = new TreeSet(new IncomingTransitionComparator());
    private SortedSet<SequenceFlowInfo> outgoingSequenceFlows = new TreeSet(new OutgoingTransitionComparator());

    @Override
    public SortedSet<SequenceFlowInfo> getIncomingSequenceFlows() {
        return this.incomingSequenceFlows;
    }

    @Override
    public void addIncomingSequenceFlow(SequenceFlowInfo incomingSequenceFlow) {
        this.incomingSequenceFlows.add(incomingSequenceFlow);
    }

    @Override
    public SortedSet<SequenceFlowInfo> getOutgoingSequenceFlows() {
        return this.outgoingSequenceFlows;
    }

    @Override
    public void addOutgoingSequenceFlow(SequenceFlowInfo outgoingSequenceFlow) {
        this.outgoingSequenceFlows.add(outgoingSequenceFlow);
    }

    @Override
    public void setDefaultOutgoingSequenceFlow(SequenceFlowInfo sequenceFlow) {
        this.defaultOutgoingSequenceFlow = sequenceFlow;
    }

    @Override
    public SequenceFlowInfo getDefaultOutgoingSequenceFlow() {
        return this.defaultOutgoingSequenceFlow;
    }

    private static class OutgoingTransitionComparator<T extends SequenceFlowInfo>
    extends IncomingTransitionComparator<T> {
        private OutgoingTransitionComparator() {
        }
    }

    private static class IncomingTransitionComparator<T extends SequenceFlowInfo>
    implements Comparator<T> {
        private IncomingTransitionComparator() {
        }

        @Override
        public int compare(T transition1, T transition2) {
            BpmnSequenceFlowType transition2FlowType;
            int result = 0;
            BpmnSequenceFlowType transition1FlowType = ((SequenceFlowInfo)transition1).getBpmnSequenceFlowType();
            if (transition1FlowType == (transition2FlowType = ((SequenceFlowInfo)transition2).getBpmnSequenceFlowType()) && transition1FlowType == BpmnSequenceFlowType.CONDITIONAL) {
                result = ((SequenceFlowInfo)transition1).getEvaluationOrder() - ((SequenceFlowInfo)transition2).getEvaluationOrder();
            } else if (transition1FlowType == BpmnSequenceFlowType.CONDITIONAL) {
                result = -1;
            } else if (transition2FlowType == BpmnSequenceFlowType.CONDITIONAL) {
                result = 1;
            }
            if (result == 0) {
                result = ((SequenceFlowInfo)transition1).getId().compareTo(((SequenceFlowInfo)transition2).getId());
            }
            return result;
        }
    }
}

