/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.common;

import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CatchAllErrorHandlingPolicy;
import oracle.bpm.bpmn.engine.model.common.Fault;
import oracle.bpm.bpmn.engine.model.common.FaultHandler;

public class FaultHandlerImpl
implements FaultHandler {
    private CatchAllErrorHandlingPolicy errorHandlingPolicy;
    private Set<QName> faultHandlerErrorCodes;
    private String id;

    public FaultHandlerImpl(String id, CatchAllErrorHandlingPolicy errorHandlingPolicy, Set<QName> faultHandlerErrorCodes) {
        this.id = id;
        this.errorHandlingPolicy = errorHandlingPolicy;
        this.faultHandlerErrorCodes = faultHandlerErrorCodes;
    }

    @Override
    public boolean handles(Fault fault) {
        return this.getErrorHandlingPolicy().isCatchAll() && (this.isSystemFault(fault.getErrorCode()) && this.getErrorHandlingPolicy().isCatchAllSystem() || this.isBusinessFault(fault.getErrorCode()) && this.getErrorHandlingPolicy().isCatchAllBusiness()) || !this.getErrorHandlingPolicy().isCatchAll() && this.getFaultHandlerErrorCodes().contains(fault.getErrorCode());
    }

    public boolean isSystemFault(QName errorCode) {
        String faultNamespace = errorCode.getNamespaceURI();
        return faultNamespace.equals("http://schemas.xmlsoap.org/ws/2003/03/business-process/") || faultNamespace.equals("http://schemas.oracle.com/bpel/extension");
    }

    public boolean isBusinessFault(QName errorCode) {
        return !this.isSystemFault(errorCode);
    }

    public Set<QName> getFaultHandlerErrorCodes() {
        return this.faultHandlerErrorCodes;
    }

    public CatchAllErrorHandlingPolicy getErrorHandlingPolicy() {
        return this.errorHandlingPolicy;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

